/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.platforms.desktop;

import it.unical.mat.embasp.base.Callback;
import it.unical.mat.embasp.base.InputProgram;
import it.unical.mat.embasp.base.OptionDescriptor;
import it.unical.mat.embasp.base.Output;
import it.unical.mat.embasp.base.Service;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;

public abstract class DesktopService
implements Service {
    protected String exe_path;
    protected String load_from_STDIN_option;

    public DesktopService(String exe_path) {
        this.exe_path = exe_path;
    }

    public String getExePath() {
        return this.exe_path;
    }

    protected abstract Output getOutput(String var1, String var2);

    public void setExePath(String exe_path) {
        this.exe_path = exe_path;
    }

    @Override
    public void startAsync(final Callback callback, final List<InputProgram> programs, final List<OptionDescriptor> options) {
        new Thread(){

            @Override
            public void run() {
                callback.callback(DesktopService.this.startSync(programs, options));
            }
        }.start();
    }

    @Override
    public Output startSync(List<InputProgram> programs, List<OptionDescriptor> options) {
        String option = new String();
        for (OptionDescriptor o : options) {
            if (o != null) {
                option = option + o.getOptions();
                option = option + o.getSeparator();
                continue;
            }
            System.err.println("Warning : wrong " + OptionDescriptor.class.getName());
        }
        String files_paths = new String();
        String final_program = new String();
        for (InputProgram p : programs) {
            if (p != null) {
                final_program = final_program + p.getPrograms();
                for (String program_file : p.getFilesPaths()) {
                    File f = new File(program_file);
                    if (f.exists() && !f.isDirectory()) {
                        files_paths = files_paths + program_file;
                        files_paths = files_paths + " ";
                        continue;
                    }
                    System.err.println("Warning : the file " + f.getAbsolutePath() + " does not exists.");
                }
                continue;
            }
            System.err.println("Warning : wrong " + InputProgram.class.getName());
        }
        final StringBuffer solverOutput = new StringBuffer();
        final StringBuffer solverError = new StringBuffer();
        try {
            long startTime = System.nanoTime();
            if (this.exe_path == null) {
                return new Output("", "Error: executable not found");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.exe_path).append(" ").append(option).append(" ").append(files_paths);
            if (!final_program.isEmpty()) {
                stringBuffer.append(this.load_from_STDIN_option);
            }
            System.err.println(stringBuffer.toString());
            final Process solver_process = Runtime.getRuntime().exec(stringBuffer.toString());
            Thread threadOutput = new Thread(){

                @Override
                public void run() {
                    try {
                        String currentLine;
                        BufferedReader bufferedReaderOutput = new BufferedReader(new InputStreamReader(solver_process.getInputStream()));
                        while ((currentLine = bufferedReaderOutput.readLine()) != null) {
                            solverOutput.append(currentLine + "\n");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            threadOutput.start();
            Thread threadError = new Thread(){

                @Override
                public void run() {
                    try {
                        String currentErrLine;
                        BufferedReader bufferedReaderError = new BufferedReader(new InputStreamReader(solver_process.getErrorStream()));
                        while ((currentErrLine = bufferedReaderError.readLine()) != null) {
                            solverError.append(currentErrLine + "\n");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            threadError.start();
            if (!final_program.isEmpty()) {
                PrintWriter writer = new PrintWriter(solver_process.getOutputStream());
                writer.println(final_program);
                if (writer != null) {
                    writer.close();
                }
                solver_process.waitFor();
            }
            threadOutput.join();
            threadError.join();
            long stopTime = System.nanoTime();
            System.err.println("Total time : " + (stopTime - startTime));
            return this.getOutput(solverOutput.toString(), solverError.toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.getOutput("", "");
    }
}

