/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.specializations.dlv2.android;

import android.app.IntentService;
import android.content.Intent;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;

public class DLV2AndroidReasoner
extends IntentService {
    public DLV2AndroidReasoner() {
        super("dlv2_service");
    }

    protected void onHandleIntent(Intent intent) {
        String action;
        Log.i((String)"DLV2", (String)((intent != null) + ""));
        if (intent != null && "it.unical.mat.embasp.specializations.dlv.android.SOLVE".equals(action = intent.getAction())) {
            String program = intent.getStringExtra("it.unical.mat.embasp.specializations.dlv.android.PROGRAM");
            String options = intent.getStringExtra("it.unical.mat.embasp.specializations.dlv.android.OPTION");
            String files = intent.getStringExtra("it.unical.mat.embasp.specializations.dlv.android.FILES");
            String result = this.handleActionSolve(program, options, files);
            this.publishResults(result);
        }
    }

    private void publishResults(String result) {
        Intent intent = new Intent("it.unical.mat.embasp.specializations.dlv.android.RESULT_NOTIFICATION");
        intent.putExtra("it.unical.mat.embasp.specializations.dlv.android.SOLVER_RESULT", result);
        this.sendBroadcast(intent);
    }

    public String handleActionSolve(String program, String options, String filesPath) {
        Log.i((String)"DLV2", (String)"Launching DLV2");
        File file = new File(this.getFilesDir(), "tmp_program");
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(program.getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder completeProgram = new StringBuilder();
        completeProgram.append(options).append(" ");
        completeProgram.append(file.getAbsolutePath()).append(" ");
        completeProgram.append(filesPath).append(" ");
        long startTime = System.nanoTime();
        String result = this.dlv2main(completeProgram.toString());
        long stopTime = System.nanoTime();
        Log.i((String)"DLV2", (String)("Execution Time: " + Long.toString(TimeUnit.NANOSECONDS.toMillis(stopTime - startTime))));
        return result;
    }

    private native String dlv2main(String var1);

    public void onDestroy() {
        super.onDestroy();
        Process.killProcess((int)Process.myPid());
    }

    static {
        System.loadLibrary("dlv2jni");
    }
}

