/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.specializations.dlv2.android;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import it.unical.mat.embasp.base.Callback;
import it.unical.mat.embasp.base.InputProgram;
import it.unical.mat.embasp.base.OptionDescriptor;
import it.unical.mat.embasp.platforms.android.AndroidService;
import it.unical.mat.embasp.specializations.dlv2.DLV2AnswerSets;
import it.unical.mat.embasp.specializations.dlv2.android.DLV2AndroidReasoner;
import java.util.List;

public class DLV2AndroidService
extends AndroidService {
    public DLV2AndroidService(Context c) {
        super(c);
    }

    @Override
    public void startAsync(Callback callback, List<InputProgram> programs, List<OptionDescriptor> options) {
        this.stopDlv2Service(this.context);
        Intent intent = new Intent(this.context, DLV2AndroidReasoner.class);
        String input_options = new String();
        input_options = input_options + "--silent";
        for (OptionDescriptor o : options) {
            input_options = input_options + o.getOptions();
        }
        intent.putExtra("it.unical.mat.embasp.specializations.dlv.android.OPTION", input_options);
        String final_program = new String();
        String files = new String();
        for (InputProgram p : programs) {
            final_program = final_program + p.getPrograms();
            String program_file = p.getStringOfFilesPaths();
            if (program_file == null) continue;
            files = files + program_file;
        }
        intent.setAction("it.unical.mat.embasp.specializations.dlv.android.SOLVE");
        intent.putExtra("it.unical.mat.embasp.specializations.dlv.android.PROGRAM", final_program);
        intent.putExtra("it.unical.mat.embasp.specializations.dlv.android.FILES", files);
        this.context.registerReceiver((BroadcastReceiver)new Receiver(callback), new IntentFilter("it.unical.mat.embasp.specializations.dlv.android.RESULT_NOTIFICATION"));
        this.context.startService(intent);
    }

    void stopDlv2Service(Context context) {
        boolean isServiceRunning = true;
        while (isServiceRunning) {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            isServiceRunning = false;
            for (ActivityManager.RunningServiceInfo processInfo : manager.getRunningServices(Integer.MAX_VALUE)) {
                if (!processInfo.service.getClassName().equals(DLV2AndroidReasoner.class.getName())) continue;
                isServiceRunning = true;
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class Receiver
    extends BroadcastReceiver {
        private Callback asCallback;

        public Receiver(Callback callback) {
            this.asCallback = callback;
        }

        public void onReceive(Context context, Intent intent) {
            String ASPResult;
            context.unregisterReceiver((BroadcastReceiver)this);
            Bundle bundle = intent.getExtras();
            if (bundle != null && (ASPResult = bundle.getString("it.unical.mat.embasp.specializations.dlv.android.SOLVER_RESULT")) != null) {
                this.asCallback.callback(new DLV2AnswerSets(ASPResult));
            }
        }
    }
}

