/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.parsers.asp.clingo;

import it.unical.mat.parsers.asp.ASPDataCollection;
import it.unical.mat.parsers.asp.clingo.ClingoLexer;
import it.unical.mat.parsers.asp.clingo.ClingoParser;
import it.unical.mat.parsers.asp.clingo.ClingoParserBaseVisitor;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public class ClingoParserBaseVisitorImplementation
extends ClingoParserBaseVisitor<Void> {
    private final ASPDataCollection answerSets;

    private ClingoParserBaseVisitorImplementation(ASPDataCollection answerSets) {
        this.answerSets = answerSets;
    }

    @Override
    public Void visitAnswer_set(ClingoParser.Answer_setContext ctx) {
        this.answerSets.addAnswerSet();
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitModel(ClingoParser.ModelContext ctx) {
        String cost = ctx.NEW_LINE().getText().trim();
        if (cost.length() > 1) {
            String[] tokens = cost.split(" ");
            int levels = tokens.length - 1;
            for (int i = 1; i < tokens.length; ++i) {
                this.answerSets.storeCost(levels--, Integer.parseInt(tokens[i]));
            }
        }
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitPredicate_atom(ClingoParser.Predicate_atomContext ctx) {
        this.answerSets.storeAtom(ctx.getText());
        return null;
    }

    public static void parse(ASPDataCollection answerSets, String atomsList, boolean two_stageParsing) {
        block3: {
            CommonTokenStream tokens = new CommonTokenStream(new ClingoLexer(CharStreams.fromString(atomsList)));
            ClingoParser parser = new ClingoParser(tokens);
            ClingoParserBaseVisitorImplementation visitor = new ClingoParserBaseVisitorImplementation(answerSets);
            if (!two_stageParsing) {
                visitor.visit(parser.output());
                return;
            }
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parser.removeErrorListeners();
            parser.setErrorHandler(new BailErrorStrategy());
            try {
                visitor.visit(parser.output());
            }
            catch (RuntimeException exception) {
                if (exception.getClass() != RuntimeException.class || !(exception.getCause() instanceof RecognitionException)) break block3;
                tokens.seek(0);
                parser.addErrorListener(ConsoleErrorListener.INSTANCE);
                parser.setErrorHandler(new DefaultErrorStrategy());
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                visitor.visit(parser.output());
            }
        }
    }
}

