/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.base;

import it.unical.mat.embasp.base.Callback;
import it.unical.mat.embasp.base.InputProgram;
import it.unical.mat.embasp.base.OptionDescriptor;
import it.unical.mat.embasp.base.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Handler {
    protected Map<Integer, InputProgram> programs = new HashMap<Integer, InputProgram>();
    protected Map<Integer, OptionDescriptor> options = new HashMap<Integer, OptionDescriptor>();

    public int addOption(OptionDescriptor o) {
        int last_index;
        int current_value = last_index = this.options.size();
        this.options.put(last_index++, o);
        return current_value;
    }

    public int addProgram(InputProgram program) {
        int last_index;
        int current_value = last_index = this.programs.size();
        this.programs.put(last_index++, program);
        return current_value;
    }

    protected List<OptionDescriptor> collect_options(List<Integer> option_index) {
        ArrayList<OptionDescriptor> input_option = new ArrayList<OptionDescriptor>();
        if (option_index == null) {
            for (Map.Entry<Integer, OptionDescriptor> option : this.options.entrySet()) {
                input_option.add(this.options.get(option.getKey()));
            }
        } else {
            for (int index : option_index) {
                input_option.add(this.options.get(index));
            }
        }
        return input_option;
    }

    protected List<InputProgram> collect_programs(List<Integer> program_index) {
        ArrayList<InputProgram> input_programs = new ArrayList<InputProgram>();
        if (program_index == null) {
            for (Map.Entry<Integer, InputProgram> program : this.programs.entrySet()) {
                input_programs.add(this.programs.get(program.getKey()));
            }
        } else {
            for (int index : program_index) {
                input_programs.add(this.programs.get(index));
            }
        }
        return input_programs;
    }

    public InputProgram getInputProgram(int key) {
        return this.programs.get(key);
    }

    public OptionDescriptor getOptionDescriptor(int key) {
        return this.options.get(key);
    }

    public void removeAll() {
        this.programs.clear();
        this.options.clear();
    }

    public void removeOption(int option_id) {
        this.options.remove(option_id);
    }

    public boolean removeOption(OptionDescriptor o) {
        boolean result = false;
        for (Map.Entry<Integer, OptionDescriptor> entry : this.options.entrySet()) {
            if (!entry.getValue().equals(o)) continue;
            this.options.remove(entry.getKey());
            result = true;
        }
        return result;
    }

    public boolean removeProgram(InputProgram p) {
        boolean result = false;
        for (Map.Entry<Integer, InputProgram> entry : this.programs.entrySet()) {
            if (!entry.getValue().equals(p)) continue;
            this.programs.remove(entry.getKey());
            result = true;
        }
        return result;
    }

    public void removeProgram(int program_id) {
        this.programs.remove(program_id);
    }

    public void startAsync(Callback c) {
        this.startAsync(c, null, null);
    }

    public void startAsync(Callback c, List<Integer> program_index, List<Integer> option_index) {
    }

    public Output startSync() {
        return this.startSync(null, null);
    }

    public Output startSync(List<Integer> program_index, List<Integer> option_index) {
        return null;
    }
}

