/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class InputProgram {
    protected String programs;
    private List<String> files_paths;
    protected String separator;

    public InputProgram() {
        this.init();
        this.separator = " ";
    }

    public InputProgram(Object inputObj) throws Exception {
        this.init();
        this.addObjectInput(inputObj);
    }

    public InputProgram(String initial_program) {
        this.init();
        this.programs = initial_program;
    }

    public void addFilesPath(String file_path) {
        this.files_paths.add(file_path);
    }

    public void addObjectInput(Object inputObj) throws Exception {
        throw new UnsupportedOperationException("functionality not implemented");
    }

    public void addObjectsInput(Set<Object> inputObjs) throws Exception {
        for (Object inputObj : inputObjs) {
            this.addObjectInput(inputObj);
        }
    }

    public void addProgram(String new_instruction) {
        this.programs = this.programs.isEmpty() ? new_instruction : this.programs + this.separator + new_instruction;
    }

    public void clearAll() {
        this.clearFilesPaths();
        this.clearPrograms();
    }

    public void clearFilesPaths() {
        this.files_paths.clear();
    }

    public void clearPrograms() {
        this.programs = "";
    }

    public List<String> getFilesPaths() {
        return this.files_paths;
    }

    public String getPrograms() {
        return this.programs;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getStringOfFilesPaths() {
        StringBuilder to_return = new StringBuilder();
        for (String paths : this.files_paths) {
            if (paths.length() == 0) continue;
            to_return.append(paths).append(" ");
        }
        return to_return.toString();
    }

    private void init() {
        this.programs = new String();
        this.files_paths = new ArrayList<String>();
    }

    public void setPrograms(String programs) {
        this.programs = programs;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

