/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.languages;

import it.unical.mat.embasp.languages.Id;
import it.unical.mat.embasp.languages.IllegalAnnotationException;
import it.unical.mat.embasp.languages.ObjectNotValidException;
import it.unical.mat.embasp.languages.Param;
import it.unical.mat.embasp.languages.asp.IllegalTermException;
import it.unical.mat.embasp.languages.asp.SymbolicConstant;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class Mapper {
    protected final Map<String, Class<?>> predicateClass = new HashMap();
    protected final Map<Class<?>, Map<String, Method>> classSetterMethod = new HashMap();

    protected abstract String getActualString(String var1, HashMap<Integer, Object> var2) throws IllegalTermException;

    public Class<?> getClass(String predicate) {
        return this.predicateClass.get(predicate);
    }

    public Object getObject(String atom) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException {
        String predicate = this.getId(atom);
        if (predicate == null) {
            return null;
        }
        Class<?> cl = this.getClass(predicate);
        if (cl == null) {
            return null;
        }
        String[] parameters = this.getParam(atom);
        if (parameters == null) {
            return null;
        }
        Object object = cl.newInstance();
        this.populateObject(cl, parameters, object);
        return object;
    }

    protected abstract String getId(String var1);

    protected abstract String[] getParam(String var1);

    public String getString(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ObjectNotValidException, IllegalAnnotationException, IllegalTermException {
        String predicate = this.registerClass(obj.getClass());
        HashMap<Integer, Object> parametersMap = new HashMap<Integer, Object>();
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (field.isSynthetic() || !field.isAnnotationPresent(Param.class)) continue;
            Object value = obj.getClass().getMethod("get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1), new Class[0]).invoke(obj, new Object[0]);
            parametersMap.put(field.getAnnotation(Param.class).value(), value);
        }
        return this.getActualString(predicate, parametersMap);
    }

    private void populateObject(Class<?> cl, String[] parameters, Object obj) throws IllegalAccessException, InvocationTargetException {
        for (Field field : cl.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Param.class)) continue;
            int term = field.getAnnotation(Param.class).value();
            String nameMethod = "set" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
            Method method = this.classSetterMethod.get(cl).get(nameMethod);
            if (method.getParameterTypes()[0].getName().equals(Integer.TYPE.getName()) || method.getParameterTypes()[0].getName().equals(Integer.class.getName())) {
                method.invoke(obj, Integer.valueOf(parameters[term]));
                continue;
            }
            if (method.getParameterTypes()[0].getName().equals(SymbolicConstant.class.getName())) {
                method.invoke(obj, new SymbolicConstant(parameters[term]));
                continue;
            }
            method.invoke(obj, parameters[term]);
        }
    }

    public String registerClass(Class<?> cl) throws ObjectNotValidException, IllegalAnnotationException {
        Id annotation = cl.getAnnotation(Id.class);
        if (annotation == null) {
            throw new IllegalAnnotationException();
        }
        String predicate = annotation.value();
        if (predicate.contains(" ")) {
            throw new ObjectNotValidException();
        }
        this.predicateClass.put(predicate, cl);
        HashMap<String, Method> namesMethods = new HashMap<String, Method>();
        for (Method method : cl.getMethods()) {
            if (!method.getName().startsWith("set")) continue;
            namesMethods.put(method.getName(), method);
        }
        this.classSetterMethod.put(cl, namesMethods);
        return predicate;
    }

    public void unregisterClass(Class<?> cl) throws IllegalAnnotationException {
        Id annotation = cl.getAnnotation(Id.class);
        if (annotation == null) {
            throw new IllegalAnnotationException();
        }
        String predicate = annotation.value();
        this.predicateClass.remove(predicate);
        this.classSetterMethod.remove(cl);
    }
}

