/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.languages.asp;

import it.unical.mat.embasp.base.Output;
import it.unical.mat.embasp.languages.asp.AnswerSet;
import it.unical.mat.parsers.asp.ASPDataCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AnswerSets
extends Output
implements ASPDataCollection {
    protected List<AnswerSet> answersets;

    public AnswerSets(String out) {
        super(out);
    }

    public AnswerSets(String out, String err) {
        super(out, err);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public List<AnswerSet> getAnswersets() {
        if (this.answersets == null) {
            this.answersets = new ArrayList<AnswerSet>();
            this.parse();
        }
        return Collections.unmodifiableList(this.answersets);
    }

    public List<AnswerSet> getOptimalAnswerSets() {
        int level = 0;
        List<AnswerSet> answerSets = this.getAnswersets();
        ArrayList<AnswerSet> optimalAnswerSets = new ArrayList<AnswerSet>();
        for (AnswerSet answerSet : answerSets) {
            int maxLevel = Collections.max(answerSet.getWeights().keySet());
            if (level >= maxLevel) continue;
            level = maxLevel;
        }
        while (level >= 1) {
            int minimumCost = Integer.MAX_VALUE;
            for (AnswerSet answerSet : answerSets) {
                int cost = answerSet.getWeights().getOrDefault(level, 0);
                if (cost < minimumCost) {
                    optimalAnswerSets.clear();
                    minimumCost = cost;
                }
                if (cost != minimumCost) continue;
                optimalAnswerSets.add(answerSet);
            }
            answerSets = new ArrayList<AnswerSet>(optimalAnswerSets);
            --level;
        }
        return optimalAnswerSets;
    }

    public String getAnswerSetsString() {
        return this.output;
    }

    @Override
    public void addAnswerSet() {
        this.answersets.add(new AnswerSet(new ArrayList<String>()));
    }

    @Override
    public void storeAtom(String result) {
        this.answersets.get(this.answersets.size() - 1).getValue().add(result);
    }

    @Override
    public void storeCost(int level, int weight) {
        this.answersets.get(this.answersets.size() - 1).getLevelWeight().put(level, weight);
    }
}

