/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.parsers.asp.dlv2;

import it.unical.mat.parsers.asp.ASPDataCollection;
import it.unical.mat.parsers.asp.dlv2.DLV2Lexer;
import it.unical.mat.parsers.asp.dlv2.DLV2Parser;
import it.unical.mat.parsers.asp.dlv2.DLV2ParserBaseVisitor;
import java.util.HashMap;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public class DLV2ParserBaseVisitorImplementation
extends DLV2ParserBaseVisitor<Void> {
    private final ASPDataCollection answerSets;
    private HashMap<Integer, Integer> costs;

    private DLV2ParserBaseVisitorImplementation(ASPDataCollection answerSets) {
        this.answerSets = answerSets;
    }

    @Override
    public Void visitAnswer_set(DLV2Parser.Answer_setContext ctx) {
        this.answerSets.addAnswerSet();
        if (ctx.cost() != null && !ctx.cost().isEmpty()) {
            this.costs = new HashMap();
            String[] firstCost = ctx.cost().COST_LABEL().getText().split(" ")[1].split("@");
            this.costs.put(Integer.parseInt(firstCost[1]), Integer.parseInt(firstCost[0]));
        }
        if (this.costs != null) {
            this.costs.forEach((level, cost) -> this.answerSets.storeCost((int)level, (int)cost));
        }
        return (Void)this.visitChildren(ctx);
    }

    @Override
    public Void visitLevel(DLV2Parser.LevelContext ctx) {
        int level = Integer.parseInt(ctx.INTEGER(1).getText());
        int cost = Integer.parseInt(ctx.INTEGER(0).getText());
        this.costs.put(level, cost);
        this.answerSets.storeCost(level, cost);
        return null;
    }

    @Override
    public Void visitPredicate_atom(DLV2Parser.Predicate_atomContext ctx) {
        this.answerSets.storeAtom(ctx.getText());
        return null;
    }

    public static void parse(ASPDataCollection answerSets, String atomsList, boolean two_stageParsing) {
        block3: {
            CommonTokenStream tokens = new CommonTokenStream(new DLV2Lexer(CharStreams.fromString(atomsList)));
            DLV2Parser parser = new DLV2Parser(tokens);
            DLV2ParserBaseVisitorImplementation visitor = new DLV2ParserBaseVisitorImplementation(answerSets);
            if (!two_stageParsing) {
                visitor.visit(parser.output());
                return;
            }
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parser.removeErrorListeners();
            parser.setErrorHandler(new BailErrorStrategy());
            try {
                visitor.visit(parser.output());
            }
            catch (RuntimeException exception) {
                if (exception.getClass() != RuntimeException.class || !(exception.getCause() instanceof RecognitionException)) break block3;
                tokens.seek(0);
                parser.addErrorListener(ConsoleErrorListener.INSTANCE);
                parser.setErrorHandler(new DefaultErrorStrategy());
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                visitor.visit(parser.output());
            }
        }
    }
}

