/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.parsers.pddl.solver_planning_domains;

import it.unical.mat.parsers.pddl.PDDLDataCollection;
import it.unical.mat.parsers.pddl.solver_planning_domains.SPDGrammarBaseVisitor;
import it.unical.mat.parsers.pddl.solver_planning_domains.SPDGrammarLexer;
import it.unical.mat.parsers.pddl.solver_planning_domains.SPDGrammarParser;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public class SPDGrammarBaseVisitorImplementation
extends SPDGrammarBaseVisitor<Void> {
    private static final int OK_STATUS = 1;
    private static final int ERROR_STATUS = -1;
    private int status;
    private final PDDLDataCollection actions;
    private String errors = "";

    private SPDGrammarBaseVisitorImplementation(PDDLDataCollection actions) {
        this.actions = actions;
    }

    @Override
    public Void visitPair(SPDGrammarParser.PairContext ctx) {
        SPDGrammarParser.ValueContext valueContext = ctx.value();
        String string = ctx.STRING().getText();
        if (this.status == 0 && string.equalsIgnoreCase("\"status\"")) {
            this.status = valueContext.getText().equalsIgnoreCase("\"ok\"") ? 1 : -1;
        } else if (this.status == -1) {
            if (string.equalsIgnoreCase("\"result\"")) {
                if (valueContext instanceof SPDGrammarParser.ArrayValueContext || valueContext instanceof SPDGrammarParser.ObjectValueContext) {
                    return (Void)this.visitChildren(ctx);
                }
                this.errors = this.errors + SPDGrammarBaseVisitorImplementation.trim(valueContext.getText());
            } else if (string.equalsIgnoreCase("\"error\"")) {
                this.errors = this.errors + SPDGrammarBaseVisitorImplementation.trim(valueContext.getText());
            }
        } else if (this.status == 1) {
            if (string.equalsIgnoreCase("\"name\"")) {
                this.actions.storeAction(SPDGrammarBaseVisitorImplementation.trim(valueContext.getText()));
            } else if (string.equalsIgnoreCase("\"plan\"") || string.equalsIgnoreCase("\"result\"")) {
                return (Void)this.visitChildren(ctx);
            }
        }
        return null;
    }

    private static String trim(String string) {
        int stringLength = string.length();
        return string.charAt(0) == '\"' && string.charAt(stringLength - 1) == '\"' ? string.substring(1, stringLength - 1) : string;
    }

    public static String parse(PDDLDataCollection actions, String spdOutput, boolean two_stageParsing) {
        SPDGrammarBaseVisitorImplementation visitor;
        block3: {
            CommonTokenStream tokens = new CommonTokenStream(new SPDGrammarLexer(CharStreams.fromString(spdOutput)));
            SPDGrammarParser parser = new SPDGrammarParser(tokens);
            visitor = new SPDGrammarBaseVisitorImplementation(actions);
            if (!two_stageParsing) {
                visitor.visit(parser.json());
                return visitor.errors;
            }
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parser.removeErrorListeners();
            parser.setErrorHandler(new BailErrorStrategy());
            try {
                visitor.visit(parser.json());
            }
            catch (RuntimeException exception) {
                if (exception.getClass() != RuntimeException.class || !(exception.getCause() instanceof RecognitionException)) break block3;
                tokens.seek(0);
                parser.addErrorListener(ConsoleErrorListener.INSTANCE);
                parser.setErrorHandler(new DefaultErrorStrategy());
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                visitor.visit(parser.json());
            }
        }
        return visitor.errors;
    }
}

