/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.jdlv.program;

import it.unical.mat.jdlv.program.DLVProgram;
import java.util.HashMap;

public class JDLVProgramManager {
    private static JDLVProgramManager instance;
    private DLVProgram currentProgram;
    private DLVProgram defaultProgram;
    private DLVProgram executingProgram;
    private HashMap<String, DLVProgram> programList = new HashMap();

    private JDLVProgramManager() {
    }

    public DLVProgram getCurrentProgram() {
        return this.currentProgram;
    }

    public static JDLVProgramManager getInstance() {
        if (instance == null) {
            instance = new JDLVProgramManager();
        }
        return instance;
    }

    public void startExecutingProgram() {
        this.currentProgram = this.executingProgram = new DLVProgram();
    }

    public void startDefaultProgram() {
        this.currentProgram = this.defaultProgram = new DLVProgram();
    }

    public void startProgram(String identifier) {
        if (!this.programList.containsKey(identifier)) {
            DLVProgram tmpProgram = new DLVProgram();
            this.programList.put(identifier, tmpProgram);
            this.currentProgram = tmpProgram;
        }
    }

    public void startProgramTag(String identifier) {
        if (this.programList.containsKey(identifier)) {
            this.currentProgram = this.programList.get(identifier);
        }
    }

    public void setOptions(String options) {
        this.getCurrentProgram().setExecutingOptions(options);
    }

    public void addOutputVariable(String identifier) {
        this.getCurrentProgram().addOutput(identifier);
    }
}

