/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.jdlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.jdlv.program.ClassTranslatorSupportInterface;
import it.unical.mat.jdlv.program.ClassTranslatorSupportManager;
import it.unical.mat.jdlv.program.Factizable;
import it.unical.mat.jdlv.program.HibernateClassTranslatorSupport;
import it.unical.mat.jdlv.util.JdlvProperties;
import it.unical.mat.jdlv.util.Util;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.Predicate;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TypeSolver {
    static HashMap<String, List<Class<? extends Object>>> usedMappings = new HashMap();
    static ClassTranslatorSupportManager classTranslatorSupportMap = new ClassTranslatorSupportManager();
    static Set<Object> writedObject = new HashSet<Object>();
    static HashMap<Object, Object> objectsMap = new HashMap();
    static Model currentModel = null;

    public static String getTypeTranslation(Object object) {
        if (Util.isPrimitiveType(object)) {
            return Util.getPrimitiveTypeTranslation(object);
        }
        if (object instanceof Factizable) {
            return String.valueOf(object.getClass().getName()) + ((Factizable)object).toFact();
        }
        if (object instanceof Collection) {
            StringBuffer buffer = new StringBuffer();
            for (Object objectInCollection : (Collection)object) {
                buffer.append(TypeSolver.getTypeTranslation(objectInCollection));
            }
            return buffer.toString();
        }
        return String.valueOf(classTranslatorSupportMap.get(object.getClass()).getObjectTranslation(object, new String[0])) + '\n';
    }

    public static String translateJavaName(String javaName, Class<? extends Object> clazz) {
        if (javaName.contains(".")) {
            String[] javaNames = javaName.split(".");
            Class<Object> tmpClazz = clazz;
            int i = 0;
            while (i < javaNames.length) {
                try {
                    Field field = tmpClazz.getDeclaredField(javaName);
                    tmpClazz = field.getType();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return classTranslatorSupportMap.get(tmpClazz).getPredicateName();
        }
        try {
            Field field = clazz.getDeclaredField(javaName);
            if (field != null) {
                Class<?> fieldClass = field.getType();
                return classTranslatorSupportMap.get(fieldClass).getPredicateName();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return "\"" + javaName + "\"";
    }

    public static String getNameTranslation(Object object, String variableName) {
        if (Util.isPrimitiveType(object)) {
            return String.valueOf(variableName) + "(" + Util.getPrimitiveTypeTranslation(object) + ").";
        }
        if (object instanceof Factizable) {
            return String.valueOf(object.getClass().getName()) + ((Factizable)object).toFact();
        }
        if (object instanceof Collection) {
            StringBuffer buffer = new StringBuffer();
            for (Object objectInCollection : (Collection)object) {
                buffer.append(TypeSolver.getNameTranslation(objectInCollection, variableName));
            }
            return buffer.toString();
        }
        return String.valueOf(classTranslatorSupportMap.get(object.getClass()).getObjectTranslation(object, variableName)) + '\n';
    }

    public static void loadPredicate(Collection variable, String predicateName, Model model, Class<?> clazz) {
        currentModel = model;
        if (Factizable.class.isAssignableFrom(clazz)) {
            Collection<Object> object = variable;
            try {
                object = clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            variable.clear();
            variable.addAll(((Factizable)((Object)object)).fromFacts(model));
        } else {
            TypeSolver.fromFact(variable, predicateName, model, clazz);
        }
    }

    public static void fromFact(Collection variable, String variableName, Model model, Class<?> clazz) {
        ArrayList<Object> predicateList = new ArrayList<Object>();
        model.beforeFirst();
        while (model.hasMorePredicates()) {
            Predicate predicate = model.nextPredicate();
            if (!predicate.name().equals(variableName)) continue;
            predicate.beforeFirst();
            while (predicate.hasMoreLiterals()) {
                Predicate.ResultLiteral resultLiteral = predicate.nextResultLiteral();
                if (clazz.equals(String.class)) {
                    predicateList.add(Util.getStringContent(resultLiteral.getTermAt(0).toString()));
                    continue;
                }
                if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                    predicateList.add(Integer.parseInt(resultLiteral.getTermAt(0).toString()));
                    continue;
                }
                if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
                    Character character = Character.valueOf(Util.getStringContent(resultLiteral.getTermAt(0).toString()).charAt(0));
                    predicateList.add(character);
                    continue;
                }
                if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                    predicateList.add(resultLiteral.getTermAt(0).toString().toLowerCase().equals("true"));
                    continue;
                }
                if (clazz.equals(Date.class)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(JdlvProperties.getInstance().getJdlvDataFormatValue());
                    try {
                        predicateList.add(sdf.parse(Util.getStringContent(resultLiteral.getTermAt(0).toString())));
                    }
                    catch (ParseException e) {
                        predicateList.add(new Date());
                        e.printStackTrace();
                    }
                    continue;
                }
                ClassTranslatorSupportInterface classTranslatorSupport = classTranslatorSupportMap.get(clazz);
                Object newObject = classTranslatorSupport.getObjectInstance(resultLiteral);
                if (classTranslatorSupport instanceof HibernateClassTranslatorSupport) {
                    HibernateClassTranslatorSupport hibernateClassTranslatorSupport = (HibernateClassTranslatorSupport)classTranslatorSupport;
                    hibernateClassTranslatorSupport.getObjectInstance(resultLiteral);
                }
                predicateList.add(newObject);
            }
        }
        variable.clear();
        variable.addAll(predicateList);
    }

    public static void addUsedMapping(String predicateName, Class<? extends Object> clazz) {
        if (!usedMappings.containsKey(predicateName)) {
            usedMappings.put(predicateName, new ArrayList());
        }
        usedMappings.get(predicateName).add(clazz);
    }

    public static ClassTranslatorSupportInterface getClassTranslatorSupport(Class<? extends Object> clazz) {
        return classTranslatorSupportMap.get(clazz);
    }

    public static void loadPredicate(Collection variable, Model model, Class<?> clazz) {
        currentModel = model;
        String predicateName = classTranslatorSupportMap.get(clazz).getPredicateName();
        TypeSolver.loadPredicate(variable, predicateName, model, clazz);
    }

    public static String translateNonPositionalAtom(String atom, Class clazz) {
        Rule rule = new Rule(String.valueOf(atom.toString()) + ".");
        if (rule.getHead() != null && !rule.getHead().isEmpty() && rule.head().get(0) instanceof NormalAtom) {
            String translatedAtom = classTranslatorSupportMap.get(clazz).translateNonPositionalAtom((Atom)rule.head().get(0)).toString();
            return translatedAtom;
        }
        return atom;
    }
}

