/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.metainfo;

import it.unical.mat.dlv.metainfo.DatabaseTableInfo;
import it.unical.mat.dlv.metainfo.datatype.AnyDatatype;
import it.unical.mat.dlv.metainfo.datatype.CustomDatatype;
import it.unical.mat.dlv.metainfo.datatype.Datatype;
import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Comment;
import it.unical.mat.dlv.program.DirectiveAnalyzer;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.ImportDirective;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.error.AritySchemaError;
import it.unical.mat.dlv.program.error.AttributeNameSchemaError;
import it.unical.mat.dlv.program.error.SchemaError;
import it.unical.mat.dlv.typ.CreateDefinition;
import it.unical.mat.dlv.typ.UseDefinition;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Schema {
    String name;
    List<Attribute> attributes = new LinkedList<Attribute>();
    ImportDirective importDir = null;
    UseDefinition useDefinition = null;
    CreateDefinition createDefinition = null;
    int line;
    int endLine;
    int beginColumn;
    int endColumn;

    public Schema(String name) {
        this.name = name;
    }

    public Schema(String name, ImportDirective importDir) {
        this.name = name;
        this.importDir = importDir;
    }

    public Schema(String name, UseDefinition useDefinition) {
        this.name = name;
        this.useDefinition = useDefinition;
    }

    public Schema(String name, CreateDefinition createDefinition) {
        this.name = name;
        this.createDefinition = createDefinition;
    }

    public Expression getExpression() {
        Expression expression = this.getImportDirective();
        if (expression == null) {
            expression = this.getUseDefinition() != null ? this.getUseDefinition().getUseDefinitionAsAnnotation() : (this.getCreateDefinition() != null ? this.getCreateDefinition().getCreateDefinitionAsAnnotation() : this.getSchemaAsAnnotation());
        }
        expression.setBeginLine(this.getBeginLine());
        expression.setEndLine(this.getEndLine());
        expression.setBeginColumn(this.getBeginColumn());
        if (expression instanceof Comment) {
            expression.setEndColumn(this.getEndColumn() - 1);
        } else {
            expression.setEndColumn(this.getEndColumn());
        }
        return expression;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
    }

    public int getArity() {
        return this.attributes.size();
    }

    public String getSchemaAsString() {
        String contentDirective = String.valueOf(this.getName()) + "(";
        boolean isFirst = true;
        for (Attribute attr : this.getAttributes()) {
            if (isFirst) {
                isFirst = false;
            } else {
                contentDirective = String.valueOf(contentDirective) + ", ";
            }
            contentDirective = String.valueOf(contentDirective) + attr.getName() + ":" + attr.getDatatype();
            if (attr.getOriginalDatatype() == null) continue;
            contentDirective = String.valueOf(contentDirective) + ":" + attr.getOriginalDatatype();
        }
        contentDirective = String.valueOf(contentDirective) + ")";
        return contentDirective;
    }

    public Comment getSchemaAsAnnotation() {
        return new Comment("%@schema " + this.getSchemaAsString());
    }

    public ImportDirective getImportDirective() {
        return this.importDir;
    }

    public void setImportDirective(ImportDirective importDir) {
        this.importDir = importDir;
    }

    public UseDefinition getUseDefinition() {
        return this.useDefinition;
    }

    public void setUseDefinition(UseDefinition useDefinition) {
        this.useDefinition = useDefinition;
    }

    public CreateDefinition getCreateDefinition() {
        return this.createDefinition;
    }

    public void setCreateDefinition(CreateDefinition createDefinition) {
        this.createDefinition = createDefinition;
    }

    public String toString() {
        return "@schema " + this.getSchemaAsString();
    }

    public void refreshInternalObjects() {
        block16: {
            block17: {
                block15: {
                    if (this.importDir == null) break block15;
                    this.importDir.setPredicateName(this.getName());
                    this.importDir.clearTypes();
                    int counter = 1;
                    for (Attribute attr : this.getAttributes()) {
                        attr.setName("attr" + counter++);
                        this.importDir.addType(ImportDirective.getImportDirectiveTypeConv((CustomDatatype)attr.getOriginalDatatype()));
                    }
                    break block16;
                }
                if (this.useDefinition == null) break block17;
                this.useDefinition.setPredicateName(this.getName());
                this.useDefinition.clearTableNameAttributes();
                this.useDefinition.clearPredicateTypes();
                for (Attribute attr : this.getAttributes()) {
                    this.useDefinition.addTableNameAttribute(attr.getName());
                    String attributeType = "VARCHAR";
                    int precision = 0;
                    int scale = 0;
                    if (attr.getOriginalDatatype() != null) {
                        attributeType = attr.getOriginalDatatype().getName();
                        precision = attr.getOriginalDatatype().getPrecision();
                        scale = attr.getOriginalDatatype().getScale();
                    }
                    int size = 1;
                    if (precision > 0 && scale == 0) {
                        size = 2;
                    } else if (scale > 0) {
                        size = 3;
                    }
                    String[] type = new String[size];
                    type[0] = attributeType;
                    if (size > 1) {
                        type[1] = String.valueOf(precision);
                        if (size > 2) {
                            type[2] = String.valueOf(scale);
                        }
                    }
                    this.useDefinition.addPredicateType(type);
                }
                break block16;
            }
            if (this.createDefinition == null) break block16;
            this.createDefinition.setPredicateName(this.getName());
            this.createDefinition.clearTableNameAttributes();
            this.createDefinition.clearPredicateTypes();
            for (Attribute attr : this.getAttributes()) {
                this.createDefinition.addTableNameAttribute(attr.getName());
                String attributeType = "VARCHAR";
                int precision = 0;
                int scale = 0;
                if (attr.getOriginalDatatype() != null) {
                    attributeType = attr.getOriginalDatatype().getName();
                    precision = attr.getOriginalDatatype().getPrecision();
                    scale = attr.getOriginalDatatype().getScale();
                }
                int size = 1;
                if (precision > 0 && scale == 0) {
                    size = 2;
                } else if (scale > 0) {
                    size = 3;
                }
                String[] type = new String[size];
                type[0] = attributeType;
                if (size > 1) {
                    type[1] = String.valueOf(precision);
                    if (size > 2) {
                        type[2] = String.valueOf(scale);
                    }
                }
                this.createDefinition.addPredicateType(type);
            }
        }
    }

    public int getBeginLine() {
        return this.line;
    }

    public void setBeginLine(int line) {
        this.line = line;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public DatabaseTableInfo getDatabaseTableInfo() {
        if (this.importDir != null) {
            return new DatabaseTableInfo(this.importDir.getDatabaseName(), this.importDir.getUsername(), this.importDir.getPassword());
        }
        if (this.useDefinition != null) {
            return new DatabaseTableInfo(this.useDefinition.getDatabaseName(), this.useDefinition.getUsername(), this.useDefinition.getPassword(), this.useDefinition.getTableName());
        }
        return null;
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schema other = (Schema)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static List<SchemaError> getAritySchemaErrors(Schema expectedSchema, ImportDirective importDirective) {
        List<SchemaError> errors = Schema.getAritySchemaErrors(expectedSchema, Schema.getSchema(importDirective));
        return errors;
    }

    public static List<SchemaError> getAritySchemaErrors(Schema expectedSchema, Schema schema) {
        ArrayList<SchemaError> errors = new ArrayList<SchemaError>();
        if (expectedSchema.getArity() != schema.getArity()) {
            String errorText = "Expected arity " + expectedSchema.getArity() + " for schema '" + schema.getSchemaAsString() + "' after the comparing with an other schema";
            errors.add(new AritySchemaError(errorText, expectedSchema, schema));
        }
        return errors;
    }

    public static List<SchemaError> getAttributeNameSchemaErrors(Schema schema) {
        ArrayList<SchemaError> errors = new ArrayList<SchemaError>();
        if (schema.getImportDirective() == null) {
            int i = 0;
            while (i < schema.getAttributes().size() - 1) {
                Attribute expectedAttribute = schema.getAttributes().get(i);
                int j = i + 1;
                while (j < schema.getAttributes().size()) {
                    Attribute attribute = schema.getAttributes().get(j);
                    if (expectedAttribute.getName().equals(attribute.getName())) {
                        String errorText = "The attribute '" + attribute.toString() + "' has the same name with the attribute '" + expectedAttribute.toString() + "'";
                        errors.add(new AttributeNameSchemaError(errorText, schema, expectedAttribute, attribute, true));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return errors;
    }

    public static List<SchemaError> getAttributeNameSchemaErrors(Schema expectedSchema, Schema schema) {
        ArrayList<SchemaError> errors = new ArrayList<SchemaError>();
        if (expectedSchema.getArity() == schema.getArity() && schema.getImportDirective() == null) {
            ListIterator<Attribute> itAttrExpected = expectedSchema.getAttributes().listIterator();
            ListIterator<Attribute> itAttr = schema.getAttributes().listIterator();
            boolean exit = false;
            while (itAttrExpected.hasNext() && !exit) {
                Attribute expectedAttribute = (Attribute)itAttrExpected.next();
                Attribute attribute = (Attribute)itAttr.next();
                if (expectedAttribute.getName().equals(attribute.getName())) continue;
                String errorText = "The attribute '" + attribute.getName() + "' has a different name with the attribute '" + expectedAttribute.getName() + "' of the schema '" + expectedSchema.getName() + "'";
                errors.add(new AttributeNameSchemaError(errorText, schema, expectedAttribute, attribute, false));
            }
        }
        return errors;
    }

    public static Schema buildSchema(String predicateName, List<String> attrsNames, List<String> attrsInternalTypes, List<String> attrsExternalTypes, List<Integer> precisions, List<Integer> scales) {
        Schema schema = new Schema(predicateName);
        ListIterator<String> itNames = attrsNames.listIterator();
        ListIterator<String> itInternalTypes = attrsInternalTypes.listIterator();
        ListIterator<String> itExternalTypes = attrsExternalTypes.listIterator();
        ListIterator<Integer> itPrecisions = precisions.listIterator();
        ListIterator<Integer> itScales = scales.listIterator();
        while (itNames.hasNext()) {
            String attrName = (String)itNames.next();
            String attrInternalType = (String)itInternalTypes.next();
            String attrExternalType = (String)itExternalTypes.next();
            Integer precision = (Integer)itPrecisions.next();
            Integer scale = (Integer)itScales.next();
            Datatype datatype = attrInternalType == null ? AnyDatatype.getInstance() : (attrInternalType.trim().equals("ANY") ? AnyDatatype.getInstance() : new CustomDatatype(attrInternalType.trim()));
            if (attrExternalType != null) {
                CustomDatatype originaldatatype = new CustomDatatype(attrExternalType.trim());
                if (precision != null) {
                    originaldatatype.setPrecision(precision);
                    if (scale != null) {
                        originaldatatype.setScale(scale);
                    }
                }
                Schema schema2 = schema;
                schema2.getClass();
                schema.addAttribute(schema2.new Attribute(attrName, datatype, originaldatatype));
                continue;
            }
            Schema schema3 = schema;
            schema3.getClass();
            schema.addAttribute(schema3.new Attribute(attrName, datatype));
        }
        return schema;
    }

    public static Schema getSchema(Comment annotation) throws ParseException, UnsupportedEncodingException {
        Schema schema = Schema.getSchema(annotation.getContent());
        schema.setBeginLine(annotation.getBeginLine());
        schema.setEndLine(annotation.getEndLine());
        schema.setBeginColumn(annotation.getBeginColumn());
        schema.setEndColumn(annotation.getEndColumn());
        return schema;
    }

    public static Schema getSchema(String annotation) throws ParseException, UnsupportedEncodingException {
        String annot = annotation;
        if (!annot.endsWith("\n")) {
            annot = String.valueOf(annot) + "\n";
        }
        Director director = new Director(new ByteArrayInputStream(annot.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.startAnnotation();
        Schema schema = builder.getSchemaDirectives().get(builder.getSchemaDirectives().keySet().iterator().next()).get(0);
        return schema;
    }

    public static Schema getSchema(ImportDirective importDirective) {
        Schema schema = new Schema(importDirective.getPredicateName());
        if (importDirective.getTypes() != null) {
            int counter = 1;
            for (ImportDirective.ImportDirectiveTypes type : importDirective.getTypes()) {
                Schema schema2 = schema;
                schema2.getClass();
                Attribute attr = schema2.new Attribute("attr" + counter, AnyDatatype.getInstance(), new CustomDatatype("" + (Object)((Object)type)));
                schema.addAttribute(attr);
                ++counter;
            }
        }
        schema.setImportDirective(importDirective);
        schema.setBeginLine(importDirective.getBeginLine());
        schema.setEndLine(importDirective.getEndLine());
        schema.setBeginColumn(importDirective.getBeginColumn());
        schema.setEndColumn(importDirective.getEndColumn());
        return schema;
    }

    public static Schema getSchemaFromTypAnnotation(Comment annotation) throws it.unical.mat.dlv.typ.parser.ParseException {
        Schema schema = Schema.getSchemaFromTypAnnotation(annotation.getContent());
        schema.setBeginLine(annotation.getBeginLine());
        schema.setEndLine(annotation.getEndLine());
        schema.setBeginColumn(annotation.getBeginColumn());
        schema.setEndColumn(annotation.getEndColumn());
        return schema;
    }

    public static Schema getSchemaFromTypAnnotation(String annotation) throws it.unical.mat.dlv.typ.parser.ParseException {
        Schema schema = null;
        boolean tryCreate = false;
        try {
            UseDefinition useDef = DirectiveAnalyzer.getUseDefinition(annotation);
            schema = Schema.getSchema(useDef);
        }
        catch (it.unical.mat.dlv.typ.parser.ParseException e) {
            tryCreate = true;
        }
        if (tryCreate) {
            CreateDefinition createDef = DirectiveAnalyzer.getCreateDefinition(annotation);
            schema = Schema.getSchema(createDef);
        }
        return schema;
    }

    public static Schema getSchema(UseDefinition useDef) {
        Schema schema = new Schema(useDef.getPredicateName());
        ListIterator<String> itNames = useDef.getTableNameAttributes().listIterator();
        ListIterator<String[]> itTypes = useDef.getPredicateTypes().listIterator();
        while (itNames.hasNext()) {
            String attrName = (String)itNames.next();
            String[] type = (String[])itTypes.next();
            CustomDatatype externalType = new CustomDatatype(type[0]);
            if (type.length > 1) {
                externalType.setPrecision(Integer.parseInt(type[1]));
                if (type.length > 2) {
                    externalType.setScale(Integer.parseInt(type[2]));
                }
            }
            Schema schema2 = schema;
            schema2.getClass();
            Attribute attr = schema2.new Attribute(attrName, AnyDatatype.getInstance(), externalType);
            schema.addAttribute(attr);
        }
        schema.setUseDefinition(useDef);
        return schema;
    }

    public static Schema getSchema(CreateDefinition createDef) {
        Schema schema = new Schema(createDef.getPredicateName());
        ListIterator<String> itNames = createDef.getTableNameAttributes().listIterator();
        ListIterator<String[]> itTypes = createDef.getPredicateTypes().listIterator();
        while (itNames.hasNext()) {
            String attrName = (String)itNames.next();
            String[] type = (String[])itTypes.next();
            CustomDatatype externalType = new CustomDatatype(type[0]);
            if (type.length > 1) {
                externalType.setPrecision(Integer.parseInt(type[1]));
                if (type.length > 2) {
                    externalType.setScale(Integer.parseInt(type[2]));
                }
            }
            Schema schema2 = schema;
            schema2.getClass();
            Attribute attr = schema2.new Attribute(attrName, AnyDatatype.getInstance(), externalType);
            schema.addAttribute(attr);
        }
        schema.setCreateDefinition(createDef);
        return schema;
    }

    public class Attribute {
        String name;
        Datatype datatype;
        Datatype originalDatatype;

        public Attribute(String name) {
            this(name, null, null);
        }

        public Attribute(String name, Datatype datatype) {
            this(name, datatype, null);
        }

        public Attribute(String name, Datatype datatype, Datatype originalDatatype) {
            this.name = name;
            this.setDatatype(datatype);
            this.originalDatatype = originalDatatype;
        }

        public Attribute(Attribute attribute) {
            this(attribute.getName(), attribute.getDatatype(), attribute.getOriginalDatatype());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Datatype getDatatype() {
            return this.datatype;
        }

        public void setDatatype(Datatype datatype) {
            this.datatype = datatype != null ? datatype : AnyDatatype.getInstance();
        }

        public Datatype getOriginalDatatype() {
            return this.originalDatatype;
        }

        public void setOriginalDatatype(Datatype originalDatatype) {
            this.originalDatatype = originalDatatype;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.datatype == null ? 0 : this.datatype.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.originalDatatype == null ? 0 : this.originalDatatype.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attribute other = (Attribute)obj;
            if (this.datatype == null ? other.datatype != null : !this.datatype.equals(other.datatype)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.originalDatatype == null ? other.originalDatatype != null : !this.originalDatatype.equals(other.originalDatatype));
        }

        private Schema getOuterType() {
            return Schema.this;
        }

        public String toString() {
            String s = String.valueOf(this.getName()) + ":" + this.getDatatype().toString();
            if (this.getOriginalDatatype() != null) {
                s = String.valueOf(s) + ":" + this.getOriginalDatatype().toString();
            }
            return s;
        }
    }
}

