/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.metainfo.datatype;

import it.unical.mat.dlv.metainfo.datatype.CustomDatatype;
import it.unical.mat.dlv.metainfo.datatype.DatatypeMappingExternalInternal;
import it.unical.mat.dlv.metainfo.datatype.InternalDatatype;
import it.unical.mat.dlv.metainfo.datatype.TermDatatypes;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DatatypeUtils {
    public static DatatypeMappingExternalInternal loadInternalExternalDatatypes(String databaseType) {
        DatatypeMappingExternalInternal datatypeMapping = new DatatypeMappingExternalInternal(databaseType);
        try {
            Element map;
            String path = "DatatypeMapping/Internal/" + databaseType.toUpperCase() + ".xml";
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(path));
            NodeList elencomap = document.getElementsByTagName("map");
            int i = 0;
            while (i < elencomap.getLength()) {
                map = (Element)elencomap.item(i);
                String external = map.getElementsByTagName("out").item(0).getTextContent();
                String internal = map.getElementsByTagName("in").item(0).getTextContent();
                datatypeMapping.mapExternalToInternal(new CustomDatatype(external), DatatypeUtils.generateInternalType(internal));
                ++i;
            }
            path = "DatatypeMapping/External/" + databaseType.toUpperCase() + ".xml";
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            document = builder.parse(new File(path));
            elencomap = document.getElementsByTagName("map");
            i = 0;
            while (i < elencomap.getLength()) {
                map = (Element)elencomap.item(i);
                String internal = map.getElementsByTagName("in").item(0).getTextContent();
                String external = map.getElementsByTagName("out").item(0).getTextContent();
                datatypeMapping.mapInternalToExternal(DatatypeUtils.generateInternalType(internal), new CustomDatatype(external));
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return datatypeMapping;
    }

    public static InternalDatatype generateInternalType(String value) {
        TermDatatypes data = new TermDatatypes();
        if (value.equals("integer")) {
            return data.integer;
        }
        if (value.equals("real")) {
            return data.real;
        }
        if (value.equals("string")) {
            return data.string;
        }
        if (value.equals("date")) {
            return data.date;
        }
        if (value.equals("time")) {
            return data.time;
        }
        if (value.equals("xml")) {
            return data.xml;
        }
        return null;
    }
}

