/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Conjunction;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.List;

public class AggregateAtom
implements Atom {
    private String name = "";
    private Term lowerGuard = Term.NO_TERM;
    private String lowOp = "";
    private Term upperGuard = Term.NO_TERM;
    private String upOp = "";
    private ArrayList<SimpleTerm> vars = new ArrayList();
    private Conjunction body = new Conjunction();
    private int atomBeginColumn = 0;
    private int atomBeginLine = 0;
    private int atomEndLine = 0;
    private int atomEndColumn = 0;

    public AggregateAtom(String name, ArrayList<SimpleTerm> aggrVars, Conjunction aggregateSetConjunction) {
        this.name = name;
        this.vars = aggrVars;
        this.body = aggregateSetConjunction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Term getLowerGuard() {
        return this.lowerGuard;
    }

    public Term getUpperGuard() {
        return this.upperGuard;
    }

    public ArrayList<SimpleTerm> getVars() {
        return this.vars;
    }

    public Conjunction getBody() {
        return this.body;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setLowerGuard(Term lowerGuard) {
        this.lowerGuard = lowerGuard;
    }

    public void setUpperGuard(Term upperGuard) {
        this.upperGuard = upperGuard;
    }

    public void setVars(ArrayList<SimpleTerm> vars) {
        this.vars = vars;
    }

    public void setBody(Conjunction body) {
        this.body = body;
    }

    public String getLowOp() {
        return this.lowOp;
    }

    public String getUpOp() {
        return this.upOp;
    }

    public void setLowOp(String lowOp) {
        this.lowOp = lowOp;
    }

    public void setUpOp(String upOp) {
        this.upOp = upOp;
    }

    @Override
    public List<Term> getVariables() {
        ArrayList<Term> res = new ArrayList<Term>();
        for (Term term : this.getVars()) {
            res.addAll(term.getVariables());
        }
        for (Literal literal : this.getBody()) {
            res.addAll(literal.getVariables());
        }
        return res;
    }

    @Override
    public boolean isGround() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getLowOp().equals("")) {
            sb.append(this.getLowerGuard());
            sb.append(' ');
            sb.append(this.getLowOp());
            sb.append(' ');
        }
        sb.append(this.name);
        sb.append('{');
        int count = 1;
        for (Term term : this.vars) {
            sb.append(term);
            if (this.vars.size() == 1 || this.vars.size() < ++count) continue;
            sb.append(',');
        }
        sb.append(" : ");
        sb.append(this.body);
        sb.append('}');
        if (!this.getUpOp().equals("")) {
            sb.append(' ');
            sb.append(this.getUpOp());
            sb.append(' ');
            sb.append(this.getUpperGuard());
        }
        return sb.toString();
    }

    @Override
    public AggregateAtom clone() {
        Conjunction conj = new Conjunction();
        ArrayList<SimpleTerm> newVars = new ArrayList<SimpleTerm>();
        for (SimpleTerm term : this.vars) {
            newVars.add(term.clone());
        }
        for (Literal literal : this.body) {
            conj.add(literal.clone());
        }
        AggregateAtom newAggregateAtom = new AggregateAtom(this.name, this.vars, conj);
        newAggregateAtom.lowerGuard = this.lowerGuard.clone();
        newAggregateAtom.lowOp = this.lowOp;
        newAggregateAtom.upperGuard = this.upperGuard.clone();
        newAggregateAtom.upOp = this.upOp;
        return newAggregateAtom;
    }

    @Override
    public int getAtomBeginColumn() {
        return this.atomBeginColumn;
    }

    public void setAtomBeginColumn(int atomBeginColumn) {
        this.atomBeginColumn = atomBeginColumn;
    }

    @Override
    public int getAtomBeginLine() {
        return this.atomBeginLine;
    }

    public void setAtomBeginLine(int atomBeginLine) {
        this.atomBeginLine = atomBeginLine;
    }

    @Override
    public int getAtomEndLine() {
        return this.atomEndLine;
    }

    public void setAtomEndLine(int atomEndLine) {
        this.atomEndLine = atomEndLine;
    }

    @Override
    public int getAtomEndColumn() {
        return this.atomEndColumn;
    }

    public void setAtomEndColumn(int atomEndColumn) {
        this.atomEndColumn = atomEndColumn;
    }

    @Override
    public boolean containsJavaContentAtoms() {
        return false;
    }

    @Override
    public boolean containsNonPositionalTerm() {
        return false;
    }
}

