/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.JavaContentAtom;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.ProgramPredicate;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Conjunction
extends ArrayList<Literal> {
    private static final long serialVersionUID = 3L;

    public Conjunction() {
    }

    public Conjunction(Literal literal) {
        this.add(literal);
    }

    public Conjunction(List<Literal> literals) {
        for (Literal literal : literals) {
            this.add(literal);
        }
    }

    public boolean isGround() {
        for (Literal lit : this) {
            if (lit.isGround()) continue;
            return false;
        }
        return true;
    }

    public void addAtom(Atom atom) {
        this.add(new Literal(true, atom));
    }

    public void addNegatedAtom(Atom a) {
        this.add(new Literal(false, a));
    }

    public boolean isFree(Term t) {
        if (t instanceof SimpleTerm) {
            for (Literal literal : this) {
                Atom atom = literal.getAtom();
                if (!(atom instanceof NormalAtom)) continue;
                List<Term> terms = ((NormalAtom)atom).getVariables();
                for (Term term : terms) {
                    if (!(term instanceof SimpleTerm) || !((SimpleTerm)term).isVariable() || !((SimpleTerm)t).getContent().equals(((SimpleTerm)term).getContent())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isUsedInAggregates(Term t, AggregateAtom originalAggregate) {
        for (Literal literal : this) {
            Atom atom = literal.getAtom();
            if (!(atom instanceof AggregateAtom) || atom == originalAggregate) continue;
            for (Literal bodyLiteral : ((AggregateAtom)atom).getBody()) {
                for (Term bodyAggregateTerm : bodyLiteral.getAtom().getVariables()) {
                    if (!((SimpleTerm)bodyAggregateTerm).isVariable() || !((SimpleTerm)t).getContent().equals(((SimpleTerm)bodyAggregateTerm).getContent())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<ProgramPredicate> getPredicates() {
        ArrayList<ProgramPredicate> predicates = new ArrayList<ProgramPredicate>();
        for (Literal literal : this) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                ProgramPredicate predicate;
                if (((NormalAtom)atom).isBuiltin() || predicates.contains(predicate = new ProgramPredicate(atom.getName(), ((NormalAtom)atom).arity()))) continue;
                predicates.add(predicate);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            for (Literal l : aggregate.getBody()) {
                ProgramPredicate predicate;
                Atom aggrAtom = l.getAtom();
                if (!(aggrAtom instanceof NormalAtom) || ((NormalAtom)aggrAtom).isBuiltin() || predicates.contains(predicate = new ProgramPredicate(aggrAtom.getName(), ((NormalAtom)aggrAtom).arity()))) continue;
                predicates.add(predicate);
            }
        }
        return predicates;
    }

    public List<Term> getVariables() {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Literal lit : this) {
            terms.addAll(lit.getVariables());
        }
        return terms;
    }

    @Override
    public Conjunction clone() {
        Conjunction newConjunction = new Conjunction();
        for (Literal l : this) {
            newConjunction.add(l.clone());
        }
        return newConjunction;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (Literal a : this) {
            sb.append(a);
            if (this.size() == 1 || this.size() < ++count) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private List<Term> getAllTermsInAtom(NormalAtom atom) {
        ArrayList<Term> simpleTermList = new ArrayList<Term>();
        ArrayList<NormalAtom> toVisit = new ArrayList<NormalAtom>();
        toVisit.add(atom);
        while (!toVisit.isEmpty()) {
            NormalAtom a = (NormalAtom)toVisit.remove(0);
            ArrayList<Term> terms = a.getAttrs();
            for (Term term : terms) {
                if (term instanceof SimpleTerm) {
                    simpleTermList.add(term);
                } else if (term instanceof NormalAtom) {
                    toVisit.add((NormalAtom)term);
                }
                if (!(term instanceof JavaContentAtom)) continue;
                simpleTermList.add(term);
            }
        }
        return simpleTermList;
    }

    protected List<Term> getUnsafeTerms() {
        ArrayList<Term> unsafeTermsInBody = new ArrayList<Term>();
        for (Literal literal : this) {
            Atom atom;
            if (literal.isAggregate()) {
                AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
                if (!aggregate.getUpOp().equals("=") && !aggregate.getUpOp().equals("") && aggregate.getUpperGuard().isVariable()) {
                    unsafeTermsInBody.add(aggregate.getUpperGuard());
                }
                if (!aggregate.getLowOp().equals("=") && !aggregate.getLowOp().equals("") && aggregate.getLowerGuard().isVariable()) {
                    unsafeTermsInBody.add(aggregate.getLowerGuard());
                }
            }
            if (!literal.isPositive()) {
                if (literal.isAggregate() || !((atom = literal.getAtom()) instanceof NormalAtom)) continue;
                List<Term> terms = this.getAllTermsInAtom((NormalAtom)atom);
                for (Term term : terms) {
                    if (term.isVariable() && ((SimpleTerm)term).isVariable()) {
                        unsafeTermsInBody.add(term);
                    }
                    if (term instanceof SimpleTerm && ((SimpleTerm)term).getContent().trim().equals("_")) {
                        unsafeTermsInBody.add(term);
                    }
                    if (!(term instanceof JavaContentAtom)) continue;
                    unsafeTermsInBody.add(term);
                }
                continue;
            }
            if (literal.isAggregate() || !((atom = literal.getAtom()) instanceof NormalAtom) || !((NormalAtom)atom).isBuiltin()) continue;
            List<Term> attrs = ((NormalAtom)atom).attributes();
            if (attrs.size() == 2) {
                Term t1 = ((NormalAtom)atom).attributes().get(0);
                Term t2 = ((NormalAtom)atom).attributes().get(1);
                if (((NormalAtom)atom).getName().equals("=")) {
                    if (!t1.isVariable() || !t2.isVariable()) continue;
                    List<Term> safeVariables = this.getSafeTermsInBuiltIn(null);
                    if (!safeVariables.contains(t1.toString())) {
                        unsafeTermsInBody.add(t2);
                    }
                    if (safeVariables.contains(t2)) continue;
                    unsafeTermsInBody.add(t1);
                    continue;
                }
                if (t1.isVariable()) {
                    unsafeTermsInBody.add(t1);
                }
                if (!t2.isVariable()) continue;
                unsafeTermsInBody.add(t2);
                continue;
            }
            if (attrs.size() != 3) continue;
            ArrayList<Term> tmpSafVars = new ArrayList<Term>();
            tmpSafVars.addAll(this.getSafeTerms(false));
            boolean unsafe = true;
            if (attrs.get(1).isNumericConstant()) {
                if (attrs.get(2).isNumericConstant()) {
                    unsafe = false;
                } else if (attrs.get(2).isVariable() && tmpSafVars.contains(attrs.get(2))) {
                    unsafe = false;
                }
            } else if (attrs.get(1).isVariable() && tmpSafVars.contains(attrs.get(1))) {
                if (attrs.get(2).isNumericConstant()) {
                    unsafe = false;
                } else if (attrs.get(2).isVariable() && tmpSafVars.contains(attrs.get(2))) {
                    unsafe = false;
                }
            }
            if (!unsafe) continue;
            unsafeTermsInBody.add(attrs.get(0));
        }
        List<Term> positiveTermsInBody = this.getSafeTerms(true);
        Iterator iterator = unsafeTermsInBody.iterator();
        while (iterator.hasNext()) {
            Term unsafeTerm = (Term)iterator.next();
            if (!positiveTermsInBody.contains(unsafeTerm)) continue;
            iterator.remove();
        }
        return unsafeTermsInBody;
    }

    protected List<Term> getSafeTermsInBuiltIn(List<Atom> ex) {
        ArrayList<Atom> toEx = new ArrayList<Atom>();
        if (ex != null) {
            toEx.addAll(ex);
        }
        ArrayList<Term> positiveTermsInBody = new ArrayList<Term>();
        for (Literal literal : this) {
            Atom atom;
            if (!literal.isPositive() || literal.isAggregate() || !((atom = literal.getAtom()) instanceof NormalAtom) || toEx.contains(atom) || !((NormalAtom)atom).isBuiltin()) continue;
            ArrayList<Term> attrs = ((NormalAtom)atom).getAttrs();
            if (attrs.size() == 2) {
                if (((Term)attrs.get(0)).isVariable() && ((NormalAtom)atom).getName().equals("=") && ((Term)attrs.get(1)).isNumericConstant()) {
                    positiveTermsInBody.add((Term)attrs.get(0));
                }
                if (!((Term)attrs.get(1)).isVariable() || !((NormalAtom)atom).getName().equals("=") || !((Term)attrs.get(0)).isNumericConstant()) continue;
                positiveTermsInBody.add((Term)attrs.get(1));
                continue;
            }
            if (attrs.size() != 3 || !((Term)attrs.get(1)).isNumericConstant()) continue;
            if (((Term)attrs.get(2)).isNumericConstant()) {
                positiveTermsInBody.add((Term)attrs.get(0));
                continue;
            }
            if (!((Term)attrs.get(2)).isVariable()) continue;
            toEx.add(atom);
            if (!this.getSafeTermsInBuiltIn(toEx).contains(attrs.get(2))) continue;
            positiveTermsInBody.add((Term)attrs.get(0));
        }
        return positiveTermsInBody;
    }

    protected List<Term> getSafeTermsInBuiltin(List<Term> positiveTermsInBody) {
        ArrayList<Term> safeTerms = new ArrayList<Term>();
        for (Literal literal : this) {
            ArrayList<Term> attrs;
            Atom atom;
            if (!literal.isPositive() || literal.isAggregate() || !((atom = literal.getAtom()) instanceof NormalAtom) || !((NormalAtom)atom).isBuiltin() || (attrs = ((NormalAtom)atom).getAttrs()).size() != 3) continue;
            if (((Term)attrs.get(1)).isNumericConstant()) {
                if (((Term)attrs.get(2)).isNumericConstant()) {
                    safeTerms.add((Term)attrs.get(0));
                    continue;
                }
                if (!((Term)attrs.get(2)).isVariable() || !positiveTermsInBody.contains(attrs.get(2))) continue;
                safeTerms.add((Term)attrs.get(0));
                continue;
            }
            if (!((Term)attrs.get(1)).isVariable() || !positiveTermsInBody.contains(attrs.get(1))) continue;
            if (((Term)attrs.get(2)).isNumericConstant()) {
                safeTerms.add((Term)attrs.get(0));
                continue;
            }
            if (!((Term)attrs.get(2)).isVariable() || !positiveTermsInBody.contains(attrs.get(2))) continue;
            safeTerms.add((Term)attrs.get(0));
        }
        return safeTerms;
    }

    public List<Term> getSafeTerms(boolean builtinSearch) {
        ArrayList<Term> positiveTermsInBody = new ArrayList<Term>();
        for (Literal literal : this) {
            if (!literal.isPositive()) continue;
            if (!literal.isAggregate()) {
                Atom atom = literal.getAtom();
                if (!(atom instanceof NormalAtom)) continue;
                if (!((NormalAtom)atom).isBuiltin()) {
                    List<Term> terms = this.getAllTermsInAtom((NormalAtom)atom);
                    for (Term term : terms) {
                        if (!(term instanceof SimpleTerm) || !((SimpleTerm)term).isVariable()) continue;
                        positiveTermsInBody.add(term);
                    }
                    continue;
                }
                if (!((NormalAtom)atom).isBuiltin() || !builtinSearch) continue;
                ArrayList<Term> tmpSafVars = new ArrayList<Term>();
                tmpSafVars.addAll(this.getSafeTerms(false));
                tmpSafVars.addAll(positiveTermsInBody);
                tmpSafVars.addAll(this.getSafeTermsInBuiltin(positiveTermsInBody));
                ArrayList<Atom> ex = new ArrayList<Atom>();
                ex.add(atom);
                tmpSafVars.addAll(this.getSafeTermsInBuiltIn(ex));
                ArrayList<Term> attrs = ((NormalAtom)atom).getAttrs();
                if (attrs.size() == 2) {
                    if (((Term)attrs.get(0)).isVariable() && ((NormalAtom)atom).getName().equals("=")) {
                        if (((Term)attrs.get(1)).isNumericConstant()) {
                            positiveTermsInBody.add((Term)attrs.get(0));
                        } else if (((Term)attrs.get(1)).isVariable() && tmpSafVars.contains(attrs.get(1))) {
                            positiveTermsInBody.add((Term)attrs.get(0));
                        }
                    }
                    if (!((Term)attrs.get(1)).isVariable() || !((NormalAtom)atom).getName().equals("=")) continue;
                    if (((Term)attrs.get(0)).isNumericConstant()) {
                        positiveTermsInBody.add((Term)attrs.get(1));
                        continue;
                    }
                    if (!((Term)attrs.get(0)).isVariable() || !this.getSafeTermsInBuiltIn(null).contains(attrs.get(0))) continue;
                    positiveTermsInBody.add((Term)attrs.get(1));
                    continue;
                }
                if (attrs.size() != 3) continue;
                if (((Term)attrs.get(1)).isNumericConstant()) {
                    if (((Term)attrs.get(2)).isNumericConstant()) {
                        positiveTermsInBody.add((Term)attrs.get(0));
                        continue;
                    }
                    if (!((Term)attrs.get(2)).isVariable() || !tmpSafVars.contains(attrs.get(2))) continue;
                    positiveTermsInBody.add((Term)attrs.get(0));
                    continue;
                }
                if (!((Term)attrs.get(1)).isVariable() || !tmpSafVars.contains(attrs.get(1))) continue;
                if (((Term)attrs.get(2)).isNumericConstant()) {
                    positiveTermsInBody.add((Term)attrs.get(0));
                    continue;
                }
                if (!((Term)attrs.get(2)).isVariable() || !tmpSafVars.contains(attrs.get(2))) continue;
                positiveTermsInBody.add((Term)attrs.get(0));
                continue;
            }
            AggregateAtom aggrAtom = (AggregateAtom)literal.getAtom();
            if (aggrAtom.getLowOp().equals("=") && aggrAtom.getLowerGuard().isVariable()) {
                positiveTermsInBody.add(aggrAtom.getLowerGuard());
            }
            if (!aggrAtom.getUpOp().equals("=") || !aggrAtom.getUpperGuard().isVariable()) continue;
            positiveTermsInBody.add(aggrAtom.getUpperGuard());
        }
        return positiveTermsInBody;
    }

    public boolean containsPredicate(String predicateName) {
        for (Literal literal : this) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                if (((NormalAtom)atom).isBuiltin() || !atom.getName().equals(predicateName)) continue;
                return true;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            for (Literal l : aggregate.getBody()) {
                Atom aggrAtom = l.getAtom();
                if (!(aggrAtom instanceof NormalAtom) || ((NormalAtom)aggrAtom).isBuiltin() || !aggrAtom.getName().equals(predicateName)) continue;
                return true;
            }
        }
        return false;
    }

    public void renamePredicate(String oldName, String newName) {
        for (Literal literal : this) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                if (((NormalAtom)atom).isBuiltin() || !atom.getName().equals(oldName)) continue;
                atom.setName(newName);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            for (Literal l : aggregate.getBody()) {
                Atom aggrAtom = l.getAtom();
                if (!(aggrAtom instanceof NormalAtom) || ((NormalAtom)aggrAtom).isBuiltin() || !aggrAtom.getName().equals(oldName)) continue;
                aggrAtom.setName(newName);
            }
        }
    }

    public boolean containsJavaContentAtoms() {
        for (Literal literal : this) {
            if (!literal.containsJavaContentAtoms()) continue;
            return true;
        }
        return false;
    }

    public Atom getFirstAtomUsingPredicate(String predicateName) {
        for (Literal literal : this) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                if (((NormalAtom)atom).isBuiltin() || !atom.getName().equals(predicateName)) continue;
                return atom;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            for (Literal l : aggregate.getBody()) {
                Atom aggrAtom = l.getAtom();
                if (!(aggrAtom instanceof NormalAtom) || ((NormalAtom)aggrAtom).isBuiltin() || !aggrAtom.getName().equals(predicateName)) continue;
                return atom;
            }
        }
        return null;
    }

    public boolean containsAggregate() {
        for (Literal l : this) {
            if (!(l.getAtom() instanceof AggregateAtom)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTerm(String termValue) {
        for (Literal literal : this) {
            if (literal.getAtom() instanceof NormalAtom) {
                if (!((NormalAtom)literal.getAtom()).containsTerm(termValue)) continue;
                return true;
            }
            if (!(literal.getAtom() instanceof AggregateAtom)) continue;
            if (((NormalAtom)((AggregateAtom)literal.getAtom()).getUpperGuard()).getName().equals(termValue)) {
                return true;
            }
            if (((NormalAtom)((AggregateAtom)literal.getAtom()).getLowerGuard()).getName().equals(termValue)) {
                return true;
            }
            if (!((AggregateAtom)literal.getAtom()).getBody().containsTerm(termValue)) continue;
            return true;
        }
        return false;
    }
}

