/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.wrapper.exception.BadDLPFunctionCompositionException;
import it.unical.mat.wrapper.exception.BadInputAtomInDLPFunctionException;
import it.unical.mat.wrapper.exception.NotMutuallyIndependentDLPFunctionsException;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DLPFunction {
    IndexedProgram program;
    Set<Atom> inputSignature;
    Set<Atom> outputSignature;
    Set<Atom> hiddenSignature;
    boolean isPredicateInput = false;

    public boolean isPredicateInput() {
        return this.isPredicateInput;
    }

    public DLPFunction(Program program) {
        this.setProgram(program);
    }

    public IndexedProgram getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program instanceof IndexedProgram ? (IndexedProgram)program : new IndexedProgram(program);
        this.inputSignature = new HashSet<Atom>();
        this.outputSignature = new HashSet<Atom>();
        this.hiddenSignature = new HashSet<Atom>();
        if (this.isPredicateInput) {
            for (String predicateSymbol : this.program.getPredicateSymbols()) {
                this.addOutput(new NormalAtom(predicateSymbol));
            }
        } else {
            for (Atom atom : this.program.getAtoms()) {
                this.addOutput(atom);
            }
        }
    }

    public Set<Atom> getInputSignature() {
        return this.inputSignature;
    }

    public void addInput(Atom inputAtom) throws BadInputAtomInDLPFunctionException {
        Atom atom = inputAtom;
        if (this.isPredicateInput) {
            atom = new NormalAtom(atom.getName());
        }
        if (!this.inputSignature.contains(atom)) {
            List<Rule> inHeadRules = this.isPredicateInput ? this.program.getRulesWithPredicateInHead(atom) : this.program.getRulesWithAtomInHead(atom);
            if (inHeadRules != null) {
                for (Rule rule : inHeadRules) {
                    if (rule.getHead().size() == 1) {
                        throw new BadInputAtomInDLPFunctionException(atom);
                    }
                    boolean accept = false;
                    Iterator iterator = rule.getHead().iterator();
                    while (iterator.hasNext()) {
                        Atom hAtom;
                        Atom headAtom = hAtom = (Atom)iterator.next();
                        if (this.isPredicateInput) {
                            headAtom = new NormalAtom(headAtom.getName());
                        }
                        if (headAtom.equals(atom) || this.inputSignature.contains(headAtom)) continue;
                        accept = true;
                    }
                    if (accept) continue;
                    throw new BadInputAtomInDLPFunctionException(atom);
                }
            }
            this.outputSignature.remove(atom);
            this.hiddenSignature.remove(atom);
            if (!this.inputSignature.contains(atom)) {
                this.inputSignature.add(atom);
            }
        }
    }

    public Set<Atom> getOutputSignature() {
        return this.outputSignature;
    }

    public void addOutput(Atom outputAtom) {
        Atom atom = outputAtom;
        if (this.isPredicateInput) {
            atom = new NormalAtom(atom.getName());
        }
        this.inputSignature.remove(atom);
        this.hiddenSignature.remove(atom);
        if (!this.outputSignature.contains(atom)) {
            this.outputSignature.add(atom);
        }
    }

    public Set<Atom> getHiddenSignature() {
        return this.hiddenSignature;
    }

    public void addHidden(Atom hiddenAtom) {
        Atom atom = hiddenAtom;
        if (this.isPredicateInput) {
            atom = new NormalAtom(atom.getName());
        }
        this.inputSignature.remove(atom);
        this.outputSignature.remove(atom);
        if (!this.hiddenSignature.contains(atom)) {
            this.hiddenSignature.add(atom);
        }
    }

    public Set<Atom> getAtoms() {
        HashSet<Atom> allAtoms = new HashSet<Atom>();
        allAtoms.addAll(this.inputSignature);
        allAtoms.addAll(this.outputSignature);
        allAtoms.addAll(this.hiddenSignature);
        return allAtoms;
    }

    public static boolean respectHiddenInterface(DLPFunction f1, DLPFunction f2) {
        for (Atom hiddenAtomF1 : f1.getHiddenSignature()) {
            if (!f2.getAtoms().contains(hiddenAtomF1)) continue;
            return false;
        }
        for (Atom hiddenAtomF2 : f2.getHiddenSignature()) {
            if (!f1.getAtoms().contains(hiddenAtomF2)) continue;
            return false;
        }
        return true;
    }

    public static boolean respectDisjointOutput(DLPFunction f1, DLPFunction f2) {
        for (Atom outputAtomF1 : f1.getOutputSignature()) {
            if (!f2.getOutputSignature().contains(outputAtomF1)) continue;
            return false;
        }
        return true;
    }

    public static boolean respectOutputDefinition(DLPFunction f1, DLPFunction f2) {
        List<Rule> rulesF2;
        List<Rule> rulesF1;
        for (Atom outputAtomF1 : f1.getOutputSignature()) {
            if (f1.isPredicateInput() || f2.isPredicateInput()) {
                rulesF1 = f1.getProgram().getRulesWithPredicateInHead(outputAtomF1);
                rulesF2 = f2.getProgram().getRulesWithPredicateInHead(outputAtomF1);
            } else {
                rulesF1 = f1.getProgram().getRulesWithAtomInHead(outputAtomF1);
                rulesF2 = f2.getProgram().getRulesWithAtomInHead(outputAtomF1);
            }
            if (rulesF2 == null) continue;
            if (rulesF1 == null) {
                return false;
            }
            for (Rule ruleF2 : rulesF2) {
                if (rulesF1.contains(ruleF2)) continue;
                return false;
            }
        }
        for (Atom outputAtomF2 : f2.getOutputSignature()) {
            if (f1.isPredicateInput() || f2.isPredicateInput()) {
                rulesF1 = f1.getProgram().getRulesWithPredicateInHead(outputAtomF2);
                rulesF2 = f2.getProgram().getRulesWithPredicateInHead(outputAtomF2);
            } else {
                rulesF1 = f1.getProgram().getRulesWithAtomInHead(outputAtomF2);
                rulesF2 = f2.getProgram().getRulesWithAtomInHead(outputAtomF2);
            }
            if (rulesF1 == null) continue;
            if (rulesF2 == null) {
                return false;
            }
            for (Rule ruleF1 : rulesF1) {
                if (rulesF2.contains(ruleF1)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean respectInputOutputInterface(DLPFunction f1, DLPFunction f2) {
        return DLPFunction.respectHiddenInterface(f1, f2) && DLPFunction.respectDisjointOutput(f1, f2) && DLPFunction.respectOutputDefinition(f1, f2);
    }

    public static boolean areMutuallyIndependent(Set<Atom> outputF1, Set<Atom> outputF2, Program composedProgram) throws BadDLPFunctionCompositionException {
        for (Atom outputAtomF1 : outputF1) {
            if (!outputF2.contains(outputAtomF1)) continue;
            throw new BadDLPFunctionCompositionException("Output atoms not disjoint");
        }
        StronglyConnectedComponentGraph positiveComponentGraph = (StronglyConnectedComponentGraph)DependencyGraph.createPositiveStronglyConnectedComponentGraph(composedProgram);
        for (Set<Atom> component : positiveComponentGraph.getStronglyConnectedSets()) {
            boolean existsInF1 = false;
            boolean existsInF2 = false;
            for (Atom componentAtom : component) {
                if (outputF1.contains(componentAtom)) {
                    if (existsInF2) {
                        return false;
                    }
                    existsInF1 = true;
                    continue;
                }
                if (!outputF2.contains(componentAtom)) continue;
                if (existsInF1) {
                    return false;
                }
                existsInF2 = true;
            }
        }
        return true;
    }

    public static boolean areComposible(DLPFunction f1, DLPFunction f2) {
        return DLPFunction.respectInputOutputInterface(f1, f2);
    }

    public static boolean areJoinable(DLPFunction f1, DLPFunction f2) {
        IndexedProgram composedProgram = new IndexedProgram(f1.getProgram());
        for (Expression expr : f2.getProgram()) {
            ((ArrayList)composedProgram).add(expr);
        }
        if (DLPFunction.areComposible(f1, f2)) {
            try {
                return DLPFunction.areMutuallyIndependent(f1.getOutputSignature(), f2.getOutputSignature(), composedProgram);
            }
            catch (BadDLPFunctionCompositionException badDLPFunctionCompositionException) {
                // empty catch block
            }
        }
        return false;
    }

    public static DLPFunction join(DLPFunction f1, DLPFunction f2) throws BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        DLPFunction fComp = DLPFunction.compose(f1, f2);
        if (!DLPFunction.areMutuallyIndependent(f1.getOutputSignature(), f2.getOutputSignature(), fComp.getProgram())) {
            throw new NotMutuallyIndependentDLPFunctionsException();
        }
        return fComp;
    }

    public static DLPFunction compose(DLPFunction f1, DLPFunction f2) throws BadDLPFunctionCompositionException {
        if (!DLPFunction.respectHiddenInterface(f1, f2)) {
            throw new BadDLPFunctionCompositionException();
        }
        if (!DLPFunction.respectDisjointOutput(f1, f2)) {
            throw new BadDLPFunctionCompositionException();
        }
        if (!DLPFunction.respectOutputDefinition(f1, f2)) {
            throw new BadDLPFunctionCompositionException();
        }
        Program pComp = new Program();
        for (Expression exp : f1.getProgram()) {
            pComp.add(exp);
        }
        for (Expression exp : f2.getProgram()) {
            pComp.add(exp);
        }
        DLPFunction fComp = new DLPFunction(pComp);
        for (Atom atomF1 : f1.getInputSignature()) {
            if (f2.getOutputSignature().contains(atomF1)) continue;
            try {
                fComp.addInput(atomF1);
            }
            catch (BadInputAtomInDLPFunctionException e) {
                e.printStackTrace();
            }
        }
        for (Atom atomF2 : f2.getInputSignature()) {
            if (f1.getOutputSignature().contains(atomF2)) continue;
            try {
                fComp.addInput(atomF2);
            }
            catch (BadInputAtomInDLPFunctionException e) {
                e.printStackTrace();
            }
        }
        for (Atom atomF1 : f1.getOutputSignature()) {
            fComp.addOutput(atomF1);
        }
        for (Atom atomF2 : f2.getOutputSignature()) {
            fComp.addOutput(atomF2);
        }
        for (Atom atomF1 : f1.getHiddenSignature()) {
            fComp.addHidden(atomF1);
        }
        for (Atom atomF2 : f2.getHiddenSignature()) {
            fComp.addHidden(atomF2);
        }
        return fComp;
    }

    public static void makeDLPFunctionsComposible(DLPFunction f1, DLPFunction f2, boolean joinable) throws BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        DLPFunction.makeDLPFunctionsComposible(f1, f2, joinable, false, false);
    }

    public static void makeDLPFunctionsComposible(DLPFunction f1, DLPFunction f2, boolean joinable, boolean fixedInputForF1, boolean fixedInputForF2) throws BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        if (!fixedInputForF1) {
            for (Atom atom : f1.getInputSignature()) {
                f1.addOutput(atom);
            }
        }
        for (Atom atom : f1.getHiddenSignature()) {
            f1.addOutput(atom);
        }
        if (!fixedInputForF2) {
            for (Atom atom : f2.getInputSignature()) {
                f2.addOutput(atom);
            }
        }
        for (Atom atom : f2.getHiddenSignature()) {
            f2.addOutput(atom);
        }
        ArrayList<Atom> outputF1 = new ArrayList<Atom>(f1.getOutputSignature());
        for (Atom atom : outputF1) {
            if (f2.getOutputSignature().contains(atom) || f2.getInputSignature().contains(atom)) continue;
            f1.addHidden(atom);
        }
        ArrayList<Atom> outputF2 = new ArrayList<Atom>(f2.getOutputSignature());
        for (Atom atom : outputF2) {
            if (f1.getOutputSignature().contains(atom) || f1.getInputSignature().contains(atom)) continue;
            f2.addHidden(atom);
        }
        if (fixedInputForF1 && fixedInputForF2) {
            if (joinable) {
                if (!DLPFunction.areJoinable(f1, f2)) {
                    throw new BadDLPFunctionCompositionException("The DLP-functions are not joinable");
                }
            } else if (!DLPFunction.areComposible(f1, f2)) {
                throw new BadDLPFunctionCompositionException("The DLP-functions are not composible");
            }
        } else {
            ArrayList<Atom> notCheckedAtoms = new ArrayList<Atom>();
            outputF1 = new ArrayList<Atom>(f1.getOutputSignature());
            for (Atom atom : outputF1) {
                List<Rule> rulesF2;
                List<Rule> rulesF1;
                if (f1.isPredicateInput() || f2.isPredicateInput()) {
                    rulesF1 = f1.getProgram().getRulesWithPredicateInHead(atom);
                    rulesF2 = f2.getProgram().getRulesWithPredicateInHead(atom);
                } else {
                    rulesF1 = f1.getProgram().getRulesWithAtomInHead(atom);
                    rulesF2 = f2.getProgram().getRulesWithAtomInHead(atom);
                }
                boolean equalRules = true;
                if (rulesF2 != null) {
                    if (rulesF1 == null) {
                        if (fixedInputForF1) {
                            throw new BadDLPFunctionCompositionException();
                        }
                        try {
                            f1.addInput(atom);
                        }
                        catch (BadInputAtomInDLPFunctionException e) {
                            throw new BadDLPFunctionCompositionException(e.getMessage());
                        }
                        equalRules = false;
                    } else {
                        for (Rule ruleF2 : rulesF2) {
                            if (rulesF1.contains(ruleF2)) continue;
                            if (fixedInputForF1) {
                                throw new BadDLPFunctionCompositionException();
                            }
                            try {
                                f1.addInput(atom);
                            }
                            catch (BadInputAtomInDLPFunctionException e) {
                                throw new BadDLPFunctionCompositionException(e.getMessage());
                            }
                            equalRules = false;
                        }
                    }
                }
                if (rulesF1 != null) {
                    if (rulesF2 == null) {
                        if (fixedInputForF2) {
                            throw new BadDLPFunctionCompositionException();
                        }
                        try {
                            f2.addInput(atom);
                        }
                        catch (BadInputAtomInDLPFunctionException e) {
                            throw new BadDLPFunctionCompositionException(e.getMessage());
                        }
                        equalRules = false;
                    } else {
                        for (Rule ruleF1 : rulesF1) {
                            if (rulesF2.contains(ruleF1)) continue;
                            if (fixedInputForF2) {
                                throw new BadDLPFunctionCompositionException();
                            }
                            try {
                                f2.addInput(atom);
                            }
                            catch (BadInputAtomInDLPFunctionException e) {
                                throw new BadDLPFunctionCompositionException(e.getMessage());
                            }
                            equalRules = false;
                        }
                    }
                }
                if (rulesF1 == null && rulesF2 == null) {
                    try {
                        if (!fixedInputForF1) {
                            f1.addInput(atom);
                        }
                        if (!fixedInputForF2) {
                            f2.addInput(atom);
                        }
                    }
                    catch (BadInputAtomInDLPFunctionException e) {
                        e.printStackTrace();
                    }
                    equalRules = false;
                }
                if (!equalRules) continue;
                notCheckedAtoms.add(atom);
            }
            if (joinable) {
                Program compProgram = new Program();
                HashSet<Atom> confirmedAtomsF1 = new HashSet<Atom>(f1.getOutputSignature());
                confirmedAtomsF1.removeAll(notCheckedAtoms);
                HashSet<Atom> confirmedAtomsF2 = new HashSet<Atom>(f2.getOutputSignature());
                confirmedAtomsF2.removeAll(notCheckedAtoms);
                for (Expression expr : f1.getProgram()) {
                    compProgram.add(expr);
                }
                for (Expression expr : f2.getProgram()) {
                    compProgram.add(expr);
                }
                if (!DLPFunction.areMutuallyIndependent(confirmedAtomsF1, confirmedAtomsF2, compProgram)) {
                    throw new NotMutuallyIndependentDLPFunctionsException();
                }
                DLPFunction.assignNotCheckedOutputAtomsForJoin(f1, f2, notCheckedAtoms, fixedInputForF1, fixedInputForF2);
            } else {
                for (Atom atom : notCheckedAtoms) {
                    if (fixedInputForF1 && !fixedInputForF2) {
                        if (f1.getInputSignature().contains(atom)) continue;
                        try {
                            f2.addInput(atom);
                            continue;
                        }
                        catch (BadInputAtomInDLPFunctionException e1) {
                            throw new BadDLPFunctionCompositionException(e1.getMessage());
                        }
                    }
                    if (!fixedInputForF1 && fixedInputForF2) {
                        if (f2.getInputSignature().contains(atom)) continue;
                        try {
                            f1.addInput(atom);
                            continue;
                        }
                        catch (BadInputAtomInDLPFunctionException e1) {
                            throw new BadDLPFunctionCompositionException(e1.getMessage());
                        }
                    }
                    try {
                        f1.addInput(atom);
                    }
                    catch (BadInputAtomInDLPFunctionException e) {
                        try {
                            f2.addInput(atom);
                        }
                        catch (BadInputAtomInDLPFunctionException e1) {
                            throw new BadDLPFunctionCompositionException(e1.getMessage());
                        }
                    }
                }
            }
        }
    }

    private static void assignNotCheckedOutputAtomsForJoin(DLPFunction f1, DLPFunction f2, List<Atom> atoms, boolean fixedInputForF1, boolean fixedInputForF2) throws BadDLPFunctionCompositionException, NotMutuallyIndependentDLPFunctionsException {
        IndexedProgram completeProgram = new IndexedProgram(f1.getProgram());
        for (Expression expr : f2.getProgram()) {
            ((ArrayList)completeProgram).add(expr);
        }
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createPositiveStronglyConnectedComponentGraph(completeProgram);
        List<Set<Atom>> components = graph.getStronglyConnectedSets();
        for (Set<Atom> component : components) {
            if (component.size() > 1) {
                if (atoms.containsAll(component)) {
                    boolean outputInF1 = false;
                    boolean assignedOutput = false;
                    for (Atom a : component) {
                        if (!assignedOutput) {
                            if (fixedInputForF1 && !fixedInputForF2) {
                                if (!f1.getInputSignature().contains(a)) {
                                    try {
                                        f2.addInput(a);
                                        outputInF1 = true;
                                        assignedOutput = true;
                                        continue;
                                    }
                                    catch (BadInputAtomInDLPFunctionException e1) {
                                        throw new BadDLPFunctionCompositionException(e1.getMessage());
                                    }
                                }
                                outputInF1 = false;
                                assignedOutput = true;
                                continue;
                            }
                            if (!fixedInputForF1 && fixedInputForF2) {
                                if (!f2.getInputSignature().contains(a)) {
                                    try {
                                        f1.addInput(a);
                                        outputInF1 = false;
                                        assignedOutput = true;
                                        continue;
                                    }
                                    catch (BadInputAtomInDLPFunctionException e1) {
                                        throw new BadDLPFunctionCompositionException(e1.getMessage());
                                    }
                                }
                                outputInF1 = true;
                                assignedOutput = true;
                                continue;
                            }
                            try {
                                f1.addInput(a);
                                outputInF1 = false;
                                assignedOutput = true;
                                continue;
                            }
                            catch (BadInputAtomInDLPFunctionException e) {
                                try {
                                    f2.addInput(a);
                                    outputInF1 = true;
                                    assignedOutput = true;
                                    continue;
                                }
                                catch (BadInputAtomInDLPFunctionException e1) {
                                    throw new BadDLPFunctionCompositionException(e1.getMessage());
                                }
                            }
                        }
                        if (outputInF1) {
                            if (fixedInputForF2) {
                                throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                            }
                            try {
                                f2.addInput(a);
                                continue;
                            }
                            catch (BadInputAtomInDLPFunctionException e) {
                                throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                            }
                        }
                        if (fixedInputForF1) {
                            throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                        }
                        try {
                            f1.addInput(a);
                        }
                        catch (BadInputAtomInDLPFunctionException e) {
                            throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                        }
                    }
                    continue;
                }
                boolean containsAtLeast = false;
                for (Atom a : component) {
                    if (!atoms.contains(a)) continue;
                    containsAtLeast = true;
                }
                if (!containsAtLeast) continue;
                boolean foundOutput = false;
                boolean isOutputInF1 = false;
                Iterator<Atom> iterator = component.iterator();
                while (iterator.hasNext() && !foundOutput) {
                    Atom compAtom = iterator.next();
                    if (atoms.contains(compAtom)) continue;
                    if (f1.getOutputSignature().contains(compAtom)) {
                        isOutputInF1 = true;
                        foundOutput = true;
                        continue;
                    }
                    if (!f2.getOutputSignature().contains(compAtom)) continue;
                    isOutputInF1 = false;
                    foundOutput = true;
                }
                if (foundOutput) {
                    for (Atom compAtom : component) {
                        if (!atoms.contains(compAtom)) continue;
                        if (isOutputInF1) {
                            if (fixedInputForF2) {
                                throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                            }
                            try {
                                f2.addInput(compAtom);
                                continue;
                            }
                            catch (BadInputAtomInDLPFunctionException e) {
                                throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                            }
                        }
                        if (fixedInputForF1) {
                            throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                        }
                        try {
                            f1.addInput(compAtom);
                        }
                        catch (BadInputAtomInDLPFunctionException e) {
                            throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                        }
                    }
                    continue;
                }
                boolean outputInF1 = false;
                boolean assignedOutput = false;
                for (Atom a : component) {
                    if (!atoms.contains(a)) continue;
                    if (!assignedOutput) {
                        if (fixedInputForF1 && !fixedInputForF2) {
                            if (!f1.getInputSignature().contains(a)) {
                                try {
                                    f2.addInput(a);
                                    outputInF1 = true;
                                    assignedOutput = true;
                                    continue;
                                }
                                catch (BadInputAtomInDLPFunctionException e1) {
                                    throw new BadDLPFunctionCompositionException(e1.getMessage());
                                }
                            }
                            outputInF1 = false;
                            assignedOutput = true;
                            continue;
                        }
                        if (!fixedInputForF1 && fixedInputForF2) {
                            if (!f2.getInputSignature().contains(a)) {
                                try {
                                    f1.addInput(a);
                                    outputInF1 = false;
                                    assignedOutput = true;
                                    continue;
                                }
                                catch (BadInputAtomInDLPFunctionException e) {
                                    throw new BadDLPFunctionCompositionException(e.getMessage());
                                }
                            }
                            outputInF1 = true;
                            assignedOutput = true;
                            continue;
                        }
                        try {
                            f1.addInput(a);
                            outputInF1 = false;
                            assignedOutput = true;
                            continue;
                        }
                        catch (BadInputAtomInDLPFunctionException e) {
                            try {
                                f2.addInput(a);
                                outputInF1 = true;
                                assignedOutput = true;
                                continue;
                            }
                            catch (BadInputAtomInDLPFunctionException e1) {
                                throw new BadDLPFunctionCompositionException(e1.getMessage());
                            }
                        }
                    }
                    if (outputInF1) {
                        if (fixedInputForF2) {
                            throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                        }
                        try {
                            f2.addInput(a);
                            continue;
                        }
                        catch (BadInputAtomInDLPFunctionException e) {
                            throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                        }
                    }
                    if (fixedInputForF1) {
                        throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                    }
                    try {
                        f1.addInput(a);
                    }
                    catch (BadInputAtomInDLPFunctionException e) {
                        throw new NotMutuallyIndependentDLPFunctionsException("The DLP Functions are not joinable.");
                    }
                }
                continue;
            }
            Atom compAtom = component.toArray(new Atom[0])[0];
            if (!atoms.contains(compAtom)) continue;
            if (fixedInputForF1 && !fixedInputForF2) {
                if (f1.getInputSignature().contains(compAtom)) continue;
                try {
                    f2.addInput(compAtom);
                    continue;
                }
                catch (BadInputAtomInDLPFunctionException e1) {
                    throw new BadDLPFunctionCompositionException(e1.getMessage());
                }
            }
            if (!fixedInputForF1 && fixedInputForF2) {
                if (f2.getInputSignature().contains(compAtom)) continue;
                try {
                    f1.addInput(compAtom);
                    continue;
                }
                catch (BadInputAtomInDLPFunctionException e1) {
                    throw new BadDLPFunctionCompositionException(e1.getMessage());
                }
            }
            try {
                f1.addInput(compAtom);
            }
            catch (BadInputAtomInDLPFunctionException e) {
                try {
                    f2.addInput(compAtom);
                }
                catch (BadInputAtomInDLPFunctionException e1) {
                    throw new BadDLPFunctionCompositionException(e1.getMessage());
                }
            }
        }
    }
}

