/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.ProgramPredicate;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Disjunction
extends ArrayList<Atom> {
    private static final long serialVersionUID = 2L;

    public Disjunction() {
    }

    public Disjunction(Atom atom) {
        this.add((NormalAtom)atom);
    }

    public Disjunction(List<Atom> atoms) {
        for (Atom atom : atoms) {
            this.add((NormalAtom)atom);
        }
    }

    public boolean isFree(Term t) {
        if (t instanceof SimpleTerm) {
            for (Atom atom : this) {
                List<Term> terms = ((NormalAtom)atom).getVariables();
                for (Term term : terms) {
                    if (!(term instanceof SimpleTerm) || !((SimpleTerm)term).isVariable() || !((SimpleTerm)t).getContent().equals(((SimpleTerm)term).getContent())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isGround() {
        for (Atom atom : this) {
            if (atom.isGround()) continue;
            return false;
        }
        return true;
    }

    public List<ProgramPredicate> getPredicates() {
        ArrayList<ProgramPredicate> predicates = new ArrayList<ProgramPredicate>();
        for (Atom atom : this) {
            ProgramPredicate predicate;
            if (!(atom instanceof NormalAtom) || predicates.contains(predicate = new ProgramPredicate(atom.getName(), ((NormalAtom)atom).arity()))) continue;
            predicates.add(predicate);
        }
        return predicates;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (Atom a : this) {
            sb.append(a);
            if (this.size() == 1 || this.size() < ++count) continue;
            sb.append(" v ");
        }
        return sb.toString();
    }

    @Override
    public Disjunction clone() {
        Disjunction newDisjunction = new Disjunction();
        for (Atom a : this) {
            newDisjunction.add(a.clone());
        }
        return newDisjunction;
    }

    public void renamePredicate(String oldName, String newName) {
        for (Atom atom : this) {
            if (!(atom instanceof NormalAtom) || ((NormalAtom)atom).isBuiltin() || !atom.getName().equals(oldName)) continue;
            atom.setName(newName);
        }
    }

    public boolean containsPredicate(String predicateName) {
        for (Atom atom : this) {
            if (!(atom instanceof NormalAtom) || ((NormalAtom)atom).isBuiltin() || !atom.getName().equals(predicateName)) continue;
            return true;
        }
        return false;
    }

    public Atom getFirstAtomUsingPredicate(String predicateName) {
        for (Atom atom : this) {
            if (!(atom instanceof NormalAtom) || ((NormalAtom)atom).isBuiltin() || !atom.getName().equals(predicateName)) continue;
            return atom;
        }
        return null;
    }

    public boolean containsTerm(String termValue) {
        for (Atom atom : this) {
            if (!(atom instanceof NormalAtom) || !((NormalAtom)atom).containsTerm(termValue)) continue;
            return true;
        }
        return false;
    }

    public Collection<? extends Term> getVariables() {
        ArrayList<Term> variables = new ArrayList<Term>();
        for (Atom atom : this) {
            variables.addAll(atom.getVariables());
        }
        return variables;
    }
}

