/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.Directive;
import it.unical.mat.wrapper.util.Util;

public class ExportDirective
extends Directive {
    String databaseName;
    String username;
    String password;
    String replaceQuery;
    String tableName;
    String predicateName;

    public ExportDirective(String databaseName, String username, String password, String predicateName, String tableName, String replaceQuery) {
        super("export", "(" + databaseName + ", \"" + username + "\", \"" + password + "\", " + predicateName + ", " + tableName + ", " + "\"" + replaceQuery + "\")");
        this.databaseName = databaseName;
        this.username = Util.getStringContent(username);
        this.password = Util.getStringContent(password);
        this.replaceQuery = Util.getStringContent(replaceQuery);
        this.tableName = tableName;
        this.predicateName = predicateName;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#export(" + this.databaseName + ", \"" + this.username + "\", \"" + this.password + "\", " + this.predicateName + ", " + this.tableName);
        if (this.replaceQuery != null && !this.replaceQuery.equals("")) {
            stringBuilder.append(", \"" + this.replaceQuery + "\"");
        }
        stringBuilder.append(").");
        return stringBuilder.toString();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getReplaceQuery() {
        return this.replaceQuery;
    }

    public void setReplaceQuery(String replaceQuery) {
        this.replaceQuery = replaceQuery;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public void setPredicateName(String predicateName) {
        this.predicateName = predicateName;
    }

    @Override
    public ExportDirective clone() {
        ExportDirective directive = (ExportDirective)super.clone();
        directive.setDatabaseName(this.databaseName);
        directive.setUsername(this.username);
        directive.setPassword(this.password);
        directive.setReplaceQuery(this.replaceQuery);
        directive.setTableName(this.tableName);
        directive.setPredicateName(this.predicateName);
        return directive;
    }

    public static enum ImportDirectiveTypes {
        U_INT,
        UT_INT,
        UR_INT,
        CONST,
        Q_COST;

    }
}

