/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.ProgramExpression;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.wrapper.exception.BadSplittingSetException;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IndexedProgram
extends Program {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, List<Rule>> headRulesAtomMap = new HashMap();
    protected HashMap<String, List<Rule>> bodyRulesAtomMap = new HashMap();
    protected HashMap<String, List<Rule>> positiveBodyRulesAtomMap = new HashMap();
    protected HashMap<String, List<Rule>> negativeBodyRulesAtomMap = new HashMap();
    protected HashMap<String, List<Rule>> aggregateRulesAtomMap = new HashMap();
    protected HashMap<String, List<Rule>> headRulesPredicateMap = new HashMap();
    protected HashMap<String, List<Rule>> bodyRulesPredicateMap = new HashMap();
    protected HashMap<String, List<Rule>> positiveBodyRulesPredicateMap = new HashMap();
    protected HashMap<String, List<Rule>> negativeBodyRulesPredicateMap = new HashMap();
    protected HashMap<String, List<Rule>> aggregateRulesPredicateMap = new HashMap();
    protected HashMap<String, Atom> atomMap = new HashMap();
    protected List<String> predicateSymbols = new ArrayList<String>();
    protected HashMap<String, List<ProgramExpression>> expressionPredicateMap = new HashMap();

    public IndexedProgram(Program program) {
        for (Expression exp : program) {
            this.add(exp);
        }
    }

    public List<ProgramExpression> getExpressionWithPredicates(String predicateName) {
        if (this.expressionPredicateMap.containsKey(predicateName)) {
            return this.expressionPredicateMap.get(predicateName);
        }
        return new ArrayList<ProgramExpression>();
    }

    public List<Rule> getRulesWithPredicateInHead(Atom atom) {
        return this.getRulesWithPredicateInHead(atom.getName());
    }

    public List<Rule> getRulesWithPredicateInHead(String name) {
        return this.headRulesPredicateMap.get(name);
    }

    public List<Rule> getRulesWithAtomInHead(Atom atom) {
        return this.getRulesWithAtomInHead(atom.toString());
    }

    public List<Rule> getRulesWithAtomInHead(String name) {
        return this.headRulesAtomMap.get(name);
    }

    public List<Rule> getRulesWithAtomInPositiveBody(Atom atom) {
        return this.getRulesWithAtomInPositiveBody(atom.toString());
    }

    public List<Rule> getRulesWithPredicateInPositiveBody(Atom atom) {
        return this.getRulesWithPredicateInPositiveBody(atom.getName());
    }

    public List<Rule> getRulesWithAtomInPositiveBody(String atomName) {
        return this.positiveBodyRulesAtomMap.get(atomName);
    }

    public List<Rule> getRulesWithPredicateInPositiveBody(String predicateName) {
        return this.positiveBodyRulesPredicateMap.get(predicateName);
    }

    public List<Rule> getRulesWithAtomInAggregates(Atom atom) {
        return this.getRulesWithAtomInAggregates(atom.toString());
    }

    public List<Rule> getRulesWithPredicateInAggregates(Atom atom) {
        return this.getRulesWithPredicateInAggregates(atom.getName());
    }

    public List<Rule> getRulesWithAtomInAggregates(String atomName) {
        return this.aggregateRulesAtomMap.get(atomName);
    }

    public List<Rule> getRulesWithPredicateInAggregates(String predicateName) {
        return this.aggregateRulesPredicateMap.get(predicateName);
    }

    public List<Rule> getRulesWithAtomInNegativeBody(Atom atom) {
        return this.getRulesWithAtomInNegativeBody(atom.toString());
    }

    public List<Rule> getRulesWithPredicateInNegativeBody(Atom atom) {
        return this.getRulesWithPredicateInNegativeBody(atom.getName());
    }

    public List<Rule> getRulesWithAtomInNegativeBody(String atomName) {
        return this.negativeBodyRulesAtomMap.get(atomName);
    }

    public List<Rule> getRulesWithPredicateInNegativeBody(String predicateName) {
        return this.negativeBodyRulesPredicateMap.get(predicateName);
    }

    public List<Rule> getRulesWithAtomInBody(Atom atom) {
        return this.getRulesWithAtomInBody(atom.toString());
    }

    public List<Rule> getRulesWithPredicateInBody(Atom atom) {
        return this.getRulesWithPredicateInBody(atom.getName());
    }

    public List<Rule> getRulesWithAtomInBody(String atomName) {
        return this.bodyRulesAtomMap.get(atomName);
    }

    public List<Rule> getRulesWithPredicateInBody(String predicateName) {
        return this.bodyRulesPredicateMap.get(predicateName);
    }

    @Override
    public boolean add(Expression expression) {
        boolean add = super.add(expression);
        if (add && expression instanceof ProgramExpression) {
            boolean isRule = expression instanceof Rule;
            boolean isConstraint = false;
            ProgramExpression programExpression = (ProgramExpression)expression;
            if (isRule) {
                isConstraint = ((Rule)programExpression).isConstraint();
            }
            if (isRule && isRule) {
                for (Atom headAtom : ((Rule)programExpression).head()) {
                    String atomName = headAtom.getName();
                    String atomSignature = headAtom.toString();
                    if (!isConstraint) {
                        if (!this.atomMap.containsKey(atomSignature)) {
                            this.atomMap.put(atomSignature, headAtom);
                        }
                        if (!this.predicateSymbols.contains(atomName)) {
                            this.predicateSymbols.add(atomName);
                        }
                        if (!this.headRulesPredicateMap.containsKey(atomName)) {
                            this.headRulesPredicateMap.put(atomName, new ArrayList());
                        }
                        if (!this.headRulesAtomMap.containsKey(atomSignature)) {
                            this.headRulesAtomMap.put(atomSignature, new ArrayList());
                        }
                        this.headRulesPredicateMap.get(atomName).add((Rule)programExpression);
                        this.headRulesAtomMap.get(atomSignature).add((Rule)programExpression);
                    }
                    if (!this.expressionPredicateMap.containsKey(atomName)) {
                        this.expressionPredicateMap.put(atomName, new ArrayList());
                    }
                    this.expressionPredicateMap.get(atomName).add(programExpression);
                }
            }
            for (Literal literal : programExpression.getBody()) {
                Atom bodyAtom = literal.getAtom();
                String atomName = bodyAtom.getName();
                String atomSignature = bodyAtom.toString();
                if (isRule && !isConstraint) {
                    if (!this.atomMap.containsKey(atomSignature)) {
                        this.atomMap.put(atomSignature, bodyAtom);
                    }
                    if (!this.predicateSymbols.contains(atomName)) {
                        this.predicateSymbols.add(atomName);
                    }
                    if (!this.bodyRulesAtomMap.containsKey(atomSignature)) {
                        this.bodyRulesAtomMap.put(atomSignature, new ArrayList());
                    }
                    this.bodyRulesAtomMap.get(atomSignature).add((Rule)programExpression);
                    if (literal.isPositive()) {
                        if (!this.positiveBodyRulesAtomMap.containsKey(atomSignature)) {
                            this.positiveBodyRulesAtomMap.put(atomSignature, new ArrayList());
                        }
                        this.positiveBodyRulesAtomMap.get(atomSignature).add((Rule)programExpression);
                    } else {
                        if (!this.negativeBodyRulesAtomMap.containsKey(atomSignature)) {
                            this.negativeBodyRulesAtomMap.put(atomSignature, new ArrayList());
                        }
                        this.negativeBodyRulesAtomMap.get(atomSignature).add((Rule)programExpression);
                    }
                    if (!this.bodyRulesPredicateMap.containsKey(atomName)) {
                        this.bodyRulesPredicateMap.put(atomName, new ArrayList());
                    }
                    this.bodyRulesPredicateMap.get(atomName).add((Rule)programExpression);
                    if (literal.isPositive()) {
                        if (!this.positiveBodyRulesPredicateMap.containsKey(atomName)) {
                            this.positiveBodyRulesPredicateMap.put(atomName, new ArrayList());
                        }
                        this.positiveBodyRulesPredicateMap.get(atomName).add((Rule)programExpression);
                    } else {
                        if (!this.negativeBodyRulesPredicateMap.containsKey(atomName)) {
                            this.negativeBodyRulesPredicateMap.put(atomName, new ArrayList());
                        }
                        this.negativeBodyRulesPredicateMap.get(atomName).add((Rule)programExpression);
                    }
                }
                if (!this.expressionPredicateMap.containsKey(atomName)) {
                    this.expressionPredicateMap.put(atomName, new ArrayList());
                }
                this.expressionPredicateMap.get(atomName).add(programExpression);
                if (bodyAtom instanceof AggregateAtom) {
                    for (Literal litInAggr : ((AggregateAtom)bodyAtom).getBody()) {
                        Atom atomInAggr = litInAggr.getAtom();
                        String atomName2 = atomInAggr.getName();
                        String atomSignature2 = atomInAggr.toString();
                        if (isRule && !isConstraint) {
                            if (!this.atomMap.containsKey(atomSignature2)) {
                                this.atomMap.put(atomSignature2, atomInAggr);
                            }
                            if (!this.predicateSymbols.contains(atomName)) {
                                this.predicateSymbols.add(atomName);
                            }
                            if (!this.bodyRulesAtomMap.containsKey(atomSignature2)) {
                                this.bodyRulesAtomMap.put(atomSignature2, new ArrayList());
                            }
                            this.bodyRulesAtomMap.get(atomSignature2).add((Rule)programExpression);
                            if (litInAggr.isPositive()) {
                                if (!this.positiveBodyRulesAtomMap.containsKey(atomSignature2)) {
                                    this.positiveBodyRulesAtomMap.put(atomSignature2, new ArrayList());
                                }
                                this.positiveBodyRulesAtomMap.get(atomSignature2).add((Rule)programExpression);
                            } else {
                                if (!this.negativeBodyRulesAtomMap.containsKey(atomSignature2)) {
                                    this.negativeBodyRulesAtomMap.put(atomSignature2, new ArrayList());
                                }
                                this.negativeBodyRulesAtomMap.get(atomSignature2).add((Rule)programExpression);
                            }
                            if (!this.bodyRulesPredicateMap.containsKey(atomName2)) {
                                this.bodyRulesPredicateMap.put(atomName2, new ArrayList());
                            }
                            this.bodyRulesPredicateMap.get(atomName2).add((Rule)programExpression);
                            if (litInAggr.isPositive()) {
                                if (!this.positiveBodyRulesPredicateMap.containsKey(atomName2)) {
                                    this.positiveBodyRulesPredicateMap.put(atomName2, new ArrayList());
                                }
                                this.positiveBodyRulesPredicateMap.get(atomName2).add((Rule)programExpression);
                            } else {
                                if (!this.negativeBodyRulesPredicateMap.containsKey(atomName2)) {
                                    this.negativeBodyRulesPredicateMap.put(atomName2, new ArrayList());
                                }
                                this.negativeBodyRulesPredicateMap.get(atomName2).add((Rule)programExpression);
                            }
                            if (!this.aggregateRulesAtomMap.containsKey(atomSignature2)) {
                                this.aggregateRulesAtomMap.put(atomSignature2, new ArrayList());
                            }
                            this.aggregateRulesAtomMap.get(atomSignature2).add((Rule)programExpression);
                            if (!this.aggregateRulesPredicateMap.containsKey(atomName2)) {
                                this.aggregateRulesPredicateMap.put(atomName2, new ArrayList());
                            }
                            this.aggregateRulesPredicateMap.get(atomName2).add((Rule)programExpression);
                        }
                        if (!this.expressionPredicateMap.containsKey(atomName)) {
                            this.expressionPredicateMap.put(atomName, new ArrayList());
                        }
                        this.expressionPredicateMap.get(atomName).add(programExpression);
                    }
                    continue;
                }
                if (((NormalAtom)bodyAtom).isBuiltin()) continue;
                if (isRule && !isConstraint) {
                    if (!this.bodyRulesPredicateMap.containsKey(atomName)) {
                        this.bodyRulesPredicateMap.put(atomName, new ArrayList());
                    }
                    if (!this.predicateSymbols.contains(atomName)) {
                        this.predicateSymbols.add(atomName);
                    }
                    this.bodyRulesPredicateMap.get(atomName).add((Rule)programExpression);
                }
                if (!this.expressionPredicateMap.containsKey(atomName)) {
                    this.expressionPredicateMap.put(atomName, new ArrayList());
                }
                this.expressionPredicateMap.get(atomName).add(programExpression);
            }
        }
        return add;
    }

    public HashMap<String, Atom> getAtomMap() {
        return this.atomMap;
    }

    public Set<Atom> getAtoms() {
        return new HashSet<Atom>(this.atomMap.values());
    }

    public List<String> getPredicateSymbols() {
        return this.predicateSymbols;
    }

    public HashMap<String, List<Rule>> getHeadRulesAtomMap() {
        return this.headRulesAtomMap;
    }

    public HashMap<String, List<Rule>> getBodyRulesAtomMap() {
        return this.bodyRulesAtomMap;
    }

    public HashMap<String, List<Rule>> getHeadRulesPredicateMap() {
        return this.headRulesPredicateMap;
    }

    public HashMap<String, List<Rule>> getBodyRulesPredicateMap() {
        return this.bodyRulesPredicateMap;
    }

    public Program getSplitBottom(Set<Atom> splittingSet) throws BadSplittingSetException {
        Program splitBottom = new Program();
        HashSet<Atom> tmpSplittingSet = new HashSet<Atom>(splittingSet);
        for (Atom atom : splittingSet) {
            List<Rule> inHeadRules = this.getRulesWithPredicateInHead(atom);
            if (inHeadRules == null) continue;
            for (Rule rule : inHeadRules) {
                if (rule.isFact()) {
                    if (splitBottom.contains(rule)) continue;
                    splitBottom.add(rule);
                    continue;
                }
                boolean contains = false;
                Iterator iterator = rule.body().iterator();
                while (iterator.hasNext() && !contains) {
                    Literal litBody = (Literal)iterator.next();
                    if (litBody.isAggregate()) {
                        for (Literal aggrLit : ((AggregateAtom)litBody.getAtom()).getBody()) {
                            if (!tmpSplittingSet.contains(new NormalAtom(aggrLit.getAtom().getName()))) continue;
                            contains = true;
                        }
                        continue;
                    }
                    if (!tmpSplittingSet.contains(new NormalAtom(litBody.getAtom().getName()))) continue;
                    contains = true;
                }
                if (!contains) {
                    throw new BadSplittingSetException();
                }
                if (splitBottom.contains(rule)) continue;
                splitBottom.add(rule);
            }
        }
        return splitBottom;
    }

    @Override
    public Set<Atom> getPredicateSymbolsAsAtoms() {
        HashSet<Atom> atoms = new HashSet<Atom>();
        for (String predSymbol : this.getPredicateSymbols()) {
            atoms.add(new NormalAtom(predSymbol));
        }
        return atoms;
    }

    public Set<Atom> getSplittingSet(Set<Atom> partialSplittingSet) {
        HashSet<Atom> splittingSet = new HashSet<Atom>();
        StronglyConnectedComponentGraph componentGraph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(this, true);
        for (Atom predicate : partialSplittingSet) {
            if (splittingSet.contains(predicate)) continue;
            Set<Atom> component = componentGraph.getConnectedComponentContains(predicate);
            splittingSet.addAll(component);
            for (Set<Atom> incomingComponent : componentGraph.getIncomingHierarchyVertices(component)) {
                splittingSet.addAll(incomingComponent);
            }
        }
        return splittingSet;
    }

    public Program getRulesWithHeadAndBodyContainPredicates(Set<Atom> predicates) {
        Program subProgram = new Program();
        HashSet<Atom> tmpAtoms = new HashSet<Atom>(predicates);
        for (Atom atom : predicates) {
            List<Rule> inHeadRules = this.getRulesWithPredicateInHead(atom);
            if (inHeadRules == null) continue;
            for (Rule rule : inHeadRules) {
                boolean contains = false;
                Iterator iterator = rule.body().iterator();
                while (iterator.hasNext() && !contains) {
                    Literal litBody = (Literal)iterator.next();
                    if (litBody.isAggregate()) {
                        for (Literal aggrLit : ((AggregateAtom)litBody.getAtom()).getBody()) {
                            if (!tmpAtoms.contains(new NormalAtom(aggrLit.getAtom().getName()))) continue;
                            contains = true;
                        }
                        continue;
                    }
                    if (!tmpAtoms.contains(new NormalAtom(litBody.getAtom().getName()))) continue;
                    contains = true;
                }
                if (!contains || subProgram.contains(rule)) continue;
                subProgram.add(rule);
            }
        }
        return subProgram;
    }

    public Program getComponentsSubProgram(Program slice) {
        Set<Atom> componentsPredicates = this.getPredicatesInSameStronglyConnectedComponents(slice.getPredicateSymbolsAsAtoms());
        return this.getRulesWithHeadAndBodyContainPredicates(componentsPredicates);
    }

    public Set<Atom> getPredicatesInSameStronglyConnectedComponents(Set<Atom> partialPredicates) {
        return this.getPredicatesInSameStronglyConnectedComponents(partialPredicates, false);
    }

    public Set<Atom> getPredicatesInSameStronglyConnectedComponents(Set<Atom> partialPredicates, boolean alsoDisjunctionConnections) {
        HashSet<Atom> predicatesComponents = new HashSet<Atom>();
        StronglyConnectedComponentGraph componentGraph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(this, alsoDisjunctionConnections);
        for (Atom predicateAtom : partialPredicates) {
            if (predicatesComponents.contains(predicateAtom)) continue;
            predicatesComponents.addAll(componentGraph.getConnectedComponentContains(predicateAtom));
        }
        return predicatesComponents;
    }
}

