/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.List;

public class JavaNameAtom
extends NormalAtom {
    private String javaName;

    public JavaNameAtom(String javaName) {
        super("[" + javaName + "]");
        this.javaName = javaName;
    }

    public JavaNameAtom(boolean trueNegated, String name, ArrayList<Term> attrs) {
        super(trueNegated, name, attrs);
    }

    public void setJavaContent(String javaContent) {
        this.javaName = javaContent;
        this.name = "[" + javaContent + "]";
    }

    public String getJavaName() {
        return this.javaName;
    }

    @Override
    public JavaNameAtom clone() {
        JavaNameAtom term = new JavaNameAtom(this.getJavaName());
        return term;
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.isTempFactsShortcut()) {
            res.append(this.name);
            res.append("(");
            res.append(this.attrs.get(0));
            res.append("..");
            res.append(this.attrs.get(2));
            res.append(")");
        } else if (!this.builtin) {
            if (this.isTrueNegated()) {
                res.append('-');
            }
            res.append(this.name);
            if (this.arity() > 0) {
                res.append('(');
            }
            int count = 1;
            for (Term t : this.attrs) {
                res.append(t);
                if (this.attrs.size() == 1 || this.attrs.size() < ++count) continue;
                res.append(", ");
            }
            if (this.arity() > 0) {
                res.append(')');
            }
        } else if (this.attrs.size() == 2) {
            res.append(this.attrs.get(0));
            res.append(' ');
            res.append("${" + this.getJavaName() + "}");
            res.append(' ');
            res.append(this.attrs.get(this.attrs.size() - 1));
        } else if (this.attrs.size() == 3) {
            res.append(this.attrs.get(0));
            res.append(' ');
            res.append('=');
            res.append(' ');
            res.append(this.attrs.get(1));
            res.append(' ');
            res.append(this.name);
            res.append(' ');
            res.append(this.attrs.get(2));
        }
        return res.toString();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public int getAtomBeginColumn() {
        return 0;
    }

    @Override
    public int getAtomBeginLine() {
        return 0;
    }

    @Override
    public int getAtomEndLine() {
        return 0;
    }

    @Override
    public int getAtomEndColumn() {
        return 0;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public boolean isNumericConstant() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public List<Term> attributes() {
        return new ArrayList<Term>();
    }

    @Override
    public boolean existsMatch(Term t) {
        return false;
    }
}

