/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.JavaContentAtom;
import it.unical.mat.dlv.program.NonPositionalTerm;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.List;

public class NormalAtom
implements Atom,
Term {
    boolean neg = false;
    boolean builtin = false;
    String name = "";
    ArrayList<Term> attrs = new ArrayList();
    int atomBeginColumn = 0;
    int atomBeginLine = 0;
    int atomEndLine = 0;
    int atomEndColumn = 0;

    public NormalAtom(String name) {
        this.name = name;
    }

    public NormalAtom(boolean trueNegated, String name) {
        this.neg = trueNegated;
        this.name = name;
    }

    public NormalAtom(boolean trueNegated, String name, List<Term> att) {
        this.neg = trueNegated;
        this.name = name;
        for (Term term : att) {
            this.attrs.add(term);
        }
    }

    public NormalAtom(String name, ArrayList<SimpleTerm> att) {
        this.name = name;
        for (SimpleTerm term : att) {
            this.attrs.add(term);
        }
    }

    public boolean isFactsShortcut() {
        if (this.attrs.size() == 1) {
            return this.attrs.get(0).toString().matches("(\\d)+\\p{Punct}\\p{Punct}(\\d)+");
        }
        return false;
    }

    boolean isTempFactsShortcut() {
        if (this.attrs.size() == 3) {
            return this.attrs.get(0).isNumericConstant() && this.attrs.get(1).toString().equals("..") && this.attrs.get(2).isNumericConstant();
        }
        return false;
    }

    public NormalAtom(String sx, String op, String dx) {
        this.name = op;
        this.attrs.add(new SimpleTerm(sx));
        this.attrs.add(new SimpleTerm(dx));
        this.setBuiltin(true);
    }

    public NormalAtom(SimpleTerm sx, String op, SimpleTerm dx) {
        this.name = op;
        this.attrs.add(sx);
        this.attrs.add(dx);
        this.setBuiltin(true);
    }

    public NormalAtom(String op, String sx, String dx1, String dx2) {
        this.name = op;
        this.attrs.add(new SimpleTerm(sx));
        this.attrs.add(new SimpleTerm(dx1));
        this.attrs.add(new SimpleTerm(dx2));
        this.setBuiltin(true);
    }

    public NormalAtom(String op, Term sx, Term dx) {
        this.name = op;
        this.attrs.add(sx);
        this.attrs.add(dx);
        this.setBuiltin(true);
    }

    public NormalAtom(String op, Term sx, Term dx1, Term dx2) {
        this.name = op;
        this.attrs.add(sx);
        this.attrs.add(dx1);
        this.attrs.add(dx2);
        this.setBuiltin(true);
    }

    public NormalAtom(String op, SimpleTerm sx, SimpleTerm dx1, SimpleTerm dx2) {
        this.name = op;
        this.attrs.add(sx);
        this.attrs.add(dx1);
        this.attrs.add(dx2);
        this.setBuiltin(true);
    }

    public boolean containsTerm(Term t1) {
        for (Term t : this.attrs) {
            if (t.isComplex()) {
                return ((NormalAtom)t).containsTerm(t1);
            }
            if (!t.toString().equals(t1.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean containsTerm(String t1) {
        for (Term t : this.attrs) {
            if (t.isComplex()) {
                return ((NormalAtom)t).containsTerm(t1);
            }
            if (!t.toString().equals(t1)) continue;
            return true;
        }
        return false;
    }

    public Term getAttributeAt(int index) {
        return this.attrs.get(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isTrueNegated() {
        return this.neg;
    }

    public void setTrueNegated(boolean trueNegated) {
        this.neg = trueNegated;
    }

    @Override
    public List<Term> attributes() {
        return this.attrs;
    }

    public int arity() {
        if (this.isTempFactsShortcut()) {
            return 1;
        }
        return this.attrs.size();
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void addAttribute(Term term) {
        this.attrs.add(term);
    }

    public void setAttributeAt(int position, Term term) {
        this.attrs.set(position, term);
    }

    public void removeAttribute(Term term) {
        this.attrs.remove(term);
        ArrayList c = new ArrayList();
        c.remove("ddd");
    }

    public void removeAttributeAt(int position) {
        this.attrs.remove(position);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isGround() {
        for (Term t : this.attrs) {
            if (t.isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumericConstant() {
        return false;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public List<Term> getVariables() {
        ArrayList<Term> ris = new ArrayList<Term>();
        for (Term t : this.attrs) {
            ris.addAll(t.getVariables());
        }
        return ris;
    }

    @Override
    public boolean existsMatch(Term t) {
        return false;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    public ArrayList<Term> getAttrs() {
        return this.attrs;
    }

    @Override
    public NormalAtom clone() {
        NormalAtom newAtom = new NormalAtom(this.neg, this.name);
        newAtom.setBuiltin(this.builtin);
        for (Term term : this.attrs) {
            newAtom.addAttribute(term.clone());
        }
        return newAtom;
    }

    @Override
    public int getAtomBeginColumn() {
        return this.atomBeginColumn;
    }

    public void setAtomBeginColumn(int atomBeginColumn) {
        this.atomBeginColumn = atomBeginColumn;
    }

    @Override
    public int getAtomBeginLine() {
        return this.atomBeginLine;
    }

    public void setAtomBeginLine(int atomBeginLine) {
        this.atomBeginLine = atomBeginLine;
    }

    @Override
    public int getAtomEndLine() {
        return this.atomEndLine;
    }

    public void setAtomEndLine(int atomEndLine) {
        this.atomEndLine = atomEndLine;
    }

    @Override
    public int getAtomEndColumn() {
        return this.atomEndColumn;
    }

    public void setAtomEndColumn(int atomEndColumn) {
        this.atomEndColumn = atomEndColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attrs == null ? 0 : this.attrs.hashCode());
        result = 31 * result + (this.builtin ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.neg ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NormalAtom other = (NormalAtom)obj;
        if (this.attrs == null ? other.attrs != null : !this.attrs.equals(other.attrs)) {
            return false;
        }
        if (this.builtin != other.builtin) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.neg == other.neg;
    }

    public boolean isNeg() {
        return this.neg;
    }

    public void setNeg(boolean neg) {
        this.neg = neg;
    }

    public void setAttrs(ArrayList<Term> attrs) {
        this.attrs = attrs;
    }

    @Override
    public boolean containsNonPositionalTerm() {
        for (Term term : this.attrs) {
            if (!(term instanceof NonPositionalTerm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsJavaContentAtoms() {
        for (Term term : this.attrs) {
            if (!(term instanceof JavaContentAtom)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.isTempFactsShortcut()) {
            res.append(this.name);
            res.append("(");
            res.append(this.attrs.get(0));
            res.append("..");
            res.append(this.attrs.get(2));
            res.append(")");
        } else if (!this.builtin) {
            if (this.isTrueNegated()) {
                res.append('-');
            }
            res.append(this.getName());
            if (this.arity() > 0) {
                res.append('(');
            }
            int count = 1;
            for (Term t : this.attrs) {
                res.append(t);
                if (this.attrs.size() == 1 || this.attrs.size() < ++count) continue;
                res.append(", ");
            }
            if (this.arity() > 0) {
                res.append(')');
            }
        } else if (this.attrs.size() == 2) {
            res.append(this.attrs.get(0));
            res.append(' ');
            res.append(this.name);
            res.append(' ');
            res.append(this.attrs.get(this.attrs.size() - 1));
        } else if (this.attrs.size() == 3) {
            res.append(this.attrs.get(0));
            res.append(' ');
            res.append('=');
            res.append(' ');
            res.append(this.attrs.get(1));
            res.append(' ');
            res.append(this.name);
            res.append(' ');
            res.append(this.attrs.get(2));
        }
        return res.toString();
    }
}

