/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.SimpleComment;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Conjunction;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.ProgramExpression;
import it.unical.mat.dlv.program.ProgramPredicate;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.dlv.program.error.ArityError;
import it.unical.mat.dlv.program.error.SafetyError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Query
implements ProgramExpression {
    private Conjunction B = new Conjunction();
    private int line;
    private int endLine;
    private int beginColumn;
    private int endColumn;
    SimpleComment comment;
    String name;

    public Query() {
    }

    public Query(Conjunction conjunction) {
        this.B = conjunction;
    }

    public Conjunction body() {
        return this.B;
    }

    public int bodySize() {
        return this.body().size();
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public boolean isGround() {
        for (Literal lit : this.body()) {
            if (lit.isGround()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.B.toString()) + '?';
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<ArityError> getArityErrors() {
        ArrayList<ArityError> errors = new ArrayList<ArityError>();
        HashMap<String, List<Atom>> atoms = this.getClassifiedAtoms();
        for (String key : atoms.keySet()) {
            int i = 0;
            while (i < atoms.get(key).size() - 1) {
                Atom a1 = atoms.get(key).get(i);
                int j = i + 1;
                while (j < atoms.get(key).size()) {
                    Atom a2 = atoms.get(key).get(j);
                    if (a1 instanceof NormalAtom && a2 instanceof NormalAtom && ((NormalAtom)a1).arity() != ((NormalAtom)a2).arity()) {
                        String errorText = "The atom '" + a2.toString() + "' in the rule " + "'" + this.toString() + "' expected arity " + ((NormalAtom)a1).arity();
                        errors.add(new ArityError(errorText, (ProgramExpression)this, a2, ((NormalAtom)a1).arity()));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return errors;
    }

    @Override
    public List<SafetyError> getSafetyErrors() {
        ArrayList<SafetyError> errors = new ArrayList<SafetyError>();
        List<Term> positiveVariableInBody = this.getSafeTermsInBody();
        for (Literal literal : this.B) {
            if (!(literal.getAtom() instanceof AggregateAtom)) continue;
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            ArrayList<String> localVariables = new ArrayList<String>();
            for (Literal literal2 : aggregate.getBody()) {
                Atom atom;
                if (!literal2.isPositive() || !((atom = literal2.getAtom()) instanceof NormalAtom)) continue;
                List<Term> terms = ((NormalAtom)atom).getVariables();
                for (Term term : terms) {
                    if (!(term instanceof SimpleTerm) || !((SimpleTerm)term).isVariable()) continue;
                    localVariables.add(((SimpleTerm)term).getContent());
                }
            }
            for (Term term : aggregate.getVars()) {
                SafetyError error;
                String message;
                if (!localVariables.contains(term.toString())) {
                    message = "In the Query '" + this.toString() + "' the local variable '" + term.toString() + "' in the aggregate '" + aggregate.toString() + "' is undefined in the aggregate body";
                    error = new SafetyError(message, this, term, false, true);
                    errors.add(error);
                }
                if (!this.isFree(term)) {
                    message = "In the Query '" + this.toString() + "' the local variable '" + term.toString() + "' in the aggregate '" + aggregate.toString() + "' is not free";
                    error = new SafetyError(message, this, term, false, true);
                    errors.add(error);
                }
                if (!this.B.isUsedInAggregates(term, aggregate)) continue;
                message = "In the Query '" + this.toString() + "' the local variable '" + term.toString() + "' used in the aggregate '" + aggregate.toString() + "' can not match in others aggregate atom";
                error = new SafetyError(message, this, term, false, true);
                errors.add(error);
            }
        }
        for (Term negativeTerm : this.getUnsafeTermsInBody()) {
            if (positiveVariableInBody.contains(negativeTerm)) continue;
            String message = "In the Query '" + this.toString() + "' the variable '" + negativeTerm + "' used in the body is not safe";
            if (negativeTerm.toString().equals("_")) {
                message = "In the Rule '" + this.toString() + "' the underscore used in the body is not safe";
            }
            SafetyError error = new SafetyError(message, this, negativeTerm, false, false);
            errors.add(error);
        }
        return errors;
    }

    @Override
    public List<Term> getSafeTermsInBody() {
        return this.B.getSafeTerms(true);
    }

    @Override
    public List<Term> getUnsafeTerms() {
        LinkedList<Term> terms = new LinkedList<Term>();
        terms.addAll(this.getUnsafeTermsInBody());
        return terms;
    }

    @Override
    public List<Term> getUnsafeTermsInBody() {
        return this.B.getUnsafeTerms();
    }

    @Override
    public boolean isSafe() {
        return this.getUnsafeTermsInBody().isEmpty();
    }

    @Override
    public boolean isTermSafe(Term term) {
        return !this.getUnsafeTermsInBody().contains(term);
    }

    @Override
    public void setComment(SimpleComment comment) {
        this.comment = comment;
    }

    @Override
    public SimpleComment getComment() {
        return this.comment;
    }

    @Override
    public List<ProgramPredicate> getPredicates() {
        return this.B.getPredicates();
    }

    @Override
    public List<ProgramPredicate> getPredicatesInBody() {
        return this.B.getPredicates();
    }

    @Override
    public List<ProgramPredicate> getPredicatesInHead() {
        return new ArrayList<ProgramPredicate>();
    }

    @Override
    public HashMap<String, List<Atom>> getClassifiedAtoms() {
        HashMap<String, List<Atom>> atoms = new HashMap<String, List<Atom>>();
        for (Literal literal : this.B) {
            if (!literal.isAggregate()) {
                Atom atom = literal.getAtom();
                if (!atoms.containsKey(atom.getName())) {
                    atoms.put(atom.getName(), new ArrayList());
                }
                atoms.get(atom.getName()).add(atom);
                continue;
            }
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            for (Literal l : aggregate.getBody()) {
                Atom a = l.getAtom();
                if (!(a instanceof NormalAtom)) continue;
                if (!atoms.containsKey(a.getName())) {
                    atoms.put(a.getName(), new ArrayList());
                }
                atoms.get(a.getName()).add(a);
            }
        }
        return atoms;
    }

    private boolean isFree(Term t) {
        return this.B.isFree(t);
    }

    @Override
    public int getBeginLine() {
        return this.getLine();
    }

    @Override
    public void setBeginLine(int line) {
        this.line = line;
    }

    @Override
    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    @Override
    public Conjunction getBody() {
        return this.B;
    }

    @Override
    public Query clone() {
        return new Query(this.B.clone());
    }

    @Override
    public boolean containsPredicate(String predicateName) {
        return this.B.containsPredicate(predicateName);
    }

    @Override
    public Atom getFirstAtomUsingPredicate(String predicateName) {
        return this.B.getFirstAtomUsingPredicate(predicateName);
    }

    @Override
    public void renamePredicate(String oldName, String newName) {
        this.B.renamePredicate(oldName, newName);
    }

    @Override
    public void renameUnusedVariables(String newName) {
        HashMap atoms = new HashMap();
        for (Literal l : this.B) {
            String name;
            Atom a = l.getAtom();
            if (a instanceof NormalAtom) {
                for (Term term : ((NormalAtom)a).getVariables()) {
                    if (!(term instanceof SimpleTerm)) continue;
                    name = ((SimpleTerm)term).getContent();
                    if (!atoms.containsKey(name)) {
                        atoms.put(name, new ArrayList());
                    }
                    ((List)atoms.get(name)).add((SimpleTerm)term);
                }
                continue;
            }
            if (!(a instanceof AggregateAtom)) continue;
            for (Term term : ((AggregateAtom)a).getVars()) {
                if (!(term instanceof SimpleTerm)) continue;
                name = ((SimpleTerm)term).getContent();
                if (!atoms.containsKey(name)) {
                    atoms.put(name, new ArrayList());
                }
                ((List)atoms.get(name)).add((SimpleTerm)term);
            }
            for (Literal literal : ((AggregateAtom)a).getBody()) {
                Atom atomAggr = literal.getAtom();
                if (!(atomAggr instanceof NormalAtom)) continue;
                for (Term termAggr : ((NormalAtom)atomAggr).getVariables()) {
                    if (!(termAggr instanceof SimpleTerm)) continue;
                    String name2 = ((SimpleTerm)termAggr).getContent();
                    if (!atoms.containsKey(name2)) {
                        atoms.put(name2, new ArrayList());
                    }
                    ((List)atoms.get(name2)).add((SimpleTerm)termAggr);
                }
            }
        }
        for (String atomName : atoms.keySet()) {
            if (((List)atoms.get(atomName)).size() != 1) continue;
            ((SimpleTerm)((List)atoms.get(atomName)).get(0)).setContent(newName);
        }
    }

    @Override
    public boolean containsAggregate() {
        return this.B.containsAggregate();
    }

    @Override
    public int compareTo(Expression o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public boolean containsTerm(String termValue) {
        return this.body().containsTerm(termValue);
    }
}

