/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.SimpleComment;
import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.ArityWarning;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Conjunction;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.ProgramExpression;
import it.unical.mat.dlv.program.ProgramPredicate;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.dlv.program.error.ArityError;
import it.unical.mat.dlv.program.error.SafetyError;
import it.unical.mat.dlv.program.error.SafetyWarning;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Rule
implements ProgramExpression {
    private Conjunction B = new Conjunction();
    private Disjunction H = new Disjunction();
    int line;
    int endLine;
    int beginColumn;
    int endColumn;
    private int modelID;
    SimpleComment comment;
    String name;

    public Rule(Disjunction disjunction) {
        if (disjunction != null) {
            this.H = disjunction;
        }
    }

    public Rule(Conjunction conjunction) {
        if (conjunction != null) {
            this.B = conjunction;
        }
    }

    @Override
    public void setComment(SimpleComment comment) {
        this.comment = comment;
    }

    @Override
    public SimpleComment getComment() {
        return this.comment;
    }

    public int size() {
        return this.B.size() + this.H.size();
    }

    public void setHead(Disjunction disjunction) {
        this.H = disjunction;
    }

    public Rule(String code) {
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        try {
            Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
            director.configureBuilder(builder);
            director.parse();
            Program program = (Program)builder.getProductHandler();
            if (program != null) {
                if (program.isEmpty()) {
                    this.H = null;
                    this.B = null;
                } else if (program.get(0) instanceof Rule) {
                    Rule rule = (Rule)program.get(0);
                    this.H = rule.H;
                    this.B = rule.B;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            this.H = null;
            this.B = null;
        }
        catch (ParseException e) {
            this.H = null;
            this.B = null;
        }
    }

    public Rule(Disjunction disjunction, Conjunction conjunction) {
        if (disjunction != null) {
            this.H = disjunction;
        }
        if (conjunction != null) {
            this.B = conjunction;
        }
    }

    public Disjunction head() {
        return this.H;
    }

    public Conjunction body() {
        return this.B;
    }

    public void addInHead(Atom atom) {
        this.H.add(atom);
    }

    public void addInPositiveBody(Atom atom) {
        this.B.addAtom(atom);
    }

    public void addInNegativeBody(Atom atom) {
        this.B.addNegatedAtom(atom);
    }

    public void addInBody(Literal literal) {
        this.B.add(literal);
    }

    public int bodySize() {
        return this.body().size();
    }

    public int HeadSize() {
        return this.head().size();
    }

    public boolean isConstraint() {
        return this.H.size() == 0;
    }

    public boolean isFact() {
        return this.B.size() == 0 && this.H.size() == 1 && ((Atom)this.H.get(0)).getVariables().isEmpty();
    }

    public boolean isNongroundFact() {
        return this.B.size() == 0 && this.H.size() == 1 && !((Atom)this.H.get(0)).getVariables().isEmpty();
    }

    public String toString() {
        if (this.B.isEmpty()) {
            return this.head() + ".";
        }
        if (this.isConstraint()) {
            return ":- " + this.body() + ".";
        }
        return this.head() + " :- " + this.body() + ".";
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public boolean isGround() {
        for (Atom headAtom : this.head()) {
            if (headAtom.isGround()) continue;
            return false;
        }
        for (Literal bodyLit : this.body()) {
            if (bodyLit.isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ArityError> getArityErrors() {
        ArrayList<ArityError> errors = new ArrayList<ArityError>();
        HashMap<String, List<Atom>> atoms = this.getClassifiedAtoms();
        for (String key : atoms.keySet()) {
            int i = 0;
            while (i < atoms.get(key).size() - 1) {
                Atom a1 = atoms.get(key).get(i);
                int j = i + 1;
                while (j < atoms.get(key).size()) {
                    Atom a2 = atoms.get(key).get(j);
                    if (a1 instanceof NormalAtom && a2 instanceof NormalAtom) {
                        String errorText;
                        NormalAtom na1 = (NormalAtom)a1;
                        NormalAtom na2 = (NormalAtom)a2;
                        if (na1.containsNonPositionalTerm()) {
                            if (!na2.containsNonPositionalTerm()) {
                                errorText = "The atom '" + a1.toString() + "' in the rule " + "'" + this.toString() + "' could have different arity from " + na2.arity();
                                errors.add(new ArityWarning(errorText, (ProgramExpression)this, a1, na2.arity()));
                            }
                        } else if (na2.containsNonPositionalTerm()) {
                            if (na2.arity() > na1.arity()) {
                                errorText = "The atom '" + a2.toString() + "' in the rule " + "'" + this.toString() + "' expected arity " + na1.arity();
                                errors.add(new ArityError(errorText, (ProgramExpression)this, a2, na1.arity()));
                            } else {
                                errorText = "The atom '" + a2.toString() + "' in the rule " + "'" + this.toString() + "' could have different arity from " + na1.arity();
                                errors.add(new ArityWarning(errorText, (ProgramExpression)this, a2, na1.arity()));
                            }
                        } else if (na2.arity() != na1.arity()) {
                            errorText = "The atom '" + a2.toString() + "' in the rule " + "'" + this.toString() + "' expected arity " + na1.arity();
                            errors.add(new ArityError(errorText, (ProgramExpression)this, a2, na1.arity()));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return errors;
    }

    @Override
    public List<Term> getSafeTermsInBody() {
        return this.B.getSafeTerms(true);
    }

    @Override
    public List<Term> getUnsafeTerms() {
        LinkedList<Term> terms = new LinkedList<Term>();
        terms.addAll(this.getUnsafeTermsInHead());
        terms.addAll(this.getUnsafeTermsInBody());
        return terms;
    }

    @Override
    public List<Term> getUnsafeTermsInBody() {
        return this.B.getUnsafeTerms();
    }

    public List<Term> getUnsafeTermsInHead() {
        LinkedList<Term> unsafeHeadTerms = new LinkedList<Term>();
        List<Term> positiveTermsInBody = this.getSafeTermsInBody();
        for (Atom atom : this.H) {
            ArrayList<Term> terms = ((NormalAtom)atom).getAttrs();
            for (Term term : terms) {
                if (!(term instanceof SimpleTerm)) continue;
                if (((SimpleTerm)term).isVariable()) {
                    if (positiveTermsInBody.contains(term)) continue;
                    unsafeHeadTerms.add(term);
                    continue;
                }
                if (!((SimpleTerm)term).getContent().equals("_")) continue;
                unsafeHeadTerms.add(term);
            }
        }
        return unsafeHeadTerms;
    }

    @Override
    public boolean isSafe() {
        return this.getUnsafeTermsInHead().isEmpty() && this.getUnsafeTermsInBody().isEmpty();
    }

    @Override
    public boolean isTermSafe(Term term) {
        return !this.getUnsafeTermsInHead().contains(term) && !this.getUnsafeTermsInBody().contains(term);
    }

    @Override
    public List<ProgramPredicate> getPredicates() {
        ArrayList<ProgramPredicate> predicates = new ArrayList<ProgramPredicate>();
        predicates.addAll(this.H.getPredicates());
        for (ProgramPredicate predicate : this.B.getPredicates()) {
            if (predicates.contains(predicate)) continue;
            predicates.add(predicate);
        }
        return predicates;
    }

    @Override
    public List<ProgramPredicate> getPredicatesInBody() {
        return this.B.getPredicates();
    }

    @Override
    public List<ProgramPredicate> getPredicatesInHead() {
        return this.H.getPredicates();
    }

    private List<SimpleTerm> getAllTermsInAtom(NormalAtom atom) {
        ArrayList<SimpleTerm> simpleTermList = new ArrayList<SimpleTerm>();
        ArrayList<NormalAtom> toVisit = new ArrayList<NormalAtom>();
        toVisit.add(atom);
        while (!toVisit.isEmpty()) {
            NormalAtom a = (NormalAtom)toVisit.remove(0);
            ArrayList<Term> terms = a.getAttrs();
            for (Term term : terms) {
                if (term instanceof SimpleTerm) {
                    simpleTermList.add((SimpleTerm)term);
                    continue;
                }
                if (!(term instanceof NormalAtom)) continue;
                toVisit.add((NormalAtom)term);
            }
        }
        return simpleTermList;
    }

    private List<NormalAtom> getAllAtomInAtom(NormalAtom atom) {
        ArrayList<NormalAtom> toVisit = new ArrayList<NormalAtom>();
        ArrayList<NormalAtom> atomList = new ArrayList<NormalAtom>();
        toVisit.add(atom);
        atomList.add(atom);
        while (!toVisit.isEmpty()) {
            NormalAtom a = (NormalAtom)toVisit.remove(0);
            ArrayList<Term> terms = a.getAttrs();
            for (Term term : terms) {
                if (!(term instanceof NormalAtom)) continue;
                toVisit.add((NormalAtom)term);
                atomList.add((NormalAtom)term);
            }
        }
        return atomList;
    }

    @Override
    public List<SafetyError> getSafetyErrors() {
        ArrayList<SafetyError> errors = new ArrayList<SafetyError>();
        List<Term> positiveTermsInBody = this.getSafeTermsInBody();
        for (Atom atom : this.H) {
            List<SimpleTerm> terms = this.getAllTermsInAtom((NormalAtom)atom);
            for (SimpleTerm term : terms) {
                Object message;
                if (term.isVariable()) {
                    if (positiveTermsInBody.contains(term)) continue;
                    if (this.body().containsJavaContentAtoms()) {
                        message = "In the Rule '" + this.toString() + "' the term '" + term.getContent() + "' used in the head may not be safe";
                        SafetyWarning safetyWarning = new SafetyWarning((String)message, this, term, true, false);
                        errors.add(safetyWarning);
                        continue;
                    }
                    message = "In the Rule '" + this.toString() + "' the term '" + term.getContent() + "' used in the head is not safe";
                    SafetyError safetyError = new SafetyError((String)message, this, term, true, false);
                    errors.add(safetyError);
                    continue;
                }
                if (!term.getContent().equals("_")) continue;
                message = "In the Rule '" + this.toString() + "' the term '_' used in the head is not safe";
                SafetyError safetyError = new SafetyError((String)message, this, term, true, false);
                errors.add(safetyError);
            }
        }
        for (Literal literal : this.B) {
            SafetyError error;
            if (!(literal.getAtom() instanceof AggregateAtom)) continue;
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            ArrayList<String> localVariables = new ArrayList<String>();
            for (Literal l : aggregate.getBody()) {
                Atom atom;
                if (!l.isPositive() || !((atom = l.getAtom()) instanceof NormalAtom)) continue;
                List<SimpleTerm> terms = this.getAllTermsInAtom((NormalAtom)atom);
                for (Term term : terms) {
                    if (!((SimpleTerm)term).isVariable()) continue;
                    localVariables.add(((SimpleTerm)term).getContent());
                }
            }
            List<Term> unsafeTerms = aggregate.getBody().getUnsafeTerms();
            List<Term> safeTerms = aggregate.getBody().getSafeTerms(true);
            for (Term term : unsafeTerms) {
                if (safeTerms.contains(term)) continue;
                String string = "In the Rule '" + this.toString() + "' the local variable '" + term.toString() + "' in the aggregate '" + aggregate.toString() + "' is not safe";
                error = new SafetyError(string, this, term, false, true);
                errors.add(error);
            }
            for (Term term : aggregate.getVars()) {
                if (!localVariables.contains(term.toString())) {
                    String string = "In the Rule '" + this.toString() + "' the local variable '" + term.toString() + "' in the aggregate '" + aggregate.toString() + "' is undefined in the aggregate body";
                    error = new SafetyError(string, this, term, false, true);
                    errors.add(error);
                }
                if (!this.isFree(term)) {
                    String string = "In the Rule '" + this.toString() + "' the local variable '" + term.toString() + "' in the aggregate '" + aggregate.toString() + "' is not free";
                    error = new SafetyError(string, this, term, false, true);
                    errors.add(error);
                }
                if (!this.B.isUsedInAggregates(term, aggregate)) continue;
                String string = "In the Rule '" + this.toString() + "' the local variable '" + term.toString() + "' used in the aggregate '" + aggregate.toString() + "' can not match in others aggregate atom";
                error = new SafetyError(string, this, term, false, true);
                errors.add(error);
            }
        }
        List<Term> unsafeTerm = this.getUnsafeTermsInBody();
        for (Term negativeTerm : unsafeTerm) {
            SafetyError error;
            if (positiveTermsInBody.contains(negativeTerm)) continue;
            String message = "In the Rule '" + this.toString() + "' the term '" + negativeTerm + "' used in the body is not safe";
            if (negativeTerm.toString().equals("_")) {
                message = "In the Rule '" + this.toString() + "' the underscore used in the body is not safe";
            }
            if (this.body().containsJavaContentAtoms()) {
                message = "In the Rule '" + this.toString() + "' the term '" + negativeTerm + "' used in the body may not be safe";
                error = new SafetyWarning(message, this, negativeTerm, false, false);
                errors.add(error);
                continue;
            }
            error = new SafetyError(message, this, negativeTerm, false, false);
            errors.add(error);
        }
        return errors;
    }

    private boolean isFree(Term t) {
        return this.H.isFree(t) && this.B.isFree(t);
    }

    @Override
    public HashMap<String, List<Atom>> getClassifiedAtoms() {
        HashMap<String, List<Atom>> atoms = new HashMap<String, List<Atom>>();
        for (Atom atomTmp : this.H) {
            if (!(atomTmp instanceof NormalAtom)) continue;
            for (NormalAtom atom : this.getAllAtomInAtom((NormalAtom)atomTmp)) {
                if (!atoms.containsKey(atom.getName())) {
                    atoms.put(atom.getName(), new ArrayList());
                }
                atoms.get(atom.getName()).add(atom);
            }
        }
        for (Literal literal : this.B) {
            if (!literal.isAggregate()) {
                Atom tmpAtom = literal.getAtom();
                if (!(tmpAtom instanceof NormalAtom)) continue;
                for (Atom atom : this.getAllAtomInAtom((NormalAtom)tmpAtom)) {
                    if (!atoms.containsKey(atom.getName())) {
                        atoms.put(atom.getName(), new ArrayList());
                    }
                    atoms.get(atom.getName()).add(atom);
                }
                continue;
            }
            AggregateAtom aggregate = (AggregateAtom)literal.getAtom();
            for (Literal literal2 : aggregate.getBody()) {
                Atom aTmp = literal2.getAtom();
                if (!(aTmp instanceof NormalAtom)) continue;
                for (Atom atom : this.getAllAtomInAtom((NormalAtom)aTmp)) {
                    if (!atoms.containsKey(atom.getName())) {
                        atoms.put(atom.getName(), new ArrayList());
                    }
                    atoms.get(atom.getName()).add(atom);
                }
            }
        }
        return atoms;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getBeginLine() {
        return this.getLine();
    }

    @Override
    public void setBeginLine(int line) {
        this.line = line;
    }

    @Override
    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    @Override
    public Conjunction getBody() {
        return this.B;
    }

    public Disjunction getHead() {
        return this.H;
    }

    @Override
    public Rule clone() {
        Rule newRule = new Rule(this.H.clone(), this.B.clone());
        return newRule;
    }

    @Override
    public boolean containsPredicate(String predicateName) {
        return this.H.containsPredicate(predicateName) || this.B.containsPredicate(predicateName);
    }

    @Override
    public Atom getFirstAtomUsingPredicate(String predicateName) {
        Atom atom = this.H.getFirstAtomUsingPredicate(predicateName);
        if (atom != null) {
            return atom;
        }
        return this.B.getFirstAtomUsingPredicate(predicateName);
    }

    @Override
    public void renamePredicate(String oldName, String newName) {
        this.H.renamePredicate(oldName, newName);
        this.B.renamePredicate(oldName, newName);
    }

    @Override
    public void renameUnusedVariables(String newName) {
        HashMap atoms = new HashMap();
        for (Atom a : this.H) {
            if (!(a instanceof NormalAtom)) continue;
            for (Term t : ((NormalAtom)a).getVariables()) {
                if (!(t instanceof SimpleTerm)) continue;
                String name = ((SimpleTerm)t).getContent();
                if (!atoms.containsKey(name)) {
                    atoms.put(name, new ArrayList());
                }
                ((List)atoms.get(name)).add((SimpleTerm)t);
            }
        }
        for (Literal l : this.B) {
            String name;
            Atom a = l.getAtom();
            if (a instanceof NormalAtom) {
                for (Term term : ((NormalAtom)a).getVariables()) {
                    if (!(term instanceof SimpleTerm)) continue;
                    name = ((SimpleTerm)term).getContent();
                    if (!atoms.containsKey(name)) {
                        atoms.put(name, new ArrayList());
                    }
                    ((List)atoms.get(name)).add((SimpleTerm)term);
                }
                continue;
            }
            if (!(a instanceof AggregateAtom)) continue;
            for (Term term : ((AggregateAtom)a).getVars()) {
                if (!(term instanceof SimpleTerm)) continue;
                name = ((SimpleTerm)term).getContent();
                if (!atoms.containsKey(name)) {
                    atoms.put(name, new ArrayList());
                }
                ((List)atoms.get(name)).add((SimpleTerm)term);
            }
            for (Literal literal : ((AggregateAtom)a).getBody()) {
                Atom atomAggr = literal.getAtom();
                if (!(atomAggr instanceof NormalAtom)) continue;
                for (Term termAggr : ((NormalAtom)atomAggr).getVariables()) {
                    if (!(termAggr instanceof SimpleTerm)) continue;
                    String name2 = ((SimpleTerm)termAggr).getContent();
                    if (!atoms.containsKey(name2)) {
                        atoms.put(name2, new ArrayList());
                    }
                    ((List)atoms.get(name2)).add((SimpleTerm)termAggr);
                }
            }
        }
        for (String atomName : atoms.keySet()) {
            if (((List)atoms.get(atomName)).size() != 1) continue;
            ((SimpleTerm)((List)atoms.get(atomName)).get(0)).setContent(newName);
        }
    }

    public List<Rule> shift() {
        ArrayList<Rule> shiftRules = new ArrayList<Rule>();
        if (this.getHead().size() > 1) {
            int i = 0;
            while (i < this.getHead().size()) {
                Disjunction disjunction = new Disjunction();
                Conjunction conjunction = new Conjunction();
                disjunction.add(((Atom)this.getHead().get(i)).clone());
                conjunction = this.getBody().clone();
                int j = 0;
                while (j < this.getHead().size()) {
                    if (i != j) {
                        Literal literal = new Literal(false, ((Atom)this.getHead().get(j)).clone());
                        conjunction.add(literal);
                    }
                    ++j;
                }
                shiftRules.add(new Rule(disjunction, conjunction));
                ++i;
            }
        } else {
            shiftRules.add(this.clone());
        }
        return shiftRules;
    }

    @Override
    public boolean containsAggregate() {
        return this.B.containsAggregate();
    }

    public List<Term> getVariables() {
        ArrayList<Term> variables = new ArrayList<Term>();
        for (Atom headAtom : this.head()) {
            for (Term var : headAtom.getVariables()) {
                if (variables.contains(var)) continue;
                variables.add(var);
            }
        }
        for (Literal bodyLiter : this.body()) {
            for (Term var : bodyLiter.getVariables()) {
                if (variables.contains(var)) continue;
                variables.add(var);
            }
        }
        return variables;
    }

    @Override
    public int compareTo(Expression o) {
        return this.toString().compareTo(o.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.B == null ? 0 : this.B.hashCode());
        result = 31 * result + (this.H == null ? 0 : this.H.hashCode());
        return result;
    }

    @Override
    public boolean containsTerm(String termValue) {
        return this.H.containsTerm(termValue) || this.B.containsTerm(termValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.B == null ? other.B != null : !this.B.equals(other.B)) {
            return false;
        }
        return !(this.H == null ? other.H != null : !this.H.equals(other.H));
    }

    public boolean isHorn() {
        if (this.isConstraint() || this.HeadSize() > 1) {
            return false;
        }
        for (Literal l : this.B) {
            if (l.isPositive()) continue;
            return false;
        }
        return true;
    }
}

