/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.ProgramComment;
import it.unical.mat.dlv.metainfo.Schema;
import it.unical.mat.dlv.metainfo.SimpleComment;
import it.unical.mat.dlv.parser.Builder;
import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Comment;
import it.unical.mat.dlv.program.Conjunction;
import it.unical.mat.dlv.program.Directive;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.ImportDirective;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.ProductHandler;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Query;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.dlv.program.WeakConstraint;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ShifterProgramBuilder
implements Builder {
    public static String startProgramComment = "@start-program-comment";
    public static String endProgramComment = "@end-program-comment";
    public static String startSimpleComment = "@start-comment";
    public static String endSimpleComment = "@end-comment";
    public static String schemaDirective = "@schema";
    public static String nameDirective = "@name";
    public static String renameDirective = "@rename";
    protected ProductHandler productHandler = new Program();
    private ArrayList<ArrayList<Term>> stack = new ArrayList();
    private ArrayList<Atom> atoms = new ArrayList();
    private ArrayList<Literal> literals = new ArrayList();
    private Disjunction disj = null;
    private Conjunction conj = null;
    private Conjunction aggregateSetConj = null;
    private ArrayList<Literal> literalsAggregateSetConj = new ArrayList();
    private boolean trace = false;
    boolean inProgramComment = false;
    ProgramComment programComment = null;
    boolean inSimpleComment = false;
    SimpleComment simpleComment = null;
    String expressionName = null;
    private ArrayList<SimpleTerm> aggrVars = new ArrayList();
    private boolean inAggregate = false;
    private Director director;
    private HashMap<String, SimpleTerm> builtinTerm = new HashMap();
    protected HashMap<String, List<Schema>> schemaDirectives = new HashMap();
    boolean shifted = false;
    boolean transformQueryToConstraint = false;
    int beginLine = -1;
    int endLine = -1;
    int beginColumn = -1;
    int endColumn = -1;
    int atomBeginLine = -1;
    int atomEndLine = -1;
    int atomBeginColumn = -1;
    int atomEndColumn = -1;
    int variableBeginLine = -1;
    int variableEndLine = -1;
    int variableBeginColumn = -1;
    int variableEndColumn = -1;
    int aggregateLowGuardBeginLine = -1;
    int aggregateLowGuardBeginColumn = -1;
    int aggregateLowGuardEndLine = -1;
    int aggregateLowGuardEndColumn = -1;

    @Override
    public void configureProductHandler(ProductHandler pr) {
        this.productHandler = pr;
        if (this.productHandler instanceof Program) {
            ((Program)this.productHandler).setSchemaDirectives(this.schemaDirectives);
        }
    }

    @Override
    public void startDirective() {
    }

    @Override
    public void aggregateAtom(String lowerGuard, String lowOp, String name, String upOp, String upperGuard) {
        SimpleTerm term;
        if (this.trace) {
            System.out.println("aggregateAtom()");
        }
        AggregateAtom aggr = new AggregateAtom("#" + name, this.aggrVars, this.aggregateSetConj);
        if (!lowerGuard.equals("")) {
            term = new SimpleTerm(lowerGuard);
            term.setBeginColumn(this.aggregateLowGuardBeginColumn);
            term.setBeginLine(this.aggregateLowGuardBeginLine);
            term.setEndColumn(this.aggregateLowGuardEndColumn);
            term.setEndLine(this.aggregateLowGuardEndLine);
            aggr.setLowerGuard(term);
            aggr.setLowOp(lowOp);
        }
        if (!upperGuard.equals("")) {
            term = new SimpleTerm(upperGuard);
            term.setBeginColumn(this.variableBeginColumn);
            term.setBeginLine(this.variableBeginLine);
            term.setEndColumn(this.variableEndColumn);
            term.setEndLine(this.variableEndLine);
            aggr.setUpperGuard(term);
            aggr.setUpOp(upOp);
        }
        this.inAggregate = false;
        this.atoms.add(aggr);
        this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public void setDirector(Director director) {
        this.director = director;
    }

    @Override
    public void aggregateSet() {
        if (this.trace) {
            System.out.println("aggregateSet()");
        }
        Conjunction temp = this.conj;
        this.conj = this.aggregateSetConj;
        this.aggregateSetConj = temp;
        this.literals = this.literalsAggregateSetConj;
    }

    @Override
    public void startAtom() {
        if (this.trace) {
            System.out.println("startAtom()");
        }
        this.stack.add(new ArrayList());
    }

    @Override
    public void atomName(String name) {
        if (this.atomBeginColumn == -1) {
            this.atomBeginColumn = this.director.token.beginColumn;
            this.atomEndLine = this.atomBeginLine = this.director.token.beginLine;
            this.atomEndColumn = this.director.token.endColumn;
        } else if (this.inAggregate && this.stack.size() == 1) {
            this.atomBeginColumn = this.director.token.beginColumn;
            this.atomEndLine = this.atomBeginLine = this.director.token.beginLine;
            this.atomEndColumn = this.director.token.endColumn;
        }
        if (!this.inAggregate) {
            this.aggregateLowGuardBeginLine = this.director.token.beginLine;
            this.aggregateLowGuardBeginColumn = this.director.token.beginColumn;
            this.aggregateLowGuardEndLine = this.director.token.endLine;
            this.aggregateLowGuardEndColumn = this.director.token.endColumn;
        }
        SimpleTerm term = new SimpleTerm(name);
        term.setBeginLine(this.director.token.beginLine);
        term.setBeginColumn(this.director.token.beginColumn);
        term.setEndLine(this.director.token.endLine);
        term.setEndColumn(this.director.token.endColumn);
        this.builtinTerm.put(name, term);
    }

    @Override
    public void startWeak() {
        if (this.beginLine == -1) {
            this.beginLine = this.director.token.beginLine;
        }
        if (this.beginColumn == -1) {
            this.beginColumn = this.director.token.beginColumn;
        }
    }

    @Override
    public void startNAF() {
        if (this.beginLine == -1) {
            this.beginLine = this.director.token.beginLine;
        }
        if (this.beginColumn == -1) {
            this.beginColumn = this.director.token.beginColumn;
        }
    }

    @Override
    public void startTrueNegation() {
        if (this.beginLine == -1) {
            this.beginLine = this.director.token.beginLine;
        }
        if (this.beginColumn == -1) {
            this.beginColumn = this.director.token.beginColumn;
        }
    }

    @Override
    public void startIF() {
        if (this.beginLine == -1) {
            this.beginLine = this.director.token.beginLine;
        }
        if (this.beginColumn == -1) {
            this.beginColumn = this.director.token.beginColumn;
        }
    }

    @Override
    public void endAtom(boolean trueNegated, String name) {
        if (this.trace) {
            System.out.println("endAtom()");
        }
        ArrayList<Term> attrs = this.topStack();
        this.stack.remove(this.stack.size() - 1);
        if (this.stack.size() == 0) {
            NormalAtom newAtom = new NormalAtom(trueNegated, name, attrs);
            newAtom.setAtomBeginColumn(this.atomBeginColumn);
            newAtom.setAtomBeginLine(this.atomBeginLine);
            newAtom.setAtomEndColumn(this.atomEndColumn);
            newAtom.setAtomEndLine(this.atomEndLine);
            this.atomBeginColumn = -1;
            if (newAtom.isTempFactsShortcut()) {
                SimpleTerm t = new SimpleTerm(newAtom.attributes().get(0) + ".." + newAtom.attributes().get(0));
                NormalAtom atom = new NormalAtom(newAtom.getName());
                atom.attributes().add(t);
                this.atoms.add(atom);
            } else {
                this.atoms.add(newAtom);
            }
        } else if (this.stack.size() == 1 && this.inAggregate) {
            NormalAtom newAtom = new NormalAtom(trueNegated, name, attrs);
            newAtom.setAtomBeginColumn(this.atomBeginColumn);
            newAtom.setAtomBeginLine(this.atomBeginLine);
            newAtom.setAtomEndColumn(this.atomEndColumn);
            newAtom.setAtomEndLine(this.atomEndLine);
            this.atoms.add(newAtom);
            this.atomBeginColumn = -1;
        } else {
            Term t = null;
            if (attrs.size() == 0) {
                SimpleTerm term = new SimpleTerm(name);
                term.setBeginColumn(this.variableBeginColumn);
                term.setBeginLine(this.variableBeginLine);
                term.setEndColumn(this.variableEndColumn);
                term.setEndLine(this.variableEndLine);
                t = term;
            } else {
                NormalAtom newAtom = new NormalAtom(false, name, attrs);
                newAtom.setAtomBeginColumn(this.atomBeginColumn);
                newAtom.setAtomBeginLine(this.atomBeginLine);
                newAtom.setAtomEndColumn(this.atomEndColumn);
                newAtom.setAtomEndLine(this.atomEndLine);
                this.atomBeginColumn = -1;
                t = newAtom;
            }
            this.topStack().add(t);
        }
        if (this.beginLine == -1) {
            this.beginLine = this.director.token.beginLine;
        }
        this.builtinTerm.clear();
    }

    private ArrayList<Term> topStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    @Override
    public void addBuiltinTerm(String value, boolean isSecondTerm) {
    }

    @Override
    public void builtin(String sx, String op, boolean simpleBuiltin) {
    }

    @Override
    public void builtin(String sx, String op, String dx) {
        if (this.trace) {
            System.out.println("builtin()");
        }
        this.atoms.add(new NormalAtom(this.builtinTerm.get(sx), op, this.builtinTerm.get(dx)));
        this.stack.remove(this.stack.size() - 1);
        this.builtinTerm.clear();
        this.atomBeginColumn = -1;
    }

    @Override
    public void comment(String c) {
        if (this.trace) {
            System.out.println("comment()");
        }
        Comment comment = new Comment(c);
        comment.setLine(this.director.token.beginLine);
        comment.setEndLine(this.director.token.endLine);
        comment.setBeginColumn(this.director.token.beginColumn);
        comment.setEndColumn(this.director.token.endColumn);
        if (c.substring(1).trim().equals(startProgramComment)) {
            this.inProgramComment = true;
            this.programComment = new ProgramComment();
        } else if (c.substring(1).trim().equals(endProgramComment)) {
            this.inProgramComment = false;
            if (this.productHandler instanceof Program) {
                ((Program)this.productHandler).setProgramComment(this.programComment);
            }
        } else if (this.inProgramComment) {
            this.programComment.appendComment(c.substring(1).trim());
        } else if (c.substring(1).trim().equals(startSimpleComment)) {
            this.inSimpleComment = true;
            this.simpleComment = new SimpleComment();
        } else if (c.substring(1).trim().equals(endSimpleComment)) {
            this.inSimpleComment = false;
            this.simpleComment = null;
        } else if (this.inSimpleComment) {
            this.simpleComment.appendComment(c.substring(1).trim());
        } else if (c.substring(1).trim().startsWith(schemaDirective)) {
            if (this.productHandler instanceof Program) {
                String schemaTMP = c.substring(1).trim();
                schemaTMP = schemaTMP.trim().substring(7);
                schemaTMP = schemaTMP.trim();
                try {
                    Schema schema = Schema.getSchema(schemaTMP);
                    schema.setBeginLine(comment.getLine());
                    schema.setEndLine(comment.getEndLine());
                    schema.setBeginColumn(comment.getBeginColumn());
                    schema.setEndColumn(comment.getEndColumn());
                    String predicateName = schema.getName();
                    if (!this.schemaDirectives.containsKey(predicateName)) {
                        this.schemaDirectives.put(predicateName, new LinkedList());
                    }
                    this.schemaDirectives.get(predicateName).add(schema);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        } else if (c.substring(1).trim().startsWith(nameDirective)) {
            String nameTmp = c.substring(1).trim();
            nameTmp = nameTmp.trim().substring(5);
            if ((nameTmp = nameTmp.trim()).contains("=")) {
                this.expressionName = nameTmp.substring(nameTmp.indexOf("=") + 1);
            }
        }
        this.productHandler.add(comment);
    }

    @Override
    public void conjunction() {
        if (this.trace) {
            System.out.println("conjunction()");
        }
        this.conj = new Conjunction((List<Literal>)this.literals);
        this.literals.clear();
    }

    @Override
    public void predicateName() {
        if (this.beginLine == -1) {
            this.beginLine = this.director.token.beginLine;
        }
        if (this.beginColumn == -1) {
            this.beginColumn = this.director.token.beginColumn;
        }
        this.variableBeginLine = this.director.token.beginLine;
        this.variableBeginColumn = this.director.token.beginColumn;
        this.variableEndLine = this.director.token.endLine;
        this.variableEndColumn = this.director.token.endColumn;
    }

    @Override
    public void directive(String sx, String dx) {
        if (this.trace) {
            System.out.println("directive()");
        }
        Directive directive = new Directive(sx, dx);
        directive.setBeginLine(this.director.token.beginLine);
        directive.setBeginColumn(this.director.token.beginColumn);
        directive.setEndLine(this.director.token.endLine);
        directive.setEndColumn(this.director.token.endColumn);
        this.productHandler.add(directive);
    }

    @Override
    public void disjunction() {
        if (this.trace) {
            System.out.println("disjunction()");
        }
        if (!this.literals.isEmpty()) {
            this.disj = new Disjunction(this.literals.get(this.literals.size() - 1).getAtom());
            this.disj.addAll(this.atoms);
        } else {
            this.disj = new Disjunction((List<Atom>)this.atoms);
        }
        this.literals.clear();
        this.atoms.clear();
    }

    @Override
    public void literal(boolean positive) {
        if (this.trace) {
            System.out.println("literal()");
        }
        if (this.atoms.size() > 0) {
            Atom a = this.atoms.remove(this.atoms.size() - 1);
            this.literals.add(new Literal(positive, a));
        }
    }

    @Override
    public void query() {
        if (this.trace) {
            System.out.println("query()");
        }
        Query query = new Query(this.conj);
        query.setBeginLine(this.beginLine);
        query.setBeginColumn(this.beginColumn);
        query.setEndLine(this.director.token.endLine);
        query.setEndColumn(this.director.token.endColumn);
        if (this.inSimpleComment) {
            query.setComment(this.simpleComment);
        }
        if (this.expressionName != null) {
            query.setName(this.expressionName);
            this.expressionName = null;
        }
        if (this.isTransformQueryToConstraint()) {
            Rule rule = new Rule(new Disjunction(), query.getBody());
            this.productHandler.add(rule);
        } else {
            this.productHandler.add(query);
        }
        this.disj = null;
        this.conj = null;
        this.beginLine = -1;
        this.beginColumn = -1;
    }

    @Override
    public void reset() {
        if (this.trace) {
            System.out.println("reset()");
        }
        this.productHandler.clear();
        this.atoms.clear();
        this.literals.clear();
        this.stack.clear();
        this.aggrVars.clear();
        this.disj = null;
        this.conj = null;
        this.aggregateSetConj = null;
        this.literalsAggregateSetConj.clear();
        this.beginLine = -1;
        this.endLine = -1;
        this.beginColumn = -1;
        this.endColumn = -1;
    }

    @Override
    public void rule() {
        Rule rule = new Rule(this.disj, this.conj);
        rule.setLine(this.beginLine);
        rule.setBeginColumn(this.beginColumn);
        rule.setEndLine(this.director.token.endLine);
        rule.setEndColumn(this.director.token.endColumn);
        if (this.inSimpleComment) {
            rule.setComment(this.simpleComment);
        }
        if (this.expressionName != null) {
            rule.setName(this.expressionName);
            this.expressionName = null;
        }
        if (this.isShifted()) {
            if (rule.getHead().size() > 1) {
                if (this.productHandler instanceof Program) {
                    ((Program)this.productHandler).addAll(rule.shift());
                }
            } else {
                this.productHandler.add(rule);
            }
        } else {
            this.productHandler.add(rule);
        }
        this.disj = null;
        this.conj = null;
        this.beginLine = -1;
        this.beginColumn = -1;
    }

    @Override
    public void weakConstraint(String level, String cost) {
        if (this.trace) {
            System.out.println("weak()");
        }
        WeakConstraint weakConstraint = null;
        weakConstraint = level != null ? (cost != null ? new WeakConstraint(this.conj, new SimpleTerm(level), new SimpleTerm(cost)) : new WeakConstraint(this.conj, new SimpleTerm(level))) : new WeakConstraint(this.conj);
        weakConstraint.setLine(this.beginLine);
        weakConstraint.setBeginColumn(this.beginColumn);
        weakConstraint.setEndLine(this.director.token.endLine);
        weakConstraint.setEndColumn(this.director.token.endColumn);
        weakConstraint.setComment(this.simpleComment);
        if (this.expressionName != null) {
            weakConstraint.setName(this.expressionName);
            this.expressionName = null;
        }
        this.productHandler.add(weakConstraint);
        this.conj = null;
        this.beginLine = -1;
        this.beginColumn = -1;
    }

    @Override
    public void startAggregateSet() {
        this.inAggregate = true;
        this.aggrVars = new ArrayList();
        this.aggregateSetConj = this.conj;
        this.conj = null;
        this.literalsAggregateSetConj = this.literals;
        this.literals = new ArrayList();
    }

    @Override
    public void aggregateVar(String v) {
        SimpleTerm term = new SimpleTerm(v);
        term.setBeginColumn(this.director.token.beginColumn);
        term.setBeginLine(this.director.token.beginLine);
        term.setEndColumn(this.director.token.endColumn);
        term.setEndLine(this.director.token.endLine);
        this.aggrVars.add(term);
    }

    public boolean tracingEnabled() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void endAttributes() {
        throw new UnsupportedOperationException("end attributes");
    }

    @Override
    public ProductHandler getProductHandler() {
        return this.productHandler;
    }

    @Override
    public void builtin(String op, String first, String second, String third) {
        if (this.trace) {
            System.out.println("builtin()");
        }
        this.atoms.add(new NormalAtom(op, this.builtinTerm.get(first), this.builtinTerm.get(second), this.builtinTerm.get(third)));
        this.stack.remove(this.stack.size() - 1);
        this.builtinTerm.clear();
        this.atomBeginColumn = -1;
    }

    public void setShifted(boolean shifted) {
        this.shifted = shifted;
    }

    public void setTransformQueryToConstraint(boolean transformQueryToConstraint) {
        this.transformQueryToConstraint = transformQueryToConstraint;
    }

    public void appendTerm(String s) {
    }

    public void endEnum(int type) {
    }

    public void startEnum() {
    }

    @Override
    public void endHeadTail() {
    }

    public void startHeadTail() {
    }

    @Override
    public void endList() {
    }

    @Override
    public void endMultiSet() {
    }

    @Override
    public void endSet() {
    }

    @Override
    public void startCollection() {
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public boolean isTransformQueryToConstraint() {
        return this.transformQueryToConstraint;
    }

    @Override
    public void maxIntDirective(int maxIntValue) {
    }

    @Override
    public void constDirective(String namedConstant, String constant) {
    }

    @Override
    public void includeDirective(String includeValue) {
    }

    @Override
    public void importDirective(String databaseName, String username, String password, String query, String tableName, List<ImportDirective.ImportDirectiveTypes> types) {
    }

    @Override
    public void exportDirective(String databaseName, String username, String password, String predicateName, String tableName, String query) {
    }

    @Override
    public void schemaAnnotation(String predicateName, List<String> attrsNames, List<String> attrsInternalTypes, List<String> attrsExternalTypes, List<Integer> precisions, List<Integer> scales) {
    }

    @Override
    public void atomValue(String value) {
    }
}

