/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.testing;

import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.testing.ParameterContent;

public class Assert {
    public static final String ASSERT_TRUE = "assertTrue";
    public static final String ASSERT_CAUTIOUSLY_TRUE = "assertCautiouslyTrue";
    public static final String ASSERT_BRAVELY_TRUE = "assertBravelyTrue";
    public static final String ASSERT_TRUE_IN = "assertTrueIn";
    public static final String ASSERT_TRUE_IN_AT_LEAST = "assertTrueInAtLeast";
    public static final String ASSERT_TRUE_IN_AT_MOST = "assertTrueInAtMost";
    public static final String ASSERT_FALSE = "assertFalse";
    public static final String ASSERT_CAUTIOUSLY_FALSE = "assertCautiouslyFalse";
    public static final String ASSERT_BRAVELY_FALSE = "assertBravelyFalse";
    public static final String ASSERT_FALSE_IN = "assertFalseIn";
    public static final String ASSERT_FALSE_IN_AT_LEAST = "assertFalseInAtLeast";
    public static final String ASSERT_FALSE_IN_AT_MOST = "assertFalseInAtMost";
    public static final String ASSERT_CONSTRAINT = "assertConstraint";
    public static final String ASSERT_CONSTRAINT_IN = "assertConstraintIn";
    public static final String ASSERT_CONSTRAINT_IN_AT_LEAST = "assertConstraintInAtLeast";
    public static final String ASSERT_CONSTRAINT_IN_AT_MOST = "assertConstraintInAtMost";
    public static final String ASSERT_BEST_MODEL_COST = "assertBestModelCost";
    public static final String ASSERT_NUMBER_MODELS = "assertNumberModels";
    public static final String ASSERT_NO_MODELS = "assertNoModels";
    public static final String CONSTRAINT_PRED_NAME_SOURCE = "System_Constraint_";
    public static final String CONSTRAINT_NOT_SUFFIX = "Not_";
    String name;
    int numberModels = -1;
    int bestModelCost = -1;
    int bestModelLevel = -1;
    ParameterContent<Program> expectedOutput = new ParameterContent();
    public int assertConstraintNumber = 0;

    public static int getConstraintNumberInName(String name) {
        int beginIndex = CONSTRAINT_PRED_NAME_SOURCE.length();
        int endIndex = name.indexOf("_", beginIndex);
        return Integer.parseInt(name.substring(beginIndex, endIndex));
    }

    public Assert(String name, int numberModels) {
        this(name);
        this.numberModels = numberModels;
    }

    public Assert() {
    }

    public Assert(String name) {
        this.name = name;
    }

    public Assert(int bestModelCost) {
        this(ASSERT_BEST_MODEL_COST);
        this.bestModelCost = bestModelCost;
    }

    public Assert(int bestModelCost, int bestModelLevel) {
        this(ASSERT_BEST_MODEL_COST);
        this.bestModelCost = bestModelCost;
        this.bestModelLevel = bestModelLevel;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberModels() {
        return this.numberModels;
    }

    public void setNumberModels(int numberModels) {
        this.numberModels = numberModels;
    }

    public int getBestModelCost() {
        return this.bestModelCost;
    }

    public void setBestModelCost(int bestModelCost) {
        this.bestModelCost = bestModelCost;
    }

    public int getBestModelLevel() {
        return this.bestModelLevel;
    }

    public void setBestModelLevel(int bestModelLevel) {
        this.bestModelLevel = bestModelLevel;
    }

    public ParameterContent<Program> getExpectedOutput() {
        return this.expectedOutput;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isConstraintType() {
        return this.name.equals(ASSERT_CONSTRAINT) || this.name.equals(ASSERT_CONSTRAINT_IN) || this.name.equals(ASSERT_CONSTRAINT_IN_AT_LEAST) || this.name.equals(ASSERT_CONSTRAINT_IN_AT_MOST);
    }

    public boolean isWeakConstraintType() {
        return this.name.equals(ASSERT_BEST_MODEL_COST);
    }

    public boolean isNumberModelsType() {
        return this.name.equals(ASSERT_NUMBER_MODELS) || this.name.equals(ASSERT_NO_MODELS);
    }

    public void setExpectedOutput(ParameterContent<Program> expectedOutput) {
        this.expectedOutput = expectedOutput;
    }

    public String getConstraintPredName() {
        return CONSTRAINT_PRED_NAME_SOURCE + this.assertConstraintNumber + "_";
    }

    public void clearBestModelCost() {
        this.bestModelCost = -1;
    }

    public void clearBestModelLevel() {
        this.bestModelLevel = -1;
    }

    public void clearNumberModels() {
        this.numberModels = -1;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.name);
        if (this.numberModels >= 0 || this.expectedOutput.getContent() != null || this.isWeakConstraintType()) {
            text.append("(");
            if (this.isWeakConstraintType()) {
                if (this.bestModelCost >= 0) {
                    text.append(this.bestModelCost);
                    if (this.bestModelLevel >= 0) {
                        text.append(", ");
                        text.append(this.bestModelLevel);
                    }
                }
            } else {
                if (this.numberModels >= 0) {
                    text.append(this.numberModels);
                    if (this.expectedOutput.getContent() != null) {
                        text.append(", ");
                    }
                }
                if (this.expectedOutput.getContent() != null) {
                    text.append(this.expectedOutput.toString());
                }
            }
            text.append(")");
        }
        text.append(";");
        return text.toString();
    }
}

