/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.testing;

import it.unical.mat.dlv.testing.Assert;
import it.unical.mat.dlv.testing.InputTest;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.TestInvocation;
import java.util.ArrayList;
import java.util.List;

public class TestSuite {
    protected TestInvocation invocation = null;
    protected List<InputTest> inputList = new ArrayList<InputTest>();
    protected List<TestCase> testCases = new ArrayList<TestCase>();
    protected List<Assert> globalAssertList = new ArrayList<Assert>();

    public void addInputTest(InputTest inputTest) {
        this.inputList.add(inputTest);
    }

    public void addGlobalAssert(Assert assertion) {
        if (assertion.isConstraintType()) {
            List<Assert> constrAsserts = this.getConstraintGlobalAsserts();
            assertion.assertConstraintNumber = constrAsserts.size() > 0 ? constrAsserts.get((int)(constrAsserts.size() - 1)).assertConstraintNumber + 1 : 1;
        }
        this.globalAssertList.add(assertion);
    }

    public List<Assert> getConstraintGlobalAsserts() {
        ArrayList<Assert> constrAsserts = new ArrayList<Assert>();
        for (Assert asser : this.globalAssertList) {
            if (!asser.isConstraintType()) continue;
            constrAsserts.add(asser);
        }
        return constrAsserts;
    }

    public TestSuite() {
    }

    public TestSuite(TestInvocation invocation) {
        this.invocation = invocation;
    }

    public void addTestCase(TestCase testCase) {
        this.testCases.add(testCase);
    }

    public List<InputTest> getInputList() {
        return this.inputList;
    }

    public void removeInputTest(InputTest inputTest) {
        this.inputList.remove(inputTest);
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public void clearTestCases() {
        this.testCases.clear();
    }

    public TestInvocation getInvocation() {
        return this.invocation;
    }

    public void setInvocation(TestInvocation invocation) {
        this.invocation = invocation;
    }

    public List<Assert> getGlobalAssertList() {
        return this.globalAssertList;
    }

    public void setGlobalAssertList(List<Assert> globalAssertList) {
        this.globalAssertList = globalAssertList;
        int counter = 1;
        for (Assert assert1 : globalAssertList) {
            if (!assert1.isConstraintType()) continue;
            assert1.assertConstraintNumber = counter++;
        }
    }

    public void removeGlobalAssert(Assert assert1) {
        this.globalAssertList.remove(assert1);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.invocation != null) {
            text.append(this.invocation.toString());
            text.append("\n");
        }
        for (InputTest input : this.inputList) {
            text.append(input.toString());
            text.append("\n");
        }
        text.append("\n");
        for (TestCase testCase : this.testCases) {
            text.append(testCase.toString());
            text.append("\n");
        }
        text.append("\n");
        for (Assert globalAssert : this.globalAssertList) {
            text.append(globalAssert.toString());
            text.append("\n");
        }
        text.append("\n");
        return text.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.globalAssertList == null ? 0 : this.globalAssertList.hashCode());
        result = 31 * result + (this.inputList == null ? 0 : this.inputList.hashCode());
        result = 31 * result + (this.invocation == null ? 0 : this.invocation.hashCode());
        result = 31 * result + (this.testCases == null ? 0 : this.testCases.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSuite other = (TestSuite)obj;
        if (this.globalAssertList == null ? other.globalAssertList != null : !this.globalAssertList.equals(other.globalAssertList)) {
            return false;
        }
        if (this.inputList == null ? other.inputList != null : !this.inputList.equals(other.inputList)) {
            return false;
        }
        if (this.invocation == null ? other.invocation != null : !this.invocation.equals(other.invocation)) {
            return false;
        }
        return !(this.testCases == null ? other.testCases != null : !this.testCases.equals(other.testCases));
    }
}

