/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.testing.execution;

import it.unical.mat.dlv.testing.Assert;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.execution.TestSuiteExecutor;
import it.unical.mat.wrapper.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TestCaseExecutor {
    TestSuiteExecutor testSuiteExecutor;
    TestCase testCase;
    TestSuiteExecutor.TestState state = TestSuiteExecutor.TestState.READY;
    String failureMotivation = "";
    HashMap<Assert, String> failedAsserts = new HashMap();
    private List<TestSuiteExecutor.AssertState> assertsChecking = new ArrayList<TestSuiteExecutor.AssertState>();
    private List<Assert> pendingAsserts = new ArrayList<Assert>();
    private int numberModelsFound = 0;

    public TestCaseExecutor(TestSuiteExecutor testSuiteExecutor, TestCase testCase) {
        this.testSuiteExecutor = testSuiteExecutor;
        this.testCase = testCase;
    }

    public TestSuiteExecutor getTestSuiteExecutor() {
        return this.testSuiteExecutor;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public TestSuiteExecutor.AssertState getAssertState(Assert assert1) {
        TestSuiteExecutor.AssertState assertState2;
        for (TestSuiteExecutor.AssertState assertState2 : this.assertsChecking) {
            if (assertState2.getAssert() != assert1) continue;
            return assertState2;
        }
        assertState2 = new TestSuiteExecutor.AssertState(assert1);
        this.assertsChecking.add(assertState2);
        return assertState2;
    }

    public void processModelInAssert(Model model, Assert asser) {
        TestSuiteExecutor.AssertState assertState = this.getAssertState(asser);
        TestSuiteExecutor.assertion(assertState, this.failedAsserts, model, this.numberModelsFound, this.testCase.getFilter());
        if (assertState.state == TestSuiteExecutor.TestState.FAILED) {
            this.state = TestSuiteExecutor.TestState.FAILED;
        }
        if (assertState.state == TestSuiteExecutor.TestState.PASSED) {
            this.pendingAsserts.remove(asser);
        } else if (assertState.state == TestSuiteExecutor.TestState.FAILED) {
            this.state = TestSuiteExecutor.TestState.FAILED;
            this.pendingAsserts.remove(asser);
        } else if ((asser.getName().equals("assertTrueInAtLeast") || asser.getName().equals("assertBravelyTrue") || asser.getName().equals("assertTrueIn") || asser.getName().equals("assertFalseInAtLeast") || asser.getName().equals("assertFalseIn") || asser.getName().equals("assertBravelyFalse") || asser.getName().equals("assertConstraintIn") || asser.getName().equals("assertConstraintInAtLeast") || asser.getName().equals("assertNumberModels") || asser.getName().equals("assertNoModels")) && !this.pendingAsserts.contains(asser)) {
            this.pendingAsserts.add(asser);
        }
    }

    public void processModel(Model model) {
        if (this.state == TestSuiteExecutor.TestState.READY) {
            this.state = TestSuiteExecutor.TestState.RUNNING;
        }
        ++this.numberModelsFound;
        for (Assert asser : this.testCase.getAssertList()) {
            this.processModelInAssert(model, asser);
        }
    }

    public TestSuiteExecutor.TestState getTestCaseState() {
        return this.state;
    }

    public void setTestCaseState(TestSuiteExecutor.TestState state) {
        this.state = state;
    }

    public void executionFinished() {
        this.assertsChecking.clear();
        if (this.numberModelsFound == 0) {
            if (this.state == TestSuiteExecutor.TestState.READY) {
                this.state = TestSuiteExecutor.TestState.RUNNING;
            }
            for (Assert asser : this.testCase.getAssertList()) {
                this.processModelInAssert(null, asser);
            }
        }
        this.numberModelsFound = 0;
        if (this.state == TestSuiteExecutor.TestState.RUNNING) {
            this.state = TestSuiteExecutor.TestState.PASSED;
        }
        TestSuiteExecutor.managePendingAsserts(this.pendingAsserts, this.failedAsserts);
        if (this.pendingAsserts.size() > 0) {
            this.state = TestSuiteExecutor.TestState.FAILED;
            this.pendingAsserts.clear();
        }
        if (this.failedAsserts.size() > 0) {
            this.state = TestSuiteExecutor.TestState.FAILED;
        }
    }

    public String getFailedMotivation() {
        StringBuffer reasons = new StringBuffer();
        if (this.testSuiteExecutor.getTestCasesExceptions().containsKey(this)) {
            reasons.append("The test case could not be executed because of the following errors :\n");
            for (Exception exc : this.testSuiteExecutor.getTestCasesExceptions().get(this)) {
                reasons.append(exc.getMessage());
            }
        } else {
            reasons.append(this.failureMotivation);
            boolean writtenFilter = false;
            for (Assert failedAssert : this.failedAsserts.keySet()) {
                if (this.testCase.getFilter() != null && !writtenFilter) {
                    reasons.append("Applied filters : ");
                    reasons.append(this.testCase.getFilter().toString());
                    reasons.append("\n");
                    writtenFilter = true;
                }
                reasons.append("Failed Assert '" + failedAssert.toString() + "'");
                reasons.append(" on test case '" + this.testCase.getName() + "'");
                reasons.append(" : ");
                reasons.append(this.failedAsserts.get(failedAssert));
                reasons.append("\n");
            }
        }
        return reasons.toString();
    }

    public void resetTest() {
        this.state = TestSuiteExecutor.TestState.READY;
        this.failedAsserts.clear();
        this.failureMotivation = "";
        this.pendingAsserts.clear();
        this.assertsChecking.clear();
        this.numberModelsFound = 0;
    }

    public String toString() {
        if (this.getTestCaseState() == TestSuiteExecutor.TestState.FAILED) {
            return this.getFailedMotivation();
        }
        return this.getTestCase().toString();
    }

    public HashMap<Assert, String> getFailedAsserts() {
        return this.failedAsserts;
    }
}

