/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.typ;

import it.unical.mat.dlv.program.Comment;
import it.unical.mat.dlv.typ.TypDefinitionInterface;
import it.unical.mat.dlv.typ.parser.TypParser;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class UseDefinition
implements TypDefinitionInterface {
    String tableName;
    List<String> tableNameAttributes = new ArrayList<String>();
    String SQLStatement;
    String databaseName;
    String username;
    String password;
    String predicateName;
    List<String[]> predicateTypes = new ArrayList<String[]>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getTableNameAttributes() {
        return this.tableNameAttributes;
    }

    public void addTableNameAttribute(String attributeName) {
        this.tableNameAttributes.add(attributeName);
    }

    public void setTableNameAttributes(List<String> tableNameAttributes) {
        this.tableNameAttributes = tableNameAttributes;
    }

    public void clearTableNameAttributes() {
        this.tableNameAttributes.clear();
    }

    public void clearPredicateTypes() {
        this.predicateTypes.clear();
    }

    public String getSQLStatement() {
        return this.SQLStatement;
    }

    public void setSQLStatement(String statement) {
        this.SQLStatement = statement;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public void setPredicateName(String predicateName) {
        this.predicateName = predicateName;
    }

    public List<String[]> getPredicateTypes() {
        return this.predicateTypes;
    }

    public void addPredicateType(String[] predicateType) {
        this.predicateTypes.add(predicateType);
    }

    public void setPredicateTypes(List<String[]> predicateTypes) {
        this.predicateTypes = predicateTypes;
    }

    public String getPredicateType(int index) {
        String[] type = this.predicateTypes.get(index);
        StringBuffer buffer = new StringBuffer();
        buffer.append(type[0]);
        if (type.length > 1) {
            buffer.append("(");
            int j = 1;
            while (j < type.length) {
                if (j > 1) {
                    buffer.append(",");
                }
                buffer.append(type[j]);
                ++j;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public Comment getUseDefinitionAsAnnotation() {
        StringBuffer annotContent = new StringBuffer();
        annotContent.append(TypParser.USE_TABLE_ANNOT);
        annotContent.append(" ");
        annotContent.append(this.getTableName());
        annotContent.append(" MAPTO ");
        annotContent.append(this.getPredicateName());
        if (!this.getTableNameAttributes().isEmpty()) {
            annotContent.append("(");
            ListIterator<String[]> itTypes = this.getPredicateTypes().listIterator();
            boolean first = true;
            for (String attrName : this.getTableNameAttributes()) {
                if (first) {
                    first = false;
                } else {
                    annotContent.append(",");
                }
                String[] type = itTypes.next();
                annotContent.append(attrName);
                annotContent.append(":");
                annotContent.append(type[0]);
                if (type.length <= 1) continue;
                annotContent.append("(");
                annotContent.append(type[1]);
                if (type.length > 2) {
                    annotContent.append(",");
                    annotContent.append(type[2]);
                }
                annotContent.append(")");
            }
            annotContent.append(")");
        }
        if (this.getDatabaseName() != null) {
            annotContent.append(" FROM ");
            annotContent.append(this.getDatabaseName());
            annotContent.append(":");
            annotContent.append(this.getUsername());
            annotContent.append(":");
            annotContent.append(this.getPassword());
        }
        return new Comment("%" + annotContent.toString());
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("USE " + this.tableName);
        if (this.tableNameAttributes.size() > 0) {
            buffer.append("(" + this.tableNameAttributes.get(0));
            i = 1;
            while (i < this.tableNameAttributes.size()) {
                buffer.append("," + this.tableNameAttributes.get(i));
                ++i;
            }
            buffer.append(")");
        }
        if (this.SQLStatement != null) {
            buffer.append("\nAS " + this.SQLStatement);
        }
        if (this.databaseName != null) {
            buffer.append("\nFROM " + this.databaseName + ":" + this.username + ":" + this.password);
        }
        buffer.append("\nMAPTO " + this.predicateName);
        if (this.predicateTypes.size() > 0) {
            buffer.append("(");
            i = 0;
            while (i < this.predicateTypes.size()) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.getPredicateType(i));
                ++i;
            }
            buffer.append(")");
        }
        buffer.append(".");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        UseDefinition u = (UseDefinition)other;
        return this.toString().equals(other.toString());
    }
}

