/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.wrapper.exception.MalformedTermException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;

public final class ConversionType {
    public static final DBNull DBNULL_CLASS = new DBNull();
    public static final String DBNULL = "null";
    public static final byte UNIMPLEMENTED = 0;
    public static final byte STRING = 2;
    public static final byte BOOLEAN = 3;
    public static final byte BIGDECIMAL = 4;
    public static final byte DATE = 5;
    public static final byte TIME = 6;
    public static final byte QUOTED_DOUBLE = 7;
    public static final byte TRUNC_DOUBLE = 8;
    public static final byte ROUND_DOUBLE = 9;
    public static final byte QUOTED_FLOAT = 10;
    public static final byte TRUNC_FLOAT = 11;
    public static final byte ROUND_FLOAT = 12;
    public static final byte QUOTED_INT = 13;
    public static final byte CONST_INT = 14;
    public static final byte QUOTED_LONG = 15;
    public static final byte CONST_LONG = 16;
    public static final byte QUOTED_SHORT = 17;
    public static final byte CONST_SHORT = 18;
    public static final byte QUOTED_BYTE = 19;
    public static final byte CONST_BYTE = 20;
    public static final byte OBJECT = 21;
    public static final byte NULL = 22;

    public static byte sqlToDlvTypes(int sqlType) {
        switch (sqlType) {
            case -7: 
            case -2: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 91: {
                return 5;
            }
            case 6: {
                return 12;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return 9;
            }
            case -5: 
            case -4: 
            case -3: {
                return 16;
            }
            case -6: 
            case 4: 
            case 5: {
                return 14;
            }
            case 2000: {
                return 21;
            }
            case 0: {
                return 22;
            }
            case 93: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return 0;
            }
            case 92: {
                return 6;
            }
            case -1: 
            case 12: {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isValid(String s) {
        if (ConversionType.isQuoted(s)) {
            return true;
        }
        if (ConversionType.isConst(s)) {
            return true;
        }
        if (ConversionType.isFunction(s)) {
            return true;
        }
        return ConversionType.isList(s);
    }

    public static boolean isList(String s) {
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        try {
            Rule rule;
            String code = "pred_name(" + s + ").";
            Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
            director.configureBuilder(builder);
            director.parse();
            Program program = (Program)builder.getProductHandler();
            if (program != null && program.get(0) instanceof Rule && (rule = (Rule)program.get(0)).getHead().size() == 1) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFunction(String s) {
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        try {
            Rule rule;
            String code = String.valueOf(s) + ".";
            Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
            director.configureBuilder(builder);
            director.parse();
            Program program = (Program)builder.getProductHandler();
            if (program != null && program.get(0) instanceof Rule && (rule = (Rule)program.get(0)).getHead().size() == 1) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConst(String s) {
        try {
            int pos = 0;
            char c = s.charAt(pos);
            if (Character.isUpperCase(c) || c == '_') {
                return false;
            }
            while (true) {
                if (pos >= s.length()) {
                    return true;
                }
                c = s.charAt(pos);
                if (c == ' ' || c == '\n' || c == '\r' || c == '#' || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '\"' || c == '.') {
                    return false;
                }
                ++pos;
            }
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isQuoted(String s) {
        if (s.length() < 2) {
            return false;
        }
        return s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"';
    }

    public static String cutQuotes(String s) {
        if (ConversionType.isQuoted(s)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    static String addQuotes(String s) {
        StringBuffer sb = new StringBuffer("\"");
        sb.append(s);
        sb.append('\"');
        return sb.toString();
    }

    static String ckeckStringAndCutQuotes(String s, boolean quoted, String errorMessage) {
        if (quoted) {
            if (ConversionType.isQuoted(s)) {
                return s.substring(1, s.length() - 1);
            }
            throw new MalformedTermException(errorMessage);
        }
        if (ConversionType.isConst(s)) {
            return s;
        }
        throw new MalformedTermException(errorMessage);
    }

    static Object stringToObject(String s, byte type) {
        switch (type) {
            case 2: {
                if (ConversionType.isValid(s)) {
                    return s;
                }
                throw new MalformedTermException("the object is not a valid string");
            }
            case 4: {
                try {
                    return new BigDecimal(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a big decimal"));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a big decimal");
                }
            }
            case 3: {
                if (s.equalsIgnoreCase("true")) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            case 19: {
                s = ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a quoted byte");
            }
            case 20: {
                try {
                    return new Byte(s);
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a (quoted) byte");
                }
            }
            case 13: {
                s = ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) integer");
            }
            case 14: {
                try {
                    return new Integer(s);
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not an integer");
                }
            }
            case 15: {
                s = ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) long");
            }
            case 16: {
                try {
                    return new Long(s);
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a long");
                }
            }
            case 17: {
                s = ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) short");
            }
            case 18: {
                try {
                    return new Short(s);
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not an short");
                }
            }
            case 5: {
                try {
                    return Date.valueOf(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a date"));
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedTermException("the object is not a date");
                }
            }
            case 6: {
                try {
                    return Time.valueOf(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not an time"));
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedTermException("the object is not an time");
                }
            }
            case 10: {
                try {
                    return new Float(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) float"));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a float");
                }
            }
            case 12: {
                try {
                    return new Float(Math.round(Math.abs(Float.parseFloat(s))));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a float");
                }
            }
            case 11: {
                try {
                    return new Float(Math.floor(Math.abs(Float.parseFloat(s))));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a float");
                }
            }
            case 7: {
                try {
                    return new Double(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) double"));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a double");
                }
            }
            case 9: {
                try {
                    return new Double(Math.round(Math.abs(Double.parseDouble(s))));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a double");
                }
            }
            case 8: {
                try {
                    return new Double(Math.floor(Math.abs(Double.parseDouble(s))));
                }
                catch (NumberFormatException n) {
                    throw new MalformedTermException("the object is not a double");
                }
            }
            case 22: {
                if (s.equalsIgnoreCase(DBNULL)) {
                    return DBNULL_CLASS;
                }
                throw new MalformedTermException("the object is not a database null");
            }
            case 0: 
            case 21: {
                throw new MalformedTermException("not implemented yet");
            }
        }
        throw new MalformedTermException();
    }

    static String objectToString(Object o, byte type) {
        if (type == 21 || type == 0) {
            throw new MalformedTermException("not implemented yet");
        }
        if (o instanceof String) {
            String s = (String)o;
            switch (type) {
                case 2: {
                    if (ConversionType.isValid(s)) {
                        return s;
                    }
                    throw new MalformedTermException("the string is not valid");
                }
                case 4: {
                    try {
                        new BigDecimal(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a big decimal"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a big decimal");
                    }
                }
                case 3: {
                    if (s.equalsIgnoreCase("true")) {
                        return s;
                    }
                    return "false";
                }
                case 20: {
                    try {
                        new Byte(s);
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a byte");
                    }
                }
                case 19: {
                    try {
                        new Byte(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) byte"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a byte");
                    }
                }
                case 14: {
                    try {
                        new Integer(s);
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not an integer");
                    }
                }
                case 13: {
                    try {
                        new Integer(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) integer"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not an integer");
                    }
                }
                case 16: {
                    try {
                        new Long(s);
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a long");
                    }
                }
                case 15: {
                    try {
                        new Long(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) long"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a long");
                    }
                }
                case 18: {
                    try {
                        new Short(s);
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a short");
                    }
                }
                case 17: {
                    try {
                        new Short(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) short"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a short");
                    }
                }
                case 5: {
                    try {
                        Date.valueOf(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not an date"));
                        return s;
                    }
                    catch (IllegalArgumentException e) {
                        throw new MalformedTermException("the object is not a date");
                    }
                }
                case 6: {
                    try {
                        Time.valueOf(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a time"));
                        return s;
                    }
                    catch (IllegalArgumentException e) {
                        throw new MalformedTermException("the object is not a time");
                    }
                }
                case 10: {
                    try {
                        new Float(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) float"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a float");
                    }
                }
                case 12: {
                    try {
                        return "" + (int)new Float(Math.round(Math.abs(Float.parseFloat(s)))).floatValue();
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a float");
                    }
                }
                case 11: {
                    try {
                        return "" + (int)new Float(Math.floor(Math.abs(Float.parseFloat(s)))).floatValue();
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a float");
                    }
                }
                case 7: {
                    try {
                        new Double(ConversionType.ckeckStringAndCutQuotes(s, true, "the object is not a (quoted) double"));
                        return s;
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a double");
                    }
                }
                case 9: {
                    try {
                        return "" + (int)new Double(Math.round(Math.abs(Double.parseDouble(s)))).doubleValue();
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a double");
                    }
                }
                case 8: {
                    try {
                        return "" + (int)new Double(Math.floor(Math.abs(Double.parseDouble(s)))).doubleValue();
                    }
                    catch (NumberFormatException n) {
                        throw new MalformedTermException("the object is not a double");
                    }
                }
                case 22: {
                    if (s.equalsIgnoreCase(DBNULL)) {
                        return DBNULL;
                    }
                    throw new MalformedTermException("the object is not a database null");
                }
                case 0: 
                case 21: {
                    throw new MalformedTermException("not implemented yet");
                }
            }
        }
        if (o instanceof BigDecimal) {
            if (type == 4 || type == 2) {
                return ConversionType.addQuotes(((BigDecimal)o).toString());
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Boolean) {
            if (type == 3 || type == 2) {
                return "" + (Boolean)o;
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Byte) {
            if (type == 20 || type == 2) {
                return "" + (Byte)o;
            }
            if (type == 19) {
                return ConversionType.addQuotes("" + (Byte)o);
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Integer) {
            if (type == 14 || type == 2) {
                return "" + (Integer)o;
            }
            if (type == 13) {
                return ConversionType.addQuotes("" + (Integer)o);
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Long) {
            if (type == 16 || type == 2) {
                return "" + (Long)o;
            }
            if (type == 15) {
                return ConversionType.addQuotes("" + (Long)o);
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Short) {
            if (type == 18 || type == 2) {
                return "" + (Short)o;
            }
            if (type == 17) {
                return ConversionType.addQuotes("" + (Short)o);
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Date) {
            if (type == 5 || type == 2) {
                return ConversionType.addQuotes(((Date)o).toString());
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Time) {
            if (type == 6 || type == 2) {
                return ConversionType.addQuotes(((Time)o).toString());
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Float) {
            switch (type) {
                case 10: {
                    return ConversionType.addQuotes("" + ((Float)o).floatValue());
                }
                case 11: {
                    return "" + (int)Math.floor(Math.abs(((Float)o).floatValue()));
                }
                case 2: 
                case 12: {
                    return "" + Math.round(Math.abs(((Float)o).floatValue()));
                }
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof Double) {
            switch (type) {
                case 7: {
                    return ConversionType.addQuotes("" + (Double)o);
                }
                case 8: {
                    return "" + (int)Math.floor(Math.abs((Double)o));
                }
                case 2: 
                case 9: {
                    return "" + (int)Math.round(Math.abs((Double)o));
                }
            }
            throw new MalformedTermException("Required type: " + type + " Found: " + o.getClass());
        }
        if (o instanceof DBNull) {
            return DBNULL;
        }
        throw new MalformedTermException();
    }

    public static final class DBNull {
        private DBNull() {
        }

        public String toString() {
            return ConversionType.DBNULL;
        }
    }
}

