/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.typ.TypDirectives;
import it.unical.mat.wrapper.DLVInputProgram;
import java.util.ArrayList;
import java.util.List;

public class DLVInputProgramImpl
implements DLVInputProgram {
    private List<String> filesPath = new ArrayList<String>();
    private StringBuffer text = new StringBuffer();
    private Program program = new Program();

    @Override
    public void addFile(String path) {
        if (!this.filesPath.contains(path)) {
            this.filesPath.add(path);
        }
    }

    @Override
    public void addText(String p) {
        if (p != null) {
            this.text.append(p);
        }
    }

    @Override
    public void clean() {
        this.filesPath.clear();
        this.text = new StringBuffer();
        this.program = new Program();
    }

    @Override
    public void cleanText() {
        this.text = new StringBuffer();
    }

    @Override
    public String getCompleteText() {
        StringBuffer tmpBuffer = new StringBuffer();
        tmpBuffer.append(this.text);
        tmpBuffer.append(this.program.toString());
        return tmpBuffer.toString();
    }

    public List<String> getFiles() {
        return this.filesPath;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public String getText() {
        return this.text.toString();
    }

    @Override
    public void removeFile(String path) {
        this.filesPath.remove(path);
    }

    @Override
    public void removeFiles(List<String> paths) {
        this.filesPath.removeAll(paths);
    }

    @Override
    public void removeProgram(Program p) {
        for (Expression exp : p) {
            while (this.program.contains(exp)) {
                this.program.remove(exp);
            }
        }
    }

    @Override
    public void includeProgram(Program p) {
        this.program.addAll(p);
        if (p.getTypDirectives() != null && !p.getTypDirectives().isEmpty()) {
            if (this.program.getTypDirectives() == null) {
                this.program.setTypDirectives(new TypDirectives());
            }
            this.program.getTypDirectives().addAll(p.getTypDirectives());
        }
    }

    @Override
    public void addExpression(Expression exp) {
        this.program.add(exp);
    }

    @Override
    public void removeExpression(Expression exp) {
        this.program.remove(exp);
    }

    @Override
    public void cleanProgram() {
        this.program = new Program();
    }
}

