/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.wrapper.ModelResult;
import it.unical.mat.wrapper.Predicate;
import it.unical.mat.wrapper.exception.IsNoModelException;
import it.unical.mat.wrapper.exception.NoSuchPredicateException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Model
implements ModelResult {
    public static final Model NO_MODEL = new Model();
    private ArrayList<Predicate> predicates = new ArrayList();
    private HashMap<String, Predicate> modelTable = new HashMap();
    private boolean isBest = false;
    public HashMap<Integer, Integer> costAndPriority = new HashMap();
    private int cursor = -1;

    public Model() {
    }

    public Model(boolean best) {
        this.isBest = best;
    }

    public boolean isEmpty() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return this.predicates.size() == 0;
    }

    public boolean isBest() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return this.isBest;
    }

    public boolean isNoModel() {
        return this == NO_MODEL;
    }

    public int getCost(int level) {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.costAndPriority != null && this.costAndPriority.containsKey(level)) {
            return this.costAndPriority.get(level);
        }
        return 0;
    }

    public List<Integer> getLevels() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.costAndPriority != null) {
            ArrayList<Integer> cAndP = new ArrayList<Integer>();
            cAndP.addAll(this.costAndPriority.keySet());
            return cAndP;
        }
        return null;
    }

    public void setCost(int level, int cost) {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.costAndPriority != null) {
            this.costAndPriority.put(level, cost);
        }
    }

    public Enumeration<Predicate> getPredicates() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return new Enumeration<Predicate>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < Model.this.predicates.size();
            }

            @Override
            public Predicate nextElement() {
                if (this.count < Model.this.predicates.size()) {
                    ++this.count;
                    return (Predicate)Model.this.predicates.get(this.count - 1);
                }
                throw new NoSuchElementException("ArrayList Enumeration");
            }
        };
    }

    public String[] getPredicateNames() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        Iterator<Predicate> it = this.predicates.iterator();
        String[] ris = new String[this.predicates.size()];
        int i = 0;
        while (it.hasNext()) {
            Predicate tmp = it.next();
            ris[i] = tmp.name();
            ++i;
        }
        return ris;
    }

    public Predicate getPredicate(String name) {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return this.modelTable.get(name);
    }

    public int size() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return this.predicates.size();
    }

    public Predicate getPredicate() {
        if (this.isNoModel()) {
            throw new IsNoModelException();
        }
        return this.getPredicate(this.cursor);
    }

    public Predicate getPredicate(int i) {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (i >= this.predicates.size() || i < 0) {
            throw new NoSuchPredicateException();
        }
        return this.predicates.get(i);
    }

    public boolean hasMorePredicates() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.predicates.size() != 0) {
            return this.cursor < this.predicates.size() - 1;
        }
        return false;
    }

    public Predicate nextPredicate() {
        if (this.next()) {
            return this.getPredicate();
        }
        throw new NoSuchPredicateException();
    }

    public Predicate previousPredicate() {
        if (this.previous()) {
            return this.getPredicate();
        }
        throw new NoSuchPredicateException();
    }

    public Predicate firstPredicate() {
        this.first();
        return this.getPredicate();
    }

    public Predicate lastPredicate() {
        this.last();
        return this.getPredicate();
    }

    public int getCursor() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return this.cursor;
    }

    public boolean first() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.predicates.size() > 0) {
            this.cursor = 0;
            return true;
        }
        return false;
    }

    public boolean last() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.predicates.size() > 0) {
            this.cursor = this.predicates.size() - 1;
            return true;
        }
        return false;
    }

    public void beforeFirst() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        this.cursor = -1;
    }

    public void afterLast() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        if (this.predicates.size() > 0) {
            this.cursor = this.predicates.size();
        }
    }

    public boolean isFirst() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        return this.cursor == 0 && this.predicates.size() > 0;
    }

    public boolean isLast() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        int size = this.predicates.size();
        return this.cursor == size - 1 && size > 0;
    }

    public boolean relative(int i) {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        int size = this.predicates.size();
        if (size <= 0) {
            return false;
        }
        this.cursor += i;
        if (this.cursor < -1) {
            this.cursor = -1;
        }
        if (this.cursor > size) {
            this.cursor = size;
        }
        return this.cursor > -1 && this.cursor < size;
    }

    public boolean previous() {
        int size;
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        this.cursor += -1;
        if (this.cursor < -1) {
            this.cursor = -1;
        }
        if (this.cursor > (size = this.predicates.size())) {
            this.cursor = size;
        }
        return this.cursor > -1 && this.cursor < size;
    }

    public boolean next() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        int size = this.predicates.size();
        if (this.cursor < -1) {
            this.cursor = -1;
            return false;
        }
        ++this.cursor;
        if (this.cursor > size) {
            this.cursor = size;
            return false;
        }
        return this.cursor > -1 && this.cursor < size && size != 0;
    }

    public boolean absolute(int position) {
        int intRow;
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        int size = this.predicates.size();
        this.cursor = position < 0 ? ((intRow = size + position) < 0 ? -1 : intRow) : ((intRow = position - 1) > size ? size : intRow);
        return this.cursor > -1 && this.cursor < size;
    }

    public void saveTo(String file) throws IOException {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        PrintWriter out = new PrintWriter(new FileWriter(file));
        if (this.predicates.size() == 0) {
            out.close();
            return;
        }
        this.appendTo(out);
        out.close();
    }

    public void appendTo(PrintWriter out) throws IOException {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        for (Predicate p : this.predicates) {
            out.println("");
            p.appendTo(out);
        }
    }

    public String toString() {
        if (this == NO_MODEL) {
            throw new IsNoModelException();
        }
        Iterator<Predicate> it = this.predicates.iterator();
        StringBuffer ris = new StringBuffer();
        while (it.hasNext()) {
            ris.append(it.next().toString());
        }
        return ris.toString();
    }

    public void addPredicate(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.modelTable.containsKey(predicate.name())) {
            return;
        }
        this.modelTable.put(predicate.name(), predicate);
        this.predicates.add(predicate);
    }

    public void setBest(boolean best) {
        this.isBest = best;
    }

    void addCostInLevel(int level, int cost) {
        this.costAndPriority.put(level, cost);
    }
}

