/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper;

import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.Model;
import it.unical.mat.wrapper.ModelHandler;
import it.unical.mat.wrapper.ModelResult;
import java.util.ArrayList;
import java.util.List;

public class ModelBufferedHandler
implements ModelHandler {
    private DLVInvocation invocation;
    private List<Model> buffer = new ArrayList<Model>();

    public ModelBufferedHandler(DLVInvocation invocation) {
        this.invocation = invocation;
        try {
            invocation.subscribe(this);
        }
        catch (DLVInvocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void handleResult(DLVInvocation observed, ModelResult result) {
        this.buffer.add((Model)result);
        this.notifyAll();
    }

    public synchronized boolean hasMoreModels() {
        while (this.invocation.getState() == DLVInvocation.DLVInvocationState.RUNNING || this.buffer.size() > 0) {
            if (this.buffer.size() > 0) {
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public synchronized Model nextModel() {
        while (this.invocation.getState() == DLVInvocation.DLVInvocationState.RUNNING || this.buffer.size() > 0) {
            if (this.buffer.size() > 0) {
                return this.buffer.remove(0);
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public synchronized void dlvFinished() {
        this.notifyAll();
    }
}

