/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.obfuscator;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Conjunction;
import it.unical.mat.dlv.program.Disjunction;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.ProgramExpression;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.ShifterProgramBuilder;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.wrapper.obfuscator.IdentifierMap;
import it.unical.mat.wrapper.util.dependencygraph.CompleteGraph;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class Obfuscator
implements Serializable {
    IdentifierMap identifierMap = new IdentifierMap();
    boolean obfuscate = false;
    boolean resume = false;
    int obfuscationLevel = 1;
    Program program;
    String mapFilePath = "obfuscator.map";
    String fileInput = "";
    String fileOutput = "";
    boolean trace = false;

    public static void main(String[] args) {
        boolean obfuscate = false;
        boolean resume = false;
        boolean loadMap = false;
        int obfuscationLevel = 1;
        String mapFilePath = "obfuscator.map";
        String fi = "";
        String fo = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--obfuscate") || args[i].equals("-o")) {
                if (resume) {
                    System.err.println("Specify --obfuscare or -- resume");
                    return;
                }
                obfuscate = true;
            }
            if (args[i].equals("--resume") || args[i].equals("-r")) {
                if (obfuscate) {
                    System.err.println("Specify --obfuscare or -- resume");
                    return;
                }
                resume = true;
            }
            if (args[i].startsWith("--level=")) {
                obfuscationLevel = Integer.parseInt(args[i].substring(8));
            }
            if (args[i].startsWith("-l=")) {
                obfuscationLevel = Integer.parseInt(args[i].substring(3));
            }
            if (args[i].startsWith("-map=")) {
                mapFilePath = args[i].substring(5);
            }
            if (args[i].startsWith("-fo=")) {
                fo = args[i].substring(4);
            }
            if (args[i].startsWith("-fi=")) {
                fi = args[i].substring(4);
            }
            ++i;
        }
        if (!obfuscate && !resume) {
            obfuscate = true;
        }
        if (new File(mapFilePath).exists()) {
            loadMap = true;
        }
        Obfuscator obfuscator = new Obfuscator(obfuscate, resume, mapFilePath, obfuscationLevel, loadMap);
        obfuscator.setFileInput(fi);
        obfuscator.setFileOutput(fo);
        obfuscator.initProgram();
        obfuscator.obfuscateOrResume();
        obfuscator.printProgram();
        try {
            obfuscator.saveIdMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Obfuscator() {
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public void setResume(boolean resume) {
        this.resume = resume;
    }

    public void setObfuscationLevel(int obfuscationLevel) {
        this.obfuscationLevel = obfuscationLevel;
    }

    public void setMapFilePath(String mapFilePath) {
        this.mapFilePath = mapFilePath;
    }

    public void setFileInput(String fileInput) {
        this.fileInput = fileInput;
    }

    public void setFileOutput(String fileOutput) {
        this.fileOutput = fileOutput;
    }

    public String getFileInput() {
        return this.fileInput;
    }

    public String getFileOutput() {
        return this.fileOutput;
    }

    public Obfuscator(boolean obfuscate, boolean resume, String mapFilePath, int obfuscationLevel, boolean loadMap) {
        this.obfuscate = obfuscate;
        this.resume = resume;
        this.mapFilePath = mapFilePath;
        if (loadMap) {
            try {
                this.loadIdMap(mapFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.identifierMap.setObfuscationLevel(obfuscationLevel);
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public void initProgram() {
        if (this.getFileInput().equals("")) {
            InputStream prgramInputStream = System.in;
            try {
                this.program = Obfuscator.getProgram(prgramInputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.getProgram(new File(this.getFileInput()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void getProgram(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        Director director = new Director(fis);
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        this.program = (Program)builder.getProductHandler();
    }

    public void printProgram() {
        if (this.getFileOutput().equals("")) {
            System.out.println(this.program);
        } else {
            this.writeProgram(new File(this.getFileOutput()), this.program);
        }
    }

    private void writeProgram(File file, Program program) {
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter outFile = new PrintWriter(bw);
            outFile.println(program.toString());
            outFile.flush();
            outFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void obfuscateOrResume() {
        try {
            if (this.obfuscate) {
                if (this.trace) {
                    System.out.println("START OBFUSCATION NAMES");
                }
                this.obfuscateNames(this.program);
                if (this.identifierMap.getObfuscationLevel() >= 2) {
                    if (this.trace) {
                        System.out.println("START SHIFT ATTRIBUTES NAMES");
                    }
                    this.shiftAttributes(this.program);
                }
                if (this.identifierMap.getObfuscationLevel() >= 3) {
                    if (this.trace) {
                        System.out.println("START ADD RULES");
                    }
                    this.addRules(this.program);
                }
                this.identifierMap.getObfuscationLevel();
                this.saveIdMap();
            } else if (this.resume) {
                File mapFile = new File(this.mapFilePath);
                if (mapFile.exists()) {
                    this.identifierMap.getObfuscationLevel();
                    if (this.identifierMap.getObfuscationLevel() >= 3) {
                        if (this.trace) {
                            System.out.println("START REMOVE RULES");
                        }
                        this.removeRules(this.program);
                    }
                    if (this.identifierMap.getObfuscationLevel() >= 2) {
                        if (this.trace) {
                            System.out.println("START RESUME SHIFTING");
                        }
                        this.resumeShiftAttributes(this.program);
                    }
                    if (this.trace) {
                        System.out.println("START RESUEME NAMES");
                    }
                    this.resumeOriginalNames(this.program);
                } else {
                    System.err.println("map file missing, impossible to resume file");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveIdMap() throws Exception {
        FileOutputStream fos = new FileOutputStream(this.mapFilePath);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.identifierMap);
        oos.flush();
        fos.close();
    }

    public void loadIdMap(String pathFile) throws Exception {
        FileInputStream fis = new FileInputStream(pathFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        this.identifierMap = (IdentifierMap)ois.readObject();
        fis.close();
    }

    public void addRules(Program program) {
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(program);
        ArrayList<Atom> connections = new ArrayList<Atom>();
        List<Set<Atom>> connectedSet = graph.getStronglyConnectedSets();
        for (Set<Atom> conn : connectedSet) {
            for (Set<Atom> conn2 : connectedSet) {
                if (conn == conn2) continue;
                for (Atom inHead : conn) {
                    for (Atom inBody : conn2) {
                        if (!this.isConnected(inHead, inBody, program) || connections.contains(inHead) || !(inHead instanceof NormalAtom) || !(inBody instanceof NormalAtom) || ((NormalAtom)inHead).isBuiltin() || ((NormalAtom)inBody).isBuiltin()) continue;
                        connections.add(inHead);
                    }
                }
            }
        }
        Random random = new Random();
        if (connections.size() >= 2) {
            int indexAtom = random.nextInt(connections.size());
            Atom toRename = (Atom)connections.get(indexAtom);
            String oldName = toRename.getName();
            String newName = this.identifierMap.getReplacedPredicateName(oldName);
            this.renamePredicateInProgram(program, oldName, newName);
            this.identifierMap.predicateNames.put(oldName, newName);
            Atom inHead = toRename.clone();
            int i = 0;
            for (Term t : ((NormalAtom)inHead).attributes()) {
                ((SimpleTerm)t).setContent("VAR_FAKE_" + ++i);
            }
            Atom inBody = inHead.clone();
            inHead.setName(newName);
            inBody.setName(oldName);
            Disjunction dis = new Disjunction(inHead);
            Conjunction con = new Conjunction(new Literal(true, inBody));
            program.add(new Rule(dis, con));
        }
    }

    public void removeRules(Program program) {
        ArrayList<Expression> toRemove = new ArrayList<Expression>();
        for (String key : this.identifierMap.replacedPredicateNames.keySet()) {
            for (Expression exp : program) {
                if (!(exp instanceof ProgramExpression) || !((ProgramExpression)exp).containsPredicate(key)) continue;
                toRemove.add(exp);
            }
        }
        program.removeAll(toRemove);
        for (String key : this.identifierMap.replacedPredicateNames.keySet()) {
            this.renamePredicateInProgram(program, this.identifierMap.replacedPredicateNames.get(key), key);
        }
    }

    private void renamePredicateInProgram(Program program, String oldName, String newName) {
        for (Expression exp : program) {
            if (!(exp instanceof ProgramExpression)) continue;
            this.renamePredicateInExpression((ProgramExpression)exp, oldName, newName);
        }
    }

    private void renamePredicateInExpression(ProgramExpression expression, String oldName, String newName) {
        if (expression instanceof Rule) {
            for (Atom atom : ((Rule)expression).head()) {
                this.renamePredicateInAtom(atom, oldName, newName);
            }
        }
        for (Literal literal : expression.getBody()) {
            Atom atom = literal.getAtom();
            this.renamePredicateInAtom(atom, oldName, newName);
        }
    }

    private void renamePredicateInAtom(Atom atom, String oldName, String newName) {
        if (atom instanceof NormalAtom) {
            if (atom.getName().equals(oldName)) {
                atom.setName(newName);
            }
        } else if (atom instanceof AggregateAtom) {
            AggregateAtom aggr = (AggregateAtom)atom;
            for (Literal literal : aggr.getBody()) {
                Atom atomAggr = literal.getAtom();
                if (!atomAggr.getName().equals(oldName)) continue;
                atomAggr.setName(newName);
            }
        }
    }

    private boolean isConnected(Atom inHead, Atom inBody, Program program) {
        CompleteGraph completeGraph = (CompleteGraph)DependencyGraph.createCompleteGraph(program);
        return completeGraph.hasPositiveEdge(inHead, inBody);
    }

    public boolean canResume(ProgramExpression expression) {
        if (expression instanceof Rule) {
            for (Atom atom : ((Rule)expression).getHead()) {
                if (this.canResumeNormalAtom((NormalAtom)atom)) continue;
                return false;
            }
        }
        for (Literal literal : expression.getBody()) {
            Atom atom = literal.getAtom();
            if (!(atom instanceof NormalAtom ? !this.canResumeNormalAtom((NormalAtom)atom) : atom instanceof AggregateAtom && !this.canResumeAggregateAtom((AggregateAtom)atom))) continue;
            return false;
        }
        return true;
    }

    private boolean canResumeAggregateAtom(AggregateAtom aggregate) {
        if (aggregate.getLowerGuard() != null && aggregate.getLowerGuard() instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)aggregate.getLowerGuard())) {
            return false;
        }
        if (aggregate.getUpperGuard() != null && aggregate.getUpperGuard() instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)aggregate.getUpperGuard())) {
            return false;
        }
        for (SimpleTerm term : aggregate.getVars()) {
            if (this.canResumeSimpleTerm(term)) continue;
            return false;
        }
        for (Literal literal : aggregate.getBody()) {
            Atom atom = literal.getAtom();
            if (!(atom instanceof NormalAtom ? !this.canResumeNormalAtom((NormalAtom)atom) : atom instanceof AggregateAtom && !this.canResumeAggregateAtom((AggregateAtom)atom))) continue;
            return false;
        }
        return true;
    }

    private boolean canResumeNormalAtom(NormalAtom atom) {
        if (!atom.isBuiltin()) {
            if (!this.identifierMap.predicateNames.containsValue(atom.getName())) {
                return false;
            }
            for (Term term : atom.getAttrs()) {
                if (!(term instanceof SimpleTerm ? !this.canResumeSimpleTerm((SimpleTerm)term) : term instanceof NormalAtom && !this.canResumeNormalAtom((NormalAtom)term))) continue;
                return false;
            }
        } else if (atom.getAttrs().size() == 2) {
            if (atom.getAttrs().get(0) instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)atom.getAttrs().get(0))) {
                return false;
            }
            if (atom.getAttrs().get(1) instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)atom.getAttrs().get(1))) {
                return false;
            }
        } else if (atom.getAttrs().size() == 3) {
            if (atom.getAttrs().get(0) instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)atom.getAttrs().get(0))) {
                return false;
            }
            if (atom.getAttrs().get(1) instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)atom.getAttrs().get(1))) {
                return false;
            }
            if (atom.getAttrs().get(2) instanceof SimpleTerm && !this.canResumeSimpleTerm((SimpleTerm)atom.getAttrs().get(2))) {
                return false;
            }
        }
        return true;
    }

    private boolean canResumeSimpleTerm(SimpleTerm term) {
        return term.equals(Term.NO_TERM) || !(term.isVariable() ? !this.identifierMap.variableNames.containsValue(term.getContent()) : !term.isNumericConstant() && !term.getContent().equals("_") && !this.identifierMap.constantValues.containsValue(term.getContent()));
    }

    public void shiftAttributes(Program program) {
        for (Expression exp : program) {
            if (!(exp instanceof ProgramExpression)) continue;
            this.shiftAttributesExpression((ProgramExpression)exp);
        }
    }

    public void resumeShiftAttributes(Program program) {
        for (Expression exp : program) {
            if (!(exp instanceof ProgramExpression)) continue;
            this.resumeShiftAttributesExpression((ProgramExpression)exp);
        }
    }

    void resumeShiftAttributesExpression(ProgramExpression expression) {
        if (expression instanceof Rule) {
            for (Atom atom : ((Rule)expression).getHead()) {
                this.resumeShiftAttributesNormalAtom((NormalAtom)atom);
            }
        }
        for (Literal literal : expression.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.resumeShiftAttributesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.resumeShiftAttributesAggregateAtom((AggregateAtom)atom);
        }
    }

    void resumeShiftAttributesAggregateAtom(AggregateAtom aggregate) {
        for (Literal literal : aggregate.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.resumeShiftAttributesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.resumeShiftAttributesAggregateAtom((AggregateAtom)atom);
        }
    }

    void resumeShiftAttributesNormalAtom(NormalAtom atom) {
        if (!atom.isBuiltin() && atom.arity() > 1) {
            int shift = 0;
            shift = this.identifierMap.getPredicateShifting(this.identifierMap.getOriginalPredicateName(atom.getName()));
            shift = atom.arity() - shift % atom.arity();
            for (Term term : atom.getAttrs()) {
                if (!(term instanceof NormalAtom)) continue;
                this.resumeShiftAttributesNormalAtom((NormalAtom)term);
            }
            Collections.rotate(atom.getAttrs(), shift);
        }
    }

    void shiftAttributesExpression(ProgramExpression expression) {
        if (expression instanceof Rule) {
            for (Atom atom : ((Rule)expression).getHead()) {
                this.shiftAttributesNormalAtom((NormalAtom)atom);
            }
        }
        for (Literal literal : expression.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.shiftAttributesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.shiftAttributesAggregateAtom((AggregateAtom)atom);
        }
    }

    void shiftAttributesAggregateAtom(AggregateAtom aggregate) {
        for (Literal literal : aggregate.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.shiftAttributesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.shiftAttributesAggregateAtom((AggregateAtom)atom);
        }
    }

    void shiftAttributesNormalAtom(NormalAtom atom) {
        if (!atom.isBuiltin() && atom.arity() > 1) {
            int shift = 0;
            shift = this.identifierMap.getPredicateShifting(this.identifierMap.getOriginalPredicateName(atom.getName()));
            shift %= atom.arity();
            for (Term term : atom.getAttrs()) {
                if (!(term instanceof NormalAtom)) continue;
                this.shiftAttributesNormalAtom((NormalAtom)term);
            }
            Collections.rotate(atom.getAttrs(), shift);
        }
    }

    public void resumeOriginalNames(Program obfuscatedProgram) {
        ArrayList<Expression> toDelete = new ArrayList<Expression>();
        for (Expression exp : obfuscatedProgram) {
            for (String key : this.identifierMap.replacedPredicateNames.keySet()) {
                if (!(exp instanceof ProgramExpression) || !((ProgramExpression)exp).containsPredicate(this.identifierMap.replacedPredicateNames.get(key))) continue;
                toDelete.add(exp);
            }
        }
        obfuscatedProgram.removeAll(toDelete);
        toDelete.clear();
        for (Expression exp : obfuscatedProgram) {
            if (!(exp instanceof ProgramExpression)) continue;
            if (this.canResume((ProgramExpression)exp)) {
                this.resumeNamesExpression((ProgramExpression)exp);
                continue;
            }
            toDelete.add(exp);
        }
        obfuscatedProgram.removeAll(toDelete);
    }

    void resumeNamesExpression(ProgramExpression expression) {
        if (expression instanceof Rule) {
            for (Atom atom : ((Rule)expression).getHead()) {
                this.resumeNamesNormalAtom((NormalAtom)atom);
            }
        }
        for (Literal literal : expression.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.resumeNamesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.resumeNamesAggregateAtom((AggregateAtom)atom);
        }
    }

    void resumeNamesAggregateAtom(AggregateAtom aggregate) {
        if (aggregate.getLowerGuard() != null && aggregate.getLowerGuard() instanceof SimpleTerm) {
            this.resumeNamesSimpleTerm((SimpleTerm)aggregate.getLowerGuard());
        }
        if (aggregate.getUpperGuard() != null && aggregate.getUpperGuard() instanceof SimpleTerm) {
            this.resumeNamesSimpleTerm((SimpleTerm)aggregate.getUpperGuard());
        }
        for (SimpleTerm term : aggregate.getVars()) {
            this.resumeNamesSimpleTerm(term);
        }
        for (Literal literal : aggregate.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.resumeNamesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.resumeNamesAggregateAtom((AggregateAtom)atom);
        }
    }

    void resumeNamesNormalAtom(NormalAtom atom) {
        if (!atom.isBuiltin()) {
            atom.setName(this.identifierMap.getOriginalPredicateName(atom.getName()));
            for (Term term : atom.getAttrs()) {
                if (term instanceof SimpleTerm) {
                    this.resumeNamesSimpleTerm((SimpleTerm)term);
                    continue;
                }
                if (!(term instanceof NormalAtom)) continue;
                this.resumeNamesNormalAtom((NormalAtom)term);
            }
        } else if (atom.getAttrs().size() == 2) {
            if (atom.getAttrs().get(0) instanceof SimpleTerm) {
                this.resumeNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(0));
            }
            if (atom.getAttrs().get(1) instanceof SimpleTerm) {
                this.resumeNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(1));
            }
        } else if (atom.getAttrs().size() == 3) {
            if (atom.getAttrs().get(0) instanceof SimpleTerm) {
                this.resumeNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(0));
            }
            if (atom.getAttrs().get(1) instanceof SimpleTerm) {
                this.resumeNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(1));
            }
            if (atom.getAttrs().get(2) instanceof SimpleTerm) {
                this.resumeNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(2));
            }
        }
    }

    void resumeNamesSimpleTerm(SimpleTerm term) {
        if (!term.equals(Term.NO_TERM)) {
            if (term.isVariable()) {
                term.setContent(this.identifierMap.getOriginalVariableName(term.getContent()));
            } else if (!term.isNumericConstant() && !term.getContent().equals("_")) {
                term.setContent(this.identifierMap.getOriginalConstantValue(term.getContent()));
            }
        }
    }

    public void obfuscateNames(Program program) {
        for (Expression exp : program) {
            if (!(exp instanceof ProgramExpression)) continue;
            this.obfuscateNamesExpression((ProgramExpression)exp);
        }
    }

    void obfuscateNamesExpression(ProgramExpression expression) {
        if (expression instanceof Rule) {
            for (Atom atom : ((Rule)expression).getHead()) {
                this.obfuscateNamesNormalAtom((NormalAtom)atom);
            }
        }
        for (Literal literal : expression.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.obfuscateNamesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.obfuscateNamesAggregateAtom((AggregateAtom)atom);
        }
    }

    void obfuscateNamesAggregateAtom(AggregateAtom aggregate) {
        if (aggregate.getLowerGuard() != null && aggregate.getLowerGuard() instanceof SimpleTerm) {
            this.obfuscateNamesSimpleTerm((SimpleTerm)aggregate.getLowerGuard());
        }
        if (aggregate.getUpperGuard() != null && aggregate.getUpperGuard() instanceof SimpleTerm) {
            this.obfuscateNamesSimpleTerm((SimpleTerm)aggregate.getUpperGuard());
        }
        for (SimpleTerm term : aggregate.getVars()) {
            this.obfuscateNamesSimpleTerm(term);
        }
        for (Literal literal : aggregate.getBody()) {
            Atom atom = literal.getAtom();
            if (atom instanceof NormalAtom) {
                this.obfuscateNamesNormalAtom((NormalAtom)atom);
                continue;
            }
            if (!(atom instanceof AggregateAtom)) continue;
            this.obfuscateNamesAggregateAtom((AggregateAtom)atom);
        }
    }

    void obfuscateNamesNormalAtom(NormalAtom atom) {
        if (!atom.isBuiltin()) {
            atom.setName(this.identifierMap.getObfuscatePredicateName(atom.getName()));
            for (Term term : atom.getAttrs()) {
                if (term instanceof SimpleTerm) {
                    this.obfuscateNamesSimpleTerm((SimpleTerm)term);
                    continue;
                }
                if (!(term instanceof NormalAtom)) continue;
                this.obfuscateNamesNormalAtom((NormalAtom)term);
            }
        } else if (atom.getAttrs().size() == 2) {
            if (atom.getAttrs().get(0) instanceof SimpleTerm) {
                this.obfuscateNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(0));
            }
            if (atom.getAttrs().get(1) instanceof SimpleTerm) {
                this.obfuscateNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(1));
            }
        } else if (atom.getAttrs().size() == 3) {
            if (atom.getAttrs().get(0) instanceof SimpleTerm) {
                this.obfuscateNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(0));
            }
            if (atom.getAttrs().get(1) instanceof SimpleTerm) {
                this.obfuscateNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(1));
            }
            if (atom.getAttrs().get(2) instanceof SimpleTerm) {
                this.obfuscateNamesSimpleTerm((SimpleTerm)atom.getAttrs().get(2));
            }
        }
    }

    public IdentifierMap getIdentifierMap() {
        return this.identifierMap;
    }

    void obfuscateNamesSimpleTerm(SimpleTerm term) {
        if (!term.equals(Term.NO_TERM)) {
            if (term.isVariable()) {
                term.setContent(this.identifierMap.getObfuscateVariableName(term.getContent()));
            } else if (!term.isNumericConstant() && !term.getContent().equals("_")) {
                term.setContent(this.identifierMap.getObfuscateConstantValue(term.getContent()));
            }
        }
    }

    private static Program getProgram(InputStream inputStream) throws UnsupportedEncodingException, ParseException, FileNotFoundException {
        Director director = new Director(inputStream);
        ShifterProgramBuilder builder = new ShifterProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

