/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.wrapper.util.dependencygraph;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.wrapper.util.dependencygraph.CompleteGraph;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class StronglyConnectedComponentGraph
extends DependencyGraph {
    DependencyGraph completeGraph;
    DefaultDirectedGraph<Atom, DefaultEdge> connectedComponentGraph;
    List<Set<Atom>> vertices;
    HashMap<Set<Atom>, List<Set<Atom>>> positiveConnections = new HashMap();
    HashMap<Set<Atom>, List<Set<Atom>>> negativeConnections = new HashMap();
    HashMap<Set<Atom>, List<Set<Atom>>> positiveAggregateConnections = new HashMap();
    HashMap<Set<Atom>, List<Set<Atom>>> negativeAggregateConnections = new HashMap();

    public StronglyConnectedComponentGraph(IndexedProgram program) {
        this.completeGraph = (CompleteGraph)DependencyGraph.createCompleteGraph(program, this.isShowDisjunctionLinks());
        this.buildConnectedComponentGraph();
    }

    public StronglyConnectedComponentGraph(boolean onlyPositive, boolean ground, IndexedProgram program) {
        this.completeGraph = onlyPositive ? DependencyGraph.createPositiveGraph(ground, program, this.isShowDisjunctionLinks()) : (CompleteGraph)DependencyGraph.createCompleteGraph(program, this.isShowDisjunctionLinks());
        this.buildConnectedComponentGraph();
    }

    public StronglyConnectedComponentGraph(IndexedProgram program, boolean showDisjunctionLinks) {
        this.setShowDisjunctionLinks(showDisjunctionLinks);
        this.completeGraph = (CompleteGraph)DependencyGraph.createCompleteGraph(program, this.isShowDisjunctionLinks());
        this.buildConnectedComponentGraph();
    }

    public List<Set<Atom>> getIncomingHierarchyVertices(Set<Atom> node) {
        if (this.vertices.contains(node)) {
            ArrayList<Set<Atom>> incomingHierarchy = new ArrayList<Set<Atom>>();
            int i = 1;
            while (i <= 4) {
                HashMap<Set<Atom>, List<Set<Atom>>> navigationConnection = i == 1 ? this.positiveConnections : (i == 2 ? this.negativeConnections : (i == 3 ? this.positiveAggregateConnections : this.negativeAggregateConnections));
                for (Set<Atom> sourceNode : navigationConnection.keySet()) {
                    if (!navigationConnection.get(sourceNode).contains(node) || incomingHierarchy.contains(sourceNode)) continue;
                    incomingHierarchy.add(sourceNode);
                    for (Set<Atom> newSourceNode : this.getIncomingHierarchyVertices(sourceNode)) {
                        if (incomingHierarchy.contains(newSourceNode)) continue;
                        incomingHierarchy.add(newSourceNode);
                    }
                }
                ++i;
            }
            return incomingHierarchy;
        }
        return null;
    }

    private void buildConnectedComponentGraph() {
        this.connectedComponentGraph = new DefaultDirectedGraph(DefaultEdge.class);
        for (Object a : this.completeGraph.getVertices()) {
            this.connectedComponentGraph.addVertex((Object)((Atom)a));
        }
        for (Object source : this.completeGraph.getVertices()) {
            for (Object dest : this.completeGraph.getPositiveConnectionsWithNode(source)) {
                this.connectedComponentGraph.addEdge((Object)((Atom)source), (Object)((Atom)dest));
            }
        }
        for (Object source : this.completeGraph.getVertices()) {
            if (this.completeGraph.getNegativeConnectionsWithNode(source) == null) continue;
            for (Object dest : this.completeGraph.getNegativeConnectionsWithNode(source)) {
                this.connectedComponentGraph.addEdge((Object)((Atom)source), (Object)((Atom)dest));
            }
        }
        StrongConnectivityInspector strongConnectivityInspector = new StrongConnectivityInspector(this.connectedComponentGraph);
        this.vertices = strongConnectivityInspector.stronglyConnectedSets();
        for (Set<Atom> sourceVertex : this.vertices) {
            for (Set<Atom> destVertex : this.vertices) {
                if (sourceVertex == destVertex) continue;
                if (!this.positiveConnections.containsKey(sourceVertex)) {
                    this.positiveConnections.put(sourceVertex, new ArrayList());
                }
                if (!this.negativeConnections.containsKey(sourceVertex)) {
                    this.negativeConnections.put(sourceVertex, new ArrayList());
                }
                if (!this.positiveAggregateConnections.containsKey(sourceVertex)) {
                    this.positiveAggregateConnections.put(sourceVertex, new ArrayList());
                }
                if (!this.negativeAggregateConnections.containsKey(sourceVertex)) {
                    this.negativeAggregateConnections.put(sourceVertex, new ArrayList());
                }
                for (Atom source : sourceVertex) {
                    for (Atom dest : destVertex) {
                        if (this.completeGraph.hasPositiveEdge(source, dest) && !this.positiveConnections.get(sourceVertex).contains(destVertex)) {
                            this.positiveConnections.get(sourceVertex).add(destVertex);
                        }
                        if (this.completeGraph.hasNegativeEdge(source, dest) && !this.negativeConnections.get(sourceVertex).contains(destVertex)) {
                            this.negativeConnections.get(sourceVertex).add(destVertex);
                        }
                        if (this.completeGraph.hasAggregatePositiveEdge(source, dest) && !this.positiveAggregateConnections.get(sourceVertex).contains(destVertex)) {
                            this.positiveAggregateConnections.get(sourceVertex).add(destVertex);
                        }
                        if (!this.completeGraph.hasAggregateNegativeEdge(source, dest) || this.negativeAggregateConnections.get(sourceVertex).contains(destVertex)) continue;
                        this.negativeAggregateConnections.get(sourceVertex).add(destVertex);
                    }
                }
            }
        }
    }

    public List<Set<Atom>> getStronglyConnectedSets() {
        return this.vertices;
    }

    @Override
    public void refresh() {
        this.positiveConnections = new HashMap();
        this.negativeConnections = new HashMap();
        this.positiveAggregateConnections = new HashMap();
        this.negativeAggregateConnections = new HashMap();
        this.buildConnectedComponentGraph();
    }

    public boolean hasPositiveEdge(Set<Atom> source, Set<Atom> dest) {
        if (this.positiveConnections.containsKey(source)) {
            return this.positiveConnections.get(source).contains(dest);
        }
        return false;
    }

    public boolean hasAggregateNegativeEdge(Set<Atom> source, Set<Atom> dest) {
        if (this.negativeAggregateConnections.containsKey(source)) {
            return this.negativeAggregateConnections.get(source).contains(dest);
        }
        return false;
    }

    public boolean hasNegativeEdge(Set<Atom> source, Set<Atom> dest) {
        if (this.negativeConnections.containsKey(source)) {
            return this.negativeConnections.get(source).contains(dest);
        }
        return false;
    }

    public boolean hasAggregatePositiveEdge(Set<Atom> source, Set<Atom> dest) {
        if (this.positiveAggregateConnections.containsKey(source)) {
            return this.positiveAggregateConnections.get(source).contains(dest);
        }
        return false;
    }

    @Override
    public boolean hasPositiveEdge(Atom source, Atom dest) {
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.positiveConnections.containsKey(setSource)) {
            return this.positiveConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    public boolean hasAggregateNegativeEdge(Atom source, Atom dest) {
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.negativeAggregateConnections.containsKey(setSource)) {
            return this.negativeAggregateConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    public boolean hasNegativeEdge(Atom source, Atom dest) {
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.negativeConnections.containsKey(setSource)) {
            return this.negativeConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    @Override
    public boolean hasAggregatePositiveEdge(Atom source, Atom dest) {
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.positiveAggregateConnections.containsKey(setSource)) {
            return this.positiveAggregateConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    public boolean hasPositiveEdge(String sourceName, String destName) {
        Atom source = StronglyConnectedComponentGraph.generateAtom(sourceName);
        Atom dest = StronglyConnectedComponentGraph.generateAtom(destName);
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.positiveConnections.containsKey(setSource)) {
            return this.positiveConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    public boolean hasAggregateNegativeEdge(String sourceName, String destName) {
        Atom source = StronglyConnectedComponentGraph.generateAtom(sourceName);
        Atom dest = StronglyConnectedComponentGraph.generateAtom(destName);
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.negativeAggregateConnections.containsKey(setSource)) {
            return this.negativeAggregateConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    public boolean hasNegativeEdge(String sourceName, String destName) {
        Atom source = StronglyConnectedComponentGraph.generateAtom(sourceName);
        Atom dest = StronglyConnectedComponentGraph.generateAtom(destName);
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.negativeConnections.containsKey(setSource)) {
            return this.negativeConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    public boolean hasAggregatePositiveEdge(String sourceName, String destName) {
        Atom source = StronglyConnectedComponentGraph.generateAtom(sourceName);
        Atom dest = StronglyConnectedComponentGraph.generateAtom(destName);
        Set<Atom> setSource = this.getConnectedComponentContains(source);
        if (this.positiveAggregateConnections.containsKey(setSource)) {
            return this.positiveAggregateConnections.get(setSource).contains(this.getConnectedComponentContains(dest));
        }
        return false;
    }

    @Override
    public boolean isStratified() {
        for (Set<Atom> vertex : this.getVertices()) {
            for (Atom a1 : vertex) {
                for (Atom a2 : vertex) {
                    if (a1.getName().equals(a2.getName()) || !this.completeGraph.hasNegativeEdge(a1, a2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public List<Set<Atom>> getVertices() {
        return this.getStronglyConnectedSets();
    }

    public List<Set<Atom>> getPositiveConnectionsWithNode(Set<Atom> source) {
        if (!this.positiveConnections.containsKey(source)) {
            return new ArrayList<Set<Atom>>();
        }
        return this.positiveConnections.get(source);
    }

    public List<Set<Atom>> getNegativeConnectionsWithNode(Set<Atom> source) {
        if (!this.negativeConnections.containsKey(source)) {
            return new ArrayList<Set<Atom>>();
        }
        return this.negativeConnections.get(source);
    }

    public List<Set<Atom>> getAggregatePositiveConnectionsWithNode(Set<Atom> source) {
        if (!this.positiveAggregateConnections.containsKey(source)) {
            return new ArrayList<Set<Atom>>();
        }
        return this.positiveAggregateConnections.get(source);
    }

    public List<Set<Atom>> getAggregateNegativeConnectionsWithNode(Set<Atom> source) {
        if (!this.negativeAggregateConnections.containsKey(source)) {
            return new ArrayList<Set<Atom>>();
        }
        return this.negativeAggregateConnections.get(source);
    }

    public Set<Atom> getConnectedComponentContains(String atomName) {
        Atom atom = StronglyConnectedComponentGraph.generateAtom(atomName);
        for (Set<Atom> vertex : this.vertices) {
            if (!vertex.contains(atom)) continue;
            return vertex;
        }
        return null;
    }

    public Set<Atom> getConnectedComponentContains(Atom atom) {
        for (Set<Atom> vertex : this.vertices) {
            if (!vertex.contains(atom)) continue;
            return vertex;
        }
        return null;
    }

    private static Atom generateAtom(String name) {
        return new NormalAtom(name);
    }

    public void removeVertex(Set<Atom> vertex) {
        this.positiveConnections.remove(vertex);
        this.positiveAggregateConnections.remove(vertex);
        this.negativeConnections.remove(vertex);
        this.negativeAggregateConnections.remove(vertex);
    }

    @Override
    public void removeVertex(Atom vertex) {
        this.positiveConnections.remove(this.getConnectedComponentContains(vertex));
        this.positiveAggregateConnections.remove(this.getConnectedComponentContains(vertex));
        this.negativeConnections.remove(this.getConnectedComponentContains(vertex));
        this.negativeAggregateConnections.remove(this.getConnectedComponentContains(vertex));
    }

    @Override
    public List getPositiveConnectionsWithNode(Object source) {
        return this.positiveConnections.get(source);
    }

    @Override
    public List getNegativeConnectionsWithNode(Object source) {
        return this.negativeConnections.get(source);
    }

    @Override
    public boolean hasNegativeEdge(Object sourceAtom, Object targetAtom) {
        return this.negativeConnections.containsKey(sourceAtom) && this.negativeConnections.get(sourceAtom).contains(targetAtom);
    }

    @Override
    public boolean hasAggregateNegativeEdge(Object source, Object dest) {
        if (this.negativeAggregateConnections.containsKey(source)) {
            return this.negativeAggregateConnections.get(source).contains(dest);
        }
        return false;
    }
}

