/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.wrapper.DLVInvocationImpl;
import it.unical.mat.wrapper.util.dependencygraph.CompleteGraph;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.PositiveGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class DependencyGraphTest {
    boolean trace = false;

    @Test
    public void positiveGraphTest() throws UnsupportedEncodingException, ParseException {
        String code = "a(X) :- not b(X).e(X) :- -f(X).a_d v b_d v c_d :- a(X), u(X,Y), not ciccio(Y,X).aggrHead :- 44 = #count {X1: inAggregate(X1, X2), inAggregate2(X1), not inAggregate3(X1)}, a(X).c(X) :- d(X).";
        Program p = this.getProgram(code);
        PositiveGraph graph = (PositiveGraph)DependencyGraph.createPositiveGraph(p);
        Assert.assertTrue((!graph.hasPositiveEdge("a", "b") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("b", "a") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("c", "d") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("d", "c"));
        Assert.assertTrue((!graph.hasPositiveEdge("e", "f") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("f", "e"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "a_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "b_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "c_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "a_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "b_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "c_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "a_d") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "b_d") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "c_d") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "aggrHead"));
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "a") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregatePositiveEdge("inAggregate", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate2", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate2") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregatePositiveEdge("inAggregate2", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate2") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate3", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("inAggregate3", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
    }

    @Test
    public void completeGraphTest() throws UnsupportedEncodingException, ParseException {
        String code = "a(X) :- not b(X).e(X) :- -f(X).a_d v b_d v c_d :- a(X), u(X,Y), not ciccio(Y,X).aggrHead :- 44 = #count {X1: inAggregate(X1, X2), inAggregate2(X1), not inAggregate3(X1)}, a(X).c(X) :- d(X).";
        Program p = this.getProgram(code);
        CompleteGraph graph = (CompleteGraph)DependencyGraph.createCompleteGraph(p);
        Assert.assertTrue((!graph.hasPositiveEdge("a", "b") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("b", "a") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("c", "d") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("d", "c"));
        Assert.assertTrue((!graph.hasPositiveEdge("e", "f") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("f", "e"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "a_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "b_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "c_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "a_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "b_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "c_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "a_d") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "b_d") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "c_d") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "aggrHead"));
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "a") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregatePositiveEdge("inAggregate", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate2", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate2") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregatePositiveEdge("inAggregate2", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate2") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate3", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("inAggregate3", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregateNegativeEdge("inAggregate3", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregateNegativeEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
    }

    @Test
    public void connectedComponentGraphTest() throws UnsupportedEncodingException, ParseException {
        String code = "a(X) :- not b(X).e(X) :- -f(X).a_d v b_d v c_d :- a(X), u(X,Y), not ciccio(Y,X).aggrHead :- 44 = #count {X1: inAggregate(X1, X2), inAggregate2(X1), not inAggregate3(X1)}, a(X).c(X) :- d(X).";
        Program p = this.getProgram(code);
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((!graph.hasPositiveEdge("a", "b") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("b", "a") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("c", "d") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("d", "c"));
        Assert.assertTrue((!graph.hasPositiveEdge("e", "f") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("f", "e"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "a_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "b_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "c_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "a_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "b_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "u") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("u", "c_d"));
        Assert.assertTrue((!graph.hasPositiveEdge("a_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "a_d") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("b_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "b_d") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("c_d", "ciccio") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("ciccio", "c_d") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasPositiveEdge("a", "aggrHead"));
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "a") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregatePositiveEdge("inAggregate", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate2", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate2") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregatePositiveEdge("inAggregate2", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate2") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("inAggregate3", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasPositiveEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("inAggregate3", "aggrHead") ? 1 : 0) != 0);
        Assert.assertTrue((!graph.hasAggregatePositiveEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.hasAggregateNegativeEdge("inAggregate3", "aggrHead"));
        Assert.assertTrue((!graph.hasAggregateNegativeEdge("aggrHead", "inAggregate3") ? 1 : 0) != 0);
    }

    @Test
    public void connectedComponentGraphTest2() throws UnsupportedEncodingException, ParseException {
        String code = "a(1) :- b(1).b(1) :- a(1).";
        Program p = this.getProgram(code);
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((graph.getVertices().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((graph.getVertices().get(0).size() == 2 ? 1 : 0) != 0);
        for (Atom atom : graph.getVertices().get(0)) {
            Assert.assertTrue((atom.getName().equals("a") || atom.getName().equals("b") ? 1 : 0) != 0);
        }
        code = "a(1) :- not b(1).b(1) :- a(1).";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((graph.getVertices().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((graph.getVertices().get(0).size() == 2 ? 1 : 0) != 0);
        for (Atom atom : graph.getVertices().get(0)) {
            Assert.assertTrue((atom.getName().equals("a") || atom.getName().equals("b") ? 1 : 0) != 0);
        }
        code = "a(1) :- not b(1).b(1) :- a(1).a(1) :- c(1).c(1) :- a(1).";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createPositiveStronglyConnectedComponentGraph(p);
        Assert.assertTrue((graph.getVertices().size() == 2 ? 1 : 0) != 0);
        boolean correct = graph.getVertices().get(0).size() == 2 && graph.getVertices().get(1).size() == 1 || graph.getVertices().get(0).size() == 1 && graph.getVertices().get(1).size() == 2;
        Assert.assertTrue((boolean)correct);
        if (graph.getVertices().get(0).size() == 2) {
            for (Atom atom : graph.getVertices().get(0)) {
                Assert.assertTrue((atom.getName().equals("a") || atom.getName().equals("c") ? 1 : 0) != 0);
            }
        } else {
            for (Atom atom : graph.getVertices().get(0)) {
                Assert.assertTrue((boolean)atom.getName().equals("b"));
            }
        }
        if (graph.getVertices().get(1).size() == 2) {
            for (Atom atom : graph.getVertices().get(0)) {
                Assert.assertTrue((atom.getName().equals("a") || atom.getName().equals("c") ? 1 : 0) != 0);
            }
        } else {
            for (Atom atom : graph.getVertices().get(1)) {
                Assert.assertTrue((boolean)atom.getName().equals("b"));
            }
        }
    }

    @Test
    public void stratifiedProgramTest() throws UnsupportedEncodingException, ParseException {
        String code = "a :- not b.b :- a.";
        Program p = this.getProgram(code);
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((!graph.isStratified() ? 1 : 0) != 0);
        code = "a v b :- not c.c :- b.";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((!graph.isStratified() ? 1 : 0) != 0);
        code = "a v b :- not c.";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((boolean)graph.isStratified());
        code = "a v b :- c.";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((boolean)graph.isStratified());
        code = "a :- b.b :- a.";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((boolean)graph.isStratified());
        code = "p(X,Y):-q(X),q(Y),not t(X,Y).p(X,Y):-r(X),t(X,Y).t(X,Y):-p(X,Y),s(Y).q(X):-a(X).";
        p = this.getProgram(code);
        graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(p);
        Assert.assertTrue((!graph.isStratified() ? 1 : 0) != 0);
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private Program getOutput(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        DLVInvocationImpl invocation = new DLVInvocationImpl();
        director.configureDlvInvocation(invocation);
        director.startOutput();
        return null;
    }
}

