/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.DirectiveAnalyzer;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.typ.CreateDefinition;
import it.unical.mat.dlv.typ.DBOutput;
import it.unical.mat.dlv.typ.Output;
import it.unical.mat.dlv.typ.QueryDefinition;
import it.unical.mat.dlv.typ.UseDB;
import it.unical.mat.dlv.typ.UseDefinition;
import it.unical.mat.wrapper.exception.NullUseDbDefinitionException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class DirectiveAnalyzerTest {
    @Test
    public void useDBTest() throws it.unical.mat.dlv.typ.parser.ParseException {
        UseDB usedb = DirectiveAnalyzer.getUseDBdefinition("     @workingDatabase    DBname_1:username_1:password_1 ");
        Assert.assertTrue((usedb != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)usedb.getDatabaseName().equals("DBname_1"));
        Assert.assertTrue((boolean)usedb.getUsername().equals("username_1"));
        Assert.assertTrue((boolean)usedb.getPassword().equals("password_1"));
        usedb = DirectiveAnalyzer.getUseDBdefinition("      @workingDatabase    dDBname_1:username_1:password_1  LIKE POSTGRES ");
        Assert.assertTrue((usedb != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)usedb.getDatabaseName().equals("dDBname_1"));
        Assert.assertTrue((boolean)usedb.getUsername().equals("username_1"));
        Assert.assertTrue((boolean)usedb.getPassword().equals("password_1"));
        Assert.assertTrue((boolean)usedb.getSystemLike().equals("POSTGRES"));
    }

    @Test
    public void useTest() throws it.unical.mat.dlv.typ.parser.ParseException {
        UseDefinition useDefinition = DirectiveAnalyzer.getUseDefinition("   @useTable tableName__1 MAPTO predicateName_1(attribute_Name_1:attribute_Type_1, attribute_Name_2:attribute_Type_2)");
        Assert.assertTrue((useDefinition != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)useDefinition.getPredicateName().equals("predicateName_1"));
        Assert.assertTrue((boolean)useDefinition.getTableName().equals("tableName__1"));
        Assert.assertTrue((boolean)useDefinition.getTableNameAttributes().get(0).equals("attribute_Name_1"));
        Assert.assertTrue((boolean)useDefinition.getPredicateType(0).equals("attribute_Type_1"));
        Assert.assertTrue((boolean)useDefinition.getTableNameAttributes().get(1).equals("attribute_Name_2"));
        Assert.assertTrue((boolean)useDefinition.getPredicateType(1).toString().equals("attribute_Type_2"));
        useDefinition = DirectiveAnalyzer.getUseDefinition("    @useTable tableName__1 MAPTO predicateName_1(attribute_Name_1:attribute_Type_1, attribute_Name_2:attribute_Type_2) FROM DBname_1:username_1:password_1 ");
        Assert.assertTrue((useDefinition != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)useDefinition.getPredicateName().equals("predicateName_1"));
        Assert.assertTrue((boolean)useDefinition.getTableName().equals("tableName__1"));
        Assert.assertTrue((boolean)useDefinition.getTableNameAttributes().get(0).equals("attribute_Name_1"));
        Assert.assertTrue((boolean)useDefinition.getPredicateType(0).equals("attribute_Type_1"));
        Assert.assertTrue((boolean)useDefinition.getTableNameAttributes().get(1).equals("attribute_Name_2"));
        Assert.assertTrue((boolean)useDefinition.getPredicateType(1).toString().equals("attribute_Type_2"));
        Assert.assertTrue((boolean)useDefinition.getDatabaseName().equals("DBname_1"));
        Assert.assertTrue((boolean)useDefinition.getUsername().equals("username_1"));
        Assert.assertTrue((boolean)useDefinition.getPassword().equals("password_1"));
    }

    @Test
    public void createTest() throws it.unical.mat.dlv.typ.parser.ParseException {
        CreateDefinition createDefinition = DirectiveAnalyzer.getCreateDefinition("   @createTable tableName__1 MAPTO predicateName_1(attribute_Name_1:attribute_Type_1, attribute_Name_2:attribute_Type_2) KEEP_AFTER_EXECUTION");
        Assert.assertTrue((createDefinition != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)createDefinition.getPredicateName().equals("predicateName_1"));
        Assert.assertTrue((boolean)createDefinition.getTableName().equals("tableName__1"));
        Assert.assertTrue((boolean)createDefinition.getTableNameAttributes().get(0).equals("attribute_Name_1"));
        Assert.assertTrue((boolean)createDefinition.getPredicateType(0).equals("attribute_Type_1"));
        Assert.assertTrue((boolean)createDefinition.getTableNameAttributes().get(1).equals("attribute_Name_2"));
        Assert.assertTrue((boolean)createDefinition.getPredicateType(1).toString().equals("attribute_Type_2"));
    }

    @Test
    public void queryTest() throws it.unical.mat.dlv.typ.parser.ParseException {
        QueryDefinition useDefinition = DirectiveAnalyzer.getQueryDefinition("   @dbQuery tableName__1");
        Assert.assertTrue((useDefinition != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)useDefinition.getTableName().equals("tableName__1"));
    }

    @Test
    public void dbOutputTest() throws it.unical.mat.dlv.typ.parser.ParseException {
        DBOutput dbOutput = DirectiveAnalyzer.getDBOutputDefinition("      @outputDatabase    DBname_1:username_1:password_1 ");
        Assert.assertTrue((dbOutput != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dbOutput.getDatabaseName().equals("DBname_1"));
        Assert.assertTrue((boolean)dbOutput.getUsername().equals("username_1"));
        Assert.assertTrue((boolean)dbOutput.getPassword().equals("password_1"));
    }

    @Test
    public void outputTest() throws it.unical.mat.dlv.typ.parser.ParseException {
        Output output = DirectiveAnalyzer.getOutputDefinition(" @outputTable OVERWRITE predName AS tableName IN DBname_1:username_1:password_1");
        Assert.assertTrue((output != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.getPredicateName().equals("predName"));
        Assert.assertTrue((boolean)output.getAliasTableName().equals("tableName"));
        Assert.assertTrue((boolean)output.getWriteOption().equals("OVERWRITE"));
        Assert.assertTrue((boolean)output.getDatabaseName().equals("DBname_1"));
        Assert.assertTrue((boolean)output.getUsername().equals("username_1"));
        Assert.assertTrue((boolean)output.getPassword().equals("password_1"));
    }

    @Test
    public void programTypGeneratorTest() throws it.unical.mat.dlv.typ.parser.ParseException, UnsupportedEncodingException, ParseException, NullUseDbDefinitionException {
        String typComparator = "USEDB databaseName:username:password LIKE POSTGRES.\n\nUSE tableName__1(attribute_Name_1,attribute_Name_2)\nMAPTO predicateName_1(attribute_Type_1,attribute_Type_2).\n\nCREATE tableName__1(attribute_Name_1,attribute_Name_2)\nMAPTO predicateName_1(attribute_Type_1,attribute_Type_2).\n\nCREATE tableName(attribute_Name,attribute_Name)\nMAPTO predicateName(attribute_Type,attribute_Type).\n\nQUERY tableName.\n\nDBOUTPUT DBname_1:username_1:password_1.";
        String programContent = "a(B):-c(A,B), !=(A,B).\n% @workingDatabase databaseName:username:password LIKE POSTGRES\na(X):-b(X).\n %  @useTable tableName__1 MAPTO predicateName_1(attribute_Name_1:attribute_Type_1, attribute_Name_2:attribute_Type_2)\na(1).\n %   @createTable tableName__1 MAPTO predicateName_1(attribute_Name_1:attribute_Type_1, attribute_Name_2:attribute_Type_2) \nb(1).\n %   @createTable tableName MAPTO predicateName(attribute_Name:attribute_Type, attribute_Name:attribute_Type) \nb(3).\n %   @dbQuery tableName  \nb(3).\n  %  @outputDatabase    DBname_1:username_1:password_1 \nb(3).\n";
        Program program = this.getProgram(programContent);
        program.generateTypDirectives();
        Assert.assertTrue((boolean)program.getTypDirectives().toString().equals(typComparator));
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

