/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.metainfo.Schema;
import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.ArityWarning;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.ConstDirective;
import it.unical.mat.dlv.program.Directive;
import it.unical.mat.dlv.program.ExportDirective;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.ImportDirective;
import it.unical.mat.dlv.program.IncludeDirective;
import it.unical.mat.dlv.program.IndexedProgram;
import it.unical.mat.dlv.program.JavaContentAtom;
import it.unical.mat.dlv.program.JavaNameAtom;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.MaxIntDirective;
import it.unical.mat.dlv.program.NonPositionalTerm;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Query;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.WeakConstraint;
import it.unical.mat.dlv.program.error.SafetyWarning;
import it.unical.mat.wrapper.DLVInvocation;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.DLVInvocationImpl;
import it.unical.mat.wrapper.FactHandler;
import it.unical.mat.wrapper.FactResult;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    boolean trace = true;

    @Test
    public void underScoreTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(1):-b(1,_).");
        p = this.getProgram("a(1):-b(1,_).");
        p = this.getProgram("a(_,R):-b(R).");
        if (this.trace) {
            System.out.println(p);
            System.out.println(p.getSafetyErrors());
        }
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void nonPositionalExampleTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(1):-b( X : Y).");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("a(1) :- b(X:Y)."));
        Assert.assertTrue((boolean)(((Literal)((Rule)p.get(0)).body().get(0)).attributes().get(0) instanceof NonPositionalTerm));
        Assert.assertTrue((boolean)((NonPositionalTerm)((Literal)((Rule)p.get(0)).body().get(0)).attributes().get(0)).getName().toString().equals("X"));
        Assert.assertTrue((boolean)((NonPositionalTerm)((Literal)((Rule)p.get(0)).body().get(0)).attributes().get(0)).getValue().toString().equals("Y"));
        System.out.println(p);
    }

    @Test
    public void javaNameAtomExampleTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("[a.b.c](1,2,3).");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("[a.b.c](1, 2, 3)."));
        Assert.assertTrue((boolean)(((Rule)p.get(0)).head().get(0) instanceof JavaNameAtom));
    }

    @Test
    public void javaAtomExampleTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram(":-b(${ciccio.pino()}).");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals(":- b(${ciccio.pino()})."));
        Assert.assertTrue((boolean)(((Literal)((Rule)p.get(0)).body().get(0)).getAttributeAt(0) instanceof JavaContentAtom));
        p = this.getProgram("${ciccio.pino()}.");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("${ciccio.pino()}."));
        Assert.assertTrue((boolean)(((Rule)p.get(0)).head().get(0) instanceof JavaContentAtom));
        p = this.getProgram("${ciccio.pino(1..22)}.");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("${ciccio.pino(1..22)}."));
        Assert.assertTrue((boolean)(((Rule)p.get(0)).head().get(0) instanceof JavaContentAtom));
        p = this.getProgram("a:- b(X, ${i+j}).");
        System.out.println(((Expression)p.get(0)).toString());
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("a :- b(X, ${i+j})."));
        Assert.assertTrue((boolean)(((Literal)((Rule)p.get(0)).body().get(0)).getAttributeAt(1) instanceof JavaContentAtom));
        p = this.getProgram("a:- not b(X, ${i+j}).");
        System.out.println(((Expression)p.get(0)).toString());
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("a :- not b(X, ${i+j})."));
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(((Literal)((Rule)p.get(0)).body().get(0)).getAttributeAt(1) instanceof JavaContentAtom));
    }

    @Test
    public void indexedProgramTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a:-33 = #count {X1: b(X1)}.");
        IndexedProgram ie = new IndexedProgram(p);
        Assert.assertTrue((ie.getRulesWithPredicateInBody("b").size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void trueNegatedTest() throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        Program p = this.getProgram("-a(1).");
        Assert.assertTrue((boolean)((NormalAtom)((Rule)p.get(0)).getHead().get(0)).isTrueNegated());
        Assert.assertTrue((boolean)((NormalAtom)((Rule)p.get(0)).getHead().get(0)).toString().equals("-a(1)"));
        p = this.getOutput("{-a(1)}");
        Assert.assertTrue((boolean)((NormalAtom)((Rule)p.get(0)).getHead().get(0)).isTrueNegated());
        Assert.assertTrue((boolean)((NormalAtom)((Rule)p.get(0)).getHead().get(0)).toString().equals("-a(1)"));
    }

    @Test
    public void builtinTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("panDiaUp(X,Y,O) :- panDiaUp(Z,W,O), X = Z-1, X > 0, next(W,Y).");
        System.out.println(((Expression)p.get(0)).toString());
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("panDiaUp(X, Y, O) :- panDiaUp(Z, W, O), X = Z - 1, X > 0, next(W, Y)."));
    }

    @Test
    public void builtinIntTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("prime(A) :- #int(A), not productOfPrimes(A).");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("prime(A) :- #int(A), not productOfPrimes(A)."));
    }

    @Test
    public void arityErrorQueryTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Arity error query test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y),a(X)?")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y),a(X), b(X), b(X,Y)?")).getArityErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getArityErrors().get(0));
            System.out.println(String.valueOf(p.getArityErrors().get(1).toString()) + '\n');
        }
    }

    @Test
    public void arityErrorRuleTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Arity error rule test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y):- b(X), a(Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y):- b(X), a(first:Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getArityErrors().get(0) instanceof ArityWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y):- b(X), a(first:Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getArityErrors().get(0) instanceof ArityWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        p = this.getProgram("a(X) v a(X,Y):- b(X), a(Y).");
        System.out.println(p.getArityErrors().size());
        Assert.assertTrue((p.getArityErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getArityErrors().get(0).toString());
            System.out.println(String.valueOf(p.getArityErrors().get(1).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y) v b(X,Y):- b(X), a(Y).")).getArityErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getArityErrors().get(0));
            System.out.println(String.valueOf(p.getArityErrors().get(1).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X,Y):- b(X), a(Y,U), b(X,Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(X). a(X, Y):-c(X,Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(X). a(X, Y):-c(X,Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(X). c(X, Y):-a(X,Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(X). c(X, Y):-b(X,Y).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).toString()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("b(X):-#count{V : a(V,U)}>100, a(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):-#count{V : a(V,U)}>100, b(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("c(X):-#count{V : a(V,U)}>100, b(X).b(X):-a(X).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("c(X):-#count{V : a(V,U)}>100, b(X).a(X):-b(X).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("c(X):-#count{V : a(V,U)}>100, b(X), #count{V : a(V)}>100.")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("c(X):-#count{V : a(V,U)}>100, b(X).c(X):-#count{V : a(V)}>100, b(X).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("q.r(\"\").~q(1) :- r(1).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void arityErrorConstraintTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Arity error constraint test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram(":-a(X,Y), b(X), a(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1).:-a(X,Y), b(X).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1).:-#count{V : a(V,U)}>100, b(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":-#count{V : a(V,U)}>100, a(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":-#count{V : a(V,U)}>100, b(T).:-#count{V : a(V)}>100, b(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void arityErrorWeakConstraintTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Arity error weak-constraint test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram(":~a(X,Y), b(X), a(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1).:~a(X,Y), b(X).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1).:~ #count{V : a(V,U)}>100, b(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ #count{V : a(V,U)}>100, a(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ #count{V : a(V,U)}>100, b(T).:~ #count{V : a(V)}>100, b(T).")).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyErrorRuleTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(Y).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((!(p.getSafetyErrors().get(0) instanceof SafetyWarning) ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- b(${getString()}).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(0) instanceof SafetyWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- X=2.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- X=${getSTring()}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(0) instanceof SafetyWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- 2=X.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- 2=${getSTring()}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(0) instanceof SafetyWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(Y) :- Y=X, X=3.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(Y) :- Y=X, X=${getString()}.");
        System.out.println(p.getSafetyErrors().size());
        Assert.assertTrue((p.getSafetyErrors().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(0) instanceof SafetyWarning));
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(1) instanceof SafetyWarning));
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(2) instanceof SafetyWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(2).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(Y) :- Y=X, ${getString()}=X.")).getSafetyErrors().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(0) instanceof SafetyWarning));
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(1) instanceof SafetyWarning));
        Assert.assertTrue((boolean)(p.getSafetyErrors().get(2) instanceof SafetyWarning));
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(2).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(Y) :- Y=X, 3=X.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":- not a(_).");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0).getMessage());
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- X=Y.")).getSafetyErrors().size() == 3 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0).getMessage());
            System.out.println(p.getSafetyErrors().get(1).getMessage());
            System.out.println(String.valueOf(p.getSafetyErrors().get(2).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- X=2+4.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(Y) :- Y=X, X=3+4.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(Y) :- Y=3+X, 3=X.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(Y) :- Y=X+Z, 3=X, Z=6.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(Y) :- Y=X+Z, 3=X, Z=6+U, 5=U.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(Z) :- Y=X+Z, 3=X, Z=6+U, U=5.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) v a(Y) :- b(X).");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- X=#count{Z : r(Z), a(Z, V)}.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- #count{Z : r(Z), a(Z, V)}=X.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- Y=X+3, #count{Z : r(Z), a(Z, V)}=X.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- Y=X+T, #count{Z : r(Z), a(Z, V)}=X, T = #count{Z1 : c(Z1), d(Z1, V1)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a :- #count{Y : b(X, X, Y)} <= 1, #count{X1 : c(X1, X1, Y)} <= 1.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- Y=X+T, #count{Z : r(Z), a(Z, V)}=X, T < #count{Z1 : c(Z1), d(Z1, V1)}.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ #count{X, Y : b(X, Y, Z)} <= 1, a(T). [X:]")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- not b(X).")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        p = this.getProgram("a(X) :- c(X), not b(${getString()}).");
        System.out.println(p.getSafetyErrors().size());
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), -b(U).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(U) :- c(X), -b(U).");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- c(X), H>2.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), X=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), X>Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), X<Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), X>=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), X<=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), H>V.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X) :- c(X), d(Y), X<=Y.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- c(X), 2=Y.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- c(X), Y=2.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- c(X), 2=Y+X.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- c(X), 2=Y+H.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        p = this.getProgram("a(X) :- c(X), Y=Y+H.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void safetyAggregateErrorRuleTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule with aggregates test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("c(X):- X = #count {T: b(T,Y), T > Y}, a(Z).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} = 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} > 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 <= #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} > VAR.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} < VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), #max{Z : r(Z), a(Z, V)} <= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("p(X) :- q(X, Y, V), VAR1 > #max{Z : r(Z), a(Z, V)} > VAR2.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{Z : r( X ,Z )}, c(VAR).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{VAR : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 ), c(VAR3)}, c(X).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("a(X):- 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 )}, c(X).");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(X):- 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(Y):- 10>#count{X : r( X ,Z )}, c(Y), b(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1, 5) :- 12 <= #count{X5 : newPredicate(X5)} <= 15, a(X5,8).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyAggregateConjunction() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule with aggregates test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram("a(1,5):- 12 = #count {X0: newPredicate(X0), H=P}.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram("a(1,5):- 12 = #count {X0: newPredicate(X0), H=2}.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram("c(aX) :- UK = #count{X : not a(Y), b(X)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyAggregateErrorWeakConstraintTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error rule with aggregates test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} = VAR.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} = 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 = #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} > 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 <= #max{Z : r(Z), a(Z, V)}.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), 10 < #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), VAR = #max{Z : r(Z), a(Z, V)} >= 10.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} > VAR.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} < VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} >= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), #max{Z : r(Z), a(Z, V)} <= VAR.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ q(X, Y, V), VAR1 > #max{Z : r(Z), a(Z, V)} > VAR2.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{VAR : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 ), c(VAR3)}, c(X).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ 10>#count{VAR1, VAR2, VAR3 : r( VAR1 , VAR2 )}, c(X).");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{X : r( X ,Z )}, c(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ 10>#count{X : r( X ,Z )}, c(Y), b(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void safetyErrorWeakConstraintTest() throws UnsupportedEncodingException, ParseException {
        Program p;
        if (this.trace) {
            System.out.println("-------   Safety error weak-constraint test   ---------");
        }
        Assert.assertTrue(((p = this.getProgram(":~ a(Y), not b(X).")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), -b(U).")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), H>2.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X=X1.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X>Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X<Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X>=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), X<=Y.")).getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), H>V.")).getSafetyErrors().size() == 2 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(p.getSafetyErrors().get(0));
            System.out.println(String.valueOf(p.getSafetyErrors().get(1).getMessage()) + '\n');
        }
        Assert.assertTrue(((p = this.getProgram(":~ c(X), d(Y), X<=Y.")).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), 2=Y.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), Y=2.");
        Assert.assertTrue((p.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), 2=Y+X.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), 2=Y+H.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        p = this.getProgram(":~ c(X), Y=Y+H.");
        Assert.assertTrue((p.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testOutput() throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        this.getOutput("{a,b,c,g(1,2),f(6,a,\"ee\")}");
        this.getOutput("{}");
    }

    @Test
    public void testOutputListTest() throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        Program p = this.getOutput("{a(x,1), a(y,2), aNext(1,2), aNotMin(2), aMin(1), aNotMax(1), aMax(2), partialAList(1,[x,y]), partialAList(2,[y])}");
    }

    @Test(expected=ParseException.class)
    public void testOutputException1() throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        this.getOutput("sample");
    }

    @Test(expected=ParseException.class)
    public void testOutputException2() throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        this.getOutput("{ a,b,c");
    }

    @Test
    public void queryParserTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(X),b(X),c(X),gg(X),b(X),m(X),a(X),b(X),c(X),gg(X),b(X), m(X)?");
        p = this.getProgram("not a(X), b(X)?");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("not a(X), b(X)?"));
        p = this.getProgram("X=#count{V: a(V), b(H)}?");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("X = #count{V : a(V), b(H)}?"));
    }

    @Test
    public void ruleLocalizerTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("\n\n   %COMMENT\n");
        Assert.assertTrue((((Expression)p.get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndColumn() == 12 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   predicateName\n(X)\n:-b(X)\n     .\n");
        Assert.assertTrue((((Expression)p.get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndLine() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndColumn() == 6 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   predicateName\n\n\n     .\n");
        Assert.assertTrue((((Expression)p.get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndLine() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndColumn() == 6 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   :-\npredicateName\n\n\n     .\n");
        Assert.assertTrue((((Expression)p.get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndLine() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndColumn() == 6 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   predicateName\n(X),\np(Y)\n     ?\n");
        Assert.assertTrue((((Expression)p.get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndLine() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndColumn() == 6 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   :~\npredicateName\n(X)\n\n     .\n");
        Assert.assertTrue((((Expression)p.get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndLine() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((((Expression)p.get(0)).getEndColumn() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void atomLocalizerTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("\n\n   predicateName(1).\n");
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomEndColumn() == 16 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   predicateName(X).\n");
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomBeginColumn() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(0)).getAtomEndColumn() == 16 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   predicateName(1) v predicateName(2) :- a.\n");
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomBeginColumn() == 23 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomEndColumn() == 35 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   predicateName(1) v predicateName(X) :- a.\n");
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomBeginColumn() == 23 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(0)).head().get(1)).getAtomEndColumn() == 35 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   a(1) v a(2) :- predicateName(1).\n");
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomBeginColumn() == 19 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomEndColumn() == 31 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   a(1) v a(2) :- predicateName(X).\n");
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomBeginColumn() == 19 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getAtomEndColumn() == 31 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   a(1) v a(2) :- predicateName(1), predicateName2(1).\n");
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginColumn() == 37 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndColumn() == 50 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   a(1) v a(2) :- predicateName(1), predicateName2(X).\n");
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginColumn() == 37 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndColumn() == 50 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   :- X = #count{V : predicateName(V)}.\n");
        AggregateAtom aggregateAtom = (AggregateAtom)((Literal)((Rule)p.get(0)).body().get(0)).getAtom();
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomBeginColumn() == 22 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomEndColumn() == 34 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   :- X = #count{V : predicateName(V), predicateName2(V)}, predicateName(V).\n");
        aggregateAtom = (AggregateAtom)((Literal)((Rule)p.get(0)).body().get(0)).getAtom();
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomBeginColumn() == 40 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomEndColumn() == 53 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginColumn() == 60 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndColumn() == 72 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   :- #count{V : predicateName(V)}=X.\n");
        aggregateAtom = (AggregateAtom)((Literal)((Rule)p.get(0)).body().get(0)).getAtom();
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomBeginColumn() == 18 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(0)).getAtom().getAtomEndColumn() == 30 ? 1 : 0) != 0);
        p = this.getProgram("\n\n   :- #count{V : predicateName(V), predicateName2(V)} = X ,predicateName(V).\n");
        aggregateAtom = (AggregateAtom)((Literal)((Rule)p.get(0)).body().get(0)).getAtom();
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomBeginColumn() == 36 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)aggregateAtom.getBody().get(1)).getAtom().getAtomEndColumn() == 49 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomBeginColumn() == 60 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getAtomEndColumn() == 72 ? 1 : 0) != 0);
    }

    @Test
    public void variableLocalizerTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("\n\n   predicateName(VAR, VAR2) v predicateName2(VAR, VAR2).\n");
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(0)).getBeginColumn() == 18 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(0)).getEndColumn() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(1)).getBeginColumn() == 23 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(0)).getVariables().get(1)).getEndColumn() == 26 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(0)).getBeginColumn() == 46 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(0)).getEndColumn() == 48 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(1)).getBeginColumn() == 51 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Atom)((Rule)p.get(0)).head().get(1)).getVariables().get(1)).getEndColumn() == 54 ? 1 : 0) != 0);
        p = this.getProgram("\n\n  a(X):- predicateName(VAR, VAR2), predicateName2(VAR, VAR2).\n");
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(0)).getBeginColumn() == 24 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(0)).getEndColumn() == 26 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(1)).getBeginColumn() == 29 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(0)).getAtom().getVariables().get(1)).getEndColumn() == 32 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(0)).getBeginColumn() == 51 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(0)).getEndColumn() == 53 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(1)).getBeginColumn() == 56 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)((Rule)p.get(0)).body().get(1)).getAtom().getVariables().get(1)).getEndColumn() == 59 ? 1 : 0) != 0);
        p = this.getProgram("\n\n:-a(X),LGUARD<  #count{VAR, VAR2 : predicateName(VAR, VAR2), predicateName2(VAR)} < UGUARD ,predicateName(VAR3).\n");
        AggregateAtom aggregateAtom = (AggregateAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom();
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getLowerGuard()).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getLowerGuard()).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getLowerGuard()).getBeginColumn() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getLowerGuard()).getEndColumn() == 13 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(0)).getBeginColumn() == 24 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(0)).getEndColumn() == 26 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(1)).getBeginColumn() == 29 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getVariables().get(1)).getEndColumn() == 32 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(0)).getBeginColumn() == 50 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(0)).getEndColumn() == 52 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(1)).getBeginColumn() == 55 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(0)).getVariables().get(1)).getEndColumn() == 58 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(1)).getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(1)).getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(1)).getVariables().get(0)).getBeginColumn() == 77 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((Literal)aggregateAtom.getBody().get(1)).getVariables().get(0)).getEndColumn() == 79 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getUpperGuard()).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getUpperGuard()).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getUpperGuard()).getBeginColumn() == 85 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)aggregateAtom.getUpperGuard()).getEndColumn() == 90 ? 1 : 0) != 0);
        p = this.getProgram("\n\na(VAR) :-   predicateName(VAR, VAR2), VAR2=10.");
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginColumn() == 39 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndColumn() == 42 ? 1 : 0) != 0);
        p = this.getProgram("\n\na(VAR) :-   predicateName(VAR, VAR2), 10=VAR2.");
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginColumn() == 42 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndColumn() == 45 ? 1 : 0) != 0);
        p = this.getProgram("\n\na(VAR) :-   predicateName(VAR, VAR2), VAR=VAR2.");
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginColumn() == 39 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndColumn() == 41 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginColumn() == 43 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndColumn() == 46 ? 1 : 0) != 0);
        p = this.getProgram("\n\na(VAR) :-   predicateName(VAR, VAR2), VAR=VAR2, VAR3>VAR4.");
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginColumn() == 39 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndColumn() == 41 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginColumn() == 43 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndColumn() == 46 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(0)).getBeginColumn() == 49 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(0)).getEndColumn() == 52 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(1)).getBeginColumn() == 54 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(2)).getAtom()).getAttrs().get(1)).getEndColumn() == 57 ? 1 : 0) != 0);
        p = this.getProgram("\n\na(VAR) :-   predicateName(VAR, VAR2, VARI4), VAR1=VAR2+VARI4.");
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getBeginColumn() == 46 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(0)).getEndColumn() == 49 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getBeginColumn() == 51 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(1)).getEndColumn() == 54 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(2)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(2)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(2)).getBeginColumn() == 56 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom()).getAttrs().get(2)).getEndColumn() == 60 ? 1 : 0) != 0);
        p = this.getProgram("\n\n:-a(X),LGUARD<  #count{VAR, VAR2 : predicateName(VAR, VAR2), VAR>VAR2} < UGUARD ,predicateName(VAR3).\n");
        aggregateAtom = (AggregateAtom)((Literal)((Rule)p.get(0)).body().get(1)).getAtom();
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(0).getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(0).getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(0).getVariables().get(0)).getBeginColumn() == 62 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(0).getVariables().get(0)).getEndColumn() == 64 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(1).getVariables().get(0)).getBeginLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(1).getVariables().get(0)).getEndLine() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(1).getVariables().get(0)).getBeginColumn() == 66 ? 1 : 0) != 0);
        Assert.assertTrue((((SimpleTerm)((NormalAtom)((Literal)aggregateAtom.getBody().get(1)).getAtom()).getAttrs().get(1).getVariables().get(0)).getEndColumn() == 69 ? 1 : 0) != 0);
        p = this.getProgram("\n\na(VAR) :-   predicateName(VAR, VAR2), VAR2=10.\npred2(4).\n");
        Assert.assertTrue((((Atom)((Rule)p.get(1)).head().get(0)).getAtomBeginLine() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(1)).head().get(0)).getAtomEndLine() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(1)).head().get(0)).getAtomBeginColumn() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Atom)((Rule)p.get(1)).head().get(0)).getAtomEndColumn() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void cloneTest() throws UnsupportedEncodingException, ParseException {
        Rule r = new Rule("a(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):-b(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- -b(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2):-b(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- not b(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- not -b(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(VAR,VAR2,VAR3).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(const1, const2).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(const1, const2), X=Y.");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(const1, const2), X>=Y.");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(const1, const2), X<=Y.");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(const1, const2), X<Y.");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X,u,2) v c(U):-b(X), a(const1, const2), X>Y.");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- 10>#count{X : r( X ,Z )}, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- #count{X : r( X ,Z )} >56, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- 10=#count{X : r( X ,Z )}, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- #count{X : r( X ,Z )} =56, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- 10>=#count{X : r( X ,Z )}, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- #count{X : r( X ,Z )} >=56, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- 12 > #count{X : r( X ,Z )} >56, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- 10=#count{X : r( X ,Z )}, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- X>=#count{X : r( X ,Z )} =56, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- 10>=#count{X : r( X ,Z )}>=H, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        r = new Rule("a(X):- R<= #count{X : r( X ,Z )} >=56, c(X).");
        Assert.assertTrue((boolean)r.toString().equals(r.clone().toString()));
        Program p = this.getProgram("a(X2) :- X2 = #sum{Y6 : stadio(X1, Y5, Y6), stadioScelto(X1)}.");
        System.out.println(p);
    }

    @Test
    public void metainfoTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgramWithAnnotations("% @start-program-comment\n% program comment line 1\n% program comment line 2\n% @end-program-comment\n% @start-comment\n% simple comment line 1\na(X):-b(X).\n% simple comment line 2\naa(XX):-bb(XX).\n% @end-comment\n% @start-comment\n% simple query line 1\nb(1), b(4)?\n% simple query line 2\n% @end-comment\n% @start-comment\n% simple weak line 1\n:~ b(1), b(4).\n% simple weak line 2\n% @end-comment\n% @schema predicateName(attr1:ANY, attr2, attr3:ANY:VARCHAR(255))\n");
        Assert.assertTrue((boolean)p.getProgramComment().getComment().equals("program comment line 1\nprogram comment line 2"));
        Assert.assertTrue((boolean)((Rule)p.get(6)).getComment().getContent().equals("simple comment line 1\nsimple comment line 2"));
        Assert.assertTrue((boolean)((Rule)p.get(8)).getComment().getContent().equals("simple comment line 1\nsimple comment line 2"));
        Assert.assertTrue((((Rule)p.get(6)).getComment() == ((Rule)p.get(8)).getComment() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Query)p.get(12)).getComment().getContent().equals("simple query line 1\nsimple query line 2"));
        Assert.assertTrue((boolean)((WeakConstraint)p.get(17)).getComment().getContent().equals("simple weak line 1\nsimple weak line 2"));
        Assert.assertTrue((boolean)p.getSchemaDirectives().get("predicateName").get(0).getSchemaAsString().equals("predicateName(attr1:ANY, attr2:ANY, attr3:ANY:VARCHAR(255))"));
        p = this.getProgram("% @name=regola 1\na(X):-b(X).\n% @name=regola 2\na(X):-b(X).\n% @name=query 1\nb(X)?\n% @name=weak 1\n:~b(X).\n");
        Assert.assertTrue((boolean)((Rule)p.get(1)).getName().equals("regola 1"));
        Assert.assertTrue((boolean)((Rule)p.get(3)).getName().equals("regola 2"));
        Assert.assertTrue((boolean)((Query)p.get(5)).getName().equals("query 1"));
        Assert.assertTrue((boolean)((WeakConstraint)p.get(7)).getName().equals("weak 1"));
    }

    @Test
    public void schemaAnnotationTest() throws UnsupportedEncodingException, ParseException {
        String dir1 = "@schema ciccio(attribute1:ANY, attribute2:String)\n";
        Schema schema1 = Schema.getSchema(dir1);
        Assert.assertTrue((schema1.getArity() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)schema1.getAttributes().get(0).getName(), (Object)"attribute1");
        Assert.assertEquals((Object)schema1.getAttributes().get(1).getDatatype().getName(), (Object)"String");
        Assert.assertNull((Object)schema1.getAttributes().get(1).getOriginalDatatype());
        String dir2 = "@schema ciccio(attribute0:Date, attribute1:ANY:INT, attribute2:String:VARCHAR(255), attribute3:String:VARCHAR(350,329))";
        Schema schema2 = Schema.getSchema(dir2);
        Assert.assertTrue((schema2.getArity() == 4 ? 1 : 0) != 0);
        Assert.assertNull((Object)schema2.getAttributes().get(0).getOriginalDatatype());
        Assert.assertEquals((Object)schema2.getAttributes().get(1).getDatatype().getName(), (Object)"ANY");
        Assert.assertEquals((Object)schema2.getAttributes().get(1).getOriginalDatatype().getName(), (Object)"INT");
        Assert.assertTrue((schema2.getAttributes().get(1).getOriginalDatatype().getPrecision() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((schema2.getAttributes().get(1).getOriginalDatatype().getScale() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)schema2.getAttributes().get(2).getOriginalDatatype().getName(), (Object)"VARCHAR");
        Assert.assertTrue((schema2.getAttributes().get(2).getOriginalDatatype().getPrecision() == 255 ? 1 : 0) != 0);
        Assert.assertTrue((schema2.getAttributes().get(2).getOriginalDatatype().getScale() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)schema2.getAttributes().get(3).getOriginalDatatype().getName(), (Object)"VARCHAR");
        Assert.assertTrue((schema2.getAttributes().get(3).getOriginalDatatype().getPrecision() == 350 ? 1 : 0) != 0);
        Assert.assertTrue((schema2.getAttributes().get(3).getOriginalDatatype().getScale() == 329 ? 1 : 0) != 0);
    }

    @Test
    public void unusedPredicateTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(true).\nb(X,1) v c(X):- a(X).\na(X)?");
        Assert.assertTrue((boolean)p.getUnusedPredicate().isEmpty());
        p = this.getProgram("a(true).\nb(X,1) v c(X):- a(X).\nunusedPredicate(X)?");
        Assert.assertTrue((p.getUnusedPredicate().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p.getUnusedPredicate().get(0).getName().equals("unusedPredicate"));
        p = this.getProgram("a(true).\nb(X,1) v c(X):- unusedPredicate(X).\n:-unusedPredicate(X).");
        Assert.assertTrue((p.getUnusedPredicate().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p.getUnusedPredicate().get(0).getName().equals("unusedPredicate"));
    }

    @Test
    public void factsShortcutTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("predicateName(1..455).");
        Assert.assertTrue((boolean)((Rule)p.get(0)).isFact());
        Assert.assertTrue((boolean)((NormalAtom)((Rule)p.get(0)).head().get(0)).isFactsShortcut());
        Assert.assertTrue((((NormalAtom)((Rule)p.get(0)).head().get(0)).arity() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((NormalAtom)((Rule)p.get(0)).head().get(0)).getName().equals("predicateName"));
        Assert.assertTrue((boolean)((Rule)p.get(0)).toString().equals("predicateName(1..455)."));
    }

    @Test
    public void directiveTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("#maxint=19.\n#include<string_lib>.\n#import(testodbc,\"dlvodbc\",\"password\",\"SELECT * FROM p\",predicateName).\n#import (cdt,\"dlv_test\",\"dlvtest\",\"SELECT dimension_name FROM dimension d JOIN tree t ON d.tree_id=t.tree_id WHERE t.tree_id=2\", dimension, type: CONST).\n#import (cdt,\"dlv_test\",\"dlvtest\",\"SELECT dimension_name FROM dimension d JOIN tree t ON d.tree_id=t.tree_id WHERE t.tree_id=2\", dimension, type: CONST, U_INT, UT_INT).\n#export(databasename, \"username\", \"password\", predname, tablename).\n#export(databasename, \"username\", \"password\", predname, tablename, \"REPLACE where SQL-Condition\").\n#const rate = 5.\n#const new_rate = rate.");
        Assert.assertTrue((boolean)(p.get(0) instanceof MaxIntDirective));
        Assert.assertTrue((boolean)((Directive)p.get(0)).getName().equals("maxint"));
        Assert.assertTrue((((MaxIntDirective)p.get(0)).getMaxIntValue() == 19 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("#maxint = 19."));
        Assert.assertTrue((boolean)(p.get(1) instanceof IncludeDirective));
        Assert.assertTrue((boolean)((IncludeDirective)p.get(1)).getIncludeValue().equals("string_lib"));
        Assert.assertTrue((boolean)((IncludeDirective)p.get(1)).getName().equals("include"));
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("#include<string_lib>."));
        Assert.assertTrue((boolean)(p.get(2) instanceof ImportDirective));
        Assert.assertTrue((boolean)((Expression)p.get(2)).toString().equals("#import(testodbc, \"dlvodbc\", \"password\", \"SELECT * FROM p\", predicateName)."));
        Assert.assertTrue((boolean)((ImportDirective)p.get(2)).getDatabaseName().equals("testodbc"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(2)).getUsername().equals("dlvodbc"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(2)).getPassword().equals("password"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(2)).getQuery().equals("SELECT * FROM p"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(2)).getPredicateName().equals("predicateName"));
        Assert.assertTrue((boolean)(p.get(3) instanceof ImportDirective));
        Assert.assertTrue((boolean)((Expression)p.get(3)).toString().equals("#import(cdt, \"dlv_test\", \"dlvtest\", \"SELECT dimension_name FROM dimension d JOIN tree t ON d.tree_id=t.tree_id WHERE t.tree_id=2\", dimension, type: CONST)."));
        Assert.assertTrue((boolean)((ImportDirective)p.get(3)).getDatabaseName().equals("cdt"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(3)).getUsername().equals("dlv_test"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(3)).getPassword().equals("dlvtest"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(3)).getQuery().equals("SELECT dimension_name FROM dimension d JOIN tree t ON d.tree_id=t.tree_id WHERE t.tree_id=2"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(3)).getPredicateName().equals("dimension"));
        Assert.assertTrue((((ImportDirective)p.get(3)).getTypes().get(0) == ImportDirective.ImportDirectiveTypes.CONST ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.get(4) instanceof ImportDirective));
        Assert.assertTrue((boolean)((Expression)p.get(4)).toString().equals("#import(cdt, \"dlv_test\", \"dlvtest\", \"SELECT dimension_name FROM dimension d JOIN tree t ON d.tree_id=t.tree_id WHERE t.tree_id=2\", dimension, type: CONST, U_INT, UT_INT)."));
        Assert.assertTrue((boolean)((ImportDirective)p.get(4)).getDatabaseName().equals("cdt"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(4)).getUsername().equals("dlv_test"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(4)).getPassword().equals("dlvtest"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(4)).getQuery().equals("SELECT dimension_name FROM dimension d JOIN tree t ON d.tree_id=t.tree_id WHERE t.tree_id=2"));
        Assert.assertTrue((boolean)((ImportDirective)p.get(4)).getPredicateName().equals("dimension"));
        Assert.assertTrue((((ImportDirective)p.get(4)).getTypes().get(0) == ImportDirective.ImportDirectiveTypes.CONST ? 1 : 0) != 0);
        Assert.assertTrue((((ImportDirective)p.get(4)).getTypes().get(1) == ImportDirective.ImportDirectiveTypes.U_INT ? 1 : 0) != 0);
        Assert.assertTrue((((ImportDirective)p.get(4)).getTypes().get(2) == ImportDirective.ImportDirectiveTypes.UT_INT ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(p.get(5) instanceof ExportDirective));
        Assert.assertTrue((boolean)((Expression)p.get(5)).toString().equals("#export(databasename, \"username\", \"password\", predname, tablename)."));
        Assert.assertTrue((boolean)((ExportDirective)p.get(5)).getDatabaseName().equals("databasename"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(5)).getUsername().equals("username"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(5)).getPassword().equals("password"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(5)).getPredicateName().equals("predname"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(5)).getTableName().equals("tablename"));
        Assert.assertTrue((boolean)(p.get(6) instanceof ExportDirective));
        System.out.println(p.get(6));
        Assert.assertTrue((boolean)((Expression)p.get(6)).toString().equals("#export(databasename, \"username\", \"password\", predname, tablename, \"REPLACE where SQL-Condition\")."));
        Assert.assertTrue((boolean)((ExportDirective)p.get(6)).getDatabaseName().equals("databasename"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(6)).getUsername().equals("username"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(6)).getPassword().equals("password"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(6)).getPredicateName().equals("predname"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(6)).getTableName().equals("tablename"));
        Assert.assertTrue((boolean)((ExportDirective)p.get(6)).getReplaceQuery().equals("REPLACE where SQL-Condition"));
        Assert.assertTrue((boolean)(p.get(7) instanceof ConstDirective));
        Assert.assertTrue((boolean)((Directive)p.get(7)).getName().equals("const"));
        Assert.assertTrue((boolean)((ConstDirective)p.get(7)).getNamedConstant().equals("rate"));
        Assert.assertTrue((boolean)((ConstDirective)p.get(7)).getConstant().equals("5"));
        Assert.assertTrue((boolean)((Expression)p.get(7)).toString().equals("#const rate = 5."));
        Assert.assertTrue((boolean)(p.get(8) instanceof ConstDirective));
        Assert.assertTrue((boolean)((Directive)p.get(8)).getName().equals("const"));
        Assert.assertTrue((boolean)((ConstDirective)p.get(8)).getNamedConstant().equals("new_rate"));
        Assert.assertTrue((boolean)((ConstDirective)p.get(8)).getConstant().equals("rate"));
        Assert.assertTrue((boolean)((Expression)p.get(8)).toString().equals("#const new_rate = rate."));
    }

    @Test
    public void directiveTest2() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(1).\n#maxint=19.\n");
        Assert.assertTrue((boolean)(p.get(0) instanceof Rule));
        Assert.assertTrue((boolean)(p.get(1) instanceof Directive));
        p = this.getProgram("#maxint = 24.\n    a(X).\n");
        Assert.assertTrue((boolean)(p.get(0) instanceof Directive));
        Assert.assertTrue((boolean)(p.get(1) instanceof Rule));
        Rule rule = (Rule)p.get(1);
        Assert.assertTrue((rule.getBeginLine() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((rule.getBeginColumn() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void commentiTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(1). %@schema\nrule.\n%@schema askjf\n");
    }

    @Test
    public void renameUnusedVariableTest() throws UnsupportedEncodingException, ParseException {
        Rule r = new Rule("a(X) :- b(X, Y).");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals("a(X) :- b(X, _)."));
        r = new Rule("a(X) :- b(Z, X, Y).");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals("a(X) :- b(_, X, _)."));
        r = new Rule("a(X) :- b(Z, X, Y), c(Z).");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals("a(X) :- b(Z, X, _), c(Z)."));
        r = new Rule(":- b(Z, X, X).");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals(":- b(_, X, X)."));
        r = new Rule(":- b(Z, X, X), Z>2.");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals(":- b(Z, X, X), Z > 2."));
        r = new Rule(":- b(Z, X, X, Y), Z>Y.");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals(":- b(Z, X, X, Y), Z > Y."));
        r = new Rule("a(Y,Y,Z):- #count{ X: b(X,Z)}=3, c(Y,Z).");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals("a(Y, Y, Z) :- #count{X : b(X, Z)} = 3, c(Y, Z)."));
        r = new Rule("a(1,1,Z):- #count{ X: b(X,Z)}=3, c(Y,Z).");
        r.renameUnusedVariables("_");
        Assert.assertTrue((boolean)r.toString().equals("a(1, 1, Z) :- #count{X : b(X, Z)} = 3, c(_, Z)."));
    }

    @Test
    public void safetyBuiltinRuleTest() throws UnsupportedEncodingException, ParseException {
        Rule r = new Rule(":- type(normal), sum(S), not #sum { A: num(I), size(N), D = N-I, J = D+1, sqr(I,J,A) } = S.");
        System.out.println(r);
        Assert.assertTrue((r.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
        r = new Rule("a:-X=Y+Z.");
        Assert.assertTrue((r.getSafetyErrors().size() > 0 ? 1 : 0) != 0);
        r = new Rule("d(1) :- #count{X : not a(X), c(X)}< 1.");
        Assert.assertTrue((r.getSafetyErrors().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void shiftRuleTest() throws UnsupportedEncodingException, ParseException {
        Rule r = new Rule("a(X) v b(X) :- c(X, Y).");
        List<Rule> shiftRules = r.shift();
        Assert.assertTrue((shiftRules.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)shiftRules.get(0).toString().equals("a(X) :- c(X, Y), not b(X)."));
        Assert.assertTrue((boolean)shiftRules.get(1).toString().equals("b(X) :- c(X, Y), not a(X)."));
        r = new Rule("a(1,2) v b(1,2,3) :- c(1, 3).");
        shiftRules = r.shift();
        Assert.assertTrue((shiftRules.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)shiftRules.get(0).toString().equals("a(1, 2) :- c(1, 3), not b(1, 2, 3)."));
        Assert.assertTrue((boolean)shiftRules.get(1).toString().equals("b(1, 2, 3) :- c(1, 3), not a(1, 2)."));
    }

    @Test
    public void trueFalseTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("true. a v false. false v true. a :- true, false. a:- false(X).");
    }

    @Test
    public void symbolFunctionTest() throws UnsupportedEncodingException, ParseException {
        this.getProgram("a(newid(X,Y)) :- b(X,Yuuu).");
    }

    @Test
    public void symbolFunctionSafetyTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(newid(X,Y)) :- b(X,Yuuu).");
        p = this.getProgram("a(newid(X,Y)):-b(X).");
        Rule rule = (Rule)p.get(0);
        Assert.assertTrue((rule.getSafetyErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getSafetyErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((rule = (Rule)(p = this.getProgram("b(X,Y):-a(newid(X,Y)).")).get(0)).getSafetyErrors().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void symbolFunctionParserTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(Y) :- Y = f(1).a(Y) :- Y = X.a(X) :- X = f(1) + f(2).");
        Assert.assertTrue((boolean)((Expression)p.get(0)).toString().equals("a(Y) :- Y = f(1)."));
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("a(Y) :- Y = X."));
        Assert.assertTrue((boolean)((Expression)p.get(2)).toString().equals("a(X) :- X = f(1) + f(2)."));
    }

    @Test
    public void symbolFunctionArityTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(newid(X,Y)) v a(newid(X)):- b(X,Y).");
        Rule rule = (Rule)p.get(0);
        Assert.assertTrue((rule.getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
        Assert.assertTrue(((rule = (Rule)(p = this.getProgram(":-a(newid(X,Y)), a(newid(X)).")).get(0)).getArityErrors().size() == 1 ? 1 : 0) != 0);
        if (this.trace) {
            System.out.println(p.toString());
            System.out.println(String.valueOf(p.getArityErrors().get(0).getMessage()) + '\n');
        }
    }

    @Test
    public void listTest() throws UnsupportedEncodingException, ParseException {
        Program p = this.getProgram("a(1).\nlista(a, [X, [Y, Z]]) :- a(X).");
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("lista(a, [X, [Y, Z]]) :- a(X)."));
        p = this.getProgram("a(1).\nlista([Y|[Z, V, V]]) :- a(X).");
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("lista([Y|[Z, V, V]]) :- a(X)."));
        p = this.getProgram("a(1).\nmultiSet({X,a,b,c}, X, [X]) :- a(X).");
        Assert.assertTrue((boolean)((Expression)p.get(1)).toString().equals("multiSet({X, a, b, c}, X, [X]) :- a(X)."));
    }

    @Test
    public void example1ListTest() throws ParseException, UnsupportedEncodingException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a( x, 1).\n");
        ruleCode.append("a( y, 2).\n");
        ruleCode.append("aNext(X,Y) :- a(_,X), a(_,Y), X<Y, not aNotNext(X,Y).\n");
        ruleCode.append("aNotNext(X,Y) :- a(_,X), a(_,Z), a(_,Y), X<Z, Z<Y.\n");
        ruleCode.append("aNotMin(X) :- aNext(_,X).\n");
        ruleCode.append("aMin(X) :- a(_,X), not aNotMin(X).\n");
        ruleCode.append("aNotMax(X) :- aNext(X,_).\n");
        ruleCode.append("aMax(X) :- a(_,X), not aNotMax(X).\n");
        ruleCode.append("partialAList(X,[Id]) :- aMax(X),a(Id,X).\n");
        ruleCode.append("partialAList(X,[Id|YL]) :- partialAList(Y,YL), aNext(X,Y), a(Id,X).\n");
        Program p = this.getProgram(ruleCode.toString());
    }

    @Test
    public void disjunctionTest() throws ParseException, UnsupportedEncodingException {
        this.getProgram("v(1) v v(2).");
    }

    @Test
    public void emptyBodyTest() throws ParseException, UnsupportedEncodingException {
        this.getProgram("v(1) v v(2) :- .");
    }

    @Test
    public void simpleBuiltInTest() throws ParseException, UnsupportedEncodingException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a(X) :- X > 3, X < Y, X <> Y, X != Y, X = 3.\n");
        Program p = this.getProgram(ruleCode.toString());
    }

    @Test
    public void arithmeticBuiltInTest() throws ParseException, UnsupportedEncodingException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a(X) :- X = Y + Z, X = Y - Z, X = Y * Z, X = Y / Z.\n");
        ruleCode.append("a(X) :- X += Y, X *= Y.\n");
        Program p = this.getProgram(ruleCode.toString());
    }

    @Test
    public void aggrRule() throws ParseException, UnsupportedEncodingException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append(":- X2 = #count{X1 : inUovo(X1), eSorpresa(X1)}, #int(X2), X2 <> 1.\n");
        ruleCode.append(":- #count{ I : inUovo(I, _, _), eSorpresa(I) } = X, #int(X), X != 1.\n");
        ruleCode.append("peso(T) :- #sum{ P, X : inUovo(X, _, P) } = T, #int(T).\n");
        Program p = this.getProgram(ruleCode.toString());
        System.out.println("Aggr : " + p.toString());
    }

    @Test
    public void aggregateTest() throws UnsupportedEncodingException, ParseException {
        StringBuffer ruleCode = new StringBuffer();
        ruleCode.append("a(X2) :- X2 = #sum{Y6 : stadio(X1, Y5, Y6), stadioScelto(X1)}.");
        Rule rule = (Rule)this.getProgram(ruleCode.toString()).get(0);
        Assert.assertTrue((boolean)(((Literal)rule.body().get(0)).getAtom() instanceof AggregateAtom));
        rule = (Rule)this.getProgram("a(X2) :- X2 = #int{Y6 : stadio(X1, Y5, Y6), stadioScelto(X1)}.").get(0);
        Assert.assertTrue((boolean)(((Literal)rule.body().get(0)).getAtom() instanceof AggregateAtom));
        Assert.assertTrue((boolean)((AggregateAtom)((Literal)rule.body().get(0)).getAtom()).getName().equals("#int"));
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private Program getProgramWithAnnotations(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.setParseAnnotation(true);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private Program getOutput(String code) throws UnsupportedEncodingException, ParseException, DLVInvocationException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        DLVInvocationImpl invocation = new DLVInvocationImpl();
        final Program p = new Program();
        FactHandler factHandler = new FactHandler(){

            @Override
            public void handleResult(DLVInvocation observed, FactResult result) {
                p.add(new Rule(String.valueOf(result.toString()) + "."));
            }
        };
        invocation.subscribe(factHandler);
        director.configureDlvInvocation(invocation);
        director.startOutput();
        return p;
    }
}

