/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.testing.Filter;
import it.unical.mat.dlv.testing.InputTest;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.TestInvocation;
import it.unical.mat.dlv.testing.TestSuite;
import it.unical.mat.dlv.testing.execution.DLVExceptionHandler;
import it.unical.mat.dlv.testing.execution.TestSuiteExecutor;
import it.unical.mat.wrapper.DLVInvocationException;
import it.unical.mat.wrapper.exception.ExecutableNotFoundInTestSuiteException;
import it.unical.mat.wrapper.exception.FileNotFoundInTestSuiteException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SelectRulesTestingTest {
    TestSuite testSuite;

    @Before
    public void initializeTest() throws FileNotFoundException {
        this.testSuite = new TestSuite(new TestInvocation("invoc", "C:/Users/Kristian/Documents/dottorato/programmi/DLV/dlv.mingw.exe", null));
    }

    @Test
    public void testSelectedRules() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(tutto).a(X) :- c(X).%@name = sempliceRegola \na(X) :- b(X).";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("sempliceFetta");
        InputTest inputTestCase = new InputTest(true);
        inputTestCase.getInputContent().setContent(this.getProgram("b(fetta)."));
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("sempliceRegola");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(fetta)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a(tutto)."));
        testCase1.addAssert(assert2TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesByPredicates() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "c(tutto).c(3).a(3) :- not c(3).a(4) :- c(4).a(X) :- b(X).c(X) :- b(X).c(X) :- X = #count{Z : k(Z)}.c(X) :- X = #count{Z : z(Z)}.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("in testa");
        InputTest inputTestCase = new InputTest(true);
        inputTestCase.getInputContent().setContent(this.getProgram("b(fetta)."));
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRulesWithPredicatesInHead("a");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("c(tutto)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("c(X)."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert3TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert3TestCase1.getExpectedOutput().setContent(this.getProgram("a(3)."));
        testCase1.addAssert(assert3TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestCase testCase2 = new TestCase("nel corpo");
        InputTest inputTestCase2 = new InputTest(true);
        inputTestCase2.getInputContent().setContent(this.getProgram("b(2)."));
        testCase2.addInputTest(inputTestCase2);
        testCase2.addSelectedRulesWithPredicatesInBody("b");
        testCase2.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase2.getExpectedOutput().setContent(this.getProgram("a(2)."));
        testCase2.addAssert(assert1TestCase2);
        it.unical.mat.dlv.testing.Assert assert2TestCase2 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert2TestCase2.getExpectedOutput().setContent(this.getProgram("a(3)."));
        testCase2.addAssert(assert2TestCase2);
        this.testSuite.addTestCase(testCase2);
        TestCase testCase3 = new TestCase("nel corpo positivo");
        InputTest inputTestCase3 = new InputTest(true);
        inputTestCase3.getInputContent().setContent(this.getProgram("c(4)."));
        testCase3.addInputTest(inputTestCase3);
        testCase3.addSelectedRulesWithPredicatesInPositiveBody("c");
        testCase3.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase3.getExpectedOutput().setContent(this.getProgram("a(4)."));
        testCase3.addAssert(assert1TestCase3);
        it.unical.mat.dlv.testing.Assert assert2TestCase3 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert2TestCase3.getExpectedOutput().setContent(this.getProgram("a(3)."));
        testCase3.addAssert(assert2TestCase3);
        this.testSuite.addTestCase(testCase3);
        TestCase testCase4 = new TestCase("nel corpo negativo");
        InputTest inputTestCase4 = new InputTest(true);
        inputTestCase4.getInputContent().setContent(this.getProgram("c(4)."));
        testCase4.addInputTest(inputTestCase4);
        testCase4.addSelectedRulesWithPredicatesInNegativeBody("c");
        testCase4.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase4 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert1TestCase4.getExpectedOutput().setContent(this.getProgram("a(4)."));
        testCase4.addAssert(assert1TestCase4);
        it.unical.mat.dlv.testing.Assert assert2TestCase4 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase4.getExpectedOutput().setContent(this.getProgram("a(3)."));
        testCase4.addAssert(assert2TestCase4);
        this.testSuite.addTestCase(testCase4);
        TestCase testCase5 = new TestCase("negli aggregati 1");
        InputTest inputTestCase5 = new InputTest(true);
        inputTestCase5.getInputContent().setContent(this.getProgram("k(1).z(1).z(2)."));
        testCase5.addInputTest(inputTestCase5);
        testCase5.addSelectedRulesWithPredicatesInAggregates("k");
        testCase5.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase5 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase5.getExpectedOutput().setContent(this.getProgram("c(1)."));
        testCase5.addAssert(assert1TestCase5);
        this.testSuite.addTestCase(testCase5);
        TestCase testCase6 = new TestCase("negli aggregati 2");
        InputTest inputTestCase6 = new InputTest(true);
        inputTestCase6.getInputContent().setContent(this.getProgram("k(1).z(1).z(2)."));
        testCase6.addInputTest(inputTestCase5);
        testCase6.addSelectedRulesWithPredicatesInAggregates("z");
        testCase6.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase6 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase6.getExpectedOutput().setContent(this.getProgram("c(2)."));
        testCase6.addAssert(assert1TestCase6);
        this.testSuite.addTestCase(testCase6);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(3).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(4).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesSplit() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "d(X) :- a(X). \ne(X) :- k(X), f(X). \na(X) :- c(X). \ne(tutto). f(tutto).%@name = primaRegola \na(X) :- b(X). \nc(X) :- e(X), f(Y). \n%@name = secondaRegola \nb(X) :- a(X). \n";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("soloFetta");
        InputTest inputTestCase = new InputTest(true);
        inputTestCase.getInputContent().setContent(this.getProgram("b(fetta)."));
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("primaRegola");
        testCase1.addSelectedRule("secondaRegola");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("a(fetta)."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("d(tutto)."));
        testCase1.addAssert(assert2TestCase1);
        TestCase testCase2 = new TestCase("fettaESplit");
        testCase2.addSelectedRule("primaRegola");
        testCase2.addSelectedRule("secondaRegola");
        testCase2.setExecuteOn(TestCase.ExecuteOn.SPLIT_PROGRAM);
        it.unical.mat.dlv.testing.Assert assert2TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase2.getExpectedOutput().setContent(this.getProgram("a(tutto)."));
        testCase2.addAssert(assert2TestCase2);
        it.unical.mat.dlv.testing.Assert assert33TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert33TestCase2.getExpectedOutput().setContent(this.getProgram("b(tutto)."));
        testCase2.addAssert(assert33TestCase2);
        it.unical.mat.dlv.testing.Assert assert3TestCase2 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert3TestCase2.getExpectedOutput().setContent(this.getProgram("d(tutto)."));
        testCase2.addAssert(assert3TestCase2);
        TestCase testCase3 = new TestCase("fettaNelTutto");
        testCase3.addSelectedRule("primaRegola");
        testCase3.addSelectedRule("secondaRegola");
        testCase3.setExecuteOn(TestCase.ExecuteOn.PROGRAM);
        it.unical.mat.dlv.testing.Assert assert2TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase3.getExpectedOutput().setContent(this.getProgram("a(tutto)."));
        testCase3.addAssert(assert2TestCase3);
        it.unical.mat.dlv.testing.Assert assert3TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert3TestCase3.getExpectedOutput().setContent(this.getProgram("d(tutto)."));
        testCase3.addAssert(assert3TestCase3);
        it.unical.mat.dlv.testing.Assert assert4TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert4TestCase3.getExpectedOutput().setContent(this.getProgram("b(tutto)."));
        testCase3.addAssert(assert4TestCase3);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesBadSliceSplit() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "f. \ne :- f. \nd :- e. \nc :- d. \n%@name = regolaAggiuntiva \na :- c. \n%@name = primaRegola \na :- b, c. \n%@name = secondaRegola \nb :- a. \n%@name = terzaRegola \nc :- b. \nk :- b. \n";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("fettaSbagliataSplit");
        testCase1.addSelectedRule("primaRegola");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SPLIT_PROGRAM);
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert1TestCase1.getExpectedOutput().setContent(this.getProgram("f.e.d.c."));
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert22TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert22TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert22TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("b. k."));
        testCase1.addAssert(assert2TestCase1);
        TestCase testCase2 = new TestCase("fettaCorrettaSplit");
        testCase2.addSelectedRule("primaRegola");
        testCase2.addSelectedRule("secondaRegola");
        testCase2.addSelectedRule("terzaRegola");
        testCase2.addSelectedRule("regolaAggiuntiva");
        testCase2.setExecuteOn(TestCase.ExecuteOn.SPLIT_PROGRAM);
        it.unical.mat.dlv.testing.Assert assert2TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase2.getExpectedOutput().setContent(this.getProgram("f.e.d.c.a.b."));
        testCase2.addAssert(assert2TestCase2);
        it.unical.mat.dlv.testing.Assert assert33TestCase2 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert33TestCase2.getExpectedOutput().setContent(this.getProgram("k."));
        testCase2.addAssert(assert33TestCase2);
        TestCase testCase3 = new TestCase("fettaSbagliataTutto");
        testCase3.addSelectedRule("primaRegola");
        testCase3.setExecuteOn(TestCase.ExecuteOn.PROGRAM);
        it.unical.mat.dlv.testing.Assert assert2TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase3.getExpectedOutput().setContent(this.getProgram("f.e.d.c.a.b.k."));
        testCase3.addAssert(assert2TestCase3);
        this.testSuite.addTestCase(testCase1);
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(2).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesSplitFiltering() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "f. b. \ne :- f. \nd :- e. \nc :- d. \n%@name = primaRegola \na :- b, c. \n%@name = secondaRegola \nb :- a. \nk :- b. \n";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase2 = new TestCase("fettaESplit");
        testCase2.addSelectedRule("primaRegola");
        testCase2.addSelectedRule("secondaRegola");
        testCase2.setExecuteOn(TestCase.ExecuteOn.SPLIT_PROGRAM);
        it.unical.mat.dlv.testing.Assert assert2TestCase2 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase2.getExpectedOutput().setContent(this.getProgram("a.b.c."));
        testCase2.addAssert(assert2TestCase2);
        it.unical.mat.dlv.testing.Assert assert33TestCase2 = new it.unical.mat.dlv.testing.Assert("assertFalse");
        assert33TestCase2.getExpectedOutput().setContent(this.getProgram("f.e."));
        testCase2.addAssert(assert33TestCase2);
        testCase2.setFilter(new Filter(Filter.TypeFilter.NORMAL, true));
        TestCase testCase3 = new TestCase("fettaNelTutto");
        testCase3.addSelectedRule("primaRegola");
        testCase3.addSelectedRule("secondaRegola");
        testCase3.setExecuteOn(TestCase.ExecuteOn.PROGRAM);
        it.unical.mat.dlv.testing.Assert assert2TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert2TestCase3.getExpectedOutput().setContent(this.getProgram("a.b.c."));
        testCase3.addAssert(assert2TestCase3);
        it.unical.mat.dlv.testing.Assert assert3TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert3TestCase3.getExpectedOutput().setContent(this.getProgram("f.e.d."));
        testCase3.addAssert(assert3TestCase3);
        it.unical.mat.dlv.testing.Assert assert4TestCase3 = new it.unical.mat.dlv.testing.Assert("assertTrue");
        assert4TestCase3.getExpectedOutput().setContent(this.getProgram("k."));
        testCase3.addAssert(assert4TestCase3);
        testCase3.setFilter(new Filter(Filter.TypeFilter.NORMAL, true));
        this.testSuite.addTestCase(testCase2);
        this.testSuite.addTestCase(testCase3);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestCaseExecutors().get(1).getTestCaseState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.FAILED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesCheckExactSplitPass() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \na v k :- b.b v z :- a, c.c :- a.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.setCheckDLPFunction(true);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                Assert.fail((String)("Unexpected Exception" + exception));
            }

            @Override
            public void handle(List<Exception> exceptions) {
                Assert.fail((String)("Unexpected Exception" + exceptions.get(0)));
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
    }

    @Test
    public void testSelectedRulesCheckExactSplitFail() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \n%@name = r3f1 \nw :- a. \na v k :- b.b v z :- a, c.c :- w.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.addSelectedRule("r3f1");
        testCase1.setCheckDLPFunction(true);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (!failure.failed) {
            Assert.fail((String)"No NotMutuallyIndependentDLPFunctions thrown");
        }
    }

    @Test
    public void testSelectedRulesCheckExactSplitInputPass() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \na v k :- b.b v z :- a, c.c :- a.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.setCheckDLPFunction(true);
        testCase1.addInputAtomDLPFunction(new NormalAtom("a"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("b"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("c"));
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Exception thrown");
        }
    }

    @Test
    public void testSelectedRulesCheckExactSplitInputFail() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \n%@name = r3f1 \nw :- a. \na v k :- b.b v z :- a, c.c :- w.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.addSelectedRule("r3f1");
        testCase1.setCheckDLPFunction(true);
        testCase1.addInputAtomDLPFunction(new NormalAtom("a"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("b"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("c"));
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (!failure.failed) {
            Assert.fail((String)"No NotMutuallyIndependentDLPFunctions thrown");
        }
    }

    @Test
    public void testSelectedRulesExecuteExactSplit1() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \na v k :- b.b v z :- a, c.c :- a.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        InputTest inputTestCase = new InputTest(true);
        inputTestCase.getInputContent().setContent(this.getProgram("b.c."));
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.setCheckDLPFunction(true);
        it.unical.mat.dlv.testing.Assert assert1TestCase1 = new it.unical.mat.dlv.testing.Assert("assertNumberModels");
        assert1TestCase1.setNumberModels(2);
        testCase1.addAssert(assert1TestCase1);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn");
        assert2TestCase1.setNumberModels(1);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        it.unical.mat.dlv.testing.Assert assert3TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn");
        assert3TestCase1.setNumberModels(1);
        assert3TestCase1.getExpectedOutput().setContent(this.getProgram("k."));
        testCase1.addAssert(assert3TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                exceptions.get(0).printStackTrace();
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Unexpected Exception");
        }
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesExecuteExactSplit2() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.a v k :- b.b v z :- a.k.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        InputTest inputTestCase = new InputTest(true);
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("r1");
        testCase1.addSelectedRule("r2");
        testCase1.addSelectedRule("r3");
        testCase1.setCheckDLPFunction(true);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn");
        assert2TestCase1.setNumberModels(1);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                exceptions.get(0).printStackTrace();
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Unexpected Exception");
        }
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesExecuteExactBadTestCaseInputFail() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \na v k :- b.b v z :- a, c.c :- a.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        InputTest inputTestCase = new InputTest(true);
        inputTestCase.getInputContent().setContent(this.getProgram("b.c.d."));
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.setCheckDLPFunction(true);
        testCase1.addInputAtomDLPFunction(new NormalAtom("a"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("b"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("z"));
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        failure.failed = true;
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = false;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = false;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Expected Bad Input for test case");
        }
    }

    @Test
    public void testSelectedRulesCheckExactSplitInputExclusionFail() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1f1 \na v k :- b. \n%@name = r2f1 \nb v z :- a, c. \na v k :- b.b v z :- a, c.c :- a.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        InputTest inputTestCase = new InputTest(true);
        inputTestCase.getInputContent().setContent(this.getProgram("b.c.d."));
        testCase1.addInputTest(inputTestCase);
        InputTest excludeInputTestCase = new InputTest(true);
        excludeInputTestCase.getInputContent().setContent(this.getProgram("d."));
        testCase1.addExcludeInputTest(excludeInputTestCase);
        testCase1.addSelectedRule("r1f1");
        testCase1.addSelectedRule("r2f1");
        testCase1.setCheckDLPFunction(true);
        testCase1.addInputAtomDLPFunction(new NormalAtom("a"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("b"));
        testCase1.addInputAtomDLPFunction(new NormalAtom("c"));
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Thrown Bad Input for test case");
        }
    }

    @Test
    public void testSelectedRulesCheckSplittingSetPass1() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.j.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("split");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        InputTest inputTestCase = new InputTest(true);
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("r1");
        testCase1.addSelectedRule("r2");
        testCase1.addSelectedRule("r3");
        testCase1.setCheckSplittingSet(true);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn");
        assert2TestCase1.setNumberModels(1);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                exceptions.get(0).printStackTrace();
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Unexpected Exception");
        }
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesCheckSplittingSetPass2() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.j.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("split");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        InputTest inputTestCase = new InputTest(true);
        testCase1.addInputTest(inputTestCase);
        testCase1.addSelectedRule("r1");
        testCase1.addSelectedRule("r2");
        testCase1.addSelectedRule("r3");
        testCase1.setCheckSplittingSet(true);
        testCase1.addAtomInSplittingSet(new NormalAtom("a"));
        testCase1.addAtomInSplittingSet(new NormalAtom("k"));
        testCase1.addAtomInSplittingSet(new NormalAtom("b"));
        testCase1.addAtomInSplittingSet(new NormalAtom("z"));
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueIn");
        assert2TestCase1.setNumberModels(1);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                exceptions.get(0).printStackTrace();
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Unexpected Exception");
        }
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesCheckSplittingSetPass3() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.j.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("split");
        InputTest inputTestCase = new InputTest(true);
        testCase1.addInputTest(inputTestCase);
        testCase1.setCheckSplittingSet(true);
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast");
        assert2TestCase1.setNumberModels(1);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                exceptions.get(0).printStackTrace();
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Unexpected Exception");
        }
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesCheckSplittingSetPass4() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.j.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("split");
        InputTest inputTestCase = new InputTest(true);
        testCase1.addInputTest(inputTestCase);
        testCase1.setCheckSplittingSet(true);
        testCase1.addAtomInSplittingSet(new NormalAtom("a"));
        testCase1.addAtomInSplittingSet(new NormalAtom("k"));
        testCase1.addAtomInSplittingSet(new NormalAtom("b"));
        testCase1.addAtomInSplittingSet(new NormalAtom("z"));
        testCase1.addAtomInSplittingSet(new NormalAtom("t1"));
        testCase1.addAtomInSplittingSet(new NormalAtom("t2"));
        testCase1.addAtomInSplittingSet(new NormalAtom("t3"));
        testCase1.addAtomInSplittingSet(new NormalAtom("j"));
        it.unical.mat.dlv.testing.Assert assert2TestCase1 = new it.unical.mat.dlv.testing.Assert("assertTrueInAtLeast");
        assert2TestCase1.setNumberModels(1);
        assert2TestCase1.getExpectedOutput().setContent(this.getProgram("a."));
        testCase1.addAssert(assert2TestCase1);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                exception.printStackTrace();
                failure.failed = true;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                exceptions.get(0).printStackTrace();
                failure.failed = true;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Unexpected Exception");
        }
        System.out.println(this.testSuite.toString());
        System.out.println((Object)executor.getTestSuiteState());
        System.out.println(executor.getFailedMotivation(false));
        Assert.assertTrue((executor.getTestCaseExecutors().get(0).getTestCaseState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
        Assert.assertTrue((executor.getTestSuiteState() == TestSuiteExecutor.TestState.PASSED ? 1 : 0) != 0);
    }

    @Test
    public void testSelectedRulesCheckSplittingSetFail1() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.b :- w.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        testCase1.addSelectedRule("r1");
        testCase1.addSelectedRule("r2");
        testCase1.addSelectedRule("r3");
        testCase1.setCheckSplittingSet(true);
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        failure.failed = true;
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = false;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = false;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Expected Bad Splitting set for test case");
        }
    }

    @Test
    public void testSelectedRulesCheckSplittingSetFail2() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.b :- w.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setExecuteOn(TestCase.ExecuteOn.SELECTED_RULES);
        testCase1.addSelectedRule("r1");
        testCase1.addSelectedRule("r2");
        testCase1.addSelectedRule("r3");
        testCase1.setCheckSplittingSet(true);
        testCase1.addAtomInSplittingSet(new NormalAtom("a"));
        testCase1.addAtomInSplittingSet(new NormalAtom("k"));
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        failure.failed = true;
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = false;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = false;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Expected Bad Splitting set for test case");
        }
    }

    @Test
    public void testSelectedRulesCheckSplittingSetFail3() throws DLVInvocationException, IOException, ParseException, FileNotFoundInTestSuiteException, ExecutableNotFoundInTestSuiteException {
        InputTest inputTest = new InputTest(true);
        String programCode = "%@name = r1 \na v k :- b.%@name = r2 \nb v z :- a.%@name = r3 \nb.t1 v t2 :- b.t3(4) :- z, a.b :- w.";
        inputTest.getInputContent().setContent(this.getProgram(programCode));
        this.testSuite.addInputTest(inputTest);
        TestCase testCase1 = new TestCase("function");
        testCase1.setCheckSplittingSet(true);
        testCase1.addAtomInSplittingSet(new NormalAtom("a"));
        testCase1.addAtomInSplittingSet(new NormalAtom("k"));
        this.testSuite.addTestCase(testCase1);
        TestSuiteExecutor executor = new TestSuiteExecutor(this.testSuite);
        final FailuerContainer failure = new FailuerContainer();
        failure.failed = true;
        executor.subscribeDLVExceptionHandler(new DLVExceptionHandler(){

            @Override
            public void handle(Exception exception) {
                failure.failed = false;
            }

            @Override
            public void handle(List<Exception> exceptions) {
                failure.failed = false;
            }
        });
        executor.setProgramInput();
        executor.setInvocation();
        executor.startTestSuiteExecution();
        executor.waitUntilTestExecutionFinishes();
        if (failure.failed) {
            Assert.fail((String)"Expected Bad Splitting set for test case");
        }
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder(builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }

    private class FailuerContainer {
        boolean failed = false;

        private FailuerContainer() {
        }
    }
}

