/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.testing.TestCase;
import it.unical.mat.dlv.testing.TestSuite;
import it.unical.mat.dlv.testing.parser.ParseException;
import it.unical.mat.dlv.testing.parser.TestParser;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class TestingParserTest {
    @Test
    public void directiveTest() throws Exception {
        String code = "invocation(\"name\");";
        TestSuite test = this.getTest(code);
        Assert.assertTrue((boolean)test.getInvocation().getName().equals("name"));
        code = "invocation(\"name\", \"executable\", \"options\");";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getInvocation().getName().equals("name"));
        Assert.assertTrue((boolean)test.getInvocation().getExecutable().equals("executable"));
        Assert.assertTrue((boolean)test.getInvocation().getOptions().equals("options"));
        code = "invocation(\"name\", \"executable\", \"options\");inputFile(\"pathFile\");";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getInputList().get(0).getInputContent().getContent().equals("pathFile"));
        code = "invocation(\"name\", \"executable\", \"options\");inputFile(\"pathFile1\");inputFile(\"pathFile2\");inputFile(\"pathFile3\");";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getInputList().get(0).getInputContent().getContent().equals("pathFile1"));
        Assert.assertTrue((boolean)test.getInputList().get(1).getInputContent().getContent().equals("pathFile2"));
        Assert.assertTrue((boolean)test.getInputList().get(2).getInputContent().getContent().equals("pathFile3"));
        code = "invocation(\"name\", \"executable\", \"options\");input(\"program.\");inputFile(\"pathFile\");";
        test = this.getTest(code);
        Assert.assertTrue((boolean)(test.getInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)test.getInputList().get(1).getInputContent().getContent().equals("pathFile"));
        code = "invocation(\"name\", \"executable\", \"options\");inputFile(\"pathFile1\");inputFile(\"pathFile2\");inputFile(\"pathFile3\");";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getInvocation().getName().equals("name"));
        Assert.assertTrue((boolean)test.getInvocation().getExecutable().equals("executable"));
        Assert.assertTrue((boolean)test.getInvocation().getOptions().equals("options"));
        Assert.assertTrue((boolean)test.getInputList().get(0).getInputContent().getContent().equals("pathFile1"));
        Assert.assertTrue((boolean)test.getInputList().get(1).getInputContent().getContent().equals("pathFile2"));
        Assert.assertTrue((boolean)test.getInputList().get(2).getInputContent().getContent().equals("pathFile3"));
    }

    @Test
    public void testCaseTest() throws Exception {
        String code = "invocation(\"name\", \"executable\", \"options\");test1(){ }";
        TestSuite test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(PROGRAM){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((!test.getTestCases().get(0).isIncludeComponentRulesInSlice() ? 1 : 0) != 0);
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(SPLIT_PROGRAM){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((!test.getTestCases().get(0).isIncludeComponentRulesInSlice() ? 1 : 0) != 0);
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES, SELECT_RULES_IN_SCC){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isIncludeComponentRulesInSlice());
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(PROGRAM, SELECT_RULES_IN_SCC){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isIncludeComponentRulesInSlice());
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(SPLIT_PROGRAM, SELECT_RULES_IN_SCC){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isIncludeComponentRulesInSlice());
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).isIncludeComponentRulesInSlice());
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(PROGRAM){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(SPLIT_PROGRAM){ }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM ? 1 : 0) != 0);
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ newOptions(\"new options\");}";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getNewOptions().equals("new options"));
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ inputFile(\"inputFile\");}";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputList().get(0).getInputContent().getContent().equals("inputFile"));
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ input(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ excludeInput(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ excludeInput(\"program.\"); checkModularity(SPLITTING_SET);}";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckSplittingSet());
        Assert.assertFalse((boolean)test.getTestCases().get(0).isCheckDLPFunction());
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ excludeInput(\"program.\"); checkModularity(SPLITTING_SET, \"a(1)\", \"a(2)\");}";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckSplittingSet());
        Assert.assertFalse((boolean)test.getTestCases().get(0).isCheckDLPFunction());
        Assert.assertTrue((test.getTestCases().get(0).getSplittingSet().size() == 2 ? 1 : 0) != 0);
        NormalAtom a1 = new NormalAtom("a");
        a1.addAttribute(new SimpleTerm("1"));
        NormalAtom a2 = new NormalAtom("a");
        a2.addAttribute(new SimpleTerm("2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSplittingSet().contains(a1));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSplittingSet().contains(a2));
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ excludeInput(\"program.\"); checkModularity(DLP_FUNCTION);}";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertFalse((boolean)test.getTestCases().get(0).isCheckSplittingSet());
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckDLPFunction());
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ excludeInput(\"program.\"); checkModularity(DLP_FUNCTION, \"a(1)\", \"a(2)\");checkModularity(SPLITTING_SET);}";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SELECTED_RULES ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckSplittingSet());
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckDLPFunction());
        Assert.assertTrue((test.getTestCases().get(0).getInputAtomsDLPFunction().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputAtomsDLPFunction().get(0).toString().trim().equals("a(1)"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputAtomsDLPFunction().get(1).toString().trim().equals("a(2)"));
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ checkModularity(DLP_FUNCTION, \"a(1)\", \"a(2)\");checkModularity(DLP_FUNCTION, \"a(1)\", \"a(2)\");}";
        try {
            test = this.getTest(code);
            Assert.fail((String)"Expected duplicate checkModularity");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Only one checkModularity referred to DLP-Functions is admitted", (Object)e.getMessage());
        }
        code = "invocation(\"name\", \"executable\", \"options\");test1(SELECTED_RULES){ checkModularity(SPLITTING_SET);checkModularity(SPLITTING_SET, \"a(1)\", \"a(2)\");}";
        try {
            test = this.getTest(code);
            Assert.fail((String)"Expected duplicate checkModularity");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"Only one checkModularity referred to splitting sets is admitted", (Object)e.getMessage());
        }
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertTrue(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertTrue"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertCautiouslyTrue(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertCautiouslyTrue"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertBravelyTrue(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertBravelyTrue"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertTrueIn(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertTrueIn"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertTrueInAtLeast(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertTrueInAtLeast"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertTrueInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertTrueInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertFalse(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalse"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertCautiouslyFalse(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertCautiouslyFalse"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertBravelyFalse(\"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertBravelyFalse"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertFalseIn(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseIn"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertFalseInAtLeast(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtLeast"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){ assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   selectRule(\"rule1\");    assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(0).equals("rule1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   selectRulesWithPredicateInHead(\"p1\");    assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRulesWithPredicatesInHead().get(0).equals("p1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   selectRulesWithPredicateInBody(\"p1\");    assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRulesWithPredicatesInBody().get(0).equals("p1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   selectRulesWithPredicateInPositiveBody(\"p1\");    assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRulesWithPredicatesInPositiveBody().get(0).equals("p1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   selectRulesWithPredicateInNegativeBody(\"p1\");    assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRulesWithPredicatesInNegativeBody().get(0).equals("p1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   selectRulesWithPredicateInAggregates(\"p1\");    assertFalseInAtMost(2, \"program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRulesWithPredicatesInAggregates().get(0).equals("p1"));
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   assertConstraint(\":- program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertConstraint"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals(":- program.\n"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   assertConstraintIn(2, \":- program.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertConstraintIn"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals(":- program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   assertConstraintInAtLeast(2, \":- program1, program2.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertConstraintInAtLeast"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals(":- program1, program2.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   assertConstraintInAtMost(2, \":- program1, program2.\"); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertConstraintInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals(":- program1, program2.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   assertNumberModels(3); }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertNumberModels"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() == null ? 1 : 0) != 0);
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
        code = "invocation(\"name\", \"executable\", \"options\");test1(){   assertNoModels; }";
        test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertNoModels"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() == null ? 1 : 0) != 0);
        Assert.assertFalse((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() >= 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)test.getTestCases().get(0).getAssertList().get(0).isConstraintType());
    }

    @Test
    public void globalAssertTest() throws Exception {
        String code = "invocation(\"name\", \"executable\", \"options\");test1(){  assertFalseInAtMost(2, \"program.\"); }assertFalseInAtMost(2, \"program.\");";
        TestSuite test = this.getTest(code);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getGlobalAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getGlobalAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getGlobalAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getGlobalAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void toStringTest() throws Exception {
        String code = "invocation(\"name\", \"executable\", \"options\");\ninput(\"program.\");\ninputFile(\"pathFile\");\ntest1(SPLIT_PROGRAM, SELECT_RULES_IN_SCC){ \n    newOptions(\"new options\");\n    inputFile(\"inputFile\");\n    input(\"program.\");\n    excludeInput(\"program.\");\n    filter(\"pred1, pred2, pred3\");\n    checkModularity(SPLITTING_SET, \"a(1)\", \"a(2)\");\n    checkModularity(DLP_FUNCTION, \"a(3)\", \"a(4)\");\n    selectRule(\"rule1\");\n    selectRule(\"rule2\");\n    assertFalseInAtMost(2, \"program.\");\n    assertBravelyFalse(\"program.\nprogram2.\");\n}\nassertFalseInAtMost(2, \"program.\");";
        TestSuite test = this.getTest(code);
        Assert.assertTrue((boolean)test.getInvocation().getName().equals("name"));
        Assert.assertTrue((boolean)test.getInvocation().getExecutable().equals("executable"));
        Assert.assertTrue((boolean)test.getInvocation().getOptions().equals("options"));
        Assert.assertTrue((boolean)(test.getInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)test.getInputList().get(1).getInputContent().getContent().equals("pathFile"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).isIncludeComponentRulesInSlice());
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputList().get(0).getInputContent().getContent().equals("inputFile"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getNewOptions().equals("new options"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getInputList().get(1).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputList().get(1).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getFilter().getPredicates().get(0).equals("pred1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getFilter().getPredicates().get(1).equals("pred2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getFilter().getPredicates().get(2).equals("pred3"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckDLPFunction());
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputAtomsDLPFunction().get(0).toString().equals("a(3)"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputAtomsDLPFunction().get(1).toString().equals("a(4)"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckSplittingSet());
        NormalAtom a1 = new NormalAtom("a");
        a1.addAttribute(new SimpleTerm("1"));
        NormalAtom a2 = new NormalAtom("a");
        a2.addAttribute(new SimpleTerm("2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSplittingSet().contains(a1));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSplittingSet().contains(a2));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(0).equals("rule1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(1).equals("rule2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(1).getName().equals("assertBravelyFalse"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(1).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(1).getExpectedOutput().getContent().toString().equals("program.\nprogram2.\n"));
        Assert.assertTrue((boolean)test.getGlobalAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getGlobalAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getGlobalAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getGlobalAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(0).equals("rule1"));
        System.out.println(test.toString());
        test = this.getTest(test.toString());
        Assert.assertTrue((boolean)test.getInvocation().getName().equals("name"));
        Assert.assertTrue((boolean)test.getInvocation().getExecutable().equals("executable"));
        Assert.assertTrue((boolean)test.getInvocation().getOptions().equals("options"));
        Assert.assertTrue((boolean)(test.getInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)test.getInputList().get(1).getInputContent().getContent().equals("pathFile"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getName().equals("test1"));
        Assert.assertTrue((test.getTestCases().get(0).getExecuteOn() == TestCase.ExecuteOn.SPLIT_PROGRAM ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputList().get(0).getInputContent().getContent().equals("inputFile"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getNewOptions().equals("new options"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getInputList().get(1).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputList().get(1).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getExcludeInputList().get(0).getInputContent().getContent().toString().equals("program.\n"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getFilter().getPredicates().get(0).equals("pred1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getFilter().getPredicates().get(1).equals("pred2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getFilter().getPredicates().get(2).equals("pred3"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckDLPFunction());
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputAtomsDLPFunction().get(0).toString().equals("a(3)"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getInputAtomsDLPFunction().get(1).toString().equals("a(4)"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).isCheckSplittingSet());
        NormalAtom a11 = new NormalAtom("a");
        a11.addAttribute(new SimpleTerm("1"));
        NormalAtom a12 = new NormalAtom("a");
        a12.addAttribute(new SimpleTerm("2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSplittingSet().contains(a11));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSplittingSet().contains(a12));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(0).equals("rule1"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(1).equals("rule2"));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getTestCases().get(0).getAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(1).getName().equals("assertBravelyFalse"));
        Assert.assertTrue((boolean)(test.getTestCases().get(0).getAssertList().get(1).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getTestCases().get(0).getAssertList().get(1).getExpectedOutput().getContent().toString().equals("program.\nprogram2.\n"));
        Assert.assertTrue((boolean)test.getGlobalAssertList().get(0).getName().equals("assertFalseInAtMost"));
        Assert.assertTrue((boolean)(test.getGlobalAssertList().get(0).getExpectedOutput().getContent() instanceof Program));
        Assert.assertTrue((boolean)test.getGlobalAssertList().get(0).getExpectedOutput().getContent().toString().equals("program.\n"));
        Assert.assertTrue((test.getGlobalAssertList().get(0).getNumberModels() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)test.getTestCases().get(0).getSelectedRules().get(0).equals("rule1"));
    }

    private TestSuite getTest(String code) throws ParseException, UnsupportedEncodingException, it.unical.mat.dlv.parser.ParseException {
        TestParser typParser = new TestParser(new ByteArrayInputStream(code.getBytes("UTF-8")));
        return typParser.start();
    }
}

