/*
 * Decompiled with CFR 0.152.
 */
package test;

import it.unical.mat.dlv.typ.TypDirectives;
import it.unical.mat.dlv.typ.parser.ParseException;
import it.unical.mat.dlv.typ.parser.TypParser;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class TypParserTest {
    @Test
    public void parserTypTest() throws UnsupportedEncodingException, ParseException {
        String typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.";
        TypDirectives typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        typContent = "USEDB dlvdb:postgres:postgres.";
        typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.\n\nUSE edge(X,Y)\nMAPTO edge(VARCHAR(20),VARCHAR(90)).\n\nCREATE reachable(X,Y)\nMAPTO reachable(varchar(33),varchar(44,66,77))\nKEEP_AFTER_EXECUTION.";
        typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.\n\nUSE edge(X,Y)\nMAPTO edge(VARCHAR,VARCHAR).\n\nCREATE reachable(X,Y)\nMAPTO reachable(varchar,varchar).\n\nQUERY queryDestination.";
        typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.\n\nUSE edge(X,Y)\nMAPTO edge(VARCHAR,VARCHAR).\n\nCREATE reachable(X,Y)\nMAPTO reachable(varchar,varchar).\n\nDBOUTPUT dlvdb:postgres:postgres.";
        typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.\n\nUSE edge(X,Y)\nMAPTO edge(VARCHAR(29),VARCHAR(34,45)).\n\nCREATE reachable(X,Y)\nMAPTO reachable(varchar,varchar).\n\nOUTPUT APPEND predicateName IN dlvdb:postgres:postgres.";
        typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        typContent = "USEDB dlvdb:postgres:postgres LIKE POSTGRES.\n\nUSE \"edge complex\"(X,Y)\nMAPTO \"edge complex\"(VARCHAR(20),VARCHAR(90)).\n\nCREATE reachable(X,Y)\nMAPTO \"reachable complex\"(varchar(33),varchar(44,66,77))\nKEEP_AFTER_EXECUTION.";
        typDirectives = this.getTypDirectives(typContent);
        Assert.assertTrue((boolean)typDirectives.toString().equals(typContent));
        System.out.println(typDirectives);
    }

    private TypDirectives getTypDirectives(String code) throws UnsupportedEncodingException, ParseException {
        TypParser typParser = new TypParser(new ByteArrayInputStream(code.getBytes("UTF-8")));
        return typParser.start();
    }
}

