/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.jdlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.NonPositionalTerm;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.SimpleTerm;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.jdlv.program.ClassTranslatorSupportInterface;
import it.unical.mat.jdlv.program.OneToManySupprt;
import it.unical.mat.jdlv.program.TypeSolver;
import it.unical.mat.jdlv.util.JdlvProperties;
import it.unical.mat.jdlv.util.Util;
import it.unical.mat.wrapper.Predicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

public class ClassTranslatorSupport
implements ClassTranslatorSupportInterface {
    private Class<? extends Object> classType;
    private String predicateName;
    private List<Field> fields = new ArrayList<Field>();
    private List<Method> getters = new ArrayList<Method>();
    private List<Method> setters = new ArrayList<Method>();
    private List<Method> manyToOneGetters = new ArrayList<Method>();
    private List<OneToManySupprt> oneToManySupportList = new ArrayList<OneToManySupprt>();
    private Method identifierGetter = null;
    private List<Field> oneToManyFields = new ArrayList<Field>();

    @Override
    public Object getObjectInstance(Predicate.ResultLiteral l) {
        try {
            Object newObject = this.classType.newInstance();
            int i = 0;
            while (i < this.setters.size()) {
                Method method = this.setters.get(i);
                if (method.getParameterTypes()[0].equals(String.class)) {
                    method.invoke(newObject, Util.getStringContent(l.getTermAt(i)));
                } else if (method.getParameterTypes()[0].equals(Integer.class) || method.getParameterTypes()[0].equals(Integer.TYPE)) {
                    method.invoke(newObject, Integer.parseInt(l.getTermAt(i).toString()));
                } else if (method.getParameterTypes()[0].equals(Character.class) || method.getParameterTypes()[0].equals(Character.TYPE)) {
                    Character character = Character.valueOf(Util.getStringContent(l.getTermAt(i).toString()).charAt(0));
                    method.invoke(newObject, character);
                } else if (method.getParameterTypes()[0].equals(Boolean.class) || method.getParameterTypes()[0].equals(Boolean.TYPE)) {
                    method.invoke(newObject, l.getTermAt(i).toString().toLowerCase().equals("true"));
                } else if (method.getParameterTypes()[0].equals(Date.class)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(JdlvProperties.getInstance().getJdlvDataFormatValue());
                    try {
                        method.invoke(newObject, sdf.parse(Util.getStringContent(l.getTermAt(i).toString())));
                    }
                    catch (ParseException e) {
                        method.invoke(newObject, new Date());
                        e.printStackTrace();
                    }
                } else if (method.getParameterTypes()[0].equals(Character.class)) {
                    method.invoke(newObject, Integer.parseInt(l.getTermAt(i)));
                }
                ++i;
            }
            return newObject;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getObjectTranslation(Object objectToTranslate, String ... predicateName) {
        StringBuffer buffer = new StringBuffer();
        if (predicateName.length > 0) {
            buffer.append(predicateName[0]);
            TypeSolver.addUsedMapping(predicateName[0], this.classType);
        } else {
            buffer.append(this.getPredicateName());
            TypeSolver.addUsedMapping(this.getPredicateName(), this.classType);
        }
        buffer.append("(");
        boolean first = true;
        for (Method getter : this.getters) {
            if (!first) {
                buffer.append(",");
            }
            first = false;
            try {
                Object object = getter.invoke(objectToTranslate, new Object[0]);
                if (Util.isPrimitiveType(object)) {
                    buffer.append(Util.getPrimitiveTypeTranslation(object));
                    continue;
                }
                if (object == null) {
                    buffer.append(JdlvProperties.getInstance().getJdlvDefaultNullValue());
                    throw new Exception("Null value in " + objectToTranslate.toString());
                }
                buffer.append("unsupported_type_" + object.getClass().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buffer.append(").");
        return buffer.toString();
    }

    public ClassTranslatorSupport(Class<? extends Object> classType) {
        this.classType = classType;
        this.setClassName();
        this.processClass();
    }

    private void setClassName() {
        String predicateName = this.classType.getSimpleName();
        if (this.containsEntityAnnotation(this.classType)) {
            if (this.classType.getAnnotation(Entity.class) != null && this.classType.getAnnotation(Entity.class).name() != null && !this.classType.getAnnotation(Entity.class).name().equals("")) {
                predicateName = this.classType.getAnnotation(Entity.class).name();
            }
            if (this.classType.getAnnotation(Table.class) != null && this.classType.getAnnotation(Table.class).name() != null && !this.classType.getAnnotation(Table.class).name().equals("")) {
                predicateName = this.classType.getAnnotation(Table.class).name();
            }
        }
        this.predicateName = predicateName;
    }

    private boolean containsEntityAnnotation(Class<? extends Object> classType) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = classType.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            String annotationName = annotation.annotationType().getName();
            if (annotationName.equals("javax.persistence.Entity") || annotationName.equals("javax.persistence.Table")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsOneToManyAssociations() {
        return !this.oneToManySupportList.isEmpty();
    }

    public boolean containsManyToOneAssociations() {
        return !this.manyToOneGetters.isEmpty();
    }

    private void processClass() {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Field> fieldToRemove = new ArrayList<Field>();
        Field idField = null;
        boolean fieldAnnotated = false;
        Field[] fieldArray = this.classType.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            fieldAnnotated = false;
            fields.add(field);
            if (this.containsEntityAnnotation(this.classType)) {
                if (field.getAnnotation(Column.class) != null) {
                    fieldAnnotated = true;
                }
                if (field.getAnnotation(Id.class) != null) {
                    fieldAnnotated = true;
                    idField = field;
                }
                if (field.getAnnotation(OneToMany.class) != null) {
                    fieldAnnotated = true;
                    fieldToRemove.add(field);
                    this.oneToManySupportList.add(new OneToManySupprt(field, this.classType));
                    this.oneToManyFields.add(field);
                }
                if (field.getAnnotation(ManyToOne.class) != null) {
                    fieldAnnotated = true;
                    fieldToRemove.add(field);
                    try {
                        this.manyToOneGetters.add(this.classType.getMethod(this.getGetterName(field), new Class[0]));
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!fieldAnnotated) {
                fieldToRemove.add(field);
            }
            ++n2;
        }
        if (fieldAnnotated) {
            fields.removeAll(fieldToRemove);
        }
        Method[] methods = this.classType.getMethods();
        ArrayList<Field> beanField = new ArrayList<Field>();
        ArrayList<Method> getters = new ArrayList<Method>();
        ArrayList<Method> setters = new ArrayList<Method>();
        for (Field field : fields) {
            boolean getter = false;
            boolean setter = false;
            String fieldName = field.getName();
            String initName = fieldName.substring(0, 1).toUpperCase();
            fieldName = fieldName.substring(1);
            fieldName = String.valueOf(initName) + fieldName;
            String getterName = null;
            String setterName = null;
            Method[] methodArray = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                if (method.getName().equals("set" + fieldName)) {
                    setter = true;
                    setterName = "set" + fieldName;
                }
                if (method.getName().equals("get" + fieldName)) {
                    getter = true;
                    getterName = "get" + fieldName;
                }
                if (method.getName().equals("is" + fieldName)) {
                    getter = true;
                    getterName = "is" + fieldName;
                }
                ++n4;
            }
            if (!getter || !setter) continue;
            beanField.add(field);
            try {
                getters.add(this.classType.getMethod(getterName, new Class[0]));
                if (field.equals(idField)) {
                    this.identifierGetter = this.classType.getMethod(getterName, new Class[0]);
                }
                setters.add(this.classType.getMethod(setterName, field.getType()));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        this.fields = beanField;
        this.getters = getters;
        this.setters = setters;
    }

    public List<Method> getManyToOneGetters() {
        return this.manyToOneGetters;
    }

    private void sortField(List<Field> fields) {
        boolean modificato = true;
        while (modificato) {
            modificato = false;
            int i = 0;
            while (i < fields.size() - 1) {
                if (fields.get(i).getName().compareTo(fields.get(i + 1).getName()) > 0) {
                    modificato = true;
                    Field tmpField = fields.get(i);
                    fields.set(i, fields.get(i + 1));
                    fields.set(i + 1, tmpField);
                }
                ++i;
            }
        }
    }

    private void sortMethod(List<Method> methods) {
        boolean modificato = true;
        while (modificato) {
            modificato = false;
            int i = 0;
            while (i < methods.size() - 1) {
                if (methods.get(i).getName().compareTo(methods.get(i + 1).getName()) > 0) {
                    modificato = true;
                    Method tmpMethod = methods.get(i);
                    methods.set(i, methods.get(i + 1));
                    methods.set(i + 1, tmpMethod);
                }
                ++i;
            }
        }
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Method> getSetters() {
        return this.setters;
    }

    public List<Method> getGetters() {
        return this.getters;
    }

    @Override
    public String getPredicateName() {
        return this.predicateName;
    }

    public Method getIdentifierGetter() {
        return this.identifierGetter;
    }

    public List<OneToManySupprt> getOneToManySupportList() {
        return this.oneToManySupportList;
    }

    public String getGetterName(Field field) {
        String fieldName = field.getName();
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    @Override
    public Atom translateNonPositionalAtom(Atom atom) {
        if (atom instanceof NormalAtom) {
            NormalAtom newAtom = (NormalAtom)atom.clone();
            newAtom.getAttrs().clear();
            HashMap<String, String> nameValueMap = new HashMap<String, String>();
            for (Term term : ((NormalAtom)atom).getAttrs()) {
                if (!(term instanceof NonPositionalTerm)) continue;
                String attributeName = ((NonPositionalTerm)term).getName().toString();
                String attributeValue = ((NonPositionalTerm)term).getValue().toString();
                nameValueMap.put(attributeName, attributeValue);
            }
            for (Field field : this.fields) {
                String fieldName = field.getName();
                if (nameValueMap.containsKey(fieldName)) {
                    newAtom.addAttribute((Term)new SimpleTerm((String)nameValueMap.get(fieldName)));
                    continue;
                }
                newAtom.addAttribute((Term)new SimpleTerm("_"));
            }
            return newAtom;
        }
        return null;
    }
}

