/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.jdlv.program;

import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.jdlv.program.AttributeTranslatorSupport;
import it.unical.mat.jdlv.program.ClassTranslatorSupportInterface;
import it.unical.mat.jdlv.program.HibernateConfiguration;
import it.unical.mat.jdlv.program.JoinObjectSupport;
import it.unical.mat.jdlv.program.ManyToOneAttributeTranlatorSupport;
import it.unical.mat.jdlv.program.OneToManyAttributeTranlatorSupport;
import it.unical.mat.jdlv.program.SimpleAttributeTranlatorSupport;
import it.unical.mat.jdlv.program.TypeSolver;
import it.unical.mat.jdlv.util.Util;
import it.unical.mat.wrapper.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class HibernateClassTranslatorSupport
implements ClassTranslatorSupportInterface {
    private Class<? extends Object> supportedClass;
    private String predicateName;
    private Method idGetter;
    private Method idSetter;
    private Table table;
    private PersistentClass persistentClass;
    private HashMap<String, Object> createdObjectMap = new HashMap();
    private List<AttributeTranslatorSupport> attributeTranslatorSupports;

    @Override
    public Object getObjectInstance(Predicate.ResultLiteral resultLiteral) {
        try {
            Object newObject = this.supportedClass.newInstance();
            int i = 0;
            while (i < this.attributeTranslatorSupports.size()) {
                HibernateClassTranslatorSupport associatedClassSupport;
                if (this.attributeTranslatorSupports.get(i) instanceof SimpleAttributeTranlatorSupport) {
                    Method method = this.attributeTranslatorSupports.get(i).getSetter();
                    if (method.getParameterTypes()[0].equals(String.class)) {
                        method.invoke(newObject, Util.getStringContent(resultLiteral.getTermAt(i)));
                    } else if (method.getParameterTypes()[0].equals(Integer.TYPE)) {
                        method.invoke(newObject, Integer.parseInt(resultLiteral.getTermAt(i)));
                    } else if (method.getParameterTypes()[0].equals(Integer.class)) {
                        method.invoke(newObject, Integer.parseInt(resultLiteral.getTermAt(i)));
                    }
                } else if (this.attributeTranslatorSupports.get(i) instanceof ManyToOneAttributeTranlatorSupport) {
                    if (this.attributeTranslatorSupports.get(i).isWritable()) {
                        String identifier = resultLiteral.getTermAt(i);
                        Method setter = this.attributeTranslatorSupports.get(i).getSetter();
                        Class<? extends Object> associatedClass = ((ManyToOneAttributeTranlatorSupport)this.attributeTranslatorSupports.get(i)).getAssociatedClass();
                        associatedClassSupport = (HibernateClassTranslatorSupport)TypeSolver.getClassTranslatorSupport(associatedClass);
                        if (associatedClassSupport.getCreatedObjectMap().isEmpty()) {
                            TypeSolver.loadPredicate(new ArrayList(), TypeSolver.currentModel, associatedClass);
                        }
                        if (associatedClassSupport.getCreatedObjectMap().containsKey(identifier)) {
                            Object associatedObject = associatedClassSupport.getCreatedObjectMap().get(identifier);
                            setter.invoke(newObject, associatedObject);
                        }
                    }
                } else if (this.attributeTranslatorSupports.get(i) instanceof OneToManyAttributeTranlatorSupport) {
                    Class<? extends Object> associatedClass = ((OneToManyAttributeTranlatorSupport)this.attributeTranslatorSupports.get(i)).getAssociatedClass();
                    String joinPredicateName = ((OneToManyAttributeTranlatorSupport)this.attributeTranslatorSupports.get(i)).getJoinPredicateName();
                    ArrayList joinObjectSupports = new ArrayList();
                    TypeSolver.loadPredicate(joinObjectSupports, joinPredicateName, TypeSolver.currentModel, JoinObjectSupport.class);
                    associatedClassSupport = (HibernateClassTranslatorSupport)TypeSolver.getClassTranslatorSupport(associatedClass);
                    if (associatedClassSupport.getCreatedObjectMap().isEmpty()) {
                        TypeSolver.loadPredicate(new ArrayList(), TypeSolver.currentModel, associatedClass);
                    }
                    ArrayList<Object> collection = new ArrayList<Object>();
                    for (JoinObjectSupport joinObjectSupport : joinObjectSupports) {
                        Object associatedObject = associatedClassSupport.getCreatedObjectMap().get(joinObjectSupport.getSecondKey());
                        collection.add(associatedObject);
                    }
                    Method setter = ((OneToManyAttributeTranlatorSupport)this.attributeTranslatorSupports.get(i)).getSetter();
                    setter.invoke(newObject, collection);
                }
                ++i;
            }
            Object identifier = this.idGetter.invoke(newObject, new Object[0]);
            this.createdObjectMap.put(Util.getPrimitiveTypeTranslation(identifier.toString()), newObject);
            return newObject;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getObjectTranslation(Object objectToTranslate, String ... predicateName) {
        StringBuffer buffer = new StringBuffer();
        if (predicateName.length > 0) {
            buffer.append(predicateName[0]);
        } else {
            buffer.append(this.getPredicateName());
        }
        buffer.append("(");
        boolean first = true;
        for (AttributeTranslatorSupport attributeSupport : this.getAttributeTranslatorSupports()) {
            if (!attributeSupport.isWritable()) continue;
            if (!first) {
                buffer.append(",");
            }
            first = false;
            try {
                buffer.append(attributeSupport.getValue(objectToTranslate));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        buffer.append(").");
        buffer.append(this.writeOneToManyObjects(objectToTranslate, predicateName));
        return buffer.toString();
    }

    private String writeOneToManyObjects(Object objectToTranslate, String[] predicateName) {
        StringBuffer buffer = new StringBuffer();
        ArrayList toWriteObjects = new ArrayList();
        for (AttributeTranslatorSupport attribute : this.getAttributeTranslatorSupports()) {
            if (!(attribute instanceof OneToManyAttributeTranlatorSupport)) continue;
            OneToManyAttributeTranlatorSupport oneToManyAttribute = (OneToManyAttributeTranlatorSupport)attribute;
            try {
                Collection collection = (Collection)oneToManyAttribute.getGetter().invoke(objectToTranslate, new Object[0]);
                Object idObjectToTranslate = this.getIdGetter().invoke(objectToTranslate, new Object[0]);
                HibernateClassTranslatorSupport joinClassTranslatorSupport = (HibernateClassTranslatorSupport)TypeSolver.getClassTranslatorSupport(oneToManyAttribute.getAssociatedClass());
                Method idGetterJoinObject = joinClassTranslatorSupport.getIdGetter();
                for (Object joinObject : collection) {
                    Object idJoinObject = idGetterJoinObject.invoke(joinObject, new Object[0]);
                    buffer.append(oneToManyAttribute.getJoinPredicateName());
                    buffer.append("(");
                    buffer.append(Util.getPrimitiveTypeTranslation(idObjectToTranslate));
                    buffer.append(",");
                    buffer.append(Util.getPrimitiveTypeTranslation(idJoinObject));
                    buffer.append(").\n");
                    toWriteObjects.add(joinObject);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (AttributeTranslatorSupport toWriteObject : toWriteObjects) {
            buffer.append(String.valueOf(TypeSolver.getTypeTranslation(toWriteObject)) + '\n');
        }
        return buffer.toString();
    }

    public HibernateClassTranslatorSupport(Class<? extends Object> supportedClass) {
        this.supportedClass = supportedClass;
        this.initialize();
        this.initializePredicateName();
        this.initializeGettersAndSetters();
    }

    private void initializeGettersAndSetters() {
        this.attributeTranslatorSupports = new ArrayList<AttributeTranslatorSupport>();
        Property property = this.persistentClass.getIdentifierProperty();
        String fieldName = property.getName();
        String tmpFieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
        try {
            this.idGetter = this.supportedClass.getMethod("get" + tmpFieldName, new Class[0]);
            this.idSetter = this.supportedClass.getMethod("set" + tmpFieldName, property.getType().getReturnedClass());
            this.attributeTranslatorSupports.add(new SimpleAttributeTranlatorSupport(this.idGetter, this.idSetter));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Iterator propertyIterator = this.persistentClass.getPropertyIterator();
        Property property1 = null;
        Property property2 = null;
        int i = 0;
        while (propertyIterator.hasNext()) {
            property = (Property)propertyIterator.next();
            if (i == 0) {
                property1 = property;
            }
            if (i == 1) {
                property2 = property;
            }
            ++i;
            if (this.isPrimitiveType(property)) {
                if (property.getColumnSpan() != 1) continue;
                this.attributeTranslatorSupports.add(this.getSimpleAttributeTranslatorSupport(property));
                continue;
            }
            if (this.isManyToOneType(property)) {
                if (property.getColumnSpan() != 1) continue;
                this.attributeTranslatorSupports.add(this.getManyToOneAttributeTranslatorSupport(property));
                continue;
            }
            if (!this.isOneToManyType(property)) continue;
            this.attributeTranslatorSupports.add(this.getOneToManyAttributeTranslatorSupport(property));
        }
    }

    private AttributeTranslatorSupport getSimpleAttributeTranslatorSupport(Property property) {
        String fieldName = property.getName();
        String tmpFieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
        try {
            Method getter = this.supportedClass.getMethod("get" + tmpFieldName, new Class[0]);
            Method setter = this.supportedClass.getMethod("set" + tmpFieldName, property.getType().getReturnedClass());
            return new SimpleAttributeTranlatorSupport(getter, setter);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    private AttributeTranslatorSupport getOneToManyAttributeTranslatorSupport(Property property) {
        if (property.getType() instanceof CollectionType) {
            String fieldName = property.getName();
            String tmpFieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
            try {
                Method getter = this.supportedClass.getMethod("get" + tmpFieldName, new Class[0]);
                Method setter = this.supportedClass.getMethod("set" + tmpFieldName, List.class);
                CollectionType collectionType = (CollectionType)property.getType();
                Class<?> clazz = Class.forName(collectionType.getAssociatedEntityName((SessionFactoryImplementor)HibernateConfiguration.getSessionFactory()));
                String joinPredicateName = collectionType.getAssociatedJoinable((SessionFactoryImplementor)HibernateConfiguration.getSessionFactory()).getTableName();
                OneToManyAttributeTranlatorSupport attribute = new OneToManyAttributeTranlatorSupport(false, clazz, getter, setter, joinPredicateName);
                System.out.println(property.getClass());
                return attribute;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (MappingException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private AttributeTranslatorSupport getManyToOneAttributeTranslatorSupport(Property property) {
        ManyToOneType manyToOneType = (ManyToOneType)property.getType();
        try {
            String fieldName = property.getName();
            String tmpFieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
            Class<?> associatedClass = Class.forName(manyToOneType.getAssociatedEntityName());
            Method getter = this.supportedClass.getMethod("get" + tmpFieldName, new Class[0]);
            Method setter = this.supportedClass.getMethod("set" + tmpFieldName, property.getType().getReturnedClass());
            boolean writable = true;
            if (TypeSolver.getClassTranslatorSupport(associatedClass) instanceof HibernateClassTranslatorSupport) {
                HibernateClassTranslatorSupport classTranslatorSupport = (HibernateClassTranslatorSupport)TypeSolver.getClassTranslatorSupport(associatedClass);
                for (AttributeTranslatorSupport attribute : classTranslatorSupport.getAttributeTranslatorSupports()) {
                    OneToManyAttributeTranlatorSupport oneToManyAttribute;
                    if (!(attribute instanceof OneToManyAttributeTranlatorSupport) || !(oneToManyAttribute = (OneToManyAttributeTranlatorSupport)attribute).getAssociatedClass().equals(this.supportedClass)) continue;
                    writable = false;
                }
            }
            return new ManyToOneAttributeTranlatorSupport(writable, associatedClass, getter, setter);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public HashMap<String, Object> getCreatedObjectMap() {
        return this.createdObjectMap;
    }

    public boolean isManyToOneType(Property property) {
        Type type = property.getType();
        return type instanceof ManyToOneType;
    }

    public boolean isOneToManyType(Property property) {
        Type type = property.getType();
        return type instanceof BagType;
    }

    public boolean isPrimitiveType(Property property) {
        Type type = property.getType();
        return type instanceof StringType || type instanceof IntegerType;
    }

    public Method getIdGetter() {
        return this.idGetter;
    }

    public Method getIdSetter() {
        return this.idSetter;
    }

    public List<AttributeTranslatorSupport> getAttributeTranslatorSupports() {
        return this.attributeTranslatorSupports;
    }

    @Override
    public String getPredicateName() {
        return this.predicateName;
    }

    private void initialize() {
        this.persistentClass = HibernateConfiguration.getHibernateConfiguration().getClassMapping(this.supportedClass.getName());
        if (this.persistentClass == null) {
            System.err.println("Can not found hibernate mapping for '" + this.supportedClass.getName() + "' class");
        } else {
            this.table = this.persistentClass.getTable();
        }
    }

    private void initializePredicateName() {
        this.predicateName = this.table.getName();
    }

    @Override
    public Atom translateNonPositionalAtom(Atom atom) {
        if (atom instanceof NormalAtom) {
            NormalAtom normalAtom = (NormalAtom)atom.clone();
        }
        return null;
    }
}

