/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.jdlv.program;

import it.unical.mat.dlv.parser.Builder;
import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.jdlv.util.JdlvProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JDLV_Logger {
    private Logger logger = Logger.getLogger("JDLV - Builder compiler");
    private static JDLV_Logger instance = null;

    private JDLV_Logger() {
    }

    public static JDLV_Logger getInstance() {
        if (instance == null) {
            instance = new JDLV_Logger();
        }
        return instance;
    }

    public void logWarningMessage(String message) {
        if (!JdlvProperties.getInstance().getJdlvLogLevel().toUpperCase().equals("NONE")) {
            this.logger.log(new LogRecord(Level.WARNING, message));
        }
    }

    public void logInfoMessage(String message) {
        if (!JdlvProperties.getInstance().getJdlvLogLevel().toUpperCase().equals("NONE")) {
            this.logger.log(new LogRecord(Level.INFO, message));
        }
    }

    public void logErrorMessage(String message) {
        if (!JdlvProperties.getInstance().getJdlvLogLevel().toUpperCase().equals("NONE")) {
            this.logger.log(new LogRecord(Level.SEVERE, message));
        }
    }

    public void logMessage(String message, Level level) {
        if (!JdlvProperties.getInstance().getJdlvLogLevel().toUpperCase().equals("NONE")) {
            this.logger.log(new LogRecord(level, message));
        }
    }

    public String getPrettyCode(String code, int lineCode) {
        try {
            Program program = this.getProgram(code);
            int limit = lineCode;
            if (program.size() < lineCode) {
                limit = program.size();
            }
            if (lineCode > 0) {
                Program tmpProgram = new Program();
                int i = 0;
                while (i < limit) {
                    tmpProgram.add((Object)((Expression)program.get(i)));
                    ++i;
                }
                return "\n" + tmpProgram.toString();
            }
            return "\n" + program.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getPrettyObject(Object object, int numberObject) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int limit = numberObject;
            if (collection.size() < numberObject) {
                limit = collection.size();
            }
            StringBuilder collectionBuilder = new StringBuilder();
            collectionBuilder.append("[");
            int counter = 0;
            for (Object collectionObject : collection) {
                if (counter > 0) {
                    collectionBuilder.append(", ");
                }
                collectionBuilder.append(collectionObject.toString());
                if (limit > 0 && ++counter >= limit) break;
            }
            collectionBuilder.append("]\n");
            return collectionBuilder.toString();
        }
        return object.toString();
    }

    private Program getProgram(String code) throws UnsupportedEncodingException, ParseException {
        Director director = new Director((InputStream)new ByteArrayInputStream(code.getBytes("UTF-8")));
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        director.configureBuilder((Builder)builder);
        director.start();
        Program p = (Program)builder.getProductHandler();
        return p;
    }
}

