/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.jdlv.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class JdlvProperties {
    private Properties properties;
    private String dlvExecutablePath = "./dlv";
    private String dlvdbExecutablePath = "./dlvdb";
    private String jdlvLogLevel = "VERBOSE";
    private String jdlvDefaultNullValue = "jdlv_null_value";
    private String jdlvDataFormatValue = "yyyy-MM-dd";
    private static String jdlvPropertiesFilePath = "./jdlv.properties";
    private static String dlvExecutablePropertiesFileKey = "executable_dlv";
    private static String dlvdbExecutablePropertiesFileKey = "executable_dlvdb";
    private static String jdlvLogLevelPropertiesFileKey = "log_level";
    private static String dlvExecutablePropertiesSystemKey = "executable_dlv";
    private static String dlvdbExecutablePropertiesSystemKey = "executable_dlvdb";
    private static String jdlvLogLevelPropertiesSystemKey = "log_level";
    private static String jdlvDafaultNullValueSystemKey = "default_null_value";
    private static String jdlvDataFormatSystemKey = "data_format";
    private static JdlvProperties instance = null;

    private JdlvProperties() {
    }

    public static JdlvProperties getInstance() {
        if (instance == null && !(instance = new JdlvProperties()).loadPropertiesFile()) {
            instance.loadSystemProperties();
        }
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private void loadSystemProperties() {
        String tmpValue = System.getProperty(dlvExecutablePropertiesSystemKey);
        if (tmpValue != null) {
            this.dlvExecutablePath = tmpValue;
        }
        if ((tmpValue = System.getProperty(dlvdbExecutablePropertiesSystemKey)) != null) {
            this.dlvdbExecutablePath = tmpValue;
        }
        if ((tmpValue = System.getProperty(jdlvLogLevelPropertiesSystemKey)) != null) {
            this.jdlvLogLevel = tmpValue;
        }
        if ((tmpValue = System.getProperty(jdlvDataFormatSystemKey)) != null) {
            this.jdlvDataFormatValue = tmpValue;
        }
        if ((tmpValue = System.getProperty(jdlvDafaultNullValueSystemKey)) != null) {
            this.jdlvDefaultNullValue = tmpValue;
        }
    }

    private boolean loadPropertiesFile() {
        this.properties = new Properties();
        if (new File(jdlvPropertiesFilePath).exists()) {
            try {
                this.properties.load(new FileInputStream(jdlvPropertiesFilePath));
                String tmpValue = this.properties.getProperty(dlvExecutablePropertiesFileKey);
                if (tmpValue != null) {
                    this.dlvExecutablePath = tmpValue;
                }
                if ((tmpValue = this.properties.getProperty(dlvdbExecutablePropertiesFileKey)) != null) {
                    this.dlvdbExecutablePath = tmpValue;
                }
                if ((tmpValue = this.properties.getProperty(jdlvLogLevelPropertiesFileKey)) != null) {
                    this.jdlvLogLevel = tmpValue;
                }
                if ((tmpValue = this.properties.getProperty(jdlvDafaultNullValueSystemKey)) != null) {
                    this.jdlvDefaultNullValue = tmpValue;
                }
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public String getJdlvLogLevel() {
        return this.jdlvLogLevel;
    }

    public String getProperty(String property) {
        String tmpValue = this.properties.getProperty(property);
        return tmpValue;
    }

    public String getDlvdbExecutablePath() {
        return this.dlvdbExecutablePath;
    }

    public void setJdlvLogLevel(String jdlvLogLevel) {
        this.jdlvLogLevel = jdlvLogLevel;
    }

    public void setDlvdbExecutablePath(String dlvdbExecutablePath) {
        this.dlvdbExecutablePath = dlvdbExecutablePath;
    }

    public void setDlvExecutablePath(String dlvExecutablePath) {
        this.dlvExecutablePath = dlvExecutablePath;
    }

    public void setJdlvDefaultNullValue(String defaultNullValue) {
        this.jdlvDefaultNullValue = defaultNullValue;
    }

    public String getJdlvDefaultNullValue() {
        return this.jdlvDefaultNullValue;
    }

    public String getDlvExecutablePath() {
        return this.dlvExecutablePath;
    }

    public static String getDlvdbExecutablePropertiesFileKey() {
        return dlvdbExecutablePropertiesFileKey;
    }

    public static String getDlvExecutablePropertiesFileKey() {
        return dlvExecutablePropertiesFileKey;
    }

    public static String getJdlvPropertiesFilePath() {
        return jdlvPropertiesFilePath;
    }

    public static String getDlvdbExecutablePropertiesSystemKey() {
        return dlvdbExecutablePropertiesSystemKey;
    }

    public static String getDlvExecutablePropertiesSystemKey() {
        return dlvExecutablePropertiesSystemKey;
    }

    public static String getJdlvLogLevelPropertiesSystemKey() {
        return jdlvLogLevelPropertiesSystemKey;
    }

    public static void setInstance(JdlvProperties instance) {
        JdlvProperties.instance = instance;
    }

    public String getJdlvDataFormatValue() {
        return this.jdlvDataFormatValue;
    }

    public void setJdlvDataFormatValue(String jdlvDataFormatValue) {
        this.jdlvDataFormatValue = jdlvDataFormatValue;
    }

    public static String getJdlvDataFormatSystemKey() {
        return jdlvDataFormatSystemKey;
    }
}

