/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.datatype.CustomDatatype;
import it.unical.mat.dlv.metainfo.datatype.Datatype;
import it.unical.mat.dlv.program.Directive;
import it.unical.mat.wrapper.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ImportDirective
extends Directive {
    String databaseName;
    String username;
    String password;
    String query;
    String predicateName;
    List<ImportDirectiveTypes> types;

    public static Datatype getImportDirectiveDatatype(ImportDirectiveTypes type) {
        return new CustomDatatype("" + (Object)((Object)type));
    }

    public static ImportDirectiveTypes getImportDirectiveTypeConv(CustomDatatype datatype) {
        if (datatype.getName().equals(ImportDirectiveTypes.U_INT.toString())) {
            return ImportDirectiveTypes.U_INT;
        }
        if (datatype.getName().equals(ImportDirectiveTypes.UT_INT.toString())) {
            return ImportDirectiveTypes.UT_INT;
        }
        if (datatype.getName().equals(ImportDirectiveTypes.UR_INT.toString())) {
            return ImportDirectiveTypes.UR_INT;
        }
        if (datatype.getName().equals(ImportDirectiveTypes.CONST.toString())) {
            return ImportDirectiveTypes.CONST;
        }
        if (datatype.getName().equals(ImportDirectiveTypes.Q_CONST.toString())) {
            return ImportDirectiveTypes.Q_CONST;
        }
        return null;
    }

    public ImportDirective(String databaseName, String username, String password, String query, String predicateName, List<ImportDirectiveTypes> types) {
        super("import", "(" + databaseName + ", \"" + username + "\", \"" + password + "\", \"" + query + "\", " + predicateName + ImportDirective.getTypeConv(types) + ")");
        this.databaseName = databaseName;
        this.username = Util.getStringContent(username);
        this.password = Util.getStringContent(password);
        this.query = Util.getStringContent(query);
        this.predicateName = predicateName;
        this.types = types;
    }

    @Override
    public String toString() {
        return "#import(" + this.databaseName + ", \"" + this.username + "\", \"" + this.password + "\", \"" + this.query + "\", " + this.predicateName + ImportDirective.getTypeConv(this.types) + ").";
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getPredicateName() {
        return this.predicateName;
    }

    public void setPredicateName(String predicateName) {
        this.predicateName = predicateName;
    }

    public List<ImportDirectiveTypes> getTypes() {
        return this.types;
    }

    public void setTypes(List<ImportDirectiveTypes> types) {
        this.types = types;
    }

    private static String getTypeConv(List<ImportDirectiveTypes> types) {
        if (types == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(", type: ");
        int i = 0;
        while (i < types.size()) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((Object)types.get(i));
            ++i;
        }
        return stringBuilder.toString();
    }

    @Override
    public ImportDirective clone() {
        ImportDirective directive = (ImportDirective)super.clone();
        directive.setDatabaseName(this.databaseName);
        directive.setUsername(this.username);
        directive.setPassword(this.password);
        directive.setQuery(this.query);
        directive.setPredicateName(this.predicateName);
        if (this.types != null) {
            directive.setTypes(new ArrayList<ImportDirectiveTypes>(this.types));
        }
        return directive;
    }

    public void clearTypes() {
        this.types = null;
    }

    public void addType(ImportDirectiveTypes type) {
        if (this.types == null) {
            this.types = new ArrayList<ImportDirectiveTypes>();
        }
        this.types.add(type);
    }

    public static enum ImportDirectiveTypes {
        U_INT,
        UT_INT,
        UR_INT,
        CONST,
        Q_CONST;

    }
}

