/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.program.Term;
import java.util.ArrayList;
import java.util.List;

public class ListTerm
implements Term {
    private ArrayList<Term> attrs = new ArrayList();
    private boolean isHeadTail = false;
    private int beginColumn = 0;
    private int beginLine = 0;
    private int endLine = 0;
    private int endColumn = 0;

    public ListTerm(ArrayList<Term> att) {
        for (Term term : att) {
            this.attrs.add(term);
        }
    }

    public ListTerm(ArrayList<Term> att, boolean headTail) {
        this.isHeadTail = headTail;
        for (Term term : att) {
            this.attrs.add(term);
        }
    }

    boolean isFactsShortcut() {
        if (this.attrs.size() == 3) {
            return this.attrs.get(0).isNumericConstant() && this.attrs.get(1).toString().equals("..") && this.attrs.get(2).isNumericConstant();
        }
        return false;
    }

    public boolean containsTerm(Term t1) {
        for (Term t : this.attrs) {
            if (t.isComplex()) {
                return ((ListTerm)t).containsTerm(t1);
            }
            if (!t.toString().equals(t1.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean containsTerm(String t1) {
        for (Term t : this.attrs) {
            if (t.isComplex()) {
                return ((ListTerm)t).containsTerm(t1);
            }
            if (!t.toString().equals(t1)) continue;
            return true;
        }
        return false;
    }

    public Term getAttributeAt(int index) {
        return this.attrs.get(index);
    }

    @Override
    public List<Term> attributes() {
        return this.attrs;
    }

    public int arity() {
        if (this.isFactsShortcut()) {
            return 1;
        }
        return this.attrs.size();
    }

    public boolean isBuiltin() {
        return false;
    }

    public void addAttribute(Term term) {
        this.attrs.add(term);
    }

    public void setAttributeAt(int position, Term term) {
        this.attrs.set(position, term);
    }

    public void removeAttribute(Term term) {
        this.attrs.remove(term);
        ArrayList c = new ArrayList();
        c.remove("ddd");
    }

    public void removeAttributeAt(int position) {
        this.attrs.remove(position);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isGround() {
        for (Term t : this.attrs) {
            if (t.isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumericConstant() {
        return false;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public List<Term> getVariables() {
        ArrayList<Term> ris = new ArrayList<Term>();
        for (Term t : this.attrs) {
            ris.addAll(t.getVariables());
        }
        return ris;
    }

    @Override
    public boolean existsMatch(Term t) {
        return false;
    }

    public ArrayList<Term> getAttrs() {
        return this.attrs;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("[");
        if (this.isHeadTail) {
            res.append(this.attrs.get(0).toString());
            res.append("|");
            res.append(this.attrs.get(1).toString());
        } else {
            if (!this.attrs.isEmpty()) {
                res.append(this.attrs.get(0).toString());
            }
            int i = 1;
            while (i < this.attrs.size()) {
                res.append(", " + this.attrs.get(i).toString());
                ++i;
            }
        }
        res.append("]");
        return res.toString();
    }

    @Override
    public ListTerm clone() {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term t : this.attrs) {
            terms.add(t.clone());
        }
        ListTerm newListAtom = new ListTerm(terms);
        newListAtom.setBeginColumn(this.beginColumn);
        newListAtom.setEndColumn(this.endColumn);
        newListAtom.setBeginLine(this.beginLine);
        newListAtom.setEndLine(this.endLine);
        return newListAtom;
    }

    public boolean isHeadTail() {
        return this.isHeadTail;
    }

    public void setHeadTail(boolean isHeadTail) {
        this.isHeadTail = isHeadTail;
    }
}

