/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.parser.Director;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.Program;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.SimpleProgramBuilder;
import it.unical.mat.dlv.program.Term;
import it.unical.mat.wrapper.FactResult;
import it.unical.mat.wrapper.Predicate;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class Literal
implements FactResult {
    private Atom atom = null;
    private boolean naf = false;
    int modelID;
    int cursor = -1;

    public Literal(boolean positive, Atom atom) {
        this.atom = atom;
        this.naf = !positive;
    }

    public Literal(Predicate.ResultLiteral resultLiteral) {
        SimpleProgramBuilder builder = new SimpleProgramBuilder();
        try {
            String code = resultLiteral.toString();
            Director director = new Director(new ByteArrayInputStream(code.getBytes("UTF-8")));
            director.configureBuilder(builder);
            director.parse();
            Program program = (Program)builder.getProductHandler();
            if (program != null && program.get(0) instanceof Rule) {
                Rule rule = (Rule)program.get(0);
                this.atom = (Atom)rule.head().get(0);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Literal(boolean positive, Atom atom, int modelID) {
        this.atom = atom;
        this.naf = !positive;
        this.modelID = modelID;
    }

    public Atom getAtom() {
        return this.atom;
    }

    public String getName() {
        return this.getAtom().getName();
    }

    public boolean isPositive() {
        return !this.naf;
    }

    public boolean isGround() {
        return this.getAtom().isGround();
    }

    public boolean isAggregate() {
        return this.atom instanceof AggregateAtom;
    }

    @Override
    public List<Term> attributes() {
        if (!this.isAggregate()) {
            return ((Term)((Object)this.getAtom())).attributes();
        }
        throw new RuntimeException("Aggregates do not have attributes");
    }

    public int arity() {
        if (!this.isAggregate()) {
            return ((NormalAtom)this.getAtom()).arity();
        }
        throw new RuntimeException("Aggregates do not have arity");
    }

    public String toString() {
        String result = this.getAtom().toString();
        if (this.isPositive()) {
            return result;
        }
        return "not " + result;
    }

    public List<Term> getVariables() {
        return this.getAtom().getVariables();
    }

    @Override
    public int getModelID() {
        return this.modelID;
    }

    @Override
    public void setModelID(int modelID) {
        this.modelID = modelID;
    }

    public Literal clone() {
        Literal newLiteral = new Literal(this.isPositive(), this.atom.clone(), this.modelID);
        return newLiteral;
    }

    public void setPositive(boolean isPositive) {
        this.naf = !isPositive;
    }

    @Override
    public Term getAttributeAt(int index) {
        if (this.getAtom() instanceof NormalAtom) {
            return ((NormalAtom)this.getAtom()).getAttributeAt(index);
        }
        try {
            throw new Exception("The function getAttributeAt(int) cannot be called to the AggregateAtom");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Literal) {
            Literal other = (Literal)obj;
            if (this.atom.equals(other.atom) && this.naf == other.naf) {
                return true;
            }
        }
        return false;
    }

    public boolean containsJavaContentAtoms() {
        return this.getAtom().containsJavaContentAtoms();
    }
}

