/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.ProgramComment;
import it.unical.mat.dlv.metainfo.Schema;
import it.unical.mat.dlv.parser.ParseException;
import it.unical.mat.dlv.program.AggregateAtom;
import it.unical.mat.dlv.program.ArityWarning;
import it.unical.mat.dlv.program.Atom;
import it.unical.mat.dlv.program.Comment;
import it.unical.mat.dlv.program.DLVProductHandler;
import it.unical.mat.dlv.program.Directive;
import it.unical.mat.dlv.program.DirectiveAnalyzer;
import it.unical.mat.dlv.program.Expression;
import it.unical.mat.dlv.program.ImportDirective;
import it.unical.mat.dlv.program.Literal;
import it.unical.mat.dlv.program.NormalAtom;
import it.unical.mat.dlv.program.ProgramExpression;
import it.unical.mat.dlv.program.ProgramPredicate;
import it.unical.mat.dlv.program.Query;
import it.unical.mat.dlv.program.Rule;
import it.unical.mat.dlv.program.error.ArityError;
import it.unical.mat.dlv.program.error.SafetyError;
import it.unical.mat.dlv.program.error.SchemaError;
import it.unical.mat.dlv.typ.TypDefinitionInterface;
import it.unical.mat.dlv.typ.TypDirectiveCreators;
import it.unical.mat.dlv.typ.TypDirectives;
import it.unical.mat.wrapper.exception.NullUseDbDefinitionException;
import it.unical.mat.wrapper.util.dependencygraph.DependencyGraph;
import it.unical.mat.wrapper.util.dependencygraph.StronglyConnectedComponentGraph;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Program
extends ArrayList<Expression>
implements DLVProductHandler {
    private static final long serialVersionUID = 1L;
    private TypDirectives typDirectives = null;
    private ProgramComment programComment = null;
    private HashMap<String, List<Schema>> schemaDirectives = new HashMap();

    public Query getLastQuery() {
        Query query = null;
        if (this.size() > 0) {
            int i = this.size() - 1;
            while (i >= 0) {
                Expression expr = (Expression)this.get(i);
                if (expr instanceof Query) {
                    return (Query)expr;
                }
                --i;
            }
        }
        return query;
    }

    public boolean containsQuery() {
        for (Expression exp : this) {
            if (!(exp instanceof Query)) continue;
            return true;
        }
        return false;
    }

    public TypDirectives getTypDirectives() {
        return this.typDirectives;
    }

    public void setTypDirectives(TypDirectives typDirectives) {
        this.typDirectives = typDirectives;
    }

    public boolean containsOnlyFacts(boolean onlyGround) {
        for (Rule rule : this.getRules()) {
            if (!rule.isFact() && !rule.isNongroundFact()) {
                return false;
            }
            if (!onlyGround || !rule.isNongroundFact()) continue;
            return false;
        }
        return true;
    }

    public boolean containsOnlyConstraints() {
        for (Rule rule : this.getRules()) {
            if (rule.isConstraint()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expression e : this) {
            sb.append(e);
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<ProgramPredicate> getUnusedPredicate() {
        ArrayList<ProgramPredicate> predicatesInHead = new ArrayList<ProgramPredicate>();
        ArrayList<ProgramPredicate> predicatesInBody = new ArrayList<ProgramPredicate>();
        ArrayList<ProgramPredicate> unusedPredicates = new ArrayList<ProgramPredicate>();
        for (Expression exp : this) {
            ProgramPredicate predicate2;
            if (exp instanceof ProgramExpression) {
                List<ProgramPredicate> tmpPredicates;
                if (exp instanceof Rule && (tmpPredicates = ((Rule)exp).getHead().getPredicates()) != null) {
                    for (ProgramPredicate predicate2 : tmpPredicates) {
                        if (predicatesInHead.contains(predicate2)) continue;
                        predicatesInHead.add(predicate2);
                    }
                }
                if ((tmpPredicates = ((ProgramExpression)exp).getBody().getPredicates()) == null) continue;
                for (ProgramPredicate predicate2 : tmpPredicates) {
                    if (predicatesInBody.contains(predicate2)) continue;
                    predicatesInBody.add(predicate2);
                }
                continue;
            }
            if (exp instanceof ImportDirective) {
                int arity = 0;
                if (((ImportDirective)exp).getTypes() != null) {
                    arity = ((ImportDirective)exp).getTypes().size();
                }
                if (predicatesInHead.contains(predicate2 = new ProgramPredicate(((ImportDirective)exp).getPredicateName(), arity))) continue;
                predicatesInHead.add(predicate2);
                continue;
            }
            if (!(exp instanceof Comment)) continue;
            try {
                Schema schema = Schema.getSchemaFromTypAnnotation((Comment)exp);
                if (schema.getUseDefinition() == null || predicatesInHead.contains(predicate2 = new ProgramPredicate(schema.getName(), schema.getArity()))) continue;
                predicatesInHead.add(predicate2);
            }
            catch (it.unical.mat.dlv.typ.parser.ParseException parseException) {
                // empty catch block
            }
        }
        for (ProgramPredicate bodyPredicate : predicatesInBody) {
            if (predicatesInHead.contains(bodyPredicate)) continue;
            unusedPredicates.add(bodyPredicate);
        }
        return unusedPredicates;
    }

    public List<SafetyError> getSafetyErrors() {
        ArrayList<SafetyError> errors = new ArrayList<SafetyError>();
        for (Expression expression : this) {
            if (!(expression instanceof ProgramExpression)) continue;
            errors.addAll(((ProgramExpression)expression).getSafetyErrors());
        }
        return errors;
    }

    public List<Schema> getAllSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Expression expression : this) {
            if (expression instanceof ImportDirective) {
                ImportDirective importDir = (ImportDirective)expression;
                schemas.add(Schema.getSchema(importDir));
                continue;
            }
            if (!(expression instanceof Comment)) continue;
            Schema schema = null;
            try {
                schema = this.getSchemaInProgram((Comment)expression);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (schema == null) {
                try {
                    schema = Schema.getSchemaFromTypAnnotation((Comment)expression);
                }
                catch (it.unical.mat.dlv.typ.parser.ParseException parseException) {
                    // empty catch block
                }
            }
            if (schema == null) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    public List<Schema> getSourceSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Expression expression : this) {
            if (expression instanceof ImportDirective) {
                ImportDirective importDir = (ImportDirective)expression;
                schemas.add(Schema.getSchema(importDir));
                continue;
            }
            if (!(expression instanceof Comment)) continue;
            try {
                Schema schema = Schema.getSchemaFromTypAnnotation((Comment)expression);
                if (schema.getUseDefinition() == null) continue;
                schemas.add(schema);
            }
            catch (it.unical.mat.dlv.typ.parser.ParseException parseException) {
                // empty catch block
            }
        }
        return schemas;
    }

    public Schema getSchemaInProgram(Comment comment) throws UnsupportedEncodingException, ParseException {
        Schema schema = null;
        Schema schemaTmp = Schema.getSchema(comment);
        if (this.schemaDirectives.containsKey(schemaTmp.getName())) {
            List<Schema> schemas = this.schemaDirectives.get(schemaTmp.getName());
            for (Schema sch : schemas) {
                if (!sch.equals(schemaTmp)) continue;
                schema = sch;
            }
        }
        return schema;
    }

    public List<SchemaError> getAritySchemaErrors() {
        ArrayList<SchemaError> errors = new ArrayList<SchemaError>();
        HashMap<String, Schema> firstSchemas = new HashMap<String, Schema>();
        List<Schema> schemas = this.getAllSchemas();
        for (Schema schema : schemas) {
            Schema firstSchema = (Schema)firstSchemas.get(schema.getName());
            if (firstSchema == null) {
                firstSchemas.put(schema.getName(), schema);
                continue;
            }
            errors.addAll(Schema.getAritySchemaErrors(firstSchema, schema));
        }
        return errors;
    }

    public List<SchemaError> getAttributeNameSchemaErrors() {
        ArrayList<SchemaError> errors = new ArrayList<SchemaError>();
        HashMap<String, Schema> firstSchemas = new HashMap<String, Schema>();
        List<Schema> schemas = this.getAllSchemas();
        for (Schema schema : schemas) {
            errors.addAll(Schema.getAttributeNameSchemaErrors(schema));
            Schema firstSchema = (Schema)firstSchemas.get(schema.getName());
            if (firstSchema == null) {
                if (schema.getImportDirective() != null) continue;
                firstSchemas.put(schema.getName(), schema);
                continue;
            }
            errors.addAll(Schema.getAttributeNameSchemaErrors(firstSchema, schema));
        }
        return errors;
    }

    public boolean isGround() {
        for (Expression expr : this) {
            if (!(expr instanceof ProgramExpression) || ((ProgramExpression)expr).isGround()) continue;
            return false;
        }
        return true;
    }

    public boolean isStratified() {
        StronglyConnectedComponentGraph graph = (StronglyConnectedComponentGraph)DependencyGraph.createStronglyConnectedComponentGraph(this);
        return graph.isStratified();
    }

    public List<ArityError> getArityErrors() {
        ArrayList<ArityError> errors = new ArrayList<ArityError>();
        HashMap<String, Integer> firstArityAtomName = new HashMap<String, Integer>();
        for (Expression expression : this) {
            if (!(expression instanceof ProgramExpression)) continue;
            errors.addAll(((ProgramExpression)expression).getArityErrors());
            HashMap<String, List<Atom>> atoms = ((ProgramExpression)expression).getClassifiedAtoms();
            for (String atomName : atoms.keySet()) {
                ArityError error;
                String errorText;
                if (!firstArityAtomName.containsKey(atomName)) {
                    Atom atom = atoms.get(atomName).get(0);
                    if (!(atom instanceof NormalAtom) || atom.containsNonPositionalTerm()) continue;
                    firstArityAtomName.put(atomName, ((NormalAtom)atom).arity());
                    Schema firstSchema = this.getFirstSchema(atomName);
                    if (firstSchema == null || ((NormalAtom)atom).arity() == firstSchema.getArity()) continue;
                    String schema = "@schema";
                    if (firstSchema.getImportDirective() != null) {
                        schema = "#import";
                    } else if (firstSchema.getUseDefinition() != null) {
                        schema = "@usaTable";
                    } else if (firstSchema.getCreateDefinition() != null) {
                        schema = "@createTable";
                    }
                    errorText = "The atom '" + atom.toString() + "' in the rule " + "'" + expression.toString() + "' expected arity " + firstSchema.getArity() + " compared with the " + schema + " of the program.";
                    error = new ArityError(errorText, (ProgramExpression)expression, atom, firstSchema.getArity());
                    errors.add(error);
                    continue;
                }
                int arity = (Integer)firstArityAtomName.get(atomName);
                for (Atom atom : atoms.get(atomName)) {
                    if (!(atom instanceof NormalAtom)) continue;
                    if (atom.containsNonPositionalTerm()) {
                        if (((NormalAtom)atom).arity() > arity) {
                            errorText = "The atom '" + atom.toString() + "' in the rule " + "'" + expression.toString() + "' expected arity " + arity;
                            error = new ArityError(errorText, (ProgramExpression)expression, atom, arity);
                            errors.add(error);
                            continue;
                        }
                        errorText = "The atom '" + atom.toString() + "' in the rule " + "'" + this.toString() + "' could have different arity from " + arity;
                        errors.add(new ArityWarning(errorText, (ProgramExpression)expression, atom, arity));
                        continue;
                    }
                    if (((NormalAtom)atom).arity() == arity) continue;
                    errorText = "The atom '" + atom.toString() + "' in the rule " + "'" + expression.toString() + "' expected arity " + arity;
                    error = new ArityError(errorText, (ProgramExpression)expression, atom, arity);
                    errors.add(error);
                }
            }
        }
        boolean foundSchema = false;
        Iterator<Schema> iterator = this.getAllSchemas().iterator();
        while (iterator.hasNext() && !foundSchema) {
            Schema schema = iterator.next();
        }
        return errors;
    }

    public List<ProgramPredicate> getPredicates() {
        return this.getPredicates(false, false);
    }

    public Schema getFirstSchema(String schemaName) {
        Schema tmpSchemaOfCreate = null;
        for (Schema schema : this.getAllSchemas()) {
            if (!schema.getName().equals(schemaName)) continue;
            if (schema.getCreateDefinition() != null) {
                if (tmpSchemaOfCreate != null) continue;
                tmpSchemaOfCreate = schema;
                continue;
            }
            return schema;
        }
        return tmpSchemaOfCreate;
    }

    public List<ProgramPredicate> getPredicates(boolean includePredicatesWithSchema, boolean includeImportDirectives) {
        ArrayList<ProgramPredicate> predicates = new ArrayList<ProgramPredicate>();
        if (includePredicatesWithSchema) {
            for (String schemaName : this.schemaDirectives.keySet()) {
                Schema schema;
                ProgramPredicate predicate = new ProgramPredicate(schemaName, schema = this.schemaDirectives.get(schemaName).get(0));
                if (predicates.contains(predicate)) continue;
                predicates.add(predicate);
            }
        }
        for (Expression exp : this) {
            if (exp instanceof ProgramExpression) {
                List<ProgramPredicate> tmpPredicates = ((ProgramExpression)exp).getPredicates();
                if (tmpPredicates == null) continue;
                for (ProgramPredicate predicate : tmpPredicates) {
                    if (predicates.contains(predicate)) continue;
                    predicates.add(predicate);
                }
                continue;
            }
            if (!includeImportDirectives || !(exp instanceof ImportDirective)) continue;
            ImportDirective importDir = (ImportDirective)exp;
            Schema schema = Schema.getSchema(importDir);
            ProgramPredicate predicate = new ProgramPredicate(importDir.getPredicateName(), schema);
            if (predicates.contains(predicate)) {
                predicates.remove(predicate);
            }
            predicates.add(predicate);
        }
        return predicates;
    }

    public ProgramPredicate getPredicate(String name) {
        List<ProgramPredicate> predicates = this.getPredicates();
        for (ProgramPredicate pred : predicates) {
            if (!pred.getName().equals(name)) continue;
            return pred;
        }
        return null;
    }

    public List<ProgramPredicate> getPredicatesInHead() {
        ArrayList<ProgramPredicate> predicates = new ArrayList<ProgramPredicate>();
        for (Expression exp : this) {
            List<ProgramPredicate> tmpPredicates;
            if (!(exp instanceof ProgramExpression) || (tmpPredicates = ((ProgramExpression)exp).getPredicatesInHead()) == null) continue;
            for (ProgramPredicate predicate : tmpPredicates) {
                if (predicates.contains(predicate)) continue;
                predicates.add(predicate);
            }
        }
        return predicates;
    }

    public List<ProgramPredicate> getPredicatesInBody() {
        ArrayList<ProgramPredicate> predicates = new ArrayList<ProgramPredicate>();
        for (Expression exp : this) {
            List<ProgramPredicate> tmpPredicates;
            if (!(exp instanceof ProgramExpression) || (tmpPredicates = ((ProgramExpression)exp).getPredicatesInBody()) == null) continue;
            for (ProgramPredicate predicate : tmpPredicates) {
                if (predicates.contains(predicate)) continue;
                predicates.add(predicate);
            }
        }
        return predicates;
    }

    public List<Rule> getFacts(boolean onlyGround) {
        ArrayList<Rule> facts = new ArrayList<Rule>();
        for (Expression expr : this) {
            if (!(expr instanceof Rule)) continue;
            Rule rule = (Rule)expr;
            if (onlyGround) {
                if (!rule.isFact()) continue;
                facts.add(rule);
                continue;
            }
            if (!rule.isFact() && !rule.isNongroundFact()) continue;
            facts.add(rule);
        }
        return facts;
    }

    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Expression expr : this) {
            if (!(expr instanceof Rule)) continue;
            Rule rule = (Rule)expr;
            rules.add(rule);
        }
        return rules;
    }

    public List<Directive> getDirectives() {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        for (Expression expr : this) {
            if (!(expr instanceof Directive)) continue;
            Directive dir = (Directive)expr;
            directives.add(dir);
        }
        return directives;
    }

    public List<ImportDirective> getImportDirectives() {
        ArrayList<ImportDirective> directives = new ArrayList<ImportDirective>();
        for (Expression expr : this) {
            if (!(expr instanceof ImportDirective)) continue;
            ImportDirective dir = (ImportDirective)expr;
            directives.add(dir);
        }
        return directives;
    }

    public void generateTypDirectives() throws NullUseDbDefinitionException {
        TypDirectiveCreators creator = new TypDirectiveCreators();
        for (Expression exp : this) {
            TypDefinitionInterface directive;
            if (!(exp instanceof Comment) || (directive = DirectiveAnalyzer.getDefinition(((Comment)exp).getContent())) == null) continue;
            creator.addTypDirective(directive);
            directive = null;
        }
        this.typDirectives = creator.getTypDirectives();
    }

    public ProgramComment getProgramComment() {
        return this.programComment;
    }

    public void setProgramComment(ProgramComment programComment) {
        this.programComment = programComment;
    }

    public void setSchemaDirectives(HashMap<String, List<Schema>> schemaDirectives) {
        this.schemaDirectives = schemaDirectives;
    }

    public HashMap<String, List<Schema>> getSchemaDirectives() {
        return this.schemaDirectives;
    }

    public ProgramExpression getExpressionByName(String name) {
        for (Expression expr : this) {
            if (!(expr instanceof ProgramExpression) || !((ProgramExpression)expr).getName().equals(name)) continue;
            return (ProgramExpression)expr;
        }
        return null;
    }

    public ProgramExpression getFirstExpressionWithPredicate(String predicate) {
        for (Expression exp : this) {
            if (!(exp instanceof ProgramExpression) || !((ProgramExpression)exp).containsPredicate(predicate)) continue;
            return (ProgramExpression)exp;
        }
        return null;
    }

    public Set<Atom> getPredicateSymbolsAsAtoms() {
        HashSet<Atom> atoms = new HashSet<Atom>();
        for (Expression expr : this) {
            NormalAtom newAtom;
            if (!(expr instanceof Rule)) continue;
            for (Atom headAtom : ((Rule)expr).head()) {
                newAtom = new NormalAtom(headAtom.getName());
                if (atoms.contains(newAtom)) continue;
                atoms.add(newAtom);
            }
            for (Literal bodyLit : ((Rule)expr).body()) {
                if (bodyLit.isAggregate()) {
                    for (Literal aggrLit : ((AggregateAtom)bodyLit.getAtom()).getBody()) {
                        NormalAtom newAtom2;
                        if (!(aggrLit.getAtom() instanceof NormalAtom) || ((NormalAtom)aggrLit.getAtom()).isBuiltin() || atoms.contains(newAtom2 = new NormalAtom(aggrLit.getName()))) continue;
                        atoms.add(newAtom2);
                    }
                    continue;
                }
                if (!(bodyLit.getAtom() instanceof NormalAtom) || ((NormalAtom)bodyLit.getAtom()).isBuiltin() || atoms.contains(newAtom = new NormalAtom(bodyLit.getName()))) continue;
                atoms.add(newAtom);
            }
        }
        return atoms;
    }

    @Override
    public Program clone() {
        Program program = new Program();
        for (Expression exp : this) {
            program.add(exp.clone());
        }
        return program;
    }
}

