/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.dlv.program;

import it.unical.mat.dlv.metainfo.Schema;
import it.unical.mat.dlv.metainfo.datatype.AnyDatatype;

public class ProgramPredicate {
    String name;
    int arity;
    Schema schema;

    public ProgramPredicate(String name, Schema schema) {
        this.name = name;
        this.schema = schema;
        this.arity = schema.getArity();
    }

    public ProgramPredicate(String name, int arity) {
        this.name = name;
        this.arity = arity;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.arity = schema.getArity();
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameWithAttributes() {
        int counter = this.arity;
        StringBuffer attributes = new StringBuffer();
        if (counter > 0) {
            attributes.append("(");
            attributes.append("X1");
            int i = 2;
            while (i <= counter) {
                attributes.append(", X" + i);
                ++i;
            }
            attributes.append(")");
        }
        return String.valueOf(this.name) + attributes.toString();
    }

    public String getNameWithSchema() {
        if (this.schema != null) {
            return this.schema.getSchemaAsString();
        }
        int counter = this.arity;
        StringBuffer attributes = new StringBuffer();
        if (counter > 0) {
            attributes.append("(");
            attributes.append("attr1:" + AnyDatatype.getInstance().toString());
            int i = 2;
            while (i <= counter) {
                attributes.append(", attr" + i + ":" + AnyDatatype.getInstance().toString());
                ++i;
            }
            attributes.append(")");
        }
        return String.valueOf(this.name) + attributes.toString();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramPredicate other = (ProgramPredicate)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

